/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.plc4x.plugins.codegenerator.types.enums.EnumValue;

public class DefaultEnumValue
implements EnumValue {
    private final String value;
    private final String name;
    private final Map<String, String> constants;

    public DefaultEnumValue(String value, String name, Map<String, String> constants) {
        this.value = Objects.requireNonNull(value);
        this.name = Objects.requireNonNull(name);
        this.constants = constants;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Optional<String> getConstant(String name) {
        if (this.constants == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.constants.get(name));
    }

    public String toString() {
        return "DefaultEnumValue{value='" + this.value + '\'' + ", name='" + this.name + '\'' + ", constants=" + this.constants + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEnumValue that = (DefaultEnumValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.name, that.name) && Objects.equals(this.constants, that.constants);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name, this.constants);
    }
}

