/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultArgument;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.Argument;
import org.apache.plc4x.plugins.codegenerator.types.definitions.EnumTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.enums.EnumValue;
import org.apache.plc4x.plugins.codegenerator.types.references.SimpleTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEnumTypeDefinition
extends DefaultTypeDefinition
implements EnumTypeDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEnumTypeDefinition.class);
    private final SimpleTypeReference type;
    private final List<EnumValue> enumValues;
    private final Map<String, TypeReference> constants;

    public DefaultEnumTypeDefinition(String name, SimpleTypeReference type, Map<String, Term> attributes, List<EnumValue> enumValues, List<Argument> parserArgument) {
        super(name, attributes, parserArgument);
        this.type = Objects.requireNonNull(type);
        this.enumValues = Objects.requireNonNull(enumValues);
        this.constants = new HashMap<String, TypeReference>();
        if (parserArgument != null) {
            for (Argument argument : parserArgument) {
                ((DefaultArgument)argument).getTypeReferenceCompletionStage().whenComplete((typeReference, throwable) -> {
                    if (throwable != null) {
                        LOGGER.debug("Error setting type for {}", (Object)argument, throwable);
                        return;
                    }
                    this.constants.put(argument.getName(), argument.getType());
                });
            }
        }
    }

    public Optional<SimpleTypeReference> getType() {
        return Optional.ofNullable(this.type);
    }

    public List<EnumValue> getEnumValues() {
        return this.enumValues;
    }

    public List<String> getConstantNames() {
        return new ArrayList<String>(this.constants.keySet());
    }

    public TypeReference getConstantType(String constantName) {
        return this.constants.get(constantName);
    }

    @Override
    public String toString() {
        return "DefaultEnumTypeDefinition{type=" + this.type + ", enumValues=" + this.enumValues + ", constants=" + this.constants + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultEnumTypeDefinition that = (DefaultEnumTypeDefinition)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.enumValues, that.enumValues) && Objects.equals(this.constants, that.constants);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type, this.enumValues, this.constants);
    }
}

