/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.Argument;
import org.apache.plc4x.plugins.codegenerator.types.definitions.DiscriminatedComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.fields.DiscriminatorField;
import org.apache.plc4x.plugins.codegenerator.types.fields.Field;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;

public class DefaultDiscriminatedComplexTypeDefinition
extends DefaultComplexTypeDefinition
implements DiscriminatedComplexTypeDefinition {
    private final List<Term> discriminatorValueTerms;

    public DefaultDiscriminatedComplexTypeDefinition(String name, Map<String, Term> attributes, List<Argument> parserArguments, boolean isAbstract, List<Field> fields, List<Term> discriminatorValueTerms) {
        super(name, attributes, parserArguments, isAbstract, fields);
        this.discriminatorValueTerms = Objects.requireNonNull(discriminatorValueTerms);
    }

    public Optional<DiscriminatorField> getDiscriminatorField() {
        return this.getParentType().flatMap(parentType -> parentType.getFields().stream().filter(field -> field instanceof DiscriminatorField).map(DiscriminatorField.class::cast).findFirst());
    }

    public List<Term> getDiscriminatorValueTerms() {
        return this.discriminatorValueTerms;
    }

    @Override
    public String toString() {
        return "DefaultDiscriminatedComplexTypeDefinition{discriminatorValueTerms=" + this.discriminatorValueTerms + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultDiscriminatedComplexTypeDefinition that = (DefaultDiscriminatedComplexTypeDefinition)o;
        return Objects.equals(this.discriminatorValueTerms, that.discriminatorValueTerms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.discriminatorValueTerms);
    }
}

