/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultArgument;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.Argument;
import org.apache.plc4x.plugins.codegenerator.types.definitions.DataIoTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.fields.SwitchField;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataIoTypeDefinition
extends DefaultComplexTypeDefinition
implements DataIoTypeDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDataIoTypeDefinition.class);
    private final SwitchField switchField;
    private TypeReference type;

    public DefaultDataIoTypeDefinition(String name, Map<String, Term> attributes, List<Argument> parserArguments, SwitchField switchField) {
        super(name, attributes, parserArguments, false, List.of(switchField));
        this.switchField = Objects.requireNonNull(switchField);
        if (parserArguments.size() < 1) {
            throw new IllegalStateException();
        }
        ((DefaultArgument)parserArguments.get(0)).getTypeReferenceCompletionStage().whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type for {}", parserArguments.get(0), throwable);
                return;
            }
            this.type = Objects.requireNonNull(((Argument)parserArguments.get(0)).getType());
        });
    }

    public TypeReference getType() {
        if (this.type == null) {
            throw new IllegalStateException("type not set");
        }
        return this.type;
    }

    @Override
    public String toString() {
        return "DefaultDataIoTypeDefinition{switchField=" + this.switchField + ", type=" + this.type + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultDataIoTypeDefinition that = (DefaultDataIoTypeDefinition)o;
        return Objects.equals(this.switchField, that.switchField) && Objects.equals(this.type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.switchField, this.type);
    }
}

