/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.Argument;
import org.apache.plc4x.plugins.codegenerator.types.definitions.ComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.fields.AbstractField;
import org.apache.plc4x.plugins.codegenerator.types.fields.AssertField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ConstField;
import org.apache.plc4x.plugins.codegenerator.types.fields.Field;
import org.apache.plc4x.plugins.codegenerator.types.fields.ImplicitField;
import org.apache.plc4x.plugins.codegenerator.types.fields.PropertyField;
import org.apache.plc4x.plugins.codegenerator.types.fields.SimpleField;
import org.apache.plc4x.plugins.codegenerator.types.fields.VirtualField;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;

public class DefaultComplexTypeDefinition
extends DefaultTypeDefinition
implements ComplexTypeDefinition {
    private final boolean isAbstract;
    private final List<Field> fields;
    protected ComplexTypeDefinition parentType;

    public DefaultComplexTypeDefinition(String name, Map<String, Term> attributes, List<Argument> parserArguments, boolean isAbstract, List<Field> fields) {
        super(name, attributes, parserArguments);
        this.isAbstract = isAbstract;
        this.fields = Objects.requireNonNull(fields);
    }

    public Optional<ComplexTypeDefinition> getParentType() {
        return Optional.ofNullable(this.parentType);
    }

    public void setParentType(ComplexTypeDefinition parentType) {
        this.parentType = parentType;
    }

    @Override
    public Optional<List<Argument>> getAllParserArguments() {
        ArrayList allArguments = new ArrayList(this.getParserArguments().orElse(Collections.emptyList()));
        if (this.getParentType().isPresent()) {
            ComplexTypeDefinition parent = this.getParentType().get();
            allArguments.addAll(parent.getAllParserArguments().orElse(Collections.emptyList()));
        }
        return Optional.of(allArguments);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<SimpleField> getSimpleFields() {
        return this.fields.stream().filter(SimpleField.class::isInstance).map(SimpleField.class::cast).collect(Collectors.toList());
    }

    public List<ConstField> getConstFields() {
        return this.fields.stream().filter(ConstField.class::isInstance).map(ConstField.class::cast).collect(Collectors.toList());
    }

    public List<AssertField> getAssertFields() {
        return this.fields.stream().filter(AssertField.class::isInstance).map(AssertField.class::cast).collect(Collectors.toList());
    }

    public List<PropertyField> getPropertyFields() {
        return this.fields.stream().filter(PropertyField.class::isInstance).filter(field -> !(field instanceof ConstField) && !(field instanceof VirtualField)).map(PropertyField.class::cast).collect(Collectors.toList());
    }

    public List<AbstractField> getAbstractFields() {
        return this.fields.stream().filter(AbstractField.class::isInstance).map(AbstractField.class::cast).collect(Collectors.toList());
    }

    public List<ImplicitField> getImplicitFields() {
        return this.fields.stream().filter(ImplicitField.class::isInstance).map(ImplicitField.class::cast).collect(Collectors.toList());
    }

    public List<VirtualField> getVirtualFields() {
        return this.fields.stream().filter(VirtualField.class::isInstance).map(VirtualField.class::cast).collect(Collectors.toList());
    }

    public List<Field> getAllFields() {
        LinkedList<Field> fields = new LinkedList<Field>();
        this.getParentType().map(ComplexTypeDefinition::getAllFields).map(fields::addAll);
        fields.addAll(this.getFields());
        return fields;
    }

    public List<PropertyField> getAllPropertyFields() {
        LinkedList<PropertyField> fields = new LinkedList<PropertyField>();
        this.getParentType().map(ComplexTypeDefinition::getAllPropertyFields).map(fields::addAll);
        fields.addAll(this.getPropertyFields());
        return fields;
    }

    public List<VirtualField> getAllVirtualFields() {
        LinkedList<VirtualField> fields = new LinkedList<VirtualField>();
        this.getParentType().map(ComplexTypeDefinition::getAllVirtualFields).map(fields::addAll);
        fields.addAll(this.getVirtualFields());
        return fields;
    }

    public List<PropertyField> getParentPropertyFields() {
        return this.getParentType().map(ComplexTypeDefinition::getAllPropertyFields).orElse(Collections.emptyList());
    }

    @Override
    public String toString() {
        return "DefaultComplexTypeDefinition{isAbstract=" + this.isAbstract + ", fields=" + this.fields + ", parentType=" + (this.parentType != null ? this.parentType.getName() : null) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultComplexTypeDefinition that = (DefaultComplexTypeDefinition)o;
        return this.isAbstract == that.isAbstract && Objects.equals(this.fields, that.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isAbstract, this.fields);
    }
}

