/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.plc4x.plugins.codegenerator.types.definitions.Argument;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReference;

public class DefaultArgument
implements Argument {
    private final String name;
    private TypeReference type;
    protected final CompletableFuture<TypeReference> typeReferenceCompletionStage = new CompletableFuture();

    public DefaultArgument(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public DefaultArgument(String name, TypeReference type) {
        this.name = Objects.requireNonNull(name);
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public TypeReference getType() {
        if (this.type == null) {
            throw new IllegalStateException("type not set");
        }
        return this.type;
    }

    public void setType(TypeReference typeReference) {
        this.type = typeReference;
        this.typeReferenceCompletionStage.complete(typeReference);
    }

    public CompletionStage<TypeReference> getTypeReferenceCompletionStage() {
        return this.typeReferenceCompletionStage;
    }

    public String toString() {
        return "DefaultArgument{type=" + this.type + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultArgument that = (DefaultArgument)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }
}

