/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.expression;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.plc4x.plugins.codegenerator.language.mspec.LazyTypeDefinitionConsumer;
import org.apache.plc4x.plugins.codegenerator.language.mspec.expression.ExpressionBaseListener;
import org.apache.plc4x.plugins.codegenerator.language.mspec.expression.ExpressionParser;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultArgument;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields.DefaultTypedField;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultBinaryTerm;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultBooleanLiteral;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultHexadecimalLiteral;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultNullLiteral;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultNumericLiteral;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultStringLiteral;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultTernaryTerm;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultUnaryTerm;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultVariableLiteral;
import org.apache.plc4x.plugins.codegenerator.types.definitions.BuiltIns;
import org.apache.plc4x.plugins.codegenerator.types.definitions.ComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.fields.NamedField;
import org.apache.plc4x.plugins.codegenerator.types.references.NonSimpleTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.BinaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.NumericLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;
import org.apache.plc4x.plugins.codegenerator.types.terms.TernaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.UnaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionStringListener
extends ExpressionBaseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionStringListener.class);
    private final LazyTypeDefinitionConsumer lazyTypeDefinitionConsumer;
    private final String rootTypeName;
    private Stack<List<Term>> parserContexts;
    private Stack<CompletableFuture<TypeReference>> futureStack;
    private Term root;

    public ExpressionStringListener(LazyTypeDefinitionConsumer lazyTypeDefinitionConsumer, String rootTypeName) {
        this.lazyTypeDefinitionConsumer = lazyTypeDefinitionConsumer;
        this.rootTypeName = rootTypeName;
    }

    public Term getRoot() {
        return this.root;
    }

    @Override
    public void enterExpressionString(ExpressionParser.ExpressionStringContext ctx) {
        this.parserContexts = new Stack();
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitExpressionString(ExpressionParser.ExpressionStringContext ctx) {
        List<Term> roots = this.parserContexts.pop();
        if (roots.isEmpty()) {
            throw new RuntimeException("Empty Expression not supported.");
        }
        if (roots.size() != 1) {
            throw new RuntimeException("Expression can only contain one root term.");
        }
        this.root = roots.get(0);
    }

    @Override
    public void exitNullExpression(ExpressionParser.NullExpressionContext ctx) {
        this.parserContexts.peek().add((Term)new DefaultNullLiteral());
    }

    @Override
    public void exitBoolExpression(ExpressionParser.BoolExpressionContext ctx) {
        this.parserContexts.peek().add((Term)new DefaultBooleanLiteral(Boolean.parseBoolean(ctx.getText())));
    }

    @Override
    public void exitNumberExpression(ExpressionParser.NumberExpressionContext ctx) {
        String strValue = ctx.Number().getText();
        if (strValue.contains(".")) {
            this.parserContexts.peek().add((Term)new DefaultNumericLiteral(Double.valueOf(strValue)));
        } else {
            this.parserContexts.peek().add((Term)new DefaultNumericLiteral(Long.valueOf(strValue)));
        }
    }

    @Override
    public void exitHexExpression(ExpressionParser.HexExpressionContext ctx) {
        String hexValue = ctx.HexExpression().getText();
        this.parserContexts.peek().add((Term)new DefaultHexadecimalLiteral(hexValue));
    }

    @Override
    public void exitStringExpression(ExpressionParser.StringExpressionContext ctx) {
        this.parserContexts.peek().add((Term)new DefaultStringLiteral(ctx.getText().substring(1, ctx.getText().length() - 1)));
    }

    @Override
    public void enterIdentifierSegment(ExpressionParser.IdentifierSegmentContext ctx) {
        String propertyName = ctx.name.getText();
        CompletableFuture<TypeReference> typeReferenceFuture = new CompletableFuture<TypeReference>();
        if (this.futureStack == null) {
            this.schedulePropertyResolution(propertyName, typeReferenceFuture, this.rootTypeName);
            this.futureStack = new Stack();
        } else {
            this.futureStack.peek().whenComplete((typeReference, throwable) -> {
                if (throwable != null) {
                    LOGGER.debug("Error processing variables", throwable);
                    return;
                }
                String typeName = ((NonSimpleTypeReference)typeReference.asNonSimpleTypeReference().orElseThrow()).getName();
                this.schedulePropertyResolution(propertyName, typeReferenceFuture, typeName);
            });
        }
        this.futureStack.push(typeReferenceFuture);
        this.parserContexts.push(new LinkedList());
    }

    private void schedulePropertyResolution(String propertyName, CompletableFuture<TypeReference> typeReferenceFuture, String typeName) {
        this.lazyTypeDefinitionConsumer.setOrScheduleTypeDefinitionConsumer(typeName, typeDefinition -> {
            TypeReference typeReference2;
            if (!typeDefinition.isComplexTypeDefinition()) {
                typeReferenceFuture.completeExceptionally(new RuntimeException("is not a complex type"));
                return;
            }
            ComplexTypeDefinition complexTypeDefinition = (ComplexTypeDefinition)typeDefinition.asComplexTypeDefinition().orElseThrow();
            Optional<DefaultTypedField> propertyFieldByName = complexTypeDefinition.getPropertyFieldByName(propertyName).map(DefaultTypedField.class::cast);
            if (propertyFieldByName.isEmpty()) {
                propertyFieldByName = complexTypeDefinition.getAllFields().stream().filter(NamedField.class::isInstance).map(NamedField.class::cast).filter(namedField -> propertyName.equals(namedField.getName())).map(DefaultTypedField.class::cast).findAny();
            }
            if (propertyFieldByName.isEmpty() && complexTypeDefinition.getAllParserArguments().isPresent()) {
                Optional<DefaultArgument> defaultArgument = ((List)complexTypeDefinition.getAllParserArguments().orElseThrow()).stream().filter(argument -> propertyName.equals(argument.getName())).map(DefaultArgument.class::cast).findAny();
                if (defaultArgument.isPresent()) {
                    defaultArgument.get().getTypeReferenceCompletionStage().whenComplete((typeReference, throwable) -> {
                        if (throwable != null) {
                            typeReferenceFuture.completeExceptionally((Throwable)throwable);
                        } else {
                            typeReferenceFuture.complete((TypeReference)typeReference);
                        }
                    });
                    return;
                }
            }
            if (propertyFieldByName.isEmpty() && (typeReference2 = (TypeReference)BuiltIns.builtInFields.get(propertyName)) != null) {
                typeReferenceFuture.complete(typeReference2);
                return;
            }
            if (propertyFieldByName.isEmpty()) {
                typeReferenceFuture.completeExceptionally(new RuntimeException("Field with name " + propertyName + " not found on " + typeName));
                return;
            }
            DefaultTypedField propertyField = propertyFieldByName.orElseThrow();
            propertyField.getTypeReferenceCompletionStage().whenComplete((propertyTypeReference, throwable) -> {
                if (throwable != null) {
                    typeReferenceFuture.completeExceptionally((Throwable)throwable);
                    return;
                }
                typeReferenceFuture.complete((TypeReference)propertyTypeReference);
            });
        });
    }

    @Override
    public void exitIdentifierSegment(ExpressionParser.IdentifierSegmentContext ctx) {
        List<Term> args = this.parserContexts.pop();
        ArgsContext argsContext = null;
        LinkedList indexContext = null;
        LinkedList restContext = null;
        for (Term arg : args) {
            if (arg instanceof ArgsContext) {
                argsContext = (ArgsContext)arg;
                continue;
            }
            if (arg instanceof IndexContext) {
                indexContext = (IndexContext)arg;
                continue;
            }
            if (!(arg instanceof RestContext)) continue;
            restContext = (RestContext)arg;
        }
        String name = ctx.name.getText();
        Integer index = null;
        if (indexContext != null) {
            index = ((NumericLiteral)indexContext.getFirst()).getNumber().intValue();
        }
        VariableLiteral rest = null;
        if (restContext != null) {
            rest = (VariableLiteral)restContext.getFirst();
        }
        DefaultVariableLiteral variableLiteral = new DefaultVariableLiteral(name, argsContext, index, rest);
        this.futureStack.pop().whenComplete((typeReference, throwable) -> {
            if (throwable != null) {
                LOGGER.debug("Error setting type", throwable);
                return;
            }
            variableLiteral.setTypeReference((TypeReference)typeReference);
        });
        if (this.futureStack.empty()) {
            this.futureStack = null;
        }
        this.parserContexts.peek().add((Term)variableLiteral);
    }

    @Override
    public void enterIdentifierSegmentArguments(ExpressionParser.IdentifierSegmentArgumentsContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitIdentifierSegmentArguments(ExpressionParser.IdentifierSegmentArgumentsContext ctx) {
        List<Term> args = this.parserContexts.pop();
        this.parserContexts.peek().add(new ArgsContext((Collection<Term>)args));
    }

    @Override
    public void enterIdentifierSegmentIndexes(ExpressionParser.IdentifierSegmentIndexesContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitIdentifierSegmentIndexes(ExpressionParser.IdentifierSegmentIndexesContext ctx) {
        List<Term> args = this.parserContexts.pop();
        List<NumericLiteral> numericLiterals = args.stream().map(NumericLiteral.class::cast).collect(Collectors.toList());
        this.parserContexts.peek().add(new IndexContext((Collection<NumericLiteral>)numericLiterals));
    }

    @Override
    public void enterIdentifierSegmentRest(ExpressionParser.IdentifierSegmentRestContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitIdentifierSegmentRest(ExpressionParser.IdentifierSegmentRestContext ctx) {
        List<Term> args = this.parserContexts.pop();
        List<VariableLiteral> variableLiterals = args.stream().map(VariableLiteral.class::cast).collect(Collectors.toList());
        this.parserContexts.peek().add(new RestContext((Collection<VariableLiteral>)variableLiterals));
    }

    @Override
    public void enterNotExpression(ExpressionParser.NotExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitNotExpression(ExpressionParser.NotExpressionContext ctx) {
        UnaryTerm ut = this.getUnaryTerm("!", this.parserContexts.pop());
        this.parserContexts.peek().add((Term)ut);
    }

    @Override
    public void enterUnaryMinusExpression(ExpressionParser.UnaryMinusExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitUnaryMinusExpression(ExpressionParser.UnaryMinusExpressionContext ctx) {
        UnaryTerm ut = this.getUnaryTerm("-", this.parserContexts.pop());
        this.parserContexts.peek().add((Term)ut);
    }

    @Override
    public void enterExpressionExpression(ExpressionParser.ExpressionExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitExpressionExpression(ExpressionParser.ExpressionExpressionContext ctx) {
        UnaryTerm ut = this.getUnaryTerm("()", this.parserContexts.pop());
        this.parserContexts.peek().add((Term)ut);
    }

    @Override
    public void enterOrExpression(ExpressionParser.OrExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitOrExpression(ExpressionParser.OrExpressionContext ctx) {
        BinaryTerm bt = this.getBinaryTerm("||", this.parserContexts.pop());
        this.parserContexts.peek().add((Term)bt);
    }

    @Override
    public void enterPowerExpression(ExpressionParser.PowerExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitPowerExpression(ExpressionParser.PowerExpressionContext ctx) {
        BinaryTerm bt = this.getBinaryTerm("^", this.parserContexts.pop());
        this.parserContexts.peek().add((Term)bt);
    }

    @Override
    public void enterEqExpression(ExpressionParser.EqExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitEqExpression(ExpressionParser.EqExpressionContext ctx) {
        BinaryTerm bt = this.getBinaryTerm(ctx.op.getText(), this.parserContexts.pop());
        this.parserContexts.peek().add((Term)bt);
    }

    @Override
    public void enterAndExpression(ExpressionParser.AndExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitAndExpression(ExpressionParser.AndExpressionContext ctx) {
        BinaryTerm bt = this.getBinaryTerm("&&", this.parserContexts.pop());
        this.parserContexts.peek().add((Term)bt);
    }

    @Override
    public void enterAddExpression(ExpressionParser.AddExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitAddExpression(ExpressionParser.AddExpressionContext ctx) {
        BinaryTerm bt = this.getBinaryTerm(ctx.op.getText(), this.parserContexts.pop());
        this.parserContexts.peek().add((Term)bt);
    }

    @Override
    public void enterBitShiftExpression(ExpressionParser.BitShiftExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitBitShiftExpression(ExpressionParser.BitShiftExpressionContext ctx) {
        BinaryTerm bt = this.getBinaryTerm(ctx.op.getText(), this.parserContexts.pop());
        this.parserContexts.peek().add((Term)bt);
    }

    @Override
    public void enterBitAndExpression(ExpressionParser.BitAndExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitBitAndExpression(ExpressionParser.BitAndExpressionContext ctx) {
        BinaryTerm bt = this.getBinaryTerm("&", this.parserContexts.pop());
        this.parserContexts.peek().add((Term)bt);
    }

    @Override
    public void enterBitOrExpression(ExpressionParser.BitOrExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitBitOrExpression(ExpressionParser.BitOrExpressionContext ctx) {
        BinaryTerm bt = this.getBinaryTerm("|", this.parserContexts.pop());
        this.parserContexts.peek().add((Term)bt);
    }

    @Override
    public void enterCompExpression(ExpressionParser.CompExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitCompExpression(ExpressionParser.CompExpressionContext ctx) {
        BinaryTerm bt = this.getBinaryTerm(ctx.op.getText(), this.parserContexts.pop());
        this.parserContexts.peek().add((Term)bt);
    }

    @Override
    public void enterMultExpression(ExpressionParser.MultExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitMultExpression(ExpressionParser.MultExpressionContext ctx) {
        BinaryTerm bt = this.getBinaryTerm(ctx.op.getText(), this.parserContexts.pop());
        this.parserContexts.peek().add((Term)bt);
    }

    @Override
    public void enterIfExpression(ExpressionParser.IfExpressionContext ctx) {
        this.parserContexts.push(new LinkedList());
    }

    @Override
    public void exitIfExpression(ExpressionParser.IfExpressionContext ctx) {
        TernaryTerm tt = this.getTernaryTerm("if", this.parserContexts.pop());
        this.parserContexts.peek().add((Term)tt);
    }

    private UnaryTerm getUnaryTerm(String op, List<Term> terms) {
        if (terms.size() != 1) {
            throw new RuntimeException(String.valueOf(op) + " should be a unary operation");
        }
        Term a = terms.get(0);
        return new DefaultUnaryTerm(a, op);
    }

    private BinaryTerm getBinaryTerm(String op, List<Term> terms) {
        if (terms.size() != 2) {
            throw new RuntimeException(String.valueOf(op) + " should be a binary operation");
        }
        Term a = terms.get(0);
        Term b = terms.get(1);
        return new DefaultBinaryTerm(a, b, op);
    }

    private TernaryTerm getTernaryTerm(String op, List<Term> terms) {
        if (terms.size() != 3) {
            throw new RuntimeException(String.valueOf(op) + " should be a ternary operation");
        }
        Term a = terms.get(0);
        Term b = terms.get(1);
        Term c = terms.get(2);
        return new DefaultTernaryTerm(a, b, c, op);
    }

    static class ArgsContext
    extends LinkedList<Term>
    implements Term {
        ArgsContext(Collection<Term> c) {
            super(c);
        }

        public boolean contains(String str) {
            return false;
        }

        public String stringRepresentation() {
            return "";
        }
    }

    static class IndexContext
    extends LinkedList<NumericLiteral>
    implements Term {
        IndexContext(Collection<NumericLiteral> c) {
            super(c);
        }

        public boolean contains(String str) {
            return false;
        }

        public String stringRepresentation() {
            return "";
        }
    }

    static class RestContext
    extends LinkedList<VariableLiteral>
    implements Term {
        RestContext(Collection<VariableLiteral> c) {
            super(c);
        }

        public boolean contains(String str) {
            return false;
        }

        public String stringRepresentation() {
            return "";
        }
    }
}

