/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.language.go;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.CaseUtils;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.definitions.DefaultArgument;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultBooleanTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultByteOrderTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultFloatTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.references.DefaultIntegerTypeReference;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultStringLiteral;
import org.apache.plc4x.plugins.codegenerator.protocol.freemarker.BaseFreemarkerLanguageTemplateHelper;
import org.apache.plc4x.plugins.codegenerator.protocol.freemarker.FreemarkerException;
import org.apache.plc4x.plugins.codegenerator.protocol.freemarker.Tracer;
import org.apache.plc4x.plugins.codegenerator.types.definitions.Argument;
import org.apache.plc4x.plugins.codegenerator.types.definitions.ComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.DataIoTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.DiscriminatedComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.EnumTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.enums.EnumValue;
import org.apache.plc4x.plugins.codegenerator.types.fields.ArrayField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ChecksumField;
import org.apache.plc4x.plugins.codegenerator.types.fields.DiscriminatorField;
import org.apache.plc4x.plugins.codegenerator.types.fields.EnumField;
import org.apache.plc4x.plugins.codegenerator.types.fields.Field;
import org.apache.plc4x.plugins.codegenerator.types.fields.ImplicitField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ManualArrayField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ManualField;
import org.apache.plc4x.plugins.codegenerator.types.fields.NamedField;
import org.apache.plc4x.plugins.codegenerator.types.fields.OptionalField;
import org.apache.plc4x.plugins.codegenerator.types.fields.PaddingField;
import org.apache.plc4x.plugins.codegenerator.types.fields.PropertyField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ReservedField;
import org.apache.plc4x.plugins.codegenerator.types.fields.SwitchField;
import org.apache.plc4x.plugins.codegenerator.types.fields.TypedField;
import org.apache.plc4x.plugins.codegenerator.types.fields.VirtualField;
import org.apache.plc4x.plugins.codegenerator.types.references.ArrayTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.ByteOrderTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.ComplexTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.DataIoTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.EnumTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.FloatTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.IntegerTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.NonSimpleTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.SimpleTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.StringTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReferenceConversions;
import org.apache.plc4x.plugins.codegenerator.types.references.VstringTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.BinaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.BooleanLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.HexadecimalLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.Literal;
import org.apache.plc4x.plugins.codegenerator.types.terms.LiteralConversions;
import org.apache.plc4x.plugins.codegenerator.types.terms.NullLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.NumericLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.StringLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;
import org.apache.plc4x.plugins.codegenerator.types.terms.TernaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.UnaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoLanguageTemplateHelper
extends BaseFreemarkerLanguageTemplateHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoLanguageTemplateHelper.class);
    private final Map<String, Object> options;
    public final SortedSet<String> requiredImports = new TreeSet<String>();
    public final SortedSet<String> requiredImportsForDataIo = new TreeSet<String>();

    public GoLanguageTemplateHelper(TypeDefinition thisType, String protocolName, String flavorName, Map<String, TypeDefinition> types, Map<String, Object> options) {
        super(thisType, protocolName, flavorName, types);
        this.options = options;
    }

    public String fileName(String protocolName, String languageName, String languageFlavorName) {
        return String.valueOf(String.join((CharSequence)"", protocolName.split("\\-"))) + "." + String.join((CharSequence)"", languageFlavorName.split("\\-"));
    }

    public String getSanitizedPackageName() {
        String sanitizedName = this.getProtocolName().replaceAll("-", "");
        sanitizedName = sanitizedName.replaceAll("\\.", "/");
        sanitizedName = sanitizedName.toLowerCase();
        return sanitizedName;
    }

    public String getSanitizedProtocolName() {
        String sanitizedName = this.getProtocolName().replaceAll("-", "");
        sanitizedName = CaseUtils.toCamelCase((String)sanitizedName, (boolean)false, (char[])new char[]{'.'});
        return sanitizedName;
    }

    public String packageName(String languageFlavorName) {
        return String.join((CharSequence)"", languageFlavorName.split("\\-"));
    }

    public String getLanguageTypeNameForField(Field field) {
        ComplexTypeReference complexTypeReference;
        ComplexTypeDefinition typeDefinition;
        PropertyField propertyField;
        boolean optional = field instanceof OptionalField;
        if (field instanceof PropertyField && (propertyField = (PropertyField)field).getType() instanceof ComplexTypeReference && (typeDefinition = (complexTypeReference = (ComplexTypeReference)propertyField.getType()).getTypeDefinition()) instanceof DataIoTypeDefinition) {
            return "PlcValue";
        }
        TypedField typedField = (TypedField)field.asTypedField().orElseThrow();
        String encoding = null;
        Optional encodingAttribute = field.getAttribute("encoding");
        if (encodingAttribute.isPresent()) {
            encoding = ((Term)encodingAttribute.get()).toString();
        }
        return this.getLanguageTypeNameForTypeReference(typedField.getType(), encoding);
    }

    public boolean isComplex(Field field) {
        return field instanceof PropertyField && ((PropertyField)field).getType() instanceof NonSimpleTypeReference;
    }

    public String getLanguageTypeNameForTypeReference(TypeReference typeReference) {
        if (this.options.containsKey("externalTypes")) {
            Object externalTypes = this.options.get("externalTypes");
            if (!(externalTypes instanceof Map)) {
                throw new IllegalArgumentException("The option 'externalTypes' is not a Map");
            }
            Map externalTypesMap = (Map)externalTypes;
            String typeName = null;
            if (typeReference.isComplexTypeReference()) {
                typeName = ((ComplexTypeReference)typeReference.asComplexTypeReference().orElseThrow()).getName();
            } else if (typeReference.isEnumTypeReference()) {
                typeName = ((EnumTypeReference)typeReference.asEnumTypeReference().orElseThrow()).getName();
            }
            if (typeName != null && externalTypesMap.containsKey(typeName)) {
                String namespaceAlias;
                String replacement = externalTypesMap.get(typeName).toString();
                if (replacement.contains(" ")) {
                    namespaceAlias = replacement.split(" ")[0];
                    String pkg = replacement.split(" ")[1];
                    pkg = pkg.substring(1, pkg.length() - 1);
                    this.emitDataIoRequiredImport(namespaceAlias, pkg);
                    this.emitRequiredImport(namespaceAlias, pkg);
                } else {
                    String[] split = replacement.split("/");
                    namespaceAlias = split[split.length - 1];
                    this.emitDataIoRequiredImport(replacement);
                    this.emitRequiredImport(replacement);
                }
                return String.valueOf(namespaceAlias) + "." + typeName;
            }
        }
        return this.getLanguageTypeNameForTypeReference(typeReference, null);
    }

    public String getLanguageTypeNameForTypeReference(TypeReference typeReference, boolean variadic) {
        return this.getLanguageTypeNameForTypeReference(typeReference, null, variadic);
    }

    public String getLanguageTypeNameForTypeReference(TypeReference typeReference, String encoding) {
        return this.getLanguageTypeNameForTypeReference(typeReference, encoding, false);
    }

    public String getLanguageTypeNameForTypeReference(TypeReference typeReference, String encoding, boolean variadic) {
        if (typeReference == null) {
            return "";
        }
        if (typeReference.isArrayTypeReference()) {
            ArrayTypeReference arrayTypeReference = (ArrayTypeReference)typeReference;
            TypeReference elementTypeReference = arrayTypeReference.getElementTypeReference();
            String arrayDeclaration = "[]";
            if (variadic) {
                arrayDeclaration = "...";
            }
            return String.valueOf(arrayDeclaration) + this.getLanguageTypeNameForTypeReference(elementTypeReference);
        }
        if (typeReference.isNonSimpleTypeReference()) {
            return ((NonSimpleTypeReference)typeReference.asNonSimpleTypeReference().orElseThrow()).getName();
        }
        if (typeReference instanceof ByteOrderTypeReference) {
            return "binary.byteOrder";
        }
        SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference.asSimpleTypeReference().orElseThrow();
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "bool";
            }
            case BYTE: {
                return "byte";
            }
            case UINT: {
                IntegerTypeReference unsignedIntegerTypeReference = (IntegerTypeReference)simpleTypeReference.asIntegerTypeReference().orElseThrow();
                if (unsignedIntegerTypeReference.getSizeInBits() <= 8) {
                    return "uint8";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 16) {
                    return "uint16";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 32) {
                    return "uint32";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 64) {
                    return "uint64";
                }
                this.emitRequiredImport("math/big");
                return "*big.Int";
            }
            case INT: {
                IntegerTypeReference integerTypeReference = (IntegerTypeReference)simpleTypeReference.asIntegerTypeReference().orElseThrow();
                if (integerTypeReference.getSizeInBits() <= 8) {
                    return "int8";
                }
                if (integerTypeReference.getSizeInBits() <= 16) {
                    return "int16";
                }
                if (integerTypeReference.getSizeInBits() <= 32) {
                    return "int32";
                }
                if (integerTypeReference.getSizeInBits() <= 64) {
                    return "int64";
                }
                this.emitRequiredImport("math/big");
                return "*big.Int";
            }
            case FLOAT: 
            case UFLOAT: {
                FloatTypeReference floatTypeReference = (FloatTypeReference)simpleTypeReference.asFloatTypeReference().orElseThrow();
                int sizeInBits = floatTypeReference.getSizeInBits();
                if (sizeInBits <= 32) {
                    return "float32";
                }
                if (sizeInBits <= 64) {
                    return "float64";
                }
                this.emitRequiredImport("math/big");
                return "*big.Float";
            }
            case STRING: 
            case VSTRING: {
                return "string";
            }
            case TIME: 
            case DATE: 
            case DATETIME: {
                this.emitRequiredImport("time");
                return "time.Time";
            }
        }
        throw new FreemarkerException("Unsupported simple type");
    }

    public String getPlcValueTypeForTypeReference(TypeReference typeReference) {
        if (typeReference == null) {
            return "";
        }
        if (typeReference.isNonSimpleTypeReference()) {
            return ((NonSimpleTypeReference)typeReference).getName();
        }
        SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference;
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "values.NewPlcBOOL";
            }
            case BYTE: {
                return "values.NewPlcBYTE";
            }
            case UINT: {
                IntegerTypeReference unsignedIntegerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (unsignedIntegerTypeReference.getSizeInBits() <= 8) {
                    return "values.NewPlcUSINT";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 16) {
                    return "values.NewPlcUINT";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 32) {
                    return "values.NewPlcUDINT";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 64) {
                    return "values.NewPlcULINT";
                }
                return "values.NewPlcBINT";
            }
            case INT: {
                IntegerTypeReference integerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (integerTypeReference.getSizeInBits() <= 8) {
                    return "values.NewPlcSINT";
                }
                if (integerTypeReference.getSizeInBits() <= 16) {
                    return "values.NewPlcINT";
                }
                if (integerTypeReference.getSizeInBits() <= 32) {
                    return "values.NewPlcDINT";
                }
                if (integerTypeReference.getSizeInBits() <= 64) {
                    return "values.NewPlcLINT";
                }
                return "values.NewPlcBINT";
            }
            case FLOAT: 
            case UFLOAT: {
                FloatTypeReference floatTypeReference = (FloatTypeReference)simpleTypeReference;
                int sizeInBits = floatTypeReference.getSizeInBits();
                if (sizeInBits <= 32) {
                    return "values.NewPlcREAL";
                }
                if (sizeInBits <= 64) {
                    return "values.NewPlcLREAL";
                }
                return "values.NewPlcBREAL";
            }
            case STRING: 
            case VSTRING: {
                return "values.NewPlcSTRING";
            }
            case TIME: {
                return "values.NewPlcTIME";
            }
            case DATE: {
                return "values.NewPlcDATE";
            }
            case DATETIME: {
                return "values.NewPlcDATE_AND_TIME";
            }
        }
        throw new FreemarkerException("Unsupported simple type" + simpleTypeReference.getBaseType());
    }

    public String getNullValueForTypeReference(TypeReference typeReference) {
        if (typeReference instanceof SimpleTypeReference) {
            SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference;
            switch (simpleTypeReference.getBaseType()) {
                case BIT: {
                    return "false";
                }
                case BYTE: 
                case UINT: 
                case INT: {
                    return "0";
                }
                case FLOAT: {
                    return "0.0";
                }
                case STRING: 
                case VSTRING: {
                    return "\"\"";
                }
            }
        } else if (typeReference.isEnumTypeReference()) {
            return "0";
        }
        return "nil";
    }

    public int getNumBits(SimpleTypeReference simpleTypeReference) {
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return 1;
            }
            case BYTE: {
                return 8;
            }
            case UINT: 
            case INT: {
                IntegerTypeReference integerTypeReference = (IntegerTypeReference)simpleTypeReference;
                return integerTypeReference.getSizeInBits();
            }
            case FLOAT: {
                FloatTypeReference floatTypeReference = (FloatTypeReference)simpleTypeReference;
                return floatTypeReference.getSizeInBits();
            }
            case STRING: 
            case VSTRING: {
                StringTypeReference stringTypeReference = (StringTypeReference)simpleTypeReference;
                return stringTypeReference.getSizeInBits();
            }
        }
        return 0;
    }

    public boolean needsPointerAccess(PropertyField field) {
        boolean isAnTypeOfOptional = "optional".equals(field.getTypeName());
        return isAnTypeOfOptional && this.isNonComplexOrArrayElementNonComplex(field.getType());
    }

    public boolean isNonComplexOrArrayElementNonComplex(TypeReference typeReference) {
        boolean arrayTypeIsNotAnComplexTypeReference;
        boolean isNotAnComplexTypeReference = !typeReference.isComplexTypeReference();
        boolean bl = arrayTypeIsNotAnComplexTypeReference = !typeReference.isArrayTypeReference() || !((ArrayTypeReference)typeReference.asArrayTypeReference().orElseThrow()).getElementTypeReference().isComplexTypeReference();
        return isNotAnComplexTypeReference && arrayTypeIsNotAnComplexTypeReference;
    }

    @Deprecated
    public String getSpecialReadBufferReadMethodCall(String logicalName, SimpleTypeReference simpleTypeReference, TypedField field) {
        return "/*TODO: migrate me*/" + this.getReadBufferReadMethodCall(logicalName, simpleTypeReference, null, field);
    }

    @Deprecated
    public String getReadBufferReadMethodCall(String logicalName, SimpleTypeReference simpleTypeReference, TypedField field) {
        return "/*TODO: migrate me*/" + this.getReadBufferReadMethodCall(logicalName, simpleTypeReference, null, field);
    }

    @Deprecated
    public String getReadBufferReadMethodCall(SimpleTypeReference simpleTypeReference, String valueString, TypedField field) {
        return "/*TODO: migrate me*/" + this.getReadBufferReadMethodCall("", simpleTypeReference, valueString, field);
    }

    @Deprecated
    public String getReadBufferReadMethodCall(String logicalName, SimpleTypeReference simpleTypeReference, String valueString, TypedField field) {
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "/*TODO: migrate me*/readBuffer.ReadBit(\"" + logicalName + "\")";
            }
            case BYTE: {
                return "/*TODO: migrate me*/readBuffer.ReadByte(\"" + logicalName + "\")";
            }
            case UINT: {
                IntegerTypeReference unsignedIntegerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (unsignedIntegerTypeReference.getSizeInBits() <= 8) {
                    return "/*TODO: migrate me*/readBuffer.ReadUint8(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ")";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 16) {
                    return "/*TODO: migrate me*/readBuffer.ReadUint16(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ")";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 32) {
                    return "/*TODO: migrate me*/readBuffer.ReadUint32(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ")";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 64) {
                    return "/*TODO: migrate me*/readBuffer.ReadUint64(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ")";
                }
                return "/*TODO: migrate me*/readBuffer.ReadBigInt(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ")";
            }
            case INT: {
                IntegerTypeReference integerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (integerTypeReference.getSizeInBits() <= 8) {
                    return "/*TODO: migrate me*/readBuffer.ReadInt8(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ")";
                }
                if (integerTypeReference.getSizeInBits() <= 16) {
                    return "/*TODO: migrate me*/readBuffer.ReadInt16(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ")";
                }
                if (integerTypeReference.getSizeInBits() <= 32) {
                    return "/*TODO: migrate me*/readBuffer.ReadInt32(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ")";
                }
                if (integerTypeReference.getSizeInBits() <= 64) {
                    return "/*TODO: migrate me*/readBuffer.ReadInt64(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ")";
                }
                return "/*TODO: migrate me*/readBuffer.ReadBigInt(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ")";
            }
            case FLOAT: {
                FloatTypeReference floatTypeReference = (FloatTypeReference)simpleTypeReference;
                if (floatTypeReference.getSizeInBits() <= 32) {
                    return "/*TODO: migrate me*/readBuffer.ReadFloat32(\"" + logicalName + "\", " + floatTypeReference.getSizeInBits() + ")";
                }
                if (floatTypeReference.getSizeInBits() <= 64) {
                    return "/*TODO: migrate me*/readBuffer.ReadFloat64(\"" + logicalName + "\", " + floatTypeReference.getSizeInBits() + ")";
                }
                return "/*TODO: migrate me*/readBuffer.ReadBigFloat(\"" + logicalName + "\", " + floatTypeReference.getSizeInBits() + ")";
            }
            case STRING: {
                String encoding = "UTF-8";
                if (field != null) {
                    Term encodingTerm = (Term)field.getEncoding().orElse(new DefaultStringLiteral(encoding));
                    encoding = ((StringLiteral)((Literal)encodingTerm.asLiteral().orElseThrow(() -> new FreemarkerException("Encoding must be a literal"))).asStringLiteral().orElseThrow(() -> new FreemarkerException("Encoding must be a quoted string value"))).getValue();
                }
                String length = Integer.toString(simpleTypeReference.getSizeInBits());
                return "/*TODO: migrate me*/readBuffer.ReadString(\"" + logicalName + "\", uint32(" + length + "), utils.WithEncoding(\"" + encoding + "\"))";
            }
            case VSTRING: {
                String encoding = "UTF-8";
                VstringTypeReference vstringTypeReference = (VstringTypeReference)simpleTypeReference;
                if (field != null) {
                    Term encodingTerm = (Term)field.getEncoding().orElse(new DefaultStringLiteral(encoding));
                    encoding = ((StringLiteral)((Literal)encodingTerm.asLiteral().orElseThrow(() -> new FreemarkerException("Encoding must be a literal"))).asStringLiteral().orElseThrow(() -> new FreemarkerException("Encoding must be a quoted string value"))).getValue();
                }
                String lengthExpression = this.toExpression((Field)field, null, vstringTypeReference.getLengthExpression(), null, null, false, false);
                lengthExpression = vstringTypeReference.getLengthExpression().isTernaryTerm() ? "(" + lengthExpression + ").(uint32)" : "uint32(" + lengthExpression + ")";
                return "/*TODO: migrate me*/readBuffer.ReadString(\"" + logicalName + "\", " + lengthExpression + ", utils.WithEncoding(\"" + encoding + "\"))";
            }
            case TIME: 
            case DATE: 
            case DATETIME: {
                this.emitRequiredImport("time");
                return "/*TODO: migrate me*/func() (time.Time, error) {raw, err := readBuffer.ReadUint32(\"" + logicalName + "\", 32);return time.UnixMilli(int64(raw)), err;}()";
            }
        }
        throw new FreemarkerException("Unsupported base type " + simpleTypeReference.getBaseType());
    }

    public String getDataReaderCall(TypeReference typeReference) {
        this.emitDataReaderRequiredImports();
        return this.getDataReaderCall(typeReference, "ByValue");
    }

    public String getDataReaderCall(TypeReference typeReference, String resolverMethod) {
        this.emitDataReaderRequiredImports();
        if (typeReference.isEnumTypeReference()) {
            String languageTypeName = this.getLanguageTypeNameForTypeReference(typeReference);
            SimpleTypeReference enumBaseTypeReference = this.getEnumBaseTypeReference(typeReference);
            return "ReadEnum(" + languageTypeName + resolverMethod + ", " + this.getDataReaderCall(enumBaseTypeReference) + ")";
        }
        if (typeReference.isArrayTypeReference()) {
            ArrayTypeReference arrayTypeReference = (ArrayTypeReference)typeReference.asArrayTypeReference().orElseThrow();
            return this.getDataReaderCall(arrayTypeReference.getElementTypeReference(), resolverMethod);
        }
        if (typeReference.isSimpleTypeReference()) {
            SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference.asSimpleTypeReference().orElseThrow(IllegalStateException::new);
            return this.getDataReaderCall(simpleTypeReference);
        }
        if (typeReference.isComplexTypeReference()) {
            String typeName;
            StringBuilder paramsString = new StringBuilder();
            ComplexTypeReference complexTypeReference = (ComplexTypeReference)typeReference.asComplexTypeReference().orElseThrow(IllegalStateException::new);
            ComplexTypeDefinition typeDefinition = complexTypeReference.getTypeDefinition();
            String parserCallString = typeName = this.getLanguageTypeNameForTypeReference(typeReference);
            if (typeReference.isDataIoTypeReference()) {
                parserCallString = ((DataIoTypeReference)typeReference.asDataIoTypeReference().orElseThrow()).getName();
            }
            if (typeDefinition.isDiscriminatedChildTypeDefinition()) {
                parserCallString = ((ComplexTypeDefinition)typeDefinition.getParentType().orElseThrow()).getName();
            }
            List paramTerms = complexTypeReference.getParams().orElse(Collections.emptyList());
            int i = 0;
            while (i < paramTerms.size()) {
                Term paramTerm = (Term)paramTerms.get(i);
                TypeReference argumentType = this.getArgumentType((TypeReference)complexTypeReference, i);
                paramsString.append(", (").append(this.getLanguageTypeNameForTypeReference(argumentType)).append(") (").append(this.toParseExpression(null, argumentType, paramTerm, null)).append(")");
                ++i;
            }
            String paramsStringString = paramsString.toString();
            if (StringUtils.isNotBlank((CharSequence)paramsStringString) || typeDefinition.isDiscriminatedChildTypeDefinition()) {
                String genericTypeParam = "";
                if (typeDefinition.isDiscriminatedParentTypeDefinition() || typeDefinition.isDiscriminatedChildTypeDefinition()) {
                    genericTypeParam = "[" + typeName + "]";
                }
                return "ReadComplex[" + typeName + "](" + parserCallString + "ParseWithBufferProducer" + genericTypeParam + "(" + StringUtils.substring((String)paramsStringString, (int)2) + "), readBuffer)";
            }
            return "ReadComplex[" + typeName + "](" + parserCallString + "ParseWithBuffer, readBuffer)";
        }
        throw new IllegalStateException("What is this type? " + typeReference);
    }

    public String getDataReaderCall(SimpleTypeReference simpleTypeReference) {
        this.emitDataReaderRequiredImports();
        int sizeInBits = simpleTypeReference.getSizeInBits();
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "ReadBoolean(readBuffer)";
            }
            case BYTE: {
                return "ReadByte(readBuffer, " + sizeInBits + ")";
            }
            case UINT: {
                if (sizeInBits <= 8) {
                    return "ReadUnsignedByte(readBuffer, uint8(" + sizeInBits + "))";
                }
                if (sizeInBits <= 16) {
                    return "ReadUnsignedShort(readBuffer, uint8(" + sizeInBits + "))";
                }
                if (sizeInBits <= 32) {
                    return "ReadUnsignedInt(readBuffer, uint8(" + sizeInBits + "))";
                }
                if (sizeInBits <= 64) {
                    return "ReadUnsignedLong(readBuffer, uint8(" + sizeInBits + "))";
                }
                return "ReadUnsignedBigInteger(readBuffer, uint8(" + sizeInBits + "))";
            }
            case INT: {
                if (sizeInBits <= 8) {
                    return "ReadSignedByte(readBuffer, uint8(" + sizeInBits + "))";
                }
                if (sizeInBits <= 16) {
                    return "ReadSignedShort(readBuffer, uint8(" + sizeInBits + "))";
                }
                if (sizeInBits <= 32) {
                    return "ReadSignedInt(readBuffer, uint8(" + sizeInBits + "))";
                }
                if (sizeInBits <= 64) {
                    return "ReadSignedLong(readBuffer, uint8(" + sizeInBits + "))";
                }
                return "ReadSignedBigInteger(readBuffer, uint8(" + sizeInBits + "))";
            }
            case FLOAT: {
                if (sizeInBits <= 32) {
                    return "ReadFloat(readBuffer, uint8(" + sizeInBits + "))";
                }
                if (sizeInBits <= 64) {
                    return "ReadDouble(readBuffer, uint8(" + sizeInBits + "))";
                }
                return "ReadBigDecimal(readBuffer, uint8(" + sizeInBits + "))";
            }
            case STRING: {
                return "ReadString(readBuffer, uint32(" + sizeInBits + "))";
            }
            case VSTRING: {
                VstringTypeReference vstringTypeReference = (VstringTypeReference)simpleTypeReference;
                return "ReadString(readBuffer, uint32(" + this.toParseExpression(null, INT_TYPE_REFERENCE, vstringTypeReference.getLengthExpression(), null) + "))";
            }
            case TIME: {
                return "ReadTime(readBuffer)";
            }
            case DATE: {
                return "ReadDate(readBuffer)";
            }
            case DATETIME: {
                return "ReadDateTime(readBuffer)";
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + simpleTypeReference.getBaseType());
    }

    public String getDataWriterCall(TypeReference typeReference, String fieldName) {
        this.emitDataReaderRequiredImports();
        if (typeReference.isSimpleTypeReference()) {
            SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference.asSimpleTypeReference().orElseThrow(IllegalStateException::new);
            return this.getDataWriterCall(simpleTypeReference);
        }
        if (typeReference.isArrayTypeReference()) {
            ArrayTypeReference arrayTypeReference = (ArrayTypeReference)typeReference.asArrayTypeReference().orElseThrow();
            return this.getDataWriterCall(arrayTypeReference.getElementTypeReference(), fieldName);
        }
        if (typeReference.isComplexTypeReference()) {
            return "WriteComplex[" + this.getLanguageTypeNameForTypeReference(typeReference) + "](writeBuffer)";
        }
        throw new IllegalStateException("What is this type? " + typeReference);
    }

    public String getEnumDataWriterCall(EnumTypeReference typeReference, String fieldName, String attributeName) {
        this.emitDataReaderRequiredImports();
        if (!typeReference.isEnumTypeReference()) {
            throw new IllegalArgumentException("this method should only be called for enum types");
        }
        String languageTypeName = this.getLanguageTypeNameForTypeReference((TypeReference)typeReference);
        SimpleTypeReference outputTypeReference = "value".equals(attributeName) ? this.getEnumBaseTypeReference((TypeReference)typeReference) : this.getEnumFieldSimpleTypeReference((NonSimpleTypeReference)typeReference.asNonSimpleTypeReference().orElseThrow(), attributeName);
        return "WriteEnum[" + languageTypeName + "," + this.getLanguageTypeNameForTypeReference((TypeReference)outputTypeReference) + "](" + languageTypeName + ".Get" + StringUtils.capitalize((String)attributeName) + ", " + languageTypeName + ".PLC4XEnumName, " + this.getDataWriterCall((TypeReference)outputTypeReference, fieldName) + ")";
    }

    public String getDataWriterCall(SimpleTypeReference simpleTypeReference) {
        this.emitDataReaderRequiredImports();
        int sizeInBits = simpleTypeReference.getSizeInBits();
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "WriteBoolean(writeBuffer)";
            }
            case BYTE: {
                return "WriteByte(writeBuffer, " + sizeInBits + ")";
            }
            case UINT: {
                if (sizeInBits <= 8) {
                    return "WriteUnsignedByte(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 16) {
                    return "WriteUnsignedShort(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 32) {
                    return "WriteUnsignedInt(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 64) {
                    return "WriteUnsignedLong(writeBuffer, " + sizeInBits + ")";
                }
                return "WriteUnsignedBigInteger(writeBuffer, " + sizeInBits + ")";
            }
            case INT: {
                if (sizeInBits <= 8) {
                    return "WriteSignedByte(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 16) {
                    return "WriteSignedShort(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 32) {
                    return "WriteSignedInt(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 64) {
                    return "WriteSignedLong(writeBuffer, " + sizeInBits + ")";
                }
                return "WriteSignedBigInteger(writeBuffer, " + sizeInBits + ")";
            }
            case FLOAT: {
                if (sizeInBits <= 32) {
                    return "WriteFloat(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 64) {
                    return "WriteDouble(writeBuffer, " + sizeInBits + ")";
                }
                return "WriteBigDecimal(writeBuffer, " + sizeInBits + ")";
            }
            case STRING: {
                return "WriteString(writeBuffer, " + sizeInBits + ")";
            }
            case VSTRING: {
                VstringTypeReference vstringTypeReference = (VstringTypeReference)simpleTypeReference;
                return "WriteString(writeBuffer, int32(" + this.toSerializationExpression(null, INT_TYPE_REFERENCE, vstringTypeReference.getLengthExpression(), null) + "))";
            }
            case TIME: {
                return "WriteTime(writeBuffer)";
            }
            case DATE: {
                return "WriteDate(writeBuffer)";
            }
            case DATETIME: {
                return "WriteDateTime(writeBuffer)";
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + simpleTypeReference.getBaseType());
    }

    @Deprecated
    public String getWriteBufferWriteMethodCall(SimpleTypeReference simpleTypeReference, String fieldName, TypedField field) {
        String logicalName = fieldName.replaceAll("[\"()*]", "").replaceFirst("_", "");
        return "/*TODO: migrate me*/" + this.getWriteBufferWriteMethodCall(logicalName, simpleTypeReference, fieldName, field, new String[0]);
    }

    @Deprecated
    public String getWriteBufferWriteMethodCall(String logicalName, SimpleTypeReference simpleTypeReference, Term valueTerm, TypedField field, String ... writerArgs) {
        if (valueTerm instanceof BooleanLiteral) {
            return "/*TODO: migrate me*/" + this.getWriteBufferWriteMethodCall(logicalName, simpleTypeReference, Boolean.toString(((BooleanLiteral)valueTerm).getValue()), field, writerArgs);
        }
        if (valueTerm instanceof NumericLiteral) {
            return "/*TODO: migrate me*/" + this.getWriteBufferWriteMethodCall(logicalName, simpleTypeReference, ((NumericLiteral)valueTerm).getNumber().toString(), field, writerArgs);
        }
        if (valueTerm instanceof HexadecimalLiteral) {
            return "/*TODO: migrate me*/" + this.getWriteBufferWriteMethodCall(logicalName, simpleTypeReference, ((HexadecimalLiteral)valueTerm).getHexString(), field, writerArgs);
        }
        if (valueTerm instanceof StringLiteral) {
            return "/*TODO: migrate me*/" + this.getWriteBufferWriteMethodCall(logicalName, simpleTypeReference, "\"" + ((StringLiteral)valueTerm).getValue() + "\"", field, writerArgs);
        }
        throw new FreemarkerException("Outputting " + valueTerm.toString() + " not implemented yet. Please continue defining other types in the GoLanguageHelper.getWriteBufferWriteMethodCall.");
    }

    @Deprecated
    public String getWriteBufferWriteMethodCall(String logicalName, SimpleTypeReference simpleTypeReference, String fieldName, TypedField field, String ... writerArgs) {
        String writerArgsString = "";
        if (writerArgs.length > 0) {
            writerArgsString = String.valueOf(writerArgsString) + ", " + StringUtils.join((Object[])writerArgs, (String)", ");
        }
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "/*TODO: migrate me*/writeBuffer.WriteBit(\"" + logicalName + "\", " + fieldName + writerArgsString + ")";
            }
            case BYTE: {
                return "/*TODO: migrate me*/writeBuffer.WriteByte(\"" + logicalName + "\", " + fieldName + writerArgsString + ")";
            }
            case UINT: {
                IntegerTypeReference unsignedIntegerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (unsignedIntegerTypeReference.getSizeInBits() <= 8) {
                    return "/*TODO: migrate me*/writeBuffer.WriteUint8(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ", uint8(" + fieldName + ")" + writerArgsString + ")";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 16) {
                    return "/*TODO: migrate me*/writeBuffer.WriteUint16(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ", uint16(" + fieldName + ")" + writerArgsString + ")";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 32) {
                    return "/*TODO: migrate me*/writeBuffer.WriteUint32(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ", uint32(" + fieldName + ")" + writerArgsString + ")";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 64) {
                    return "/*TODO: migrate me*/writeBuffer.WriteUint64(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ", uint64(" + fieldName + ")" + writerArgsString + ")";
                }
                return "/*TODO: migrate me*/writeBuffer.WriteBigInt(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ", " + fieldName + writerArgsString + ")";
            }
            case INT: {
                IntegerTypeReference integerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (integerTypeReference.getSizeInBits() <= 8) {
                    return "/*TODO: migrate me*/writeBuffer.WriteInt8(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ", int8(" + fieldName + ")" + writerArgsString + ")";
                }
                if (integerTypeReference.getSizeInBits() <= 16) {
                    return "/*TODO: migrate me*/writeBuffer.WriteInt16(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ", int16(" + fieldName + ")" + writerArgsString + ")";
                }
                if (integerTypeReference.getSizeInBits() <= 32) {
                    return "/*TODO: migrate me*/writeBuffer.WriteInt32(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ", int32(" + fieldName + ")" + writerArgsString + ")";
                }
                if (integerTypeReference.getSizeInBits() <= 64) {
                    return "/*TODO: migrate me*/writeBuffer.WriteInt64(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ", int64(" + fieldName + ")" + writerArgsString + ")";
                }
                return "/*TODO: migrate me*/writeBuffer.WriteBigInt(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ", " + fieldName + writerArgsString + ")";
            }
            case FLOAT: 
            case UFLOAT: {
                FloatTypeReference floatTypeReference = (FloatTypeReference)simpleTypeReference;
                if (floatTypeReference.getSizeInBits() <= 32) {
                    return "/*TODO: migrate me*/writeBuffer.WriteFloat32(\"" + logicalName + "\", " + floatTypeReference.getSizeInBits() + ", " + fieldName + writerArgsString + ")";
                }
                if (floatTypeReference.getSizeInBits() <= 64) {
                    return "/*TODO: migrate me*/writeBuffer.WriteFloat64(\"" + logicalName + "\", " + floatTypeReference.getSizeInBits() + ", " + fieldName + writerArgsString + ")";
                }
                return "/*TODO: migrate me*/writeBuffer.WriteBigFloat(\"" + logicalName + "\", " + floatTypeReference.getSizeInBits() + ", " + fieldName + writerArgsString + ")";
            }
            case STRING: {
                StringTypeReference stringTypeReference = (StringTypeReference)simpleTypeReference;
                String encoding = "UTF-8";
                if (field != null) {
                    Term encodingTerm = (Term)field.getEncoding().orElse(new DefaultStringLiteral("UTF-8"));
                    encoding = ((StringLiteral)((Literal)encodingTerm.asLiteral().orElseThrow(() -> new FreemarkerException("Encoding must be a literal"))).asStringLiteral().orElseThrow(() -> new FreemarkerException("Encoding must be a quoted string value"))).getValue();
                }
                String length = Integer.toString(simpleTypeReference.getSizeInBits());
                return "/*TODO: migrate me*/writeBuffer.WriteString(\"" + logicalName + "\", uint32(" + length + "), " + fieldName + writerArgsString + ", utils.WithEncoding(\"" + encoding + ")\"))";
            }
            case VSTRING: {
                VstringTypeReference vstringTypeReference = (VstringTypeReference)simpleTypeReference;
                String encoding = "UTF-8";
                if (field != null) {
                    Term encodingTerm = (Term)field.getEncoding().orElse(new DefaultStringLiteral("UTF-8"));
                    encoding = ((StringLiteral)((Literal)encodingTerm.asLiteral().orElseThrow(() -> new FreemarkerException("Encoding must be a literal"))).asStringLiteral().orElseThrow(() -> new FreemarkerException("Encoding must be a quoted string value"))).getValue();
                }
                String lengthExpression = this.toExpression((Field)field, null, vstringTypeReference.getLengthExpression(), null, Collections.singletonList(new DefaultArgument("stringLength", (TypeReference)new DefaultIntegerTypeReference(SimpleTypeReference.SimpleBaseType.INT, 32))), true, false);
                lengthExpression = vstringTypeReference.getLengthExpression().isTernaryTerm() ? "(" + lengthExpression + ").(uint32)" : "uint32(" + lengthExpression + ")";
                String length = Integer.toString(simpleTypeReference.getSizeInBits());
                return "/*TODO: migrate me*/writeBuffer.WriteString(\"" + logicalName + "\", " + lengthExpression + ", " + fieldName + writerArgsString + ", utils.WithEncoding(\"" + encoding + ")\"))";
            }
            case TIME: 
            case DATE: 
            case DATETIME: {
                return "/*TODO: migrate me*/writeBuffer.WriteUint32(\"" + logicalName + "\", uint32(" + fieldName + ")" + writerArgsString + ")";
            }
        }
        throw new FreemarkerException("Unsupported base type " + simpleTypeReference.getBaseType());
    }

    public String getReservedValue(ReservedField reservedField) {
        String languageTypeName;
        switch (languageTypeName = this.getLanguageTypeNameForTypeReference(reservedField.getType())) {
            case "*big.Int": {
                this.emitRequiredImport("math/big");
                return "big.NewInt(" + reservedField.getReferenceValue() + ")";
            }
            case "*big.Float": {
                this.emitRequiredImport("math/big");
                return "*big.Float(" + reservedField.getReferenceValue() + ")";
            }
        }
        return String.valueOf(languageTypeName) + "(" + reservedField.getReferenceValue() + ")";
    }

    public String toTypeSafeCompare(ReservedField reservedField) {
        String languageTypeName;
        switch (languageTypeName = this.getLanguageTypeNameForTypeReference(reservedField.getType())) {
            case "*big.Int": 
            case "*big.Float": {
                this.emitRequiredImport("math/big");
                return "reserved.Cmp(" + this.getReservedValue(reservedField) + ") != 0";
            }
        }
        return "reserved != " + this.getReservedValue(reservedField);
    }

    public String toParseExpression(Field field, TypeReference resultType, Term term, List<Argument> parserArguments) {
        Tracer tracer = Tracer.start((String)"toParseExpression");
        return tracer + this.toTypedParseExpression(field, resultType, term, parserArguments);
    }

    public String toParseExpression(Field field, TypeReference resultType, Term term, List<Argument> parserArguments, boolean suppressPointerAccess) {
        Tracer tracer = Tracer.start((String)"toParseExpression");
        return tracer + this.toTypedParseExpression(field, resultType, term, parserArguments, suppressPointerAccess);
    }

    public String toSerializationExpression(Field field, TypeReference resultType, Term term, List<Argument> serializerArguments) {
        Tracer tracer = Tracer.start((String)"toSerializationExpression");
        return tracer + this.toTypedSerializationExpression(field, resultType, term, serializerArguments);
    }

    public String toBooleanParseExpression(Field field, Term term, List<Argument> parserArguments) {
        Tracer tracer = Tracer.start((String)"toBooleanParseExpression");
        return tracer + this.toTypedParseExpression(field, (TypeReference)new DefaultBooleanTypeReference(), term, parserArguments);
    }

    public String toBooleanSerializationExpression(Field field, Term term, List<Argument> serializerArguments) {
        Tracer tracer = Tracer.start((String)"toBooleanSerializationExpression");
        return tracer + this.toTypedSerializationExpression(field, (TypeReference)new DefaultBooleanTypeReference(), term, serializerArguments);
    }

    public String toIntegerParseExpression(Field field, int sizeInBits, Term term, List<Argument> parserArguments) {
        Tracer tracer = Tracer.start((String)"toIntegerParseExpression");
        return tracer + this.toTypedParseExpression(field, (TypeReference)new DefaultIntegerTypeReference(SimpleTypeReference.SimpleBaseType.UINT, sizeInBits), term, parserArguments);
    }

    public String toIntegerSerializationExpression(Field field, int sizeInBits, Term term, List<Argument> serializerArguments) {
        Tracer tracer = Tracer.start((String)"toIntegerSerializationExpression");
        return tracer + this.toTypedSerializationExpression(field, (TypeReference)new DefaultIntegerTypeReference(SimpleTypeReference.SimpleBaseType.UINT, sizeInBits), term, serializerArguments);
    }

    public String toTypedParseExpression(Field field, TypeReference fieldType, Term term, List<Argument> parserArguments) {
        Tracer tracer = Tracer.start((String)"toTypedParseExpression");
        return tracer + this.toExpression(field, fieldType, term, parserArguments, null, false, fieldType != null && fieldType.isComplexTypeReference());
    }

    public String toTypedParseExpression(Field field, TypeReference fieldType, Term term, List<Argument> parserArguments, boolean suppressPointerAccess) {
        Tracer tracer = Tracer.start((String)"toTypedParseExpression");
        return tracer + this.toExpression(field, fieldType, term, parserArguments, null, false, suppressPointerAccess);
    }

    public String toTypedSerializationExpression(Field field, TypeReference fieldType, Term term, List<Argument> serializerArguments) {
        Tracer tracer = Tracer.start((String)"toTypedSerializationExpression");
        return tracer + this.toExpression(field, fieldType, term, null, serializerArguments, true, false);
    }

    String getCastExpressionForTypeReference(TypeReference typeReference) {
        Tracer tracer = Tracer.start((String)"castExpression");
        if (typeReference instanceof SimpleTypeReference) {
            return tracer.dive("simpleTypeRef") + this.getLanguageTypeNameForTypeReference(typeReference);
        }
        if (typeReference instanceof ByteOrderTypeReference) {
            return tracer.dive("byteOrderTypeRef") + "binary.ByteOrder";
        }
        if (typeReference != null) {
            return tracer.dive("anyTypeRef") + "Cast" + this.getLanguageTypeNameForTypeReference(typeReference);
        }
        return "" + tracer.dive("noTypeRef");
    }

    private String toExpression(Field field, TypeReference fieldType, Term term, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess) {
        Tracer tracer = Tracer.start((String)("toExpression(suppressPointerAccess=" + suppressPointerAccess + ")"));
        if (term == null) {
            return "";
        }
        if (term instanceof Literal) {
            return this.toLiteralTermExpression(field, fieldType, term, parserArguments, serializerArguments, serialize, suppressPointerAccess, tracer);
        }
        if (term instanceof UnaryTerm) {
            return this.toUnaryTermExpression(field, fieldType, (UnaryTerm)term, parserArguments, serializerArguments, serialize, tracer);
        }
        if (term instanceof BinaryTerm) {
            return this.toBinaryTermExpression(field, fieldType, (BinaryTerm)term, parserArguments, serializerArguments, serialize, tracer);
        }
        if (term instanceof TernaryTerm) {
            return this.toTernaryTermExpression(field, fieldType, (TernaryTerm)term, parserArguments, serializerArguments, serialize, tracer);
        }
        throw new FreemarkerException("Unsupported Term type " + term.getClass().getName());
    }

    private String toTernaryTermExpression(Field field, TypeReference fieldType, TernaryTerm ternaryTerm, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, Tracer tracer) {
        tracer = tracer.dive("ternary term instanceOf");
        if ("if".equals(ternaryTerm.getOperation())) {
            Term a = ternaryTerm.getA();
            Term b = ternaryTerm.getB();
            Term c = ternaryTerm.getC();
            String castExpressionForTypeReference = this.getCastExpressionForTypeReference(fieldType);
            String inlineIf = "utils.InlineIf(" + this.toExpression(field, (TypeReference)new DefaultBooleanTypeReference(), a, parserArguments, serializerArguments, serialize, false) + ", " + "func() any {return " + castExpressionForTypeReference + "(" + this.toExpression(field, fieldType, b, parserArguments, serializerArguments, serialize, false) + ")}, " + "func() any {return " + castExpressionForTypeReference + "(" + this.toExpression(field, fieldType, c, parserArguments, serializerArguments, serialize, false) + ")})";
            if (fieldType != null) {
                if (fieldType instanceof ByteOrderTypeReference) {
                    return tracer.dive("byteordertypereference") + "(" + inlineIf + ").(binary.ByteOrder)";
                }
                if (fieldType.isNonSimpleTypeReference()) {
                    return tracer.dive("nonsimpletypereference") + castExpressionForTypeReference + "(" + inlineIf + ")";
                }
                return tracer + inlineIf + ".(" + castExpressionForTypeReference + ")";
            }
            return tracer + inlineIf;
        }
        throw new FreemarkerException("Unsupported ternary operation type " + ternaryTerm.getOperation());
    }

    private String toBinaryTermExpression(Field field, TypeReference fieldType, BinaryTerm binaryTerm, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, Tracer tracer) {
        tracer = tracer.dive("binary term instanceOf");
        Term a = binaryTerm.getA();
        Term b = binaryTerm.getB();
        String operation = binaryTerm.getOperation();
        String castExpressionForTypeReference = this.getCastExpressionForTypeReference(fieldType);
        switch (operation) {
            case "^": {
                tracer = tracer.dive("^");
                this.emitRequiredImport("math");
                return tracer + "Math.pow(" + castExpressionForTypeReference + "(" + this.toExpression(field, fieldType, a, parserArguments, serializerArguments, serialize, false) + "), " + castExpressionForTypeReference + "(" + this.toExpression(field, fieldType, b, parserArguments, serializerArguments, serialize, false) + "))";
            }
            case "<": 
            case ">": 
            case "!=": 
            case "<=": 
            case "==": 
            case ">=": {
                tracer = tracer.dive("compare");
                boolean suppressPointerAccessOverride = !(!operation.equals("==") && !operation.equals("!=") || !(a instanceof NullLiteral) && !(b instanceof NullLiteral));
                String aExpression = this.toExpression(field, null, a, parserArguments, serializerArguments, serialize, suppressPointerAccessOverride);
                String bExpression = this.toExpression(field, null, b, parserArguments, serializerArguments, serialize, suppressPointerAccessOverride);
                return tracer + "bool((" + aExpression + ") " + operation + " (" + bExpression + "))";
            }
            case "&": 
            case "|": 
            case "<<": 
            case ">>": {
                tracer = tracer.dive("bitwise");
                return tracer + this.toExpression(field, fieldType, a, parserArguments, serializerArguments, serialize, false) + operation + " " + this.toExpression(field, fieldType, b, parserArguments, serializerArguments, serialize, false);
            }
        }
        tracer = tracer.dive("default");
        if (fieldType instanceof StringTypeReference) {
            tracer = tracer.dive("string type reference");
            return tracer + this.toExpression(field, fieldType, a, parserArguments, serializerArguments, serialize, false) + operation + " " + this.toExpression(field, fieldType, b, parserArguments, serializerArguments, serialize, false);
        }
        return tracer + castExpressionForTypeReference + "(" + this.toExpression(field, fieldType, a, parserArguments, serializerArguments, serialize, false) + ") " + operation + " " + castExpressionForTypeReference + "(" + this.toExpression(field, fieldType, b, parserArguments, serializerArguments, serialize, false) + ")";
    }

    private String toUnaryTermExpression(Field field, TypeReference fieldType, UnaryTerm unaryTerm, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, Tracer tracer) {
        tracer = tracer.dive("unary term instanceOf");
        Term a = unaryTerm.getA();
        switch (unaryTerm.getOperation()) {
            case "!": {
                tracer = tracer.dive("case !");
                return tracer + "!(" + this.toExpression(field, fieldType, a, parserArguments, serializerArguments, serialize, false) + ")";
            }
            case "-": {
                tracer = tracer.dive("case -");
                return tracer + "-(" + this.toExpression(field, fieldType, a, parserArguments, serializerArguments, serialize, false) + ")";
            }
            case "()": {
                tracer = tracer.dive("case ()");
                return tracer + "(" + this.toExpression(field, fieldType, a, parserArguments, serializerArguments, serialize, false) + ")";
            }
        }
        throw new FreemarkerException("Unsupported unary operation type " + unaryTerm.getOperation());
    }

    private String toLiteralTermExpression(Field field, TypeReference fieldType, Term term, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess, Tracer tracer) {
        tracer = tracer.dive("literal term instanceOf");
        if (term instanceof NullLiteral) {
            tracer = tracer.dive("null literal instanceOf");
            return tracer + "nil";
        }
        if (term instanceof BooleanLiteral) {
            tracer = tracer.dive("boolean literal instanceOf");
            return tracer + this.getCastExpressionForTypeReference(fieldType) + "(" + ((BooleanLiteral)term).getValue() + ")";
        }
        if (term instanceof NumericLiteral) {
            tracer = tracer.dive("numeric literal instanceOf");
            if (this.getCastExpressionForTypeReference(fieldType).equals("string")) {
                tracer = tracer.dive("type reference string");
                return tracer + "(" + ((NumericLiteral)term).getNumber().toString() + ")";
            }
            return tracer + this.getCastExpressionForTypeReference(fieldType) + "(" + ((NumericLiteral)term).getNumber().toString() + ")";
        }
        if (term instanceof HexadecimalLiteral) {
            tracer = tracer.dive("hexadecimal literal instanceOf");
            return tracer + ((HexadecimalLiteral)term).getHexString();
        }
        if (term instanceof StringLiteral) {
            tracer = tracer.dive("string literal instanceOf");
            return tracer + "\"" + ((StringLiteral)term).getValue() + "\"";
        }
        if (term instanceof VariableLiteral) {
            tracer = tracer.dive("variable literal instanceOf");
            VariableLiteral variableLiteral = (VariableLiteral)term;
            if ("curPos".equals(((VariableLiteral)term).getName())) {
                return "(positionAware.GetPos() - startPos)";
            }
            if ("BIG_ENDIAN".equals(((VariableLiteral)term).getName()) && fieldType instanceof ByteOrderTypeReference) {
                return "binary.BigEndian";
            }
            if ("LITTLE_ENDIAN".equals(((VariableLiteral)term).getName()) && fieldType instanceof ByteOrderTypeReference) {
                return "binary.LittleEndian";
            }
            return tracer + this.toVariableExpression(field, fieldType, (VariableLiteral)term, parserArguments, serializerArguments, serialize, suppressPointerAccess);
        }
        throw new FreemarkerException("Unsupported Literal type " + term.getClass().getName());
    }

    private String toVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess) {
        return this.toVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, serialize, suppressPointerAccess, false);
    }

    /*
     * Unable to fully structure code
     */
    private String toVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess, boolean isChild) {
        tracer = Tracer.start((String)("toVariableExpression(serialize=" + serialize + ")"));
        variableLiteralName = variableLiteral.getName();
        v0 = isEnumTypeReference = typeReference != null && typeReference.isEnumTypeReference() != false;
        if ("lengthInBytes".equals(variableLiteralName)) {
            return this.toLengthInBytesVariableExpression(typeReference, serialize, tracer);
        }
        if ("lengthInBits".equals(variableLiteralName)) {
            return this.toLengthInBitsVariableExpression(typeReference, serialize, tracer);
        }
        if ("_value".equals(variableLiteralName)) {
            return this.toValueVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, serialize, suppressPointerAccess, tracer);
        }
        if ("_lastItem".equals(variableLiteralName)) {
            return this.toLastItemVariableExpression(typeReference, serialize, tracer);
        }
        if ("length".equals(variableLiteral.getChild().map((Function<VariableLiteral, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Lorg/apache/plc4x/plugins/codegenerator/types/terms/VariableLiteral;)Ljava/lang/String;)()).orElse(""))) {
            return this.toLengthVariableExpression(field, variableLiteral, serialize, tracer);
        }
        if (this.getTypeDefinitions().get(variableLiteralName) instanceof EnumTypeDefinition) {
            return this.toEnumVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, suppressPointerAccess, tracer);
        }
        if (this.thisType.isComplexTypeDefinition()) {
            if (((ComplexTypeDefinition)this.thisType.asComplexTypeDefinition().orElseThrow((Supplier<IllegalAccessError>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalAccessError;)())).getPropertyFieldByName(variableLiteralName).filter((Predicate<PropertyField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/apache/plc4x/plugins/codegenerator/types/fields/PropertyField;)Z)(EnumField.class)).isPresent() && variableLiteral.getChild().isPresent()) {
                return this.toConstantVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, suppressPointerAccess, tracer);
            }
        }
        if (!serialize && this.thisType.isComplexTypeDefinition()) {
            if (((ComplexTypeDefinition)this.thisType.asComplexTypeDefinition().orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalStateException;)())).getPropertyFieldByName(variableLiteralName).filter((Predicate<PropertyField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/apache/plc4x/plugins/codegenerator/types/fields/PropertyField;)Z)(OptionalField.class)).isPresent()) {
                tracer = tracer.dive("non serialize optional fields");
                return this.toOptionalVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, suppressPointerAccess, tracer);
            }
        }
        if (this.thisType.isComplexTypeDefinition()) {
            if (((ComplexTypeDefinition)this.thisType.asComplexTypeDefinition().orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalStateException;)())).getPropertyFieldByName(variableLiteralName).filter((Predicate<PropertyField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/apache/plc4x/plugins/codegenerator/types/fields/PropertyField;)Z)(OptionalField.class)).isPresent()) {
                tracer = tracer.dive("optional fields");
                optionalField = (OptionalField)((PropertyField)((ComplexTypeDefinition)this.thisType.asComplexTypeDefinition().orElseThrow()).getPropertyFieldByName(variableLiteralName).orElseThrow()).asOptionalField().orElseThrow();
                return tracer + "(" + (suppressPointerAccess != false || optionalField.getType().isComplexTypeReference() != false ? "" : "*") + "m.Get" + this.capitalize(variableLiteral.getName()) + "())" + variableLiteral.getChild().map((Function<VariableLiteral, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$18(org.apache.plc4x.plugins.codegenerator.types.fields.Field org.apache.plc4x.plugins.codegenerator.types.references.TypeReference java.util.List java.util.List boolean org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral ), (Lorg/apache/plc4x/plugins/codegenerator/types/terms/VariableLiteral;)Ljava/lang/String;)((GoLanguageTemplateHelper)this, (Field)field, (TypeReference)typeReference, parserArguments, serializerArguments, (boolean)suppressPointerAccess)).orElse("");
            }
        }
        if ("CAST".equals(variableLiteralName)) {
            return this.toCastVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, serialize, suppressPointerAccess, tracer);
        }
        if ("STATIC_CALL".equals(variableLiteralName)) {
            return this.toStaticCallVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, serialize, suppressPointerAccess, tracer);
        }
        if (!isEnumTypeReference && "COUNT".equals(variableLiteralName)) {
            return this.toCountVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, serialize, suppressPointerAccess, tracer);
        }
        if (!isEnumTypeReference && "ARRAY_SIZE_IN_BYTES".equals(variableLiteralName)) {
            return this.toArraySizeInBytesVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, suppressPointerAccess, tracer);
        }
        if ("CEIL".equals(variableLiteralName)) {
            return this.toCeilVariableExpression(field, variableLiteral, parserArguments, serializerArguments, serialize, suppressPointerAccess, tracer);
        }
        if ("STR_LEN".equals(variableLiteralName)) {
            return this.toStrLenVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, serialize, suppressPointerAccess, tracer);
        }
        if (variableLiteralName.equals(variableLiteralName.toUpperCase())) {
            tracer = tracer.dive("utility");
            return this.toUppercaseVariableExpression(field, typeReference, variableLiteral, parserArguments, serializerArguments, serialize, suppressPointerAccess, tracer);
        }
        if (!this.thisType.isComplexTypeDefinition()) ** GOTO lbl-1000
        if (((ComplexTypeDefinition)this.thisType.asComplexTypeDefinition().orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalStateException;)())).getPropertyFieldFromThisOrParentByName(variableLiteralName).filter((Predicate<PropertyField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/apache/plc4x/plugins/codegenerator/types/fields/PropertyField;)Z)(DiscriminatorField.class)).isPresent()) {
            tracer = tracer.dive("discriminator value");
        } else if (variableLiteral.getChild().isPresent() && ((ComplexTypeDefinition)this.thisType).getTypeReferenceForProperty(variableLiteralName).isPresent()) {
            tracer = tracer.dive("child element");
            typeReferenceForProperty = ((ComplexTypeDefinition)this.thisType).getTypeReferenceForProperty(variableLiteralName).flatMap((Function<TypeReference, Optional>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, asNonSimpleTypeReference(), (Lorg/apache/plc4x/plugins/codegenerator/types/references/TypeReference;)Ljava/util/Optional;)());
            if (typeReferenceForProperty.isPresent()) {
                tracer = tracer.dive("complex");
                nonSimpleTypeReference = (NonSimpleTypeReference)typeReferenceForProperty.get();
                typeDefinition = nonSimpleTypeReference.getTypeDefinition();
                if (typeDefinition instanceof ComplexTypeDefinition) {
                    tracer = tracer.dive("complex");
                    complexTypeDefinition = (ComplexTypeDefinition)typeDefinition;
                    childProperty = ((VariableLiteral)variableLiteral.getChild().orElseThrow((Supplier<FreemarkerException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$22(), ()Lorg/apache/plc4x/plugins/codegenerator/protocol/freemarker/FreemarkerException;)())).getName();
                    matchingDiscriminatorField = complexTypeDefinition.getFields().stream().filter((Predicate<Field>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$23(java.lang.String org.apache.plc4x.plugins.codegenerator.types.fields.Field ), (Lorg/apache/plc4x/plugins/codegenerator/types/fields/Field;)Z)((String)childProperty)).findFirst();
                    if (matchingDiscriminatorField.isPresent()) {
                        return tracer + "Cast" + this.getLanguageTypeNameForTypeReference((TypeReference)nonSimpleTypeReference) + "(" + variableLiteralName + ").Get" + this.capitalize(childProperty) + "()";
                    }
                    tracer = tracer.dive("we fell through the complex complex");
                } else if (typeDefinition instanceof EnumTypeDefinition) {
                    tracer = tracer.dive("enum");
                    variableAccess = variableLiteralName;
                    if (isChild) {
                        variableAccess = "Get" + this.capitalize(variableLiteralName) + "()";
                    }
                    return tracer + (serialize != false ? "m.Get" + this.capitalize(variableLiteralName) + "()" : variableAccess) + "." + this.capitalize(((VariableLiteral)variableLiteral.getChild().orElseThrow((Supplier<FreemarkerException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$24(), ()Lorg/apache/plc4x/plugins/codegenerator/protocol/freemarker/FreemarkerException;)())).getName()) + "()";
                }
            }
            tracer = tracer.dive("we fell through the child complete");
        } else if (this.isVariableLiteralImplicitField(variableLiteral)) {
            tracer = tracer.dive("implicit");
            if (serialize) {
                tracer = tracer.dive("serialize");
                referencedImplicitField = this.getReferencedImplicitField(variableLiteral);
                return tracer + this.toSerializationExpression((Field)referencedImplicitField, referencedImplicitField.getType(), this.getReferencedImplicitField(variableLiteral).getSerializeExpression(), serializerArguments);
            }
            return tracer + variableLiteralName;
        }
        if (serializerArguments != null && serializerArguments.stream().anyMatch((Predicate<Argument>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$25(java.lang.String org.apache.plc4x.plugins.codegenerator.types.definitions.Argument ), (Lorg/apache/plc4x/plugins/codegenerator/types/definitions/Argument;)Z)((String)variableLiteralName)) && "stringLength".equals(variableLiteralName)) {
            tracer = tracer.dive("serialization argument");
            return tracer + variableLiteralName + variableLiteral.getChild().map((Function<VariableLiteral, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$26(org.apache.plc4x.plugins.codegenerator.types.fields.Field org.apache.plc4x.plugins.codegenerator.types.references.TypeReference java.util.List java.util.List boolean org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral ), (Lorg/apache/plc4x/plugins/codegenerator/types/terms/VariableLiteral;)Ljava/lang/String;)((GoLanguageTemplateHelper)this, (Field)field, (TypeReference)typeReference, parserArguments, serializerArguments, (boolean)suppressPointerAccess)).orElse("");
        }
        if (serializerArguments != null && serializerArguments.stream().anyMatch((Predicate<Argument>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$27(java.lang.String org.apache.plc4x.plugins.codegenerator.types.definitions.Argument ), (Lorg/apache/plc4x/plugins/codegenerator/types/definitions/Argument;)Z)((String)variableLiteralName))) {
            tracer = tracer.dive("serialization argument");
            return tracer + "m.Get" + this.capitalize(variableLiteralName) + "()" + variableLiteral.getChild().map((Function<VariableLiteral, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$28(org.apache.plc4x.plugins.codegenerator.types.fields.Field org.apache.plc4x.plugins.codegenerator.types.references.TypeReference java.util.List java.util.List boolean org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral ), (Lorg/apache/plc4x/plugins/codegenerator/types/terms/VariableLiteral;)Ljava/lang/String;)((GoLanguageTemplateHelper)this, (Field)field, (TypeReference)typeReference, parserArguments, serializerArguments, (boolean)suppressPointerAccess)).orElse("");
        }
        if (parserArguments != null && parserArguments.stream().anyMatch((Predicate<Argument>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$29(java.lang.String org.apache.plc4x.plugins.codegenerator.types.definitions.Argument ), (Lorg/apache/plc4x/plugins/codegenerator/types/definitions/Argument;)Z)((String)variableLiteralName))) {
            tracer = tracer.dive("parser argument");
            return tracer + variableLiteralName + variableLiteral.getChild().map((Function<VariableLiteral, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$30(org.apache.plc4x.plugins.codegenerator.types.fields.Field org.apache.plc4x.plugins.codegenerator.types.references.TypeReference java.util.List java.util.List boolean org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral ), (Lorg/apache/plc4x/plugins/codegenerator/types/terms/VariableLiteral;)Ljava/lang/String;)((GoLanguageTemplateHelper)this, (Field)field, (TypeReference)typeReference, parserArguments, serializerArguments, (boolean)suppressPointerAccess)).orElse("");
        }
        indexCall = "";
        if (variableLiteral.getIndex().isPresent()) {
            tracer = tracer.dive("indexCall");
            indexCall = "[" + variableLiteral.getIndex().orElseThrow() + "]";
        }
        tracer2 = tracer = tracer.dive("else");
        variableAccess = variableLiteralName;
        if (isChild) {
            variableAccess = "Get" + this.capitalize(variableAccess) + "()";
        }
        return tracer + (serialize != false ? "m.Get" + this.capitalize(variableLiteralName) + "()" : variableAccess) + indexCall + variableLiteral.getChild().map((Function<VariableLiteral, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$31(org.apache.plc4x.plugins.codegenerator.types.fields.Field org.apache.plc4x.plugins.codegenerator.types.references.TypeReference java.util.List java.util.List boolean org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral ), (Lorg/apache/plc4x/plugins/codegenerator/types/terms/VariableLiteral;)Ljava/lang/String;)((GoLanguageTemplateHelper)this, (Field)field, (TypeReference)typeReference, parserArguments, serializerArguments, (boolean)suppressPointerAccess)).orElse("");
    }

    private String toUppercaseVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess, Tracer tracer) {
        tracer = tracer.dive("toUppercaseVariableExpression");
        StringBuilder sb = new StringBuilder("Get" + this.capitalize(variableLiteral.getName()) + "()");
        if (variableLiteral.getArgs().isPresent()) {
            sb.append("(");
            boolean firstArg = true;
            for (Term arg : (List)variableLiteral.getArgs().get()) {
                if (!firstArg) {
                    sb.append(", ");
                }
                sb.append(this.toExpression(field, typeReference, arg, parserArguments, serializerArguments, serialize, suppressPointerAccess));
                firstArg = false;
            }
            sb.append(")");
        }
        if (variableLiteral.getIndex().isPresent()) {
            sb.append("[").append(variableLiteral.getIndex().orElseThrow()).append("]");
        }
        return tracer + sb.toString() + variableLiteral.getChild().map(child -> "." + this.toVariableExpression(field, typeReference, (VariableLiteral)child, parserArguments, serializerArguments, false, suppressPointerAccess, true)).orElse("");
    }

    private String toCeilVariableExpression(Field field, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess, Tracer tracer) {
        tracer = tracer.dive("ceil");
        Term va = (Term)((List)variableLiteral.getArgs().orElseThrow(() -> new FreemarkerException("CEIL needs at least one arg"))).stream().findFirst().orElseThrow(IllegalStateException::new);
        DefaultFloatTypeReference tr = new DefaultFloatTypeReference(SimpleTypeReference.SimpleBaseType.FLOAT, 64);
        this.emitRequiredImport("math");
        return tracer + "math.Ceil(" + this.toExpression(field, (TypeReference)tr, va, parserArguments, serializerArguments, serialize, suppressPointerAccess) + ")";
    }

    private String toArraySizeInBytesVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean suppressPointerAccess, Tracer tracer) {
        boolean isSerializerArg;
        tracer = tracer.dive("array size in bytes");
        VariableLiteral va = (VariableLiteral)((Literal)((Term)((List)variableLiteral.getArgs().orElseThrow(() -> new FreemarkerException("ARRAY_SIZE_IN_BYTES needs at least one arg"))).stream().findFirst().orElseThrow(IllegalStateException::new)).asLiteral().orElseThrow(() -> new FreemarkerException("ARRAY_SIZE_IN_BYTES needs a literal"))).asVariableLiteral().orElseThrow(() -> new FreemarkerException("ARRAY_SIZE_IN_BYTES needs a variable literal"));
        boolean bl = isSerializerArg = "readBuffer".equals(va.getName()) || "writeBuffer".equals(va.getName()) || "m".equals(va.getName()) || "element".equals(va.getName());
        if (!isSerializerArg && serializerArguments != null) {
            for (Argument serializerArgument : serializerArguments) {
                if (!serializerArgument.getName().equals(va.getName())) continue;
                isSerializerArg = true;
                break;
            }
        }
        StringBuilder sb = new StringBuilder();
        if (isSerializerArg) {
            sb.append(va.getName()).append(va.getChild().map(child -> "." + this.toVariableExpression(field, typeReference, (VariableLiteral)child, parserArguments, serializerArguments, true, suppressPointerAccess, true)).orElse(""));
        } else {
            sb.append(this.toVariableExpression(field, typeReference, va, parserArguments, serializerArguments, true, suppressPointerAccess));
        }
        return tracer + this.getCastExpressionForTypeReference(typeReference) + "(" + va.getName() + "ArraySizeInBytes(" + sb + "))";
    }

    private String toCountVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess, Tracer tracer) {
        tracer = tracer.dive("count");
        VariableLiteral countLiteral = (VariableLiteral)((Literal)((Term)((List)variableLiteral.getArgs().orElseThrow(() -> new FreemarkerException("Count needs at least one arg"))).get(0)).asLiteral().orElseThrow(() -> new FreemarkerException("Count needs a literal"))).asVariableLiteral().orElseThrow(() -> new FreemarkerException("Count needs a variable literal"));
        return tracer + (typeReference instanceof SimpleTypeReference ? this.getCastExpressionForTypeReference(typeReference) : "") + "(len(" + this.toVariableExpression(field, typeReference, countLiteral, parserArguments, serializerArguments, serialize, suppressPointerAccess) + "))";
    }

    private String toStrLenVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess, Tracer tracer) {
        tracer = tracer.dive("str-len");
        VariableLiteral countLiteral = (VariableLiteral)((Literal)((Term)((List)variableLiteral.getArgs().orElseThrow(() -> new FreemarkerException("Str-len needs at least one arg"))).get(0)).asLiteral().orElseThrow(() -> new FreemarkerException("Str-len needs a literal"))).asVariableLiteral().orElseThrow(() -> new FreemarkerException("Str-len needs a variable literal"));
        return tracer + (typeReference instanceof SimpleTypeReference ? this.getCastExpressionForTypeReference(typeReference) : "") + "(len(" + this.toVariableExpression(field, typeReference, countLiteral, parserArguments, serializerArguments, serialize, suppressPointerAccess) + "))";
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private String toStaticCallVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess, Tracer tracer) {
        tracer = tracer.dive("STATIC_CALL");
        sb = new StringBuilder();
        arguments = (List)variableLiteral.getArgs().orElseThrow((Supplier<FreemarkerException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$46(), ()Lorg/apache/plc4x/plugins/codegenerator/protocol/freemarker/FreemarkerException;)());
        if (arguments.size() < 1) {
            throw new FreemarkerException("A STATIC_CALL expression expects at least one argument.");
        }
        staticCall = ((StringLiteral)((Literal)((Term)arguments.get(0)).asLiteral().orElseThrow((Supplier<FreemarkerException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$47(), ()Lorg/apache/plc4x/plugins/codegenerator/protocol/freemarker/FreemarkerException;)())).asStringLiteral().orElseThrow((Supplier<FreemarkerException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$48(), ()Lorg/apache/plc4x/plugins/codegenerator/protocol/freemarker/FreemarkerException;)())).getValue();
        sb.append(this.capitalize(staticCall)).append("(").append("ctx, ");
        i = 1;
        while (i < arguments.size()) {
            block22: {
                block25: {
                    block24: {
                        block23: {
                            arg = (Term)arguments.get(i);
                            if (i > 1) {
                                sb.append(", ");
                            }
                            if (arg instanceof UnaryTerm) {
                                arg = ((UnaryTerm)arg).getA();
                            }
                            if (!(arg instanceof VariableLiteral)) break block23;
                            tracer = tracer.dive("VariableLiteral nr." + i);
                            va = (VariableLiteral)arg;
                            isParserArg = "readBuffer".equals(va.getName()) != false || "writeBuffer".equals(va.getName()) != false || this.thisType instanceof DataIoTypeDefinition != false && "_value".equals(va.getName()) != false;
                            isTypeArg = "_type".equals(va.getName());
                            if (isParserArg || isTypeArg || parserArguments == null) break block24;
                            var18_18 = parserArguments.iterator();
                            if (true) ** GOTO lbl51
                        }
                        if (arg instanceof StringLiteral) {
                            tracer = tracer.dive("StringLiteral");
                            sb.append(((StringLiteral)arg).getValue());
                            ** break;
                        }
                        if (arg instanceof BooleanLiteral) {
                            tracer = tracer.dive("BooleanLiteral");
                            sb.append(((BooleanLiteral)arg).getValue());
                            ** break;
                        }
                        if (arg instanceof NumericLiteral) {
                            tracer = tracer.dive("NumericLiteral");
                            sb.append(((NumericLiteral)arg).getNumber());
                            ** break;
                        }
                        if (!(arg instanceof BinaryTerm)) {
                            throw new FreemarkerException(arg.getClass().getName());
                        }
                        tracer = tracer.dive("BinaryTerm");
                        sb.append(this.toBinaryTermExpression(field, typeReference, (BinaryTerm)arg, parserArguments, serializerArguments, serialize, tracer));
                        ** break;
                        do {
                            if (!(parserArgument = var18_18.next()).getName().equals(va.getName())) continue;
                            isParserArg = true;
                            break;
lbl51:
                            // 2 sources

                        } while (var18_18.hasNext());
                    }
                    if (!isParserArg) break block25;
                    tracer = tracer.dive("isParserArg");
                    if (va.getName().equals("_value")) {
                        tracer = tracer.dive("is _value");
                        sb.append(va.getName().substring(1)).append(va.getChild().map((Function<VariableLiteral, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$49(org.apache.plc4x.plugins.codegenerator.types.fields.Field org.apache.plc4x.plugins.codegenerator.types.references.TypeReference java.util.List java.util.List boolean org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral ), (Lorg/apache/plc4x/plugins/codegenerator/types/terms/VariableLiteral;)Ljava/lang/String;)((GoLanguageTemplateHelper)this, (Field)field, (TypeReference)typeReference, parserArguments, serializerArguments, (boolean)suppressPointerAccess)).orElse(""));
                        break block22;
                    } else {
                        sb.append(va.getName()).append(va.getChild().isPresent() != false ? ".Get" + this.capitalize(this.toVariableExpression(field, typeReference, (VariableLiteral)va.getChild().orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalStateException;)()), parserArguments, serializerArguments, false, suppressPointerAccess)) + "()" : "");
                    }
                    break block22;
                }
                if (!isTypeArg) ** GOTO lbl96
                part = va.getChild().map((Function<VariableLiteral, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Lorg/apache/plc4x/plugins/codegenerator/types/terms/VariableLiteral;)Ljava/lang/String;)()).orElse("");
                var18_18 = part;
                tmp = -1;
                switch (var18_18.hashCode()) {
                    case -1106363674: {
                        if (!var18_18.equals("length")) break;
                        tmp = 1;
                        break;
                    }
                    case 3373707: {
                        if (!var18_18.equals("name")) break;
                        tmp = 2;
                        break;
                    }
                    case 1711222099: {
                        if (!var18_18.equals("encoding")) break;
                        tmp = 3;
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        sb.append("\"").append(((SimpleTypeReference)typeReference).getSizeInBits()).append("\"");
                        break;
                    }
                    case 3: {
                        encodingTerm = (Term)field.getEncoding().orElse(new DefaultStringLiteral("UTF-8"));
                        if (!(encodingTerm instanceof StringLiteral)) {
                            throw new FreemarkerException("Encoding must be a quoted string value");
                        }
                        encoding = ((StringLiteral)encodingTerm).getValue();
                        sb.append("\"").append(encoding).append("\"");
                    }
                    default: {
                        break;
                    }
lbl96:
                    // 1 sources

                    sb.append(this.toVariableExpression(field, typeReference, va, parserArguments, serializerArguments, serialize, suppressPointerAccess));
                    break;
                    case 2: 
                }
            }
            ++i;
        }
        sb.append(")");
        return tracer + sb.toString();
    }

    private String toCastVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess, Tracer tracer) {
        tracer = tracer.dive("CAST");
        List arguments = (List)variableLiteral.getArgs().orElseThrow(() -> new FreemarkerException("A Cast expression needs arguments"));
        if (arguments.size() != 2) {
            throw new FreemarkerException("A CAST expression expects exactly two arguments.");
        }
        VariableLiteral firstArgument = (VariableLiteral)((Literal)((Term)arguments.get(0)).asLiteral().orElseThrow(() -> new FreemarkerException("First argument should be a literal"))).asVariableLiteral().orElseThrow(() -> new FreemarkerException("First argument should be a Variable literal"));
        StringLiteral typeLiteral = (StringLiteral)((Literal)((Term)arguments.get(1)).asLiteral().orElseThrow(() -> new FreemarkerException("Second argument should be a String literal"))).asStringLiteral().orElseThrow(() -> new FreemarkerException("Second argument should be a String literal"));
        TypeDefinition typeDefinition = (TypeDefinition)this.getTypeDefinitions().get(typeLiteral.getValue());
        StringBuilder sb = new StringBuilder();
        if (typeDefinition.isComplexTypeDefinition()) {
            sb.append("Cast");
        }
        sb.append(typeLiteral.getValue());
        sb.append("(").append(this.toVariableExpression(field, typeReference, firstArgument, parserArguments, serializerArguments, serialize, suppressPointerAccess)).append(")");
        return tracer + sb.toString() + variableLiteral.getChild().map(child -> "." + this.capitalize(this.toVariableExpression(field, typeReference, (VariableLiteral)child, parserArguments, serializerArguments, false, suppressPointerAccess, true))).orElse("");
    }

    private String toOptionalVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean suppressPointerAccess, Tracer tracer) {
        tracer = tracer.dive("optional fields");
        return tracer + "(" + (suppressPointerAccess || typeReference != null && typeReference.isComplexTypeReference() ? "" : "*") + variableLiteral.getName() + ")" + variableLiteral.getChild().map(child -> "." + this.capitalize(this.toVariableExpression(field, typeReference, (VariableLiteral)child, parserArguments, serializerArguments, false, suppressPointerAccess, true))).orElse("");
    }

    private String toConstantVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean suppressPointerAccess, Tracer tracer) {
        tracer = tracer.dive("enum constant");
        VariableLiteral child = (VariableLiteral)variableLiteral.getChild().orElseThrow(IllegalStateException::new);
        return tracer + variableLiteral.getName() + "." + this.capitalize(child.getName()) + "()" + child.getChild().map(childChild -> "." + this.toVariableExpression(field, typeReference, (VariableLiteral)childChild, parserArguments, serializerArguments, false, suppressPointerAccess, true)).orElse("");
    }

    private String toEnumVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean suppressPointerAccess, Tracer tracer) {
        tracer = tracer.dive("enum");
        VariableLiteral child = (VariableLiteral)variableLiteral.getChild().orElseThrow(() -> new FreemarkerException("Enum should have a child"));
        return tracer + variableLiteral.getName() + "_" + child.getName() + child.getChild().map(childChild -> "." + this.toVariableExpression(field, typeReference, (VariableLiteral)childChild, parserArguments, serializerArguments, false, suppressPointerAccess, true)).orElse("");
    }

    private String toLastItemVariableExpression(TypeReference typeReference, boolean serialize, Tracer tracer) {
        tracer = tracer.dive("lastItem");
        return tracer + "utils.GetLastItemFromContext(ctx)";
    }

    private String toLengthVariableExpression(Field field, VariableLiteral variableLiteral, boolean serialize, Tracer tracer) {
        tracer = tracer.dive("length");
        return tracer + (serialize ? "len(m.Get" + this.capitalize(variableLiteral.getName()) + "())" : "(" + variableLiteral.getName() + ")");
    }

    private String toValueVariableExpression(Field field, TypeReference typeReference, VariableLiteral variableLiteral, List<Argument> parserArguments, List<Argument> serializerArguments, boolean serialize, boolean suppressPointerAccess, Tracer tracer) {
        Tracer tracer2 = tracer.dive("_value");
        return variableLiteral.getChild().map(child -> tracer2.dive("withChild") + "m." + this.toUppercaseVariableExpression(field, typeReference, (VariableLiteral)child, parserArguments, serializerArguments, serialize, suppressPointerAccess, tracer2)).orElse(tracer2 + "m");
    }

    private String toLengthInBitsVariableExpression(TypeReference typeReference, boolean serialize, Tracer tracer) {
        tracer = tracer.dive("lengthInBits");
        return tracer + (serialize ? String.valueOf(this.getCastExpressionForTypeReference(typeReference)) + "(m.Get" : "Get") + "LengthInBits" + (serialize ? "(ctx))" : "(ctx)");
    }

    private String toLengthInBytesVariableExpression(TypeReference typeReference, boolean serialize, Tracer tracer) {
        tracer = tracer.dive("lengthInBytes");
        return tracer + (serialize ? String.valueOf(this.getCastExpressionForTypeReference(typeReference)) + "(m.Get" : "Get") + "LengthInBytes" + (serialize ? "(ctx))" : "(ctx)");
    }

    public String getSizeInBits(ComplexTypeDefinition complexTypeDefinition, List<Argument> parserArguments) {
        int sizeInBits = 0;
        StringBuilder sb = new StringBuilder();
        for (Field field : complexTypeDefinition.getFields()) {
            SimpleTypeReference type;
            if (field instanceof ArrayField) {
                ArrayField arrayField = (ArrayField)field;
                type = (SimpleTypeReference)arrayField.getType();
                switch (arrayField.getLoopType()) {
                    case COUNT: {
                        sb.append("(").append(this.toTypedSerializationExpression(field, (TypeReference)type, arrayField.getLoopExpression(), parserArguments)).append(" * ").append(type.getSizeInBits()).append(") + ");
                        break;
                    }
                    case LENGTH: {
                        sb.append("(").append(this.toTypedSerializationExpression(field, (TypeReference)type, arrayField.getLoopExpression(), parserArguments)).append(" * 8) + ");
                        break;
                    }
                }
                continue;
            }
            if (!(field instanceof TypedField)) continue;
            TypedField typedField = (TypedField)field;
            type = typedField.getType();
            if (field instanceof ManualField) {
                ManualField manualField = (ManualField)field;
                sb.append("(").append(this.toSerializationExpression((Field)manualField, this.getIntTypeReference(), manualField.getLengthExpression(), parserArguments)).append(") + ");
                continue;
            }
            if (type instanceof SimpleTypeReference) {
                SimpleTypeReference simpleTypeReference = type;
                sizeInBits += simpleTypeReference.getSizeInBits();
                continue;
            }
            throw new IllegalStateException("No ComplexTypeReference supported");
        }
        return String.valueOf(sb.toString()) + sizeInBits;
    }

    public String escapeValue(TypeReference typeReference, String valueString) {
        if (valueString == null) {
            return null;
        }
        if (typeReference instanceof SimpleTypeReference) {
            SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference;
            switch (simpleTypeReference.getBaseType()) {
                case UINT: 
                case INT: {
                    if (NumberUtils.isParsable((String)valueString) || valueString.length() != 1) break;
                    return "'" + valueString + "'";
                }
                case STRING: 
                case VSTRING: {
                    return "\"" + valueString + "\"";
                }
            }
        }
        return valueString;
    }

    public String escapeEnumValue(TypeReference typeReference, String valueString) {
        if (typeReference != null && typeReference.isNonSimpleTypeReference()) {
            if ("null".equals(valueString) || valueString == null) {
                return "0";
            }
            if (valueString.contains(".")) {
                String typeName = valueString.substring(0, valueString.indexOf(46));
                String constantName = valueString.substring(valueString.indexOf(46) + 1);
                return String.valueOf(typeName) + "_" + constantName;
            }
            return valueString;
        }
        return this.escapeValue(typeReference, valueString);
    }

    public Collection<EnumValue> getUniqueEnumValues(List<EnumValue> enumValues) {
        TreeMap<String, EnumValue> filteredEnumValues = new TreeMap<String, EnumValue>();
        for (EnumValue enumValue : enumValues) {
            if (filteredEnumValues.containsKey(enumValue.getValue())) continue;
            filteredEnumValues.put(enumValue.getValue(), enumValue);
        }
        return filteredEnumValues.values();
    }

    public List<DiscriminatedComplexTypeDefinition> getUniqueSwitchCases(List<DiscriminatedComplexTypeDefinition> allSwitchCases) {
        LinkedHashMap<String, DiscriminatedComplexTypeDefinition> switchCases = new LinkedHashMap<String, DiscriminatedComplexTypeDefinition>();
        for (DiscriminatedComplexTypeDefinition switchCase : allSwitchCases) {
            if (switchCases.containsKey(switchCase.getName())) continue;
            switchCases.put(switchCase.getName(), switchCase);
        }
        return new ArrayList<DiscriminatedComplexTypeDefinition>(switchCases.values());
    }

    public void emitRequiredImportRaw(String requiredImport) {
        LOGGER.debug("emitting import '{}'", (Object)requiredImport);
        this.requiredImports.add(requiredImport);
    }

    public void emitRequiredImport(String requiredImport) {
        LOGGER.debug("emitting import '\"{}\"'", (Object)requiredImport);
        this.requiredImports.add(String.valueOf('\"') + requiredImport + '\"');
    }

    public void emitRequiredImport(String alias, String requiredImport) {
        LOGGER.debug("emitting import '{} \"{}'\"", (Object)alias, (Object)requiredImport);
        this.requiredImports.add(String.valueOf(alias) + ' ' + '\"' + requiredImport + '\"');
    }

    public Set<String> getRequiredImports() {
        return this.requiredImports;
    }

    public void emitDataReaderRequiredImports() {
        this.requiredImports.add(". \"github.com/apache/plc4x/plc4go/spi/codegen/fields\"");
        this.requiredImports.add(". \"github.com/apache/plc4x/plc4go/spi/codegen/io\"");
    }

    public void emitCodegenRequiredImports() {
        this.requiredImports.add("\"github.com/apache/plc4x/plc4go/spi/codegen\"");
    }

    public void emitDataIoRequiredImport(String requiredImport) {
        LOGGER.debug("emitting io import '\"{}\"'", (Object)requiredImport);
        this.requiredImportsForDataIo.add(String.valueOf('\"') + requiredImport + '\"');
    }

    public void emitDataIoRequiredImport(String alias, String requiredImport) {
        LOGGER.debug("emitting data io import '{} \"{}'\"", (Object)alias, (Object)requiredImport);
        this.requiredImportsForDataIo.add(String.valueOf(alias) + ' ' + '\"' + requiredImport + '\"');
    }

    public Set<String> getRequiredImportsForDataIo() {
        return this.requiredImportsForDataIo;
    }

    public String getVariableName(Field field) {
        if (!(field instanceof NamedField)) {
            return "_";
        }
        NamedField namedField = (NamedField)field;
        String name = null;
        for (Field curField : ((ComplexTypeDefinition)this.thisType).getFields()) {
            VirtualField virtualField;
            if (curField == field) {
                name = namedField.getName();
                continue;
            }
            if (name == null) continue;
            if (curField instanceof ArrayField) {
                ArrayField arrayField = (ArrayField)curField;
                if (arrayField.getLoopExpression().contains(name)) {
                    return name;
                }
            } else if (curField instanceof ChecksumField) {
                ChecksumField checksumField = (ChecksumField)curField;
                if (checksumField.getChecksumExpression().contains(name)) {
                    return name;
                }
            } else if (curField instanceof ImplicitField) {
                ImplicitField implicitField = (ImplicitField)curField;
                if (implicitField.getSerializeExpression().contains(name)) {
                    return name;
                }
            } else if (curField instanceof ManualArrayField) {
                ManualArrayField manualArrayField = (ManualArrayField)curField;
                if (manualArrayField.getLengthExpression().contains(name)) {
                    return name;
                }
                if (manualArrayField.getLoopExpression().contains(name)) {
                    return name;
                }
                if (manualArrayField.getParseExpression().contains(name)) {
                    return name;
                }
                if (manualArrayField.getSerializeExpression().contains(name)) {
                    return name;
                }
            } else if (curField instanceof ManualField) {
                ManualField manualField = (ManualField)curField;
                if (manualField.getLengthExpression().contains(name)) {
                    return name;
                }
                if (manualField.getParseExpression().contains(name)) {
                    return name;
                }
                if (manualField.getSerializeExpression().contains(name)) {
                    return name;
                }
            } else if (curField instanceof OptionalField) {
                OptionalField optionalField = (OptionalField)curField;
                if (optionalField.getConditionExpression().isPresent() && ((Term)optionalField.getConditionExpression().orElseThrow(IllegalStateException::new)).contains(name)) {
                    return name;
                }
            } else if (curField instanceof SwitchField) {
                SwitchField switchField = (SwitchField)curField;
                for (Term discriminatorExpression : switchField.getDiscriminatorExpressions()) {
                    if (!discriminatorExpression.contains(name)) continue;
                    return name;
                }
                for (DiscriminatedComplexTypeDefinition curCase : switchField.getCases()) {
                    for (Argument parserArgument : curCase.getParserArguments().orElse(Collections.emptyList())) {
                        if (!parserArgument.getName().equals(name)) continue;
                        return name;
                    }
                }
            } else if (curField instanceof VirtualField && (virtualField = (VirtualField)curField).getValueExpression().contains(name)) {
                return name;
            }
            List params = field.asTypedField().map(typedField -> typedField.getType().asNonSimpleTypeReference().map(NonSimpleTypeReference::getParams).map(terms -> terms.orElse(Collections.emptyList())).orElse(Collections.emptyList())).orElse(Collections.emptyList());
            for (Term param : params) {
                if (!param.contains(name)) continue;
                return name;
            }
        }
        return "_";
    }

    public boolean needsVariable(Field field, String variableName, boolean serialization) {
        VirtualField virtualField;
        ArrayField arrayField;
        if (!serialization && field instanceof ArrayField && (arrayField = (ArrayField)field).getLoopExpression().contains(variableName)) {
            return true;
        }
        if (field instanceof VirtualField && (virtualField = (VirtualField)field).getValueExpression().contains(variableName)) {
            return true;
        }
        if (field instanceof PaddingField) {
            PaddingField paddingField = (PaddingField)field;
            if (paddingField.getPaddingCondition().contains(variableName)) {
                return true;
            }
            if (paddingField.getPaddingValue().contains(variableName)) {
                return true;
            }
        }
        return field.asTypedField().map(typedField -> typedField.getType().asNonSimpleTypeReference().map(nonSimpleTypeReference -> nonSimpleTypeReference.getParams().map(params -> params.stream().anyMatch(param -> param.contains(variableName))).orElse(false)).orElse(false)).orElse(false);
    }

    public Map<String, String> requiresHelperFunctions(String functionName) {
        HashMap<String, String> result = new HashMap<String, String>();
        boolean usesFunction = false;
        for (Field curField : ((ComplexTypeDefinition)this.thisType).getFields()) {
            ImplicitField implicitField;
            if (curField instanceof ArrayField) {
                ArrayField arrayField = (ArrayField)curField;
                if (arrayField.getLoopExpression().contains(functionName)) {
                    usesFunction = true;
                }
                result.put(arrayField.getName(), this.getLanguageTypeNameForField((Field)arrayField));
                continue;
            }
            if (!(curField instanceof ImplicitField) || !(implicitField = (ImplicitField)curField).getSerializeExpression().contains(functionName)) continue;
            usesFunction = true;
        }
        if (!usesFunction) {
            return Collections.emptyMap();
        }
        return result;
    }

    public boolean requiresCurPos() {
        if (this.thisType instanceof ComplexTypeDefinition) {
            ComplexTypeDefinition complexTypeDefinition = (ComplexTypeDefinition)this.thisType;
            for (Field curField : complexTypeDefinition.getFields()) {
                if (!this.requiresVariable(curField, "curPos")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean requiresStartPos() {
        if (this.thisType instanceof ComplexTypeDefinition) {
            ComplexTypeDefinition complexTypeDefinition = (ComplexTypeDefinition)this.thisType;
            for (Field curField : complexTypeDefinition.getFields()) {
                if (!this.requiresVariable(curField, "startPos")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean requiresVariable(Field curField, String variable) {
        OptionalField optionalField;
        ArrayField arrayField;
        if (curField.isArrayField() ? (arrayField = (ArrayField)curField).getLoopExpression().contains(variable) : curField.isOptionalField() && (optionalField = (OptionalField)curField).getConditionExpression().isPresent() && ((Term)optionalField.getConditionExpression().orElseThrow(IllegalStateException::new)).contains(variable)) {
            return true;
        }
        return curField.asTypedField().map(typedField -> typedField.getType().asNonSimpleTypeReference().map(nonSimpleTypeReference -> nonSimpleTypeReference.getParams().map(params -> params.stream().anyMatch(param -> param.contains(variable))).orElse(false)).orElse(false)).orElse(false);
    }

    public Term findTerm(Term baseTerm, String name) {
        if (baseTerm instanceof VariableLiteral) {
            Term found;
            VariableLiteral variableLiteral = (VariableLiteral)baseTerm;
            if (variableLiteral.getName().equals(name)) {
                return variableLiteral;
            }
            if (variableLiteral.getChild().isPresent() && (found = this.findTerm((Term)variableLiteral.getChild().get(), name)) != null) {
                return found;
            }
            for (Term arg : variableLiteral.getArgs().orElse(Collections.emptyList())) {
                Term found2 = this.findTerm(arg, name);
                if (found2 == null) continue;
                return found2;
            }
        } else {
            if (baseTerm instanceof UnaryTerm) {
                UnaryTerm unaryTerm = (UnaryTerm)baseTerm;
                return this.findTerm(unaryTerm.getA(), name);
            }
            if (baseTerm instanceof BinaryTerm) {
                BinaryTerm binaryTerm = (BinaryTerm)baseTerm;
                Term found = this.findTerm(binaryTerm.getA(), name);
                if (found != null) {
                    return found;
                }
                found = this.findTerm(binaryTerm.getB(), name);
                return found;
            }
            if (baseTerm instanceof TernaryTerm) {
                TernaryTerm ternaryTerm = (TernaryTerm)baseTerm;
                Term found = this.findTerm(ternaryTerm.getA(), name);
                if (found != null) {
                    return found;
                }
                found = this.findTerm(ternaryTerm.getB(), name);
                if (found != null) {
                    return found;
                }
                found = this.findTerm(ternaryTerm.getC(), name);
                return found;
            }
        }
        return null;
    }

    public String getEnumExpression(String expression) {
        String enumName = expression.substring(0, expression.indexOf(46));
        String enumConstant = expression.substring(expression.indexOf(46) + 1);
        return String.valueOf(enumName) + "_" + enumConstant;
    }

    public boolean needsReferenceForParserArgument(String propertyName, TypeReference argumentType) {
        return argumentType.asComplexTypeReference().map(complexTypeReference -> this.thisType.asComplexTypeDefinition().map(complexTypeDefinition -> complexTypeDefinition.getPropertyFieldByName(propertyName).map(TypedField.class::cast).map(TypedField::getType).filter(NonSimpleTypeReference.class::isInstance).map(NonSimpleTypeReference.class::cast).map(NonSimpleTypeReference::getTypeDefinition).map(typeDefinition -> !(typeDefinition instanceof EnumTypeDefinition)).orElse(false)).orElse(false)).orElse(false);
    }

    public String capitalize(String str) {
        Tracer dummyTracer = Tracer.start((String)"");
        String extractedTrace = dummyTracer.extractTraces(str);
        String cleanedString = dummyTracer.removeTraces(str);
        return String.valueOf(extractedTrace) + StringUtils.capitalize((String)cleanedString);
    }

    public String getEndiannessOptions(boolean read, boolean separatorPrefix) {
        return this.getEndiannessOptions(read, separatorPrefix, Collections.emptyList());
    }

    public String getEndiannessOptions(boolean read, boolean separatorPrefix, List<Argument> parserArguments) {
        Optional byteOrder = this.thisType.getAttribute("byteOrder");
        if (byteOrder.isPresent()) {
            this.emitRequiredImport("encoding/binary");
            if (read) {
                return String.valueOf(separatorPrefix ? ", " : "") + "utils.WithByteOrderForReadBufferByteBased(" + this.toParseExpression(null, (TypeReference)new DefaultByteOrderTypeReference(), (Term)byteOrder.orElseThrow(), parserArguments) + ")";
            }
            return String.valueOf(separatorPrefix ? ", " : "") + "utils.WithByteOrderForByteBasedBuffer(" + this.toSerializationExpression(null, (TypeReference)new DefaultByteOrderTypeReference(), (Term)byteOrder.orElseThrow(), parserArguments) + ")";
        }
        return "";
    }

    public String getFieldOptions(TypedField field, List<Argument> parserArguments) {
        StringBuilder sb = new StringBuilder();
        field.getEncoding().ifPresent(term -> {
            this.emitCodegenRequiredImports();
            String encoding = this.toParseExpression((Field)field, field.getType(), (Term)term, parserArguments);
            sb.append(", codegen.WithEncoding(").append(encoding).append(")");
        });
        field.getByteOrder().ifPresent(term -> {
            this.emitCodegenRequiredImports();
            this.emitRequiredImport("encoding/binary");
            String byteOrder = "binary.BigEndian";
            switch (term.stringRepresentation()) {
                case "BIG_ENDIAN": {
                    byteOrder = "binary.BigEndian";
                    break;
                }
                case "LITTLE_ENDIAN": {
                    byteOrder = "binary.LittleEndian";
                    break;
                }
                default: {
                    throw new RuntimeException("unmapped bytes order " + term.stringRepresentation());
                }
            }
            sb.append(", codegen.WithByteOrder(").append(byteOrder).append(")");
        });
        field.getAttribute("nullBytesHex").ifPresent(term -> {
            this.emitCodegenRequiredImports();
            String nullBytesHex = this.toParseExpression((Field)field, field.getType(), (Term)term, parserArguments);
            sb.append(", codegen.WithNullBytesHex(\"").append(nullBytesHex).append("\")");
        });
        return sb.toString();
    }

    public boolean isBigIntegerSource(Term term) {
        boolean isBigInteger = term.asLiteral().flatMap(LiteralConversions::asVariableLiteral).flatMap(VariableLiteral::getChild).map(Term.class::cast).map(this::isBigIntegerSource).orElse(false);
        return isBigInteger || term.asLiteral().flatMap(LiteralConversions::asVariableLiteral).map(VariableLiteral::getTypeReference).flatMap(TypeReferenceConversions::asIntegerTypeReference).map(integerTypeReference -> integerTypeReference.getSizeInBits() >= 64).orElse(false) != false;
    }

    public boolean isGeneratePropertiesForParserArguments() {
        return this.options.getOrDefault("generate-properties-for-parser-arguments", "false").equals("true");
    }

    public boolean isGeneratePropertiesForReservedFields() {
        return this.options.getOrDefault("generate-properties-for-reserved-fields", "false").equals("true");
    }

    private /* synthetic */ String lambda$18(Field field, TypeReference typeReference, List list, List list2, boolean bl, VariableLiteral child) {
        return "." + this.capitalize(this.toVariableExpression(field, typeReference, child, list, list2, false, bl, true));
    }

    private static /* synthetic */ FreemarkerException lambda$22() {
        return new FreemarkerException("complex needs a child");
    }

    private static /* synthetic */ boolean lambda$23(String string, Field curField) {
        return curField instanceof DiscriminatorField && ((DiscriminatorField)curField).getName().equals(string);
    }

    private static /* synthetic */ FreemarkerException lambda$24() {
        return new FreemarkerException("enum needs a child");
    }

    private static /* synthetic */ boolean lambda$25(String string, Argument argument) {
        return argument.getName().equals(string);
    }

    private /* synthetic */ String lambda$26(Field field, TypeReference typeReference, List list, List list2, boolean bl, VariableLiteral child) {
        return "." + this.capitalize(this.toVariableExpression(field, typeReference, child, list, list2, false, bl, true));
    }

    private static /* synthetic */ boolean lambda$27(String string, Argument argument) {
        return argument.getName().equals(string);
    }

    private /* synthetic */ String lambda$28(Field field, TypeReference typeReference, List list, List list2, boolean bl, VariableLiteral child) {
        return "." + this.capitalize(this.toVariableExpression(field, typeReference, child, list, list2, false, bl, true));
    }

    private static /* synthetic */ boolean lambda$29(String string, Argument argument) {
        return argument.getName().equals(string);
    }

    private /* synthetic */ String lambda$30(Field field, TypeReference typeReference, List list, List list2, boolean bl, VariableLiteral child) {
        return "." + this.capitalize(this.toVariableExpression(field, typeReference, child, list, list2, false, bl, true));
    }

    private /* synthetic */ String lambda$31(Field field, TypeReference typeReference, List list, List list2, boolean bl, VariableLiteral child) {
        return "." + this.capitalize(this.toVariableExpression(field, typeReference, child, list, list2, false, bl, true));
    }

    private static /* synthetic */ FreemarkerException lambda$46() {
        return new FreemarkerException("A STATIC_CALL expression needs arguments");
    }

    private static /* synthetic */ FreemarkerException lambda$47() {
        return new FreemarkerException("First argument should be a literal");
    }

    private static /* synthetic */ FreemarkerException lambda$48() {
        return new FreemarkerException("Expecting the first argument of a 'STATIC_CALL' to be a StringLiteral");
    }

    private /* synthetic */ String lambda$49(Field field, TypeReference typeReference, List list, List list2, boolean bl, VariableLiteral child) {
        return "." + this.toVariableExpression(field, typeReference, child, list, list2, false, bl, true);
    }
}

