/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.language.cs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.WordUtils;
import org.apache.plc4x.plugins.codegenerator.language.mspec.model.terms.DefaultStringLiteral;
import org.apache.plc4x.plugins.codegenerator.protocol.freemarker.BaseFreemarkerLanguageTemplateHelper;
import org.apache.plc4x.plugins.codegenerator.protocol.freemarker.FreemarkerException;
import org.apache.plc4x.plugins.codegenerator.protocol.freemarker.Tracer;
import org.apache.plc4x.plugins.codegenerator.types.definitions.Argument;
import org.apache.plc4x.plugins.codegenerator.types.definitions.ComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.DataIoTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.EnumTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.fields.ArrayField;
import org.apache.plc4x.plugins.codegenerator.types.fields.Field;
import org.apache.plc4x.plugins.codegenerator.types.fields.ImplicitField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ManualField;
import org.apache.plc4x.plugins.codegenerator.types.fields.PropertyField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ReservedField;
import org.apache.plc4x.plugins.codegenerator.types.fields.TypedField;
import org.apache.plc4x.plugins.codegenerator.types.references.ArrayTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.ByteTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.EnumTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.FloatTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.IntegerTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.NonSimpleTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.SimpleTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.StringTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.VstringTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.BinaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.BooleanLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.HexadecimalLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.Literal;
import org.apache.plc4x.plugins.codegenerator.types.terms.NullLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.NumericLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.StringLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;
import org.apache.plc4x.plugins.codegenerator.types.terms.TernaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.UnaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral;

public class CsLanguageTemplateHelper
extends BaseFreemarkerLanguageTemplateHelper {
    private final Map<String, String> options;

    public CsLanguageTemplateHelper(TypeDefinition thisType, String protocolName, String flavorName, Map<String, TypeDefinition> types, Map<String, String> options) {
        super(thisType, protocolName, flavorName, types);
        this.options = options;
    }

    public String fileName(String protocolName, String languageName, String languageFlavorName) {
        return "drivers." + String.join((CharSequence)"", protocolName.split("-")) + "." + String.join((CharSequence)"", languageFlavorName.split("-"));
    }

    public String packageName() {
        return this.packageName(this.protocolName, "cs", this.flavorName);
    }

    public String packageName(String protocolName, String languageName, String languageFlavorName) {
        return Optional.ofNullable(this.options.get("package")).orElseGet(() -> "org.apache.plc4x." + String.join((CharSequence)"", languageName.split("-")) + "." + String.join((CharSequence)"", protocolName.split("-")) + "." + String.join((CharSequence)"", languageFlavorName.split("-")));
    }

    public String getLanguageTypeNameForField(Field field) {
        PropertyField propertyField;
        if (field.isPropertyField() && (propertyField = (PropertyField)field.asPropertyField().orElseThrow(IllegalStateException::new)).getType().isComplexTypeReference()) {
            NonSimpleTypeReference nonSimpleTypeReference = (NonSimpleTypeReference)propertyField.getType().asNonSimpleTypeReference().orElseThrow(IllegalStateException::new);
            TypeDefinition typeDefinition = (TypeDefinition)this.getTypeDefinitions().get(nonSimpleTypeReference.getName());
            if (typeDefinition instanceof DataIoTypeDefinition) {
                return "PlcValue";
            }
        }
        return this.getLanguageTypeNameForTypeReference(((TypedField)field).getType());
    }

    public String getLanguageTypeNameForTypeReference(TypeReference typeReference) {
        Objects.requireNonNull(typeReference);
        if (typeReference instanceof ArrayTypeReference) {
            ArrayTypeReference arrayTypeReference = (ArrayTypeReference)typeReference;
            return String.valueOf(this.getLanguageTypeNameForTypeReference(arrayTypeReference.getElementTypeReference())) + "[]";
        }
        if (typeReference.isDataIoTypeReference()) {
            return "PlcValue";
        }
        if (typeReference.isNonSimpleTypeReference()) {
            return ((NonSimpleTypeReference)typeReference.asNonSimpleTypeReference().orElseThrow()).getName();
        }
        SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference;
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "bool";
            }
            case BYTE: {
                return "byte";
            }
            case UINT: {
                IntegerTypeReference unsignedIntegerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (unsignedIntegerTypeReference.getSizeInBits() <= 8) {
                    return "byte";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 16) {
                    return "ushort";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 32) {
                    return "uint";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 64) {
                    return "ulong";
                }
                throw new FreemarkerException("Unsupported simple type");
            }
            case INT: {
                IntegerTypeReference integerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (integerTypeReference.getSizeInBits() <= 8) {
                    return "sbyte";
                }
                if (integerTypeReference.getSizeInBits() <= 16) {
                    return "short";
                }
                if (integerTypeReference.getSizeInBits() <= 32) {
                    return "int";
                }
                if (integerTypeReference.getSizeInBits() <= 64) {
                    return "long";
                }
                throw new FreemarkerException("Unsupported simple type");
            }
            case FLOAT: 
            case UFLOAT: {
                FloatTypeReference floatTypeReference = (FloatTypeReference)simpleTypeReference;
                int sizeInBits = floatTypeReference.getSizeInBits();
                if (sizeInBits <= 32) {
                    return "float";
                }
                if (sizeInBits <= 64) {
                    return "double";
                }
                throw new FreemarkerException("Unsupported simple type");
            }
            case STRING: 
            case VSTRING: {
                return "string";
            }
            case TIME: {
                return "time";
            }
            case DATE: {
                return "date";
            }
            case DATETIME: {
                return "datetime2";
            }
        }
        throw new FreemarkerException("Unsupported simple type");
    }

    public String getPlcValueTypeForTypeReference(TypeReference typeReference) {
        if (!(typeReference instanceof SimpleTypeReference)) {
            return "PlcStruct";
        }
        SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference;
        int sizeInBits = simpleTypeReference.getSizeInBits();
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "PlcBOOL";
            }
            case BYTE: {
                return "PlcBYTE";
            }
            case UINT: {
                if (sizeInBits <= 8) {
                    return "PlcUSINT";
                }
                if (sizeInBits <= 16) {
                    return "PlcUINT";
                }
                if (sizeInBits <= 32) {
                    return "PlcUDINT";
                }
                if (sizeInBits <= 64) {
                    return "PlcULINT";
                }
                throw new FreemarkerException("Unsupported UINT with bit length " + sizeInBits);
            }
            case INT: {
                if (sizeInBits <= 8) {
                    return "PlcSINT";
                }
                if (sizeInBits <= 16) {
                    return "PlcINT";
                }
                if (sizeInBits <= 32) {
                    return "PlcDINT";
                }
                if (sizeInBits <= 64) {
                    return "PlcLINT";
                }
                throw new FreemarkerException("Unsupported INT with bit length " + sizeInBits);
            }
            case FLOAT: 
            case UFLOAT: {
                if (sizeInBits <= 32) {
                    return "PlcREAL";
                }
                if (sizeInBits <= 64) {
                    return "PlcLREAL";
                }
                throw new FreemarkerException("Unsupported REAL with bit length " + sizeInBits);
            }
            case STRING: 
            case VSTRING: {
                return "PlcSTRING";
            }
            case TIME: 
            case DATE: 
            case DATETIME: {
                return "PlcTIME";
            }
        }
        throw new FreemarkerException("Unsupported simple type");
    }

    public String getNullValueForTypeReference(TypeReference typeReference) {
        if (typeReference instanceof SimpleTypeReference) {
            SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference;
            switch (simpleTypeReference.getBaseType()) {
                case BIT: {
                    return "false";
                }
                case BYTE: {
                    return "0";
                }
                case UINT: {
                    IntegerTypeReference unsignedIntegerTypeReference = (IntegerTypeReference)simpleTypeReference;
                    if (unsignedIntegerTypeReference.getSizeInBits() <= 16) {
                        return "0";
                    }
                    if (unsignedIntegerTypeReference.getSizeInBits() <= 32) {
                        return "0l";
                    }
                    return "null";
                }
                case INT: {
                    IntegerTypeReference integerTypeReference = (IntegerTypeReference)simpleTypeReference;
                    if (integerTypeReference.getSizeInBits() <= 32) {
                        return "0";
                    }
                    if (integerTypeReference.getSizeInBits() <= 64) {
                        return "0l";
                    }
                    return "null";
                }
                case FLOAT: {
                    FloatTypeReference floatTypeReference = (FloatTypeReference)simpleTypeReference;
                    int sizeInBits = floatTypeReference.getSizeInBits();
                    if (sizeInBits <= 32) {
                        return "0.0f";
                    }
                    if (sizeInBits <= 64) {
                        return "0.0";
                    }
                    return "null";
                }
                case STRING: 
                case VSTRING: {
                    return "null";
                }
            }
            throw new FreemarkerException("Unmapped base-type" + simpleTypeReference.getBaseType());
        }
        return "null";
    }

    public int getNumBits(SimpleTypeReference simpleTypeReference) {
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return 1;
            }
            case BYTE: {
                return 8;
            }
            case UINT: 
            case INT: {
                IntegerTypeReference integerTypeReference = (IntegerTypeReference)simpleTypeReference;
                return integerTypeReference.getSizeInBits();
            }
            case FLOAT: {
                FloatTypeReference floatTypeReference = (FloatTypeReference)simpleTypeReference;
                return floatTypeReference.getSizeInBits();
            }
            case STRING: {
                StringTypeReference stringTypeReference = (StringTypeReference)simpleTypeReference;
                return stringTypeReference.getSizeInBits();
            }
            case VSTRING: {
                throw new IllegalArgumentException("getSizeInBits doesn't work for 'vstring' fields");
            }
        }
        return 0;
    }

    @Deprecated
    public String getReadBufferReadMethodCall(SimpleTypeReference simpleTypeReference, String valueString, TypedField field) {
        return this.getReadBufferReadMethodCall("", simpleTypeReference, valueString, field);
    }

    @Deprecated
    public String getReadBufferReadMethodCall(String logicalName, SimpleTypeReference simpleTypeReference, String valueString, TypedField field) {
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "readBuffer.ReadBit(\"" + logicalName + "\")";
            }
            case BYTE: {
                return "readBuffer.ReadByte(\"" + logicalName + "\", 8)";
            }
            case UINT: {
                String unsignedIntegerType;
                IntegerTypeReference unsignedIntegerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (unsignedIntegerTypeReference.getSizeInBits() <= 8) {
                    unsignedIntegerType = "Byte";
                } else if (unsignedIntegerTypeReference.getSizeInBits() <= 16) {
                    unsignedIntegerType = "Ushort";
                } else if (unsignedIntegerTypeReference.getSizeInBits() <= 32) {
                    unsignedIntegerType = "Uint";
                } else if (unsignedIntegerTypeReference.getSizeInBits() <= 64) {
                    unsignedIntegerType = "Ulong";
                } else {
                    throw new FreemarkerException("Unsupported type");
                }
                return "readBuffer.Read" + unsignedIntegerType + "(\"" + logicalName + "\", " + simpleTypeReference.getSizeInBits() + ")";
            }
            case INT: {
                String integerType;
                if (simpleTypeReference.getSizeInBits() <= 8) {
                    integerType = "Sbyte";
                } else if (simpleTypeReference.getSizeInBits() <= 16) {
                    integerType = "Short";
                } else if (simpleTypeReference.getSizeInBits() <= 32) {
                    integerType = "Int";
                } else if (simpleTypeReference.getSizeInBits() <= 64) {
                    integerType = "Long";
                } else {
                    throw new FreemarkerException("Unsupported type");
                }
                return "readBuffer.Read" + integerType + "(\"" + logicalName + "\", " + simpleTypeReference.getSizeInBits() + ")";
            }
            case FLOAT: {
                String floatType = simpleTypeReference.getSizeInBits() <= 32 ? "Float" : "Double";
                return "readBuffer.Read" + floatType + "(\"" + logicalName + "\", " + simpleTypeReference.getSizeInBits() + ")";
            }
            case STRING: 
            case VSTRING: {
                String stringType = "String";
                Term encodingTerm = (Term)field.getEncoding().orElse(new DefaultStringLiteral("UTF-8"));
                if (!(encodingTerm instanceof StringLiteral)) {
                    throw new FreemarkerException("Encoding must be a quoted string value");
                }
                String encoding = ((StringLiteral)encodingTerm).getValue();
                String length = Integer.toString(simpleTypeReference.getSizeInBits());
                if (simpleTypeReference.getBaseType() == SimpleTypeReference.SimpleBaseType.VSTRING) {
                    VstringTypeReference vstringTypeReference = (VstringTypeReference)simpleTypeReference;
                    length = this.toParseExpression((Field)field, INT_TYPE_REFERENCE, vstringTypeReference.getLengthExpression(), null);
                }
                return "readBuffer.Read" + stringType + "(\"" + logicalName + "\", " + length + ", System.Text.Encoding.GetEncoding(\"" + encoding + "\"))";
            }
        }
        return "";
    }

    public String getDataReaderCall(TypeReference typeReference) {
        return this.getDataReaderCall(typeReference, "enumForValue");
    }

    public String getDataReaderCall(TypeReference typeReference, String resolverMethod) {
        if (typeReference.isEnumTypeReference()) {
            String languageTypeName = this.getLanguageTypeNameForTypeReference(typeReference);
            SimpleTypeReference enumBaseTypeReference = this.getEnumBaseTypeReference(typeReference);
            return "new DataReaderEnumDefault<>(" + languageTypeName + "::" + resolverMethod + ", " + this.getDataReaderCall(enumBaseTypeReference) + ")";
        }
        if (typeReference.isArrayTypeReference()) {
            ArrayTypeReference arrayTypeReference = (ArrayTypeReference)typeReference.asArrayTypeReference().orElseThrow();
            return this.getDataReaderCall(arrayTypeReference.getElementTypeReference(), resolverMethod);
        }
        if (typeReference.isSimpleTypeReference()) {
            SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference.asSimpleTypeReference().orElseThrow(IllegalStateException::new);
            return this.getDataReaderCall(simpleTypeReference);
        }
        if (typeReference.isNonSimpleTypeReference()) {
            StringBuilder paramsString = new StringBuilder();
            NonSimpleTypeReference nonSimpleTypeReference = (NonSimpleTypeReference)typeReference.asNonSimpleTypeReference().orElseThrow(IllegalStateException::new);
            ComplexTypeDefinition typeDefinition = (ComplexTypeDefinition)((NonSimpleTypeReference)typeReference.asNonSimpleTypeReference().orElseThrow()).getTypeDefinition().asComplexTypeDefinition().orElseThrow();
            String parserCallString = this.getLanguageTypeNameForTypeReference(typeReference);
            if (typeDefinition.isDiscriminatedChildTypeDefinition()) {
                parserCallString = "(" + this.getLanguageTypeNameForTypeReference(typeReference) + ") " + ((ComplexTypeDefinition)typeDefinition.getParentType().orElseThrow()).getName();
            }
            List paramTerms = nonSimpleTypeReference.getParams().orElse(Collections.emptyList());
            int i = 0;
            while (i < paramTerms.size()) {
                Term paramTerm = (Term)paramTerms.get(i);
                TypeReference argumentType = this.getArgumentType((TypeReference)nonSimpleTypeReference, i);
                paramsString.append(", (").append(this.getLanguageTypeNameForTypeReference(argumentType)).append(") (").append(this.toParseExpression(null, argumentType, paramTerm, null)).append(")");
                ++i;
            }
            return "new DataReaderComplexDefault<>(() -> " + parserCallString + "IO.staticParse(readBuffer" + paramsString + "), readBuffer)";
        }
        throw new IllegalStateException("What is this type? " + typeReference);
    }

    public String getDataReaderCall(SimpleTypeReference simpleTypeReference) {
        int sizeInBits = simpleTypeReference.getSizeInBits();
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "readBoolean(readBuffer)";
            }
            case BYTE: {
                return "readByte(readBuffer, " + sizeInBits + ")";
            }
            case UINT: {
                if (sizeInBits <= 4) {
                    return "readUnsignedByte(readBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 8) {
                    return "readUnsignedShort(readBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 16) {
                    return "readUnsignedInt(readBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 32) {
                    return "readUnsignedLong(readBuffer, " + sizeInBits + ")";
                }
                return "readUnsignedBigInteger(readBuffer, " + sizeInBits + ")";
            }
            case INT: {
                if (sizeInBits <= 8) {
                    return "readSignedByte(readBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 16) {
                    return "readSignedShort(readBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 32) {
                    return "readSignedInt(readBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 64) {
                    return "readSignedLong(readBuffer, " + sizeInBits + ")";
                }
                return "readSignedBigInteger(readBuffer, " + sizeInBits + ")";
            }
            case FLOAT: {
                if (sizeInBits <= 32) {
                    return "readFloat(readBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 64) {
                    return "readDouble(readBuffer, " + sizeInBits + ")";
                }
                return "readBigDecimal(readBuffer, " + sizeInBits + ")";
            }
            case STRING: {
                return "readString(readBuffer, " + sizeInBits + ")";
            }
            case VSTRING: {
                VstringTypeReference vstringTypeReference = (VstringTypeReference)simpleTypeReference;
                return "readString(readBuffer, " + this.toParseExpression(null, INT_TYPE_REFERENCE, vstringTypeReference.getLengthExpression(), null) + ")";
            }
            case TIME: {
                return "readTime(readBuffer)";
            }
            case DATE: {
                return "readDate(readBuffer)";
            }
            case DATETIME: {
                return "readDateTime(readBuffer)";
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + simpleTypeReference.getBaseType());
    }

    public String getDataWriterCall(TypeReference typeReference, String fieldName) {
        if (typeReference.isSimpleTypeReference()) {
            SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference.asSimpleTypeReference().orElseThrow(IllegalStateException::new);
            return this.getDataWriterCall(simpleTypeReference);
        }
        if (typeReference.isComplexTypeReference()) {
            return "new DataWriterComplexDefault<>(writeBuffer)";
        }
        throw new IllegalStateException("What is this type? " + typeReference);
    }

    public String getEnumDataWriterCall(EnumTypeReference typeReference, String fieldName, String attributeName) {
        if (!typeReference.isEnumTypeReference()) {
            throw new IllegalArgumentException("this method should only be called for enum types");
        }
        String languageTypeName = this.getLanguageTypeNameForTypeReference((TypeReference)typeReference);
        SimpleTypeReference outputTypeReference = "value".equals(attributeName) ? this.getEnumBaseTypeReference((TypeReference)typeReference) : this.getEnumFieldSimpleTypeReference((NonSimpleTypeReference)typeReference, attributeName);
        return "new DataWriterEnumDefault<>(" + languageTypeName + "::get" + StringUtils.capitalize((String)attributeName) + ", " + languageTypeName + "::name, " + this.getDataWriterCall((TypeReference)outputTypeReference, fieldName) + ")";
    }

    public String getDataWriterCall(SimpleTypeReference simpleTypeReference) {
        int sizeInBits = simpleTypeReference.getSizeInBits();
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "writeBoolean(writeBuffer)";
            }
            case BYTE: {
                return "writeByte(writeBuffer, " + sizeInBits + ")";
            }
            case UINT: {
                if (sizeInBits <= 4) {
                    return "writeUnsignedByte(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 8) {
                    return "writeUnsignedShort(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 16) {
                    return "writeUnsignedInt(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 32) {
                    return "writeUnsignedLong(writeBuffer, " + sizeInBits + ")";
                }
                return "writeUnsignedBigInteger(writeBuffer, " + sizeInBits + ")";
            }
            case INT: {
                if (sizeInBits <= 8) {
                    return "writeSignedByte(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 16) {
                    return "writeSignedShort(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 32) {
                    return "writeSignedInt(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 64) {
                    return "writeSignedLong(writeBuffer, " + sizeInBits + ")";
                }
                return "writeSignedBigInteger(writeBuffer, " + sizeInBits + ")";
            }
            case FLOAT: {
                if (sizeInBits <= 32) {
                    return "writeFloat(writeBuffer, " + sizeInBits + ")";
                }
                if (sizeInBits <= 64) {
                    return "writeDouble(writeBuffer, " + sizeInBits + ")";
                }
                return "writeBigDecimal(writeBuffer, " + sizeInBits + ")";
            }
            case STRING: {
                return "writeString(writeBuffer, " + sizeInBits + ")";
            }
            case VSTRING: {
                VstringTypeReference vstringTypeReference = (VstringTypeReference)simpleTypeReference;
                return "writeString(writeBuffer, " + this.toParseExpression(null, INT_TYPE_REFERENCE, vstringTypeReference.getLengthExpression(), null) + ")";
            }
            case TIME: {
                return "writeTime(writeBuffer)";
            }
            case DATE: {
                return "writeDate(writeBuffer)";
            }
            case DATETIME: {
                return "writeDateTime(readBuffer)";
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + simpleTypeReference.getBaseType());
    }

    @Deprecated
    public String getWriteBufferWriteMethodCall(SimpleTypeReference simpleTypeReference, String fieldName, TypedField field) {
        return this.getWriteBufferWriteMethodCall("", simpleTypeReference, fieldName, field, new String[0]);
    }

    @Deprecated
    public String getWriteBufferWriteMethodCall(String logicalName, SimpleTypeReference simpleTypeReference, String fieldName, TypedField field, String ... writerArgs) {
        String writerArgsString = "";
        if (writerArgs.length > 0) {
            writerArgsString = String.valueOf(writerArgsString) + ", " + StringUtils.join((Object[])writerArgs, (String)", ");
        }
        switch (simpleTypeReference.getBaseType()) {
            case BIT: {
                return "writeBuffer.WriteBit(\"" + logicalName + "\", " + fieldName + writerArgsString + ")";
            }
            case BYTE: {
                ByteTypeReference byteTypeReference = (ByteTypeReference)simpleTypeReference;
                return "writeBuffer.WriteByte(\"" + logicalName + "\", " + fieldName + writerArgsString + ", 8)";
            }
            case UINT: {
                IntegerTypeReference unsignedIntegerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (unsignedIntegerTypeReference.getSizeInBits() <= 8) {
                    return "writeBuffer.WriteByte(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ", (byte) " + fieldName + writerArgsString + ")";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 16) {
                    return "writeBuffer.WriteUshort(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ", (ushort) " + fieldName + writerArgsString + ")";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 32) {
                    return "writeBuffer.WriteUint(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ", (uint) " + fieldName + writerArgsString + ")";
                }
                if (unsignedIntegerTypeReference.getSizeInBits() <= 64) {
                    return "writeBuffer.WriteUlong(\"" + logicalName + "\", " + unsignedIntegerTypeReference.getSizeInBits() + ", (ulong) " + fieldName + writerArgsString + ")";
                }
                throw new FreemarkerException("Unsupported uint type");
            }
            case INT: {
                IntegerTypeReference integerTypeReference = (IntegerTypeReference)simpleTypeReference;
                if (integerTypeReference.getSizeInBits() <= 8) {
                    return "writeBuffer.WriteSbyte(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ", (sbyte) " + fieldName + writerArgsString + ")";
                }
                if (integerTypeReference.getSizeInBits() <= 16) {
                    return "writeBuffer.WriteShort(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ", (short) " + fieldName + writerArgsString + ")";
                }
                if (integerTypeReference.getSizeInBits() <= 32) {
                    return "writeBuffer.WriteInt(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ", (int) " + fieldName + writerArgsString + ")";
                }
                if (integerTypeReference.getSizeInBits() <= 64) {
                    return "writeBuffer.WriteLong(\"" + logicalName + "\", " + integerTypeReference.getSizeInBits() + ", (long) " + fieldName + writerArgsString + ")";
                }
                throw new FreemarkerException("Unsupported int type");
            }
            case FLOAT: 
            case UFLOAT: {
                FloatTypeReference floatTypeReference = (FloatTypeReference)simpleTypeReference;
                if (floatTypeReference.getSizeInBits() <= 32) {
                    return "writeBuffer.WriteFloat(\"" + logicalName + "\", " + floatTypeReference.getSizeInBits() + "," + fieldName + writerArgsString + ")";
                }
                if (floatTypeReference.getSizeInBits() <= 64) {
                    return "writeBuffer.WriteDouble(\"" + logicalName + "\", " + floatTypeReference.getSizeInBits() + "," + fieldName + writerArgsString + ")";
                }
                throw new FreemarkerException("Unsupported float type");
            }
            case STRING: 
            case VSTRING: {
                Term encodingTerm = (Term)field.getEncoding().orElse(new DefaultStringLiteral("UTF-8"));
                if (!(encodingTerm instanceof StringLiteral)) {
                    throw new FreemarkerException("Encoding must be a quoted string value");
                }
                String encoding = ((StringLiteral)encodingTerm).getValue();
                String length = Integer.toString(simpleTypeReference.getSizeInBits());
                if (simpleTypeReference.getBaseType() == SimpleTypeReference.SimpleBaseType.VSTRING) {
                    VstringTypeReference vstringTypeReference = (VstringTypeReference)simpleTypeReference;
                    length = this.toSerializationExpression((Field)field, INT_TYPE_REFERENCE, vstringTypeReference.getLengthExpression(), this.thisType.getParserArguments().orElse(Collections.emptyList()));
                }
                return "writeBuffer.WriteString(\"" + logicalName + "\", " + length + ", \"" + encoding + "\", (string) " + fieldName + writerArgsString + ")";
            }
        }
        throw new FreemarkerException("Unmapped basetype" + simpleTypeReference.getBaseType());
    }

    public String getReservedValue(ReservedField reservedField) {
        String languageTypeName = this.getLanguageTypeNameForTypeReference(reservedField.getType());
        if ("BigInteger".equals(languageTypeName)) {
            return "BigInteger.valueOf(" + reservedField.getReferenceValue() + ")";
        }
        return "" + reservedField.getReferenceValue();
    }

    public String toParseExpression(Field field, TypeReference resultType, Term term, List<Argument> parserArguments) {
        Tracer tracer = Tracer.start((String)"toParseExpression");
        return tracer + this.toExpression(field, resultType, term, variableLiteral -> tracer.dive("variableExpressionGenerator") + this.toVariableParseExpression(field, resultType, (VariableLiteral)variableLiteral, parserArguments));
    }

    public String toSerializationExpression(Field field, TypeReference resultType, Term term, List<Argument> serializerArguments) {
        Tracer tracer = Tracer.start((String)"toSerializationExpression");
        return tracer + this.toExpression(field, resultType, term, variableLiteral -> tracer.dive("variableExpressionGenerator") + this.toVariableSerializationExpression(field, resultType, (VariableLiteral)variableLiteral, serializerArguments));
    }

    private String toExpression(Field field, TypeReference resultType, Term term, Function<VariableLiteral, String> variableExpressionGenerator) {
        Tracer tracer = Tracer.start((String)"toExpression");
        if (term == null) {
            return "" + tracer;
        }
        if (term instanceof Literal) {
            return this.toLiteralTermExpression(field, resultType, (Literal)term, variableExpressionGenerator, tracer);
        }
        if (term instanceof UnaryTerm) {
            return this.toUnaryTermExpression(field, resultType, (UnaryTerm)term, variableExpressionGenerator, tracer);
        }
        if (term instanceof BinaryTerm) {
            return this.toBinaryTermExpression(field, resultType, (BinaryTerm)term, variableExpressionGenerator, tracer);
        }
        if (term instanceof TernaryTerm) {
            return this.toTernaryTermExpression(field, resultType, (TernaryTerm)term, variableExpressionGenerator, tracer);
        }
        throw new FreemarkerException("Unsupported Term type " + term.getClass().getName());
    }

    private String toLiteralTermExpression(Field field, TypeReference resultType, Literal literal, Function<VariableLiteral, String> variableExpressionGenerator, Tracer tracer) {
        tracer = tracer.dive("literal term instanceOf");
        if (literal instanceof NullLiteral) {
            tracer = tracer.dive("null literal instanceOf");
            return tracer + "null";
        }
        if (literal instanceof BooleanLiteral) {
            tracer = tracer.dive("boolean literal instanceOf");
            return tracer + Boolean.toString(((BooleanLiteral)literal).getValue());
        }
        if (literal instanceof NumericLiteral) {
            FloatTypeReference floatTypeReference;
            tracer = tracer.dive("numeric literal instanceOf");
            String numberString = ((NumericLiteral)literal).getNumber().toString();
            if (resultType.isIntegerTypeReference()) {
                IntegerTypeReference integerTypeReference = (IntegerTypeReference)resultType.asIntegerTypeReference().orElseThrow(FreemarkerException::new);
                if (integerTypeReference.getBaseType() == SimpleTypeReference.SimpleBaseType.UINT && integerTypeReference.getSizeInBits() >= 32) {
                    tracer = tracer.dive("uint >= 32bit");
                    return tracer + numberString + "L";
                }
                if (integerTypeReference.getBaseType() == SimpleTypeReference.SimpleBaseType.INT && integerTypeReference.getSizeInBits() > 32) {
                    tracer = tracer.dive("int > 32bit");
                    return tracer + numberString + "L";
                }
            } else if (resultType.isFloatTypeReference() && (floatTypeReference = (FloatTypeReference)resultType.asFloatTypeReference().orElseThrow(FreemarkerException::new)).getSizeInBits() <= 32) {
                tracer = tracer.dive("float < 32bit");
                return tracer + numberString + "F";
            }
            return tracer + numberString;
        }
        if (literal instanceof HexadecimalLiteral) {
            tracer = tracer.dive("hexadecimal literal instanceOf");
            String hexString = ((HexadecimalLiteral)literal).getHexString();
            if (resultType.isIntegerTypeReference()) {
                IntegerTypeReference integerTypeReference = (IntegerTypeReference)resultType.asIntegerTypeReference().orElseThrow(FreemarkerException::new);
                if (integerTypeReference.getBaseType() == SimpleTypeReference.SimpleBaseType.UINT && integerTypeReference.getSizeInBits() >= 32) {
                    tracer = tracer.dive("uint >= 32bit");
                    return tracer + hexString + "L";
                }
                if (integerTypeReference.getBaseType() == SimpleTypeReference.SimpleBaseType.INT && integerTypeReference.getSizeInBits() > 32) {
                    tracer = tracer.dive("int > 32bit");
                    return tracer + hexString + "L";
                }
            }
            return tracer + hexString;
        }
        if (literal instanceof StringLiteral) {
            tracer = tracer.dive("string literal instanceOf");
            return tracer + "\"" + ((StringLiteral)literal).getValue() + "\"";
        }
        if (literal instanceof VariableLiteral) {
            tracer = tracer.dive("variable literal instanceOf");
            VariableLiteral variableLiteral = (VariableLiteral)literal;
            if ("curPos".equals(((VariableLiteral)literal).getName())) {
                return "(readBuffer.getPos() - startPos)";
            }
            if (this.getTypeDefinitions().get(variableLiteral.getName()) instanceof EnumTypeDefinition) {
                tracer = tracer.dive("enum definition instanceOf");
                VariableLiteral enumDefinitionChild = (VariableLiteral)variableLiteral.getChild().orElseThrow(() -> new FreemarkerException("enum definitions should have childs"));
                return tracer + variableLiteral.getName() + "." + enumDefinitionChild.getName() + enumDefinitionChild.getChild().map(child -> "." + this.toVariableExpressionRest(field, resultType, (VariableLiteral)child)).orElse("");
            }
            return tracer + variableExpressionGenerator.apply(variableLiteral);
        }
        throw new FreemarkerException("Unsupported Literal type " + literal.getClass().getName());
    }

    private String toUnaryTermExpression(Field field, TypeReference resultType, UnaryTerm unaryTerm, Function<VariableLiteral, String> variableExpressionGenerator, Tracer tracer) {
        tracer = tracer.dive("unary term instanceOf");
        Term a = unaryTerm.getA();
        switch (unaryTerm.getOperation()) {
            case "!": {
                tracer = tracer.dive("case !");
                if (resultType != this.getAnyTypeReference() && !resultType.isBooleanTypeReference()) {
                    throw new IllegalArgumentException("'!(...)' expression requires boolean type");
                }
                return tracer + "!(" + this.toExpression(field, resultType, a, variableExpressionGenerator) + ")";
            }
            case "-": {
                tracer = tracer.dive("case -");
                if (resultType != this.getAnyTypeReference() && !resultType.isIntegerTypeReference() && !resultType.isFloatTypeReference()) {
                    throw new IllegalArgumentException("'-(...)' expression requires integer or floating-point type");
                }
                return tracer + "-(" + this.toExpression(field, resultType, a, variableExpressionGenerator) + ")";
            }
            case "()": {
                tracer = tracer.dive("case ()");
                return tracer + "(" + this.toExpression(field, resultType, a, variableExpressionGenerator) + ")";
            }
        }
        throw new FreemarkerException("Unsupported unary operation type " + unaryTerm.getOperation());
    }

    private String toBinaryTermExpression(Field field, TypeReference resultType, BinaryTerm binaryTerm, Function<VariableLiteral, String> variableExpressionGenerator, Tracer tracer) {
        String operation;
        tracer = tracer.dive("binary term instanceOf");
        Term a = binaryTerm.getA();
        Term b = binaryTerm.getB();
        switch (operation = binaryTerm.getOperation()) {
            case "^": {
                tracer = tracer.dive(operation);
                if (resultType != this.getAnyTypeReference() && !resultType.isIntegerTypeReference() && !resultType.isFloatTypeReference()) {
                    throw new IllegalArgumentException("'A^B' expression requires numeric result type");
                }
                return tracer + "Math.pow((" + this.toExpression(field, resultType, a, variableExpressionGenerator) + "), (" + this.toExpression(field, resultType, b, variableExpressionGenerator) + "))";
            }
            case "%": 
            case "*": 
            case "+": 
            case "-": 
            case "/": {
                tracer = tracer.dive(operation);
                if (resultType != this.getAnyTypeReference() && !resultType.isIntegerTypeReference() && !resultType.isFloatTypeReference()) {
                    throw new IllegalArgumentException("'A" + operation + "B' expression requires numeric result type");
                }
                return tracer + "(" + this.toExpression(field, resultType, a, variableExpressionGenerator) + ") " + operation + " (" + this.toExpression(field, resultType, b, variableExpressionGenerator) + ")";
            }
            case "<<": 
            case ">>": {
                tracer = tracer.dive(operation);
                return tracer + "(" + this.toExpression(field, resultType, a, variableExpressionGenerator) + ") " + operation + " (" + this.toExpression(field, INT_TYPE_REFERENCE, b, variableExpressionGenerator) + ")";
            }
            case "<": 
            case ">": 
            case "!=": 
            case "<=": 
            case "==": 
            case ">=": {
                if (resultType != this.getAnyTypeReference() && !resultType.isBooleanTypeReference()) {
                    throw new IllegalArgumentException("'A" + operation + "B' expression requires boolean result type");
                }
                return tracer + "(" + this.toExpression(field, ANY_TYPE_REFERENCE, a, variableExpressionGenerator) + ") " + operation + " (" + this.toExpression(field, ANY_TYPE_REFERENCE, b, variableExpressionGenerator) + ")";
            }
            case "&&": 
            case "||": {
                if (resultType != this.getAnyTypeReference() && !resultType.isBooleanTypeReference()) {
                    throw new IllegalArgumentException("'A" + operation + "B' expression requires boolean result type");
                }
                return tracer + "(" + this.toExpression(field, resultType, a, variableExpressionGenerator) + ") " + operation + " (" + this.toExpression(field, resultType, b, variableExpressionGenerator) + ")";
            }
            case "&": 
            case "|": {
                throw new IllegalArgumentException("Implement this some day ...");
            }
        }
        throw new IllegalArgumentException("Unsupported ternary operation type " + operation);
    }

    private String toTernaryTermExpression(Field field, TypeReference resultType, TernaryTerm ternaryTerm, Function<VariableLiteral, String> variableExpressionGenerator, Tracer tracer) {
        tracer = tracer.dive("ternary term instanceOf");
        if ("if".equals(ternaryTerm.getOperation())) {
            Term a = ternaryTerm.getA();
            Term b = ternaryTerm.getB();
            Term c = ternaryTerm.getC();
            return tracer + "(" + "(" + this.toExpression(field, BOOL_TYPE_REFERENCE, a, variableExpressionGenerator) + ") ? " + this.toExpression(field, resultType, b, variableExpressionGenerator) + " : " + this.toExpression(field, resultType, c, variableExpressionGenerator) + ")";
        }
        throw new IllegalArgumentException("Unsupported ternary operation type " + ternaryTerm.getOperation());
    }

    public String toVariableEnumAccessExpression(VariableLiteral variableLiteral) {
        return variableLiteral.getName();
    }

    private String toVariableParseExpression(Field field, TypeReference resultType, VariableLiteral variableLiteral, List<Argument> parserArguments) {
        Tracer tracer;
        block22: {
            tracer = Tracer.start((String)"toVariableParseExpression");
            if ("CAST".equals(variableLiteral.getName())) {
                return this.toCastVariableParseExpression(field, resultType, variableLiteral, parserArguments, tracer);
            }
            if ("BIG_ENDIAN".equals(variableLiteral.getName())) {
                return "ByteOrder.BIG_ENDIAN";
            }
            if ("LITTLE_ENDIAN".equals(variableLiteral.getName())) {
                return "ByteOrder.LITTLE_ENDIAN";
            }
            if (this.isVariableLiteralImplicitField(variableLiteral)) {
                return this.toImplicitVariableParseExpression(field, resultType, variableLiteral, tracer);
            }
            if ("STATIC_CALL".equals(variableLiteral.getName())) {
                return this.toStaticCallParseExpression(field, resultType, variableLiteral, parserArguments, tracer);
            }
            if (variableLiteral.getName().equals(variableLiteral.getName().toUpperCase())) {
                return this.toFunctionCallParseExpression(field, resultType, variableLiteral, parserArguments, tracer);
            }
            boolean isParserArg = "readBuffer".equals(variableLiteral.getName());
            boolean isTypeArg = "_type".equals(variableLiteral.getName());
            if (!isParserArg && !isTypeArg && parserArguments != null) {
                for (Argument serializerArgument : parserArguments) {
                    if (!serializerArgument.getName().equals(variableLiteral.getName())) continue;
                    isParserArg = true;
                    break;
                }
            }
            if (isParserArg) {
                tracer = tracer.dive("parser arg");
                return tracer + variableLiteral.getName() + variableLiteral.getChild().map(child -> "." + this.toVariableExpressionRest(field, resultType, (VariableLiteral)child)).orElse("");
            }
            if (!isTypeArg) break block22;
            tracer = tracer.dive("type arg");
            String part = variableLiteral.getChild().map(VariableLiteral::getName).orElse("");
            switch (part) {
                case "name": {
                    return tracer + "\"" + field.getTypeName() + "\"";
                }
                case "length": {
                    return tracer + "\"" + ((SimpleTypeReference)field).getSizeInBits() + "\"";
                }
                case "encoding": {
                    String encoding = ((StringLiteral)field.getEncoding().orElse(new DefaultStringLiteral("UTF-8"))).getValue();
                    return tracer + "\"" + encoding + "\"";
                }
            }
            return "" + tracer;
        }
        return tracer + variableLiteral.getName() + variableLiteral.getChild().map(child -> "." + this.toVariableExpressionRest(field, resultType, (VariableLiteral)child)).orElse("");
    }

    private String toCastVariableParseExpression(Field field, TypeReference resultType, VariableLiteral variableLiteral, List<Argument> parserArguments, Tracer tracer) {
        tracer = tracer.dive("CAST");
        List arguments = (List)variableLiteral.getArgs().orElseThrow(() -> new FreemarkerException("A Cast expression needs arguments"));
        if (arguments.size() != 2) {
            throw new FreemarkerException("A CAST expression expects exactly two arguments.");
        }
        VariableLiteral firstArgument = (VariableLiteral)((Literal)((Term)arguments.get(0)).asLiteral().orElseThrow(() -> new FreemarkerException("First argument should be a literal"))).asVariableLiteral().orElseThrow(() -> new FreemarkerException("First argument should be a Variable literal"));
        StringLiteral typeArgument = (StringLiteral)((Literal)((Term)arguments.get(1)).asLiteral().orElseThrow(() -> new FreemarkerException("Second argument should be a String literal"))).asStringLiteral().orElseThrow(() -> new FreemarkerException("Second argument should be a String literal"));
        String sb = "CAST(" + this.toVariableParseExpression(field, ANY_TYPE_REFERENCE, firstArgument, parserArguments) + ", " + typeArgument.getValue() + ".class)";
        return tracer + sb + variableLiteral.getChild().map(child -> "." + this.toVariableExpressionRest(field, resultType, (VariableLiteral)child)).orElse("");
    }

    private String toImplicitVariableParseExpression(Field field, TypeReference resultType, VariableLiteral variableLiteral, Tracer tracer) {
        tracer = tracer.dive("implicit");
        return tracer + variableLiteral.getName();
    }

    private String toStaticCallParseExpression(Field field, TypeReference resultType, VariableLiteral variableLiteral, List<Argument> parserArguments, Tracer tracer) {
        tracer = tracer.dive("STATIC_CALL");
        List arguments = (List)variableLiteral.getArgs().orElseThrow(() -> new FreemarkerException("A STATIC_CALL expression needs arguments"));
        if (arguments.size() < 1) {
            throw new FreemarkerException("A STATIC_CALL expression expects at least one argument.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.packageName()).append(".utils.StaticHelper.");
        String methodName = ((StringLiteral)((Literal)((Term)arguments.get(0)).asLiteral().orElseThrow(() -> new FreemarkerException("First argument should be a literal"))).asStringLiteral().orElseThrow(() -> new FreemarkerException("Expecting the first argument of a 'STATIC_CALL' to be a StringLiteral"))).getValue();
        sb.append(methodName).append("(");
        int i = 1;
        while (i < arguments.size()) {
            Term arg = (Term)arguments.get(i);
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(this.toParseExpression(field, ANY_TYPE_REFERENCE, arg, parserArguments));
            ++i;
        }
        sb.append(")");
        if (variableLiteral.getIndex().isPresent()) {
            sb.append(".get(").append(variableLiteral.getIndex().orElseThrow()).append(")");
        }
        return tracer + sb.toString();
    }

    private String toFunctionCallParseExpression(Field field, TypeReference resultType, VariableLiteral variableLiteral, List<Argument> parserArguments, Tracer tracer) {
        tracer = tracer.dive("FunctionCall");
        StringBuilder sb = new StringBuilder(variableLiteral.getName());
        if (variableLiteral.getArgs().isPresent()) {
            sb.append("(");
            boolean firstArg = true;
            for (Term arg : (List)variableLiteral.getArgs().get()) {
                if (!firstArg) {
                    sb.append(", ");
                }
                sb.append(this.toParseExpression(field, ANY_TYPE_REFERENCE, arg, parserArguments));
                firstArg = false;
            }
            sb.append(")");
        }
        if (variableLiteral.getIndex().isPresent()) {
            sb.append(".get(").append(variableLiteral.getIndex().orElseThrow()).append(")");
        }
        return tracer + sb.toString() + variableLiteral.getChild().map(child -> "." + this.toVariableExpressionRest(field, resultType, (VariableLiteral)child)).orElse("");
    }

    private String toVariableSerializationExpression(Field field, TypeReference resultType, VariableLiteral variableLiteral, List<Argument> serialzerArguments) {
        Tracer tracer;
        block20: {
            tracer = Tracer.start((String)"variable serialization expression");
            if ("STATIC_CALL".equals(variableLiteral.getName())) {
                return this.toStaticCallSerializationExpression(field, resultType, variableLiteral, serialzerArguments, tracer);
            }
            if (variableLiteral.getName().equals(variableLiteral.getName().toUpperCase())) {
                return this.toGlobalFunctionCallSerializationExpression(field, resultType, variableLiteral, serialzerArguments, tracer);
            }
            if (this.isVariableLiteralImplicitField(variableLiteral)) {
                tracer = tracer.dive("implicit field");
                ImplicitField referencedImplicitField = this.getReferencedImplicitField(variableLiteral);
                return tracer + this.toSerializationExpression((Field)referencedImplicitField, referencedImplicitField.getType(), this.getReferencedImplicitField(variableLiteral).getSerializeExpression(), serialzerArguments);
            }
            if (this.isVariableLiteralVirtualField(variableLiteral)) {
                tracer = tracer.dive("virtual field");
                return tracer + this.toVariableExpressionRest(field, resultType, variableLiteral);
            }
            boolean isSerializerArg = "writeBuffer".equals(variableLiteral.getName()) || "checksumRawData".equals(variableLiteral.getName()) || "_value".equals(variableLiteral.getName()) || "element".equals(variableLiteral.getName()) || "size".equals(variableLiteral.getName());
            boolean isTypeArg = "_type".equals(variableLiteral.getName());
            if (!isSerializerArg && !isTypeArg && serialzerArguments != null) {
                for (Argument serializerArgument : serialzerArguments) {
                    if (!serializerArgument.getName().equals(variableLiteral.getName())) continue;
                    isSerializerArg = true;
                    break;
                }
            }
            if (isSerializerArg) {
                tracer = tracer.dive("serializer arg");
                return tracer + variableLiteral.getName() + variableLiteral.getChild().map(child -> "." + this.toVariableExpressionRest(field, resultType, (VariableLiteral)child)).orElse("");
            }
            if (!isTypeArg) break block20;
            tracer = tracer.dive("type arg");
            String part = variableLiteral.getChild().map(VariableLiteral::getName).orElse("");
            switch (part) {
                case "name": {
                    return tracer + "\"" + field.getTypeName() + "\"";
                }
                case "length": {
                    return tracer + "\"" + ((SimpleTypeReference)field).getSizeInBits() + "\"";
                }
                case "encoding": {
                    String encoding = ((StringLiteral)field.getEncoding().orElse(new DefaultStringLiteral("UTF-8"))).getValue();
                    return tracer + "\"" + encoding + "\"";
                }
            }
            return "" + tracer;
        }
        return tracer + this.toVariableExpressionRest(field, resultType, variableLiteral);
    }

    private String toGlobalFunctionCallSerializationExpression(Field field, TypeReference resultType, VariableLiteral variableLiteral, List<Argument> serialzerArguments, Tracer tracer) {
        tracer = tracer.dive("GLOBAL_FUNCTION_CALL");
        StringBuilder sb = new StringBuilder(variableLiteral.getName());
        if (variableLiteral.getArgs().isPresent()) {
            sb.append("(");
            boolean firstArg = true;
            for (Term arg : (List)variableLiteral.getArgs().get()) {
                if (!firstArg) {
                    sb.append(", ");
                }
                sb.append(this.toSerializationExpression(field, ANY_TYPE_REFERENCE, arg, serialzerArguments));
                firstArg = false;
            }
            sb.append(")");
        }
        return tracer + sb.toString();
    }

    private String toStaticCallSerializationExpression(Field field, TypeReference resultType, VariableLiteral variableLiteral, List<Argument> serialzerArguments, Tracer tracer) {
        tracer = tracer.dive("STATIC_CALL");
        StringBuilder sb = new StringBuilder();
        List arguments = (List)variableLiteral.getArgs().orElseThrow(() -> new FreemarkerException("A STATIC_CALL expression needs arguments"));
        if (arguments.size() < 1) {
            throw new FreemarkerException("A STATIC_CALL expression expects at least one argument.");
        }
        sb.append(this.packageName()).append(".utils.StaticHelper.");
        String methodName = ((StringLiteral)((Literal)((Term)arguments.get(0)).asLiteral().orElseThrow(() -> new FreemarkerException("First argument should be a literal"))).asStringLiteral().orElseThrow(() -> new FreemarkerException("Expecting the first argument of a 'STATIC_CALL' to be a StringLiteral"))).getValue();
        sb.append(methodName).append("(");
        int i = 1;
        while (i < arguments.size()) {
            Term arg = (Term)arguments.get(i);
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(this.toSerializationExpression(field, ANY_TYPE_REFERENCE, arg, serialzerArguments));
            ++i;
        }
        sb.append(")");
        return tracer + sb.toString();
    }

    private String toVariableExpressionRest(Field field, TypeReference resultType, VariableLiteral variableLiteral) {
        Tracer tracer = Tracer.start((String)"variable expression rest");
        String variableLiteralName = variableLiteral.getName();
        if (variableLiteralName.equals("length")) {
            tracer = tracer.dive("length");
            return tracer + variableLiteralName + "()" + (variableLiteral.getIndex().isPresent() ? ".get(" + variableLiteral.getIndex().orElseThrow() + ")" : "") + variableLiteral.getChild().map(child -> "." + this.toVariableExpressionRest(field, resultType, (VariableLiteral)child)).orElse("");
        }
        return tracer + "get" + WordUtils.capitalize((String)variableLiteralName) + "()" + (variableLiteral.getIndex().isPresent() ? ".get(" + variableLiteral.getIndex().orElseThrow() + ")" : "") + variableLiteral.getChild().map(child -> "." + this.toVariableExpressionRest(field, resultType, (VariableLiteral)child)).orElse("");
    }

    public String getSizeInBits(ComplexTypeDefinition complexTypeDefinition, List<Argument> parserArguments) {
        int sizeInBits = 0;
        StringBuilder sb = new StringBuilder();
        for (Field field : complexTypeDefinition.getFields()) {
            SimpleTypeReference type;
            if (field instanceof ArrayField) {
                ArrayField arrayField = (ArrayField)field;
                type = (SimpleTypeReference)arrayField.getType();
                switch (arrayField.getLoopType()) {
                    case COUNT: {
                        sb.append("(").append(this.toSerializationExpression(null, INT_TYPE_REFERENCE, arrayField.getLoopExpression(), parserArguments)).append(" * ").append(type.getSizeInBits()).append(") + ");
                        break;
                    }
                    case LENGTH: {
                        sb.append("(").append(this.toSerializationExpression(null, INT_TYPE_REFERENCE, arrayField.getLoopExpression(), parserArguments)).append(" * 8) + ");
                        break;
                    }
                }
                continue;
            }
            if (!(field instanceof TypedField)) continue;
            TypedField typedField = (TypedField)field;
            type = typedField.getType();
            if (field instanceof ManualField) {
                ManualField manualField = (ManualField)field;
                sb.append("(").append(this.toSerializationExpression(null, INT_TYPE_REFERENCE, manualField.getLengthExpression(), parserArguments)).append(") + ");
                continue;
            }
            if (!(type instanceof SimpleTypeReference)) continue;
            SimpleTypeReference simpleTypeReference = type;
            if (simpleTypeReference instanceof VstringTypeReference) {
                sb.append(this.toSerializationExpression(null, INT_TYPE_REFERENCE, ((VstringTypeReference)simpleTypeReference).getLengthExpression(), parserArguments)).append(" + ");
                continue;
            }
            sizeInBits += simpleTypeReference.getSizeInBits();
        }
        return String.valueOf(sb.toString()) + sizeInBits;
    }

    public String escapeValue(TypeReference typeReference, String valueString) {
        block8: {
            block7: {
                if (valueString == null) {
                    return null;
                }
                if (!typeReference.isSimpleTypeReference()) break block7;
                SimpleTypeReference simpleTypeReference = (SimpleTypeReference)typeReference;
                switch (simpleTypeReference.getBaseType()) {
                    case UINT: 
                    case INT: {
                        if (!NumberUtils.isParsable((String)valueString) && valueString.length() == 1) {
                            return "'" + valueString + "'";
                        }
                        break block8;
                    }
                    case STRING: 
                    case VSTRING: {
                        return "\"" + valueString + "\"";
                    }
                }
                break block8;
            }
            if (typeReference.isEnumTypeReference()) {
                return "model." + ((EnumTypeReference)typeReference.asEnumTypeReference().orElseThrow()).getName() + "." + valueString;
            }
        }
        return valueString;
    }

    public String getFieldOptions(TypedField field, List<Argument> parserArguments) {
        Optional byteOrderOptional;
        StringBuilder sb = new StringBuilder();
        Optional encodingOptional = field.getEncoding();
        if (encodingOptional.isPresent()) {
            String encoding = this.toParseExpression((Field)field, field.getType(), (Term)encodingOptional.get(), parserArguments);
            sb.append(", WithOption.WithEncoding(").append(encoding).append(")");
        }
        if ((byteOrderOptional = field.getByteOrder()).isPresent()) {
            String byteOrder = this.toParseExpression((Field)field, field.getType(), (Term)byteOrderOptional.get(), parserArguments);
            sb.append(", WithOption.WithByteOrder(").append(byteOrder).append(")");
        }
        return sb.toString();
    }
}

