/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.protocol.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateNotFoundException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.plugins.codegenerator.language.LanguageOutput;
import org.apache.plc4x.plugins.codegenerator.protocol.freemarker.FreemarkerLanguageTemplateHelper;
import org.apache.plc4x.plugins.codegenerator.types.definitions.DataIoTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.EnumTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.exceptions.GenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FreemarkerLanguageOutput
implements LanguageOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(FreemarkerLanguageOutput.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generate(File outputDir, String languageName, String protocolName, String outputFlavor, Map<String, TypeDefinition> types) throws GenerationException {
        try {
            Configuration freemarkerConfiguration = this.getFreemarkerConfiguration();
            ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(FreemarkerLanguageOutput.class, "/");
            freemarkerConfiguration.setTemplateLoader((TemplateLoader)classTemplateLoader);
            List<Template> specTemplates = this.getSpecTemplates(freemarkerConfiguration);
            List<Template> complexTypesTemplateList = this.getComplexTypeTemplates(freemarkerConfiguration);
            List<Template> enumTypesTemplateList = this.getEnumTypeTemplates(freemarkerConfiguration);
            List<Template> dataIoTemplateList = this.getDataIoTemplates(freemarkerConfiguration);
            if (!specTemplates.isEmpty()) {
                HashMap<String, Object> typeContext = new HashMap<String, Object>();
                typeContext.put("languageName", languageName);
                typeContext.put("protocolName", protocolName);
                typeContext.put("outputFlavor", outputFlavor);
                typeContext.put("helper", this.getHelper(null, protocolName, outputFlavor, types));
                for (Template template : specTemplates) {
                    try {
                        this.renderTemplate(outputDir, template, typeContext);
                    }
                    catch (ParseException | MalformedTemplateNameException | TemplateException | TemplateNotFoundException e) {
                        throw new GenerationException("Error generating global protocol output.", e);
                    }
                }
            }
            for (Map.Entry<String, TypeDefinition> typeEntry : types.entrySet()) {
                List<Template> templateList;
                HashMap<String, Object> typeContext = new HashMap<String, Object>();
                typeContext.put("languageName", languageName);
                typeContext.put("protocolName", protocolName);
                typeContext.put("outputFlavor", outputFlavor);
                typeContext.put("typeName", typeEntry.getKey());
                typeContext.put("type", typeEntry.getValue());
                typeContext.put("helper", this.getHelper(typeEntry.getValue(), protocolName, outputFlavor, types));
                if (typeEntry.getValue() instanceof EnumTypeDefinition) {
                    templateList = enumTypesTemplateList;
                } else if (typeEntry.getValue() instanceof DataIoTypeDefinition) {
                    templateList = dataIoTemplateList;
                } else {
                    if (typeEntry.getValue().getParentType() instanceof DataIoTypeDefinition) continue;
                    templateList = complexTypesTemplateList;
                }
                LOGGER.info(String.format("Generating type %s", typeEntry.getKey()));
                for (Template template : templateList) {
                    try {
                        this.renderTemplate(outputDir, template, typeContext);
                    }
                    catch (ParseException | MalformedTemplateNameException | TemplateException | TemplateNotFoundException e) {
                        throw new GenerationException("Error generating output for type '" + typeEntry.getKey() + "'", e);
                    }
                }
                continue;
                return;
            }
        }
        catch (IOException e) {
            throw new GenerationException("Error generating sources", (Throwable)e);
        }
    }

    protected void renderTemplate(File outputDir, Template template, Map<String, Object> context) throws TemplateException, IOException, GenerationException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        template.process(context, (Writer)new OutputStreamWriter(output));
        try (BufferedReader input = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.toByteArray())));){
            String outputFileName = input.readLine();
            if (outputFileName == null) {
                return;
            }
            File outputFile = new File(outputDir, outputFileName);
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                throw new GenerationException("Unable to create output directory " + outputFile.getParent());
            }
            try (BufferedWriter outputFileWriter = Files.newBufferedWriter(outputFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                String line;
                while ((line = input.readLine()) != null) {
                    outputFileWriter.write(line);
                    outputFileWriter.newLine();
                }
                outputFileWriter.flush();
            }
        }
    }

    private Configuration getFreemarkerConfiguration() throws IOException {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        configuration.setLogTemplateExceptions(false);
        configuration.setWrapUncheckedExceptions(true);
        configuration.setDirectoryForTemplateLoading(new File("/"));
        return configuration;
    }

    protected abstract List<Template> getSpecTemplates(Configuration var1) throws IOException;

    protected abstract List<Template> getComplexTypeTemplates(Configuration var1) throws IOException;

    protected abstract List<Template> getEnumTypeTemplates(Configuration var1) throws IOException;

    protected abstract List<Template> getDataIoTemplates(Configuration var1) throws IOException;

    protected abstract FreemarkerLanguageTemplateHelper getHelper(TypeDefinition var1, String var2, String var3, Map<String, TypeDefinition> var4);
}

