/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator.protocol.freemarker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.apache.plc4x.plugins.codegenerator.protocol.freemarker.FreemarkerLanguageTemplateHelper;
import org.apache.plc4x.plugins.codegenerator.types.definitions.Argument;
import org.apache.plc4x.plugins.codegenerator.types.definitions.ComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.DiscriminatedComplexTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.EnumTypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.definitions.TypeDefinition;
import org.apache.plc4x.plugins.codegenerator.types.enums.EnumValue;
import org.apache.plc4x.plugins.codegenerator.types.fields.AbstractField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ArrayField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ChecksumField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ConstField;
import org.apache.plc4x.plugins.codegenerator.types.fields.DiscriminatorField;
import org.apache.plc4x.plugins.codegenerator.types.fields.Field;
import org.apache.plc4x.plugins.codegenerator.types.fields.ImplicitField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ManualArrayField;
import org.apache.plc4x.plugins.codegenerator.types.fields.NamedField;
import org.apache.plc4x.plugins.codegenerator.types.fields.OptionalField;
import org.apache.plc4x.plugins.codegenerator.types.fields.PaddingField;
import org.apache.plc4x.plugins.codegenerator.types.fields.PropertyField;
import org.apache.plc4x.plugins.codegenerator.types.fields.ReservedField;
import org.apache.plc4x.plugins.codegenerator.types.fields.SimpleField;
import org.apache.plc4x.plugins.codegenerator.types.fields.SwitchField;
import org.apache.plc4x.plugins.codegenerator.types.fields.TypedField;
import org.apache.plc4x.plugins.codegenerator.types.fields.VirtualField;
import org.apache.plc4x.plugins.codegenerator.types.references.ComplexTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.SimpleTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.StringTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.references.TypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.BinaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.BooleanLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.Literal;
import org.apache.plc4x.plugins.codegenerator.types.terms.NullLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.NumericLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.StringLiteral;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;
import org.apache.plc4x.plugins.codegenerator.types.terms.TernaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.UnaryTerm;
import org.apache.plc4x.plugins.codegenerator.types.terms.VariableLiteral;

public abstract class BaseFreemarkerLanguageTemplateHelper
implements FreemarkerLanguageTemplateHelper {
    private final TypeDefinition thisType;
    private final String protocolName;
    private final String flavorName;
    private final Map<String, TypeDefinition> types;
    private static Map<String, SimpleTypeReference> builtInFields;

    public BaseFreemarkerLanguageTemplateHelper(TypeDefinition thisType, String protocolName, String flavorName, Map<String, TypeDefinition> types) {
        builtInFields = new HashMap<String, SimpleTypeReference>();
        builtInFields.put("curPos", new SimpleTypeReference(){

            public SimpleTypeReference.SimpleBaseType getBaseType() {
                return SimpleTypeReference.SimpleBaseType.UINT;
            }

            public int getSizeInBits() {
                return 16;
            }
        });
        builtInFields.put("startPos", new SimpleTypeReference(){

            public SimpleTypeReference.SimpleBaseType getBaseType() {
                return SimpleTypeReference.SimpleBaseType.UINT;
            }

            public int getSizeInBits() {
                return 16;
            }
        });
        builtInFields.put("lastItem", new SimpleTypeReference(){

            public SimpleTypeReference.SimpleBaseType getBaseType() {
                return SimpleTypeReference.SimpleBaseType.BIT;
            }

            public int getSizeInBits() {
                return 1;
            }
        });
        this.thisType = thisType;
        this.protocolName = protocolName;
        this.flavorName = flavorName;
        this.types = types;
    }

    protected TypeDefinition getThisTypeDefinition() {
        return this.thisType;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getFlavorName() {
        return this.flavorName;
    }

    public Map<String, TypeDefinition> getTypeDefinitions() {
        return this.types;
    }

    public List<TypeDefinition> getComplexTypeRootDefinitions() {
        return this.types.values().stream().filter(typeDefinition -> typeDefinition instanceof ComplexTypeDefinition && !(typeDefinition instanceof DiscriminatedComplexTypeDefinition)).collect(Collectors.toList());
    }

    protected static Map<String, SimpleTypeReference> getBuiltInFieldTypes() {
        return builtInFields;
    }

    public abstract String getLanguageTypeNameForField(Field var1);

    public abstract String getLanguageTypeNameForTypeReference(TypeReference var1);

    public String getReadBufferReadMethodCall(SimpleTypeReference simpleTypeReference) {
        return this.getReadBufferReadMethodCall(simpleTypeReference, null);
    }

    public abstract String getReadBufferReadMethodCall(SimpleTypeReference var1, String var2);

    public abstract String getWriteBufferWriteMethodCall(SimpleTypeReference var1, String var2);

    public abstract String getNullValueForTypeReference(TypeReference var1);

    public boolean isSimpleTypeReference(TypeReference typeReference) {
        return typeReference instanceof SimpleTypeReference;
    }

    public boolean isComplexTypeReference(TypeReference typeReference) {
        return typeReference instanceof ComplexTypeReference;
    }

    public boolean isEnumTypeReference(TypeReference typeReference) {
        return this.getTypeDefinitionForTypeReference(typeReference) instanceof EnumTypeDefinition;
    }

    public boolean isStringTypeReference(TypeReference typeReference) {
        return typeReference instanceof StringTypeReference;
    }

    public Collection<String> getComplexTypeReferences() {
        return this.getComplexTypeReferences(this.thisType);
    }

    public Collection<String> getComplexTypeReferences(TypeDefinition baseType) {
        ComplexTypeReference complexTypeReference;
        DiscriminatedComplexTypeDefinition discriminatedComplexTypeDefinition;
        HashSet<String> complexTypeReferences = new HashSet<String>();
        if (baseType instanceof DiscriminatedComplexTypeDefinition && !(discriminatedComplexTypeDefinition = (DiscriminatedComplexTypeDefinition)baseType).isAbstract()) {
            complexTypeReferences.add(((ComplexTypeReference)discriminatedComplexTypeDefinition.getParentType().getTypeReference()).getName());
        }
        if (baseType instanceof ComplexTypeDefinition) {
            ComplexTypeDefinition complexTypeDefinition = (ComplexTypeDefinition)baseType;
            for (Field field : complexTypeDefinition.getFields()) {
                if (field instanceof PropertyField) {
                    PropertyField propertyField = (PropertyField)field;
                    if (!(propertyField.getType() instanceof ComplexTypeReference)) continue;
                    complexTypeReference = (ComplexTypeReference)propertyField.getType();
                    complexTypeReferences.add(complexTypeReference.getName());
                    continue;
                }
                if (!(field instanceof SwitchField)) continue;
                SwitchField switchField = (SwitchField)field;
                for (DiscriminatedComplexTypeDefinition switchCase : switchField.getCases()) {
                    complexTypeReferences.addAll(this.getComplexTypeReferences((TypeDefinition)switchCase));
                }
            }
        } else if (baseType instanceof EnumTypeDefinition) {
            for (String string : ((EnumTypeDefinition)baseType).getConstantNames()) {
                TypeReference constantType = ((EnumTypeDefinition)this.thisType).getConstantType(string);
                if (!(constantType instanceof ComplexTypeReference)) continue;
                ComplexTypeReference complexTypeReference2 = (ComplexTypeReference)constantType;
                complexTypeReferences.add(complexTypeReference2.getName());
            }
        }
        if (baseType.getParserArguments() != null) {
            for (String string : baseType.getParserArguments()) {
                if (!(string.getType() instanceof ComplexTypeReference)) continue;
                complexTypeReference = (ComplexTypeReference)string.getType();
                complexTypeReferences.add(complexTypeReference.getName());
            }
        }
        return complexTypeReferences;
    }

    public Optional<TypeReference> getTypeReferenceForProperty(ComplexTypeDefinition baseType, String propertyName) {
        Optional<Argument> argumentOptional;
        if (builtInFields.containsKey(propertyName)) {
            return Optional.of((TypeReference)builtInFields.get(propertyName));
        }
        Optional<PropertyField> propertyFieldOptional = baseType.getPropertyFields().stream().filter(propertyField -> propertyField.getName().equals(propertyName)).findFirst();
        if (propertyFieldOptional.isPresent()) {
            PropertyField propertyField2 = propertyFieldOptional.get();
            return Optional.of(propertyField2.getType());
        }
        Optional<ImplicitField> implicitFieldOptional = baseType.getFields().stream().filter(field -> field instanceof ImplicitField).map(field -> (ImplicitField)field).filter(implicitField -> implicitField.getName().equals(propertyName)).findFirst();
        if (implicitFieldOptional.isPresent()) {
            ImplicitField implicitField2 = implicitFieldOptional.get();
            return Optional.of(implicitField2.getType());
        }
        if (baseType.getParserArguments() != null && (argumentOptional = Arrays.stream(baseType.getParserArguments()).filter(argument -> argument.getName().equals(propertyName)).findFirst()).isPresent()) {
            Argument argument2 = argumentOptional.get();
            return Optional.of(argument2.getType());
        }
        Optional<DiscriminatorField> discriminatorFieldOptional = baseType.getFields().stream().filter(field -> field instanceof DiscriminatorField).map(field -> (DiscriminatorField)field).filter(discriminatorField -> discriminatorField.getName().equals(propertyName)).findFirst();
        if (discriminatorFieldOptional.isPresent()) {
            DiscriminatorField discriminatorField2 = discriminatorFieldOptional.get();
            return Optional.of(discriminatorField2.getType());
        }
        return Optional.empty();
    }

    public SimpleTypeReference getEnumBaseTypeReference(TypeReference typeReference) {
        if (!(typeReference instanceof ComplexTypeReference)) {
            throw new RuntimeException("type reference for enum types must be of type complex type");
        }
        ComplexTypeReference complexTypeReference = (ComplexTypeReference)typeReference;
        TypeDefinition typeDefinition = this.types.get(complexTypeReference.getName());
        if (typeDefinition == null) {
            throw new RuntimeException("Couldn't find given enum type definition with name " + complexTypeReference.getName());
        }
        if (!(typeDefinition instanceof EnumTypeDefinition)) {
            throw new RuntimeException("Referenced type with name " + complexTypeReference.getName() + " is not an enum type");
        }
        EnumTypeDefinition enumTypeDefinition = (EnumTypeDefinition)typeDefinition;
        return (SimpleTypeReference)enumTypeDefinition.getType();
    }

    public boolean hasFieldOfType(String fieldTypeName) {
        if (this.getThisTypeDefinition() instanceof ComplexTypeDefinition) {
            return ((ComplexTypeDefinition)this.getThisTypeDefinition()).getFields().stream().anyMatch(field -> field.getTypeName().equals(fieldTypeName));
        }
        return false;
    }

    public boolean hasFieldsWithNames(List<Field> fields, String ... names) {
        for (String name : names) {
            boolean foundName = false;
            for (Field field : fields) {
                if (!(field instanceof NamedField) || !name.equals(((NamedField)field).getName())) continue;
                foundName = true;
                break;
            }
            if (foundName) continue;
            return false;
        }
        return true;
    }

    public Field getFieldForNameFromCurrentOrParent(String fieldName) {
        if (this.getThisTypeDefinition() instanceof ComplexTypeDefinition) {
            return ((ComplexTypeDefinition)this.getThisTypeDefinition()).getAllPropertyFields().stream().filter(propertyField -> propertyField.getName().equals(fieldName)).findFirst().orElse(null);
        }
        return null;
    }

    public Field getFieldForNameFromCurrent(String fieldName) {
        if (this.getThisTypeDefinition() instanceof ComplexTypeDefinition) {
            return ((ComplexTypeDefinition)this.getThisTypeDefinition()).getPropertyFields().stream().filter(propertyField -> propertyField.getName().equals(fieldName)).findFirst().orElse(null);
        }
        return null;
    }

    public boolean isAbstractField(Field field) {
        return field instanceof AbstractField;
    }

    public boolean isArrayField(Field field) {
        return field instanceof ArrayField;
    }

    public boolean isChecksumField(Field field) {
        return field instanceof ChecksumField;
    }

    public boolean isConstField(Field field) {
        return field instanceof ConstField;
    }

    public boolean isDiscriminatorField(Field field) {
        return field instanceof DiscriminatorField;
    }

    public boolean isEnumField(Field field) {
        TypeDefinition typeDefinition;
        TypedField typedField;
        TypeReference typeReference;
        return field instanceof TypedField && !this.isSimpleTypeReference(typeReference = (typedField = (TypedField)field).getType()) && (typeDefinition = this.getTypeDefinitionForTypeReference(typedField.getType())) instanceof EnumTypeDefinition;
    }

    public boolean isImplicitField(Field field) {
        return field instanceof ImplicitField;
    }

    public boolean isManualArrayField(Field field) {
        return field instanceof ManualArrayField;
    }

    public boolean isNamedField(Field field) {
        return field instanceof NamedField;
    }

    public boolean isOptionalField(Field field) {
        return field instanceof OptionalField;
    }

    public boolean isPaddingField(Field field) {
        return field instanceof PaddingField;
    }

    public boolean isPropertyField(Field field) {
        return field instanceof PropertyField;
    }

    public boolean isReservedField(Field field) {
        return field instanceof ReservedField;
    }

    public boolean isSimpleField(Field field) {
        return field instanceof SimpleField;
    }

    public boolean isSwitchField(Field field) {
        return field instanceof SwitchField;
    }

    public boolean isTypedField(Field field) {
        return field instanceof TypedField;
    }

    public boolean isVirtualField(Field field) {
        return field instanceof VirtualField;
    }

    public boolean isCountArrayField(Field field) {
        if (field instanceof ArrayField) {
            ArrayField arrayField = (ArrayField)field;
            return arrayField.getLoopType() == ArrayField.LoopType.COUNT;
        }
        if (field instanceof ManualArrayField) {
            ManualArrayField arrayField = (ManualArrayField)field;
            return arrayField.getLoopType() == ManualArrayField.LoopType.COUNT;
        }
        return false;
    }

    public boolean isLengthArrayField(Field field) {
        if (field instanceof ArrayField) {
            ArrayField arrayField = (ArrayField)field;
            return arrayField.getLoopType() == ArrayField.LoopType.LENGTH;
        }
        if (field instanceof ManualArrayField) {
            ManualArrayField arrayField = (ManualArrayField)field;
            return arrayField.getLoopType() == ManualArrayField.LoopType.LENGTH;
        }
        return false;
    }

    public boolean isTerminatedArrayField(Field field) {
        if (field instanceof ArrayField) {
            ArrayField arrayField = (ArrayField)field;
            return arrayField.getLoopType() == ArrayField.LoopType.TERMINATED;
        }
        if (field instanceof ManualArrayField) {
            ManualArrayField arrayField = (ManualArrayField)field;
            return arrayField.getLoopType() == ManualArrayField.LoopType.TERMINATED;
        }
        return false;
    }

    public SwitchField getSwitchField() {
        return this.getSwitchField(this.thisType);
    }

    protected SwitchField getSwitchField(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof ComplexTypeDefinition) {
            ComplexTypeDefinition complexTypeDefinition = (ComplexTypeDefinition)typeDefinition;
            return complexTypeDefinition.getFields().stream().filter(field -> field instanceof SwitchField).findFirst().orElse(null);
        }
        return null;
    }

    public Collection<Field> getPropertyAndSwitchFields() {
        return this.getPropertyAndSwitchFields(this.thisType);
    }

    public Collection<Field> getPropertyAndSwitchFields(TypeDefinition typeDefinition) {
        if (this.thisType instanceof ComplexTypeDefinition) {
            return ((ComplexTypeDefinition)this.thisType).getFields().stream().filter(field -> field instanceof PropertyField || field instanceof SwitchField).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean isDiscriminatedParentTypeDefinition() {
        return this.isDiscriminatedParentTypeDefinition(this.thisType);
    }

    public boolean isDiscriminatedParentTypeDefinition(TypeDefinition typeDefinition) {
        return typeDefinition instanceof ComplexTypeDefinition && ((ComplexTypeDefinition)typeDefinition).isAbstract();
    }

    public boolean isDiscriminatedChildTypeDefinition() {
        return this.isDiscriminatedChildTypeDefinition(this.thisType);
    }

    public boolean isDiscriminatedChildTypeDefinition(TypeDefinition typeDefinition) {
        return typeDefinition instanceof DiscriminatedComplexTypeDefinition && !((ComplexTypeDefinition)typeDefinition).isAbstract();
    }

    public TypeDefinition getTypeDefinitionForTypeReference(TypeReference typeReference) {
        if (!(typeReference instanceof ComplexTypeReference)) {
            throw new RuntimeException("Type reference must be a complex type reference");
        }
        return this.getTypeDefinitions().get(((ComplexTypeReference)typeReference).getName());
    }

    public List<DiscriminatedComplexTypeDefinition> getSubTypeDefinitions() {
        return this.getSubTypeDefinitions(this.thisType);
    }

    public List<DiscriminatedComplexTypeDefinition> getSubTypeDefinitions(TypeDefinition type) {
        SwitchField switchField = this.getSwitchField(type);
        if (switchField != null) {
            return switchField.getCases();
        }
        return Collections.emptyList();
    }

    protected boolean isFixedValueExpression(Term term) {
        if (term instanceof VariableLiteral) {
            return false;
        }
        if (term instanceof UnaryTerm) {
            UnaryTerm unaryTerm = (UnaryTerm)term;
            return this.isFixedValueExpression(unaryTerm.getA());
        }
        if (term instanceof BinaryTerm) {
            BinaryTerm binaryTerm = (BinaryTerm)term;
            return this.isFixedValueExpression(binaryTerm.getA()) && this.isFixedValueExpression(binaryTerm.getB());
        }
        if (term instanceof TernaryTerm) {
            TernaryTerm ternaryTerm = (TernaryTerm)term;
            return this.isFixedValueExpression(ternaryTerm.getA()) && this.isFixedValueExpression(ternaryTerm.getB()) && this.isFixedValueExpression(ternaryTerm.getC());
        }
        return true;
    }

    protected int evaluateFixedValueExpression(Term term) {
        Expression expression = new ExpressionBuilder(this.toString(term)).build();
        return (int)expression.evaluate();
    }

    protected String toString(Term term) {
        if (term instanceof NullLiteral) {
            return "null";
        }
        if (term instanceof BooleanLiteral) {
            return Boolean.toString(((BooleanLiteral)term).getValue());
        }
        if (term instanceof NumericLiteral) {
            return ((NumericLiteral)term).getNumber().toString();
        }
        if (term instanceof StringLiteral) {
            return "\"" + ((StringLiteral)term).getValue() + "\"";
        }
        if (term instanceof UnaryTerm) {
            return ((UnaryTerm)term).getOperation() + this.toString(((UnaryTerm)term).getA());
        }
        if (term instanceof BinaryTerm) {
            return this.toString(((BinaryTerm)term).getA()) + ((BinaryTerm)term).getOperation() + this.toString(((BinaryTerm)term).getB());
        }
        if (term instanceof TernaryTerm) {
            return "(" + this.toString(((TernaryTerm)term).getA()) + ") ? (" + this.toString(((TernaryTerm)term).getB()) + ") : (" + this.toString(((TernaryTerm)term).getC()) + ")";
        }
        return "";
    }

    private Optional<TypeReference> getDiscriminatorType(ComplexTypeDefinition parentType, Term disciminatorExpression) {
        ComplexTypeReference complexTypeReference;
        TypeDefinition typeDefinition;
        TypeReference typeReference;
        if (!(disciminatorExpression instanceof VariableLiteral)) {
            throw new RuntimeException("Currently no arithmetic expressions are supported as discriminator expressions.");
        }
        VariableLiteral variableLiteral = (VariableLiteral)disciminatorExpression;
        Optional<TypeReference> type = this.getTypeReferenceForProperty(parentType, variableLiteral.getName());
        if (type.isPresent() && variableLiteral.getChild() != null && (typeReference = type.get()) instanceof ComplexTypeReference && (typeDefinition = this.types.get((complexTypeReference = (ComplexTypeReference)typeReference).getName())) instanceof ComplexTypeDefinition) {
            return this.getDiscriminatorType((ComplexTypeDefinition)typeDefinition, (Term)variableLiteral.getChild());
        }
        return type;
    }

    public List<String> getDiscriminatorNames() {
        TypeDefinition baseType = this.thisType;
        if (this.thisType.getParentType() != null) {
            baseType = this.thisType.getParentType();
        }
        SwitchField switchField = this.getSwitchField(baseType);
        ArrayList<String> discriminatorNames = new ArrayList<String>();
        for (Term discriminatorExpression : switchField.getDiscriminatorExpressions()) {
            discriminatorNames.add(this.getDiscriminatorName(discriminatorExpression));
        }
        return discriminatorNames;
    }

    public boolean isNonDiscriminatorField(String discriminatorName) {
        return ((ComplexTypeDefinition)this.thisType).getAllPropertyFields().stream().anyMatch(field -> !(field instanceof DiscriminatorField) && field.getName().equals(discriminatorName));
    }

    public String getDiscriminatorName(Term discriminatorExpression) {
        if (discriminatorExpression instanceof Literal) {
            Literal literal = (Literal)discriminatorExpression;
            if (literal instanceof NullLiteral) {
                return "null";
            }
            if (literal instanceof BooleanLiteral) {
                return Boolean.toString(((BooleanLiteral)literal).getValue());
            }
            if (literal instanceof NumericLiteral) {
                return ((NumericLiteral)literal).getNumber().toString();
            }
            if (literal instanceof StringLiteral) {
                return ((StringLiteral)literal).getValue();
            }
            if (literal instanceof VariableLiteral) {
                VariableLiteral variableLiteral = (VariableLiteral)literal;
                return this.getVariableLiteralName(variableLiteral);
            }
        } else {
            if (discriminatorExpression instanceof UnaryTerm) {
                UnaryTerm unaryTerm = (UnaryTerm)discriminatorExpression;
                return this.getDiscriminatorName(unaryTerm.getA());
            }
            if (discriminatorExpression instanceof BinaryTerm) {
                BinaryTerm binaryTerm = (BinaryTerm)discriminatorExpression;
                return this.getDiscriminatorName(binaryTerm.getA()) + "_" + this.getDiscriminatorName(binaryTerm.getB());
            }
            if (discriminatorExpression instanceof TernaryTerm) {
                TernaryTerm ternaryTerm = (TernaryTerm)discriminatorExpression;
                return this.getDiscriminatorName(ternaryTerm.getA()) + "_" + this.getDiscriminatorName(ternaryTerm.getB()) + "_" + this.getDiscriminatorName(ternaryTerm.getC());
            }
        }
        return "";
    }

    private String getVariableLiteralName(VariableLiteral variableLiteral) {
        String rest = "";
        if (variableLiteral.getChild() != null) {
            rest = this.getVariableLiteralName(variableLiteral.getChild());
            rest = rest.substring(0, 1).toUpperCase() + rest.substring(1);
        }
        return variableLiteral.getName() + rest;
    }

    public Map<String, TypeReference> getDiscriminatorTypes() {
        ComplexTypeDefinition parentType = this.thisType instanceof DiscriminatedComplexTypeDefinition ? (ComplexTypeDefinition)this.thisType.getParentType() : (ComplexTypeDefinition)this.thisType;
        SwitchField switchField = this.getSwitchField((TypeDefinition)parentType);
        if (switchField != null) {
            TreeMap<String, TypeReference> discriminatorTypes = new TreeMap<String, TypeReference>();
            for (Term discriminatorExpression : switchField.getDiscriminatorExpressions()) {
                String discriminatorName = this.getDiscriminatorName(discriminatorExpression);
                Optional<TypeReference> discriminatorType = this.getDiscriminatorType(parentType, discriminatorExpression);
                discriminatorTypes.put(discriminatorName, discriminatorType.orElse(null));
            }
            return discriminatorTypes;
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getDiscriminatorValues(TypeDefinition type) {
        if (type instanceof DiscriminatedComplexTypeDefinition) {
            DiscriminatedComplexTypeDefinition switchType = (DiscriminatedComplexTypeDefinition)type;
            List<String> discriminatorNames = this.getDiscriminatorNames();
            LinkedHashMap<String, String> discriminatorValues = new LinkedHashMap<String, String>();
            for (int i = 0; i < discriminatorNames.size(); ++i) {
                String discriminatorValue = i < switchType.getDiscriminatorValues().length ? switchType.getDiscriminatorValues()[i] : null;
                discriminatorValues.put(discriminatorNames.get(i), discriminatorValue);
            }
            return discriminatorValues;
        }
        return Collections.emptyMap();
    }

    public Map<String, Map<String, String>> getDiscriminatorValues() {
        ComplexTypeDefinition parentType = this.thisType instanceof DiscriminatedComplexTypeDefinition ? (ComplexTypeDefinition)this.thisType.getParentType() : (ComplexTypeDefinition)this.thisType;
        SwitchField switchField = this.getSwitchField((TypeDefinition)parentType);
        if (switchField != null) {
            LinkedHashMap<String, Map<String, String>> discriminatorTypes = new LinkedHashMap<String, Map<String, String>>();
            for (DiscriminatedComplexTypeDefinition switchCase : switchField.getCases()) {
                discriminatorTypes.put(switchCase.getName(), this.getDiscriminatorValues((TypeDefinition)switchCase));
            }
            return discriminatorTypes;
        }
        return Collections.emptyMap();
    }

    public TypeReference getArgumentType(TypeReference typeReference, int index) {
        if (typeReference instanceof ComplexTypeReference) {
            ComplexTypeReference complexTypeReference = (ComplexTypeReference)typeReference;
            if (!this.getTypeDefinitions().containsKey(complexTypeReference.getName())) {
                throw new RuntimeException("Could not find definition of complex type " + complexTypeReference.getName());
            }
            TypeDefinition complexTypeDefinition = this.getTypeDefinitions().get(complexTypeReference.getName());
            if (complexTypeDefinition.getParserArguments().length <= index) {
                throw new RuntimeException("Type " + complexTypeReference.getName() + " specifies too few parser arguments");
            }
            return complexTypeDefinition.getParserArguments()[index].getType();
        }
        throw new RuntimeException("Only complex type references supported here.");
    }

    public List<Argument> getSerializerArguments(Argument[] arguments) {
        LinkedList<Argument> serializerArguments = new LinkedList<Argument>();
        if (arguments != null) {
            for (Argument argument : arguments) {
                if (!"lastItem".equals(argument.getName())) continue;
                serializerArguments.add(argument);
            }
        }
        return serializerArguments;
    }

    public List<Term> getSerializerTerms(Term[] terms) {
        LinkedList<Term> serializerTerms = new LinkedList<Term>();
        if (terms != null) {
            for (Term term : terms) {
                if (!term.contains("lastItem")) continue;
                serializerTerms.add(term);
            }
        }
        return serializerTerms;
    }

    public boolean hasLastItemTerm(Term[] terms) {
        if (terms != null) {
            for (Term term : terms) {
                if (!term.contains("lastItem")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean discriminatorValueNeedsStringEqualityCheck(Term term) {
        if (term instanceof VariableLiteral) {
            TypedField typedField;
            Field referencedField;
            VariableLiteral variableLiteral = (VariableLiteral)term;
            if (this.getTypeDefinitions().get(variableLiteral.getName()) instanceof EnumTypeDefinition) {
                return false;
            }
            if (this.getThisTypeDefinition() instanceof ComplexTypeDefinition && (referencedField = (Field)((ComplexTypeDefinition)this.getThisTypeDefinition()).getFields().stream().filter(field -> field instanceof NamedField && ((NamedField)field).getName().equals(variableLiteral.getName())).findFirst().orElse(null)) != null && referencedField instanceof TypedField && (typedField = (TypedField)referencedField).getType() instanceof StringTypeReference) {
                return true;
            }
            if (this.getThisTypeDefinition().getParserArguments() != null) {
                for (Argument parserArgument : this.getThisTypeDefinition().getParserArguments()) {
                    if (!parserArgument.getName().equals(variableLiteral.getName()) || !(parserArgument.getType() instanceof StringTypeReference)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Collection<EnumValue> getUniqueEnumValues(EnumValue[] enumValues) {
        TreeMap<String, EnumValue> filteredEnumValues = new TreeMap<String, EnumValue>();
        for (EnumValue enumValue : enumValues) {
            if (filteredEnumValues.containsKey(enumValue.getValue())) continue;
            filteredEnumValues.put(enumValue.getValue(), enumValue);
        }
        return filteredEnumValues.values();
    }
}

