/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.simulator.simulation.watertank;

import java.util.concurrent.TimeUnit;
import org.apache.plc4x.simulator.model.Context;
import org.apache.plc4x.simulator.simulation.SimulationModule;

public class WaterTankSimulationModule
implements SimulationModule {
    private static final long MAX_WATER_LEVEL = 27648L;
    private static final long EMERGENCY_VALVE_WATER_LEVEL = 27500L;
    private static final int NUM_INPUT_VALVE_INPUT = 0;
    private static final int NUM_OUTPUT_VALVE_INPUT = 1;
    private static final int EMERGENCY_VALVE_OUTPUT = 0;
    private static final String PROP_WATER_LEVEL = "waterLevel";
    private final Context context = new Context.ContextBuilder().addDigitalInput(false).addDigitalInput(true).addDigitalOutput(false).addMemoryVariable("waterLevel", 0L).build();

    @Override
    public String getName() {
        return "Water Tank";
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void loop() {
        try {
            Long value = (Long)this.context.getMemory().get(PROP_WATER_LEVEL);
            if (this.context.getDigitalInputs().get(0).booleanValue()) {
                value = value + 10L;
                value = Math.min(27648L, value);
            }
            if (this.context.getDigitalInputs().get(1).booleanValue()) {
                value = value - 8L;
                value = Math.max(0L, value);
            }
            boolean emergencyValveOpen = value > 27500L;
            this.context.getMemory().put(PROP_WATER_LEVEL, value);
            this.context.getDigitalOutputs().set(0, emergencyValveOpen);
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

