/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.simulator.server.s7.protocol;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionRequest;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionResponse;
import org.apache.plc4x.java.s7.readwrite.COTPPacketData;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCalledTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterCallingTsap;
import org.apache.plc4x.java.s7.readwrite.COTPParameterTpduSize;
import org.apache.plc4x.java.s7.readwrite.COTPProtocolClass;
import org.apache.plc4x.java.s7.readwrite.COTPTpduSize;
import org.apache.plc4x.java.s7.readwrite.DataTransportErrorCode;
import org.apache.plc4x.java.s7.readwrite.DataTransportSize;
import org.apache.plc4x.java.s7.readwrite.S7Address;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7MessageUserData;
import org.apache.plc4x.java.s7.readwrite.S7Parameter;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7ParameterSetupCommunication;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserData;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserDataItem;
import org.apache.plc4x.java.s7.readwrite.S7ParameterUserDataItemCPUFunctions;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7Payload;
import org.apache.plc4x.java.s7.readwrite.S7PayloadReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserData;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItem;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadUserDataItemCpuFunctionReadSzlResponse;
import org.apache.plc4x.java.s7.readwrite.S7VarPayloadDataItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItem;
import org.apache.plc4x.java.s7.readwrite.S7VarRequestParameterItemAddress;
import org.apache.plc4x.java.s7.readwrite.SzlDataTreeItem;
import org.apache.plc4x.java.s7.readwrite.SzlId;
import org.apache.plc4x.java.s7.readwrite.SzlModuleTypeClass;
import org.apache.plc4x.java.s7.readwrite.SzlSublist;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.simulator.model.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7Step7ServerAdapter
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(S7Step7ServerAdapter.class);
    private Context context;
    private State state;
    private static final int localReference = 42;
    private int remoteReference = -1;
    private COTPProtocolClass protocolClass;
    private static final int localTsapId = 1;
    private int remoteTsapId = -1;
    private static final COTPTpduSize maxTpduSize = COTPTpduSize.SIZE_256;
    private COTPTpduSize tpduSize;
    private static final int maxAmqCaller = 1;
    private int amqCaller;
    private static final int maxAmqCallee = 1;
    private int amqCallee;
    private static final int maxPduLength = 240;
    private int pduLength;

    public S7Step7ServerAdapter(Context context) {
        this.context = context;
        this.state = State.INITIAL;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof TPKTPacket) {
            TPKTPacket packet = (TPKTPacket)msg;
            COTPPacket cotpPacket = packet.getPayload();
            switch (this.state) {
                case INITIAL: {
                    if (!(cotpPacket instanceof COTPPacketConnectionRequest)) {
                        LOGGER.error("Expecting COTP Connection-Request");
                        return;
                    }
                    COTPTpduSize proposedTpduSize = null;
                    COTPPacketConnectionRequest cotpConnectionRequest = (COTPPacketConnectionRequest)cotpPacket;
                    for (COTPParameter parameter : cotpConnectionRequest.getParameters()) {
                        if (parameter instanceof COTPParameterCalledTsap) continue;
                        if (parameter instanceof COTPParameterCallingTsap) {
                            COTPParameterCallingTsap callingTsapParameter = (COTPParameterCallingTsap)parameter;
                            this.remoteTsapId = callingTsapParameter.getTsapId();
                            continue;
                        }
                        if (parameter instanceof COTPParameterTpduSize) {
                            COTPParameterTpduSize tpduSizeParameter = (COTPParameterTpduSize)parameter;
                            proposedTpduSize = tpduSizeParameter.getTpduSize();
                            continue;
                        }
                        LOGGER.error(String.format("Unexpected COTP Connection-Request Parameter %s", parameter.getClass().getName()));
                        return;
                    }
                    if (proposedTpduSize == null) {
                        LOGGER.error("Missing COTP Connection-Request Parameter Tpdu Size");
                        return;
                    }
                    this.remoteReference = cotpConnectionRequest.getSourceReference();
                    this.protocolClass = cotpConnectionRequest.getProtocolClass();
                    this.tpduSize = proposedTpduSize.getSizeInBytes() > maxTpduSize.getSizeInBytes() ? maxTpduSize : proposedTpduSize;
                    ArrayList<Object> parameters = new ArrayList<Object>();
                    parameters.add(new COTPParameterCalledTsap(this.remoteTsapId, Short.valueOf((short)0)));
                    parameters.add(new COTPParameterCallingTsap(1, Short.valueOf((short)0)));
                    parameters.add(new COTPParameterTpduSize(this.tpduSize, Short.valueOf((short)0)));
                    COTPPacketConnectionResponse response = new COTPPacketConnectionResponse(parameters, null, this.remoteReference, 42, this.protocolClass, Integer.valueOf(-1));
                    ctx.writeAndFlush((Object)new TPKTPacket((COTPPacket)response));
                    this.state = State.COTP_CONNECTED;
                    break;
                }
                case COTP_CONNECTED: {
                    if (!(cotpPacket instanceof COTPPacketData)) {
                        LOGGER.error("Expecting COTP Data packet");
                        return;
                    }
                    COTPPacketData packetData = (COTPPacketData)cotpPacket;
                    short cotpTpduRef = packetData.getTpduRef();
                    S7Message payload = packetData.getPayload();
                    if (!(payload instanceof S7MessageRequest)) {
                        LOGGER.error("Expecting S7 Message Request");
                        return;
                    }
                    S7MessageRequest s7MessageRequest = (S7MessageRequest)payload;
                    int s7TpduReference = s7MessageRequest.getTpduReference();
                    S7Parameter s7Parameter = s7MessageRequest.getParameter();
                    if (!(s7Parameter instanceof S7ParameterSetupCommunication)) {
                        LOGGER.error("Expecting S7 Message Request containing a S7 Setup Communication Parameter");
                        return;
                    }
                    S7ParameterSetupCommunication s7ParameterSetupCommunication = (S7ParameterSetupCommunication)s7Parameter;
                    this.amqCaller = Math.min(s7ParameterSetupCommunication.getMaxAmqCaller(), 1);
                    this.amqCallee = Math.min(s7ParameterSetupCommunication.getMaxAmqCallee(), 1);
                    this.pduLength = Math.min(s7ParameterSetupCommunication.getPduLength(), 240);
                    S7ParameterSetupCommunication s7ParameterSetupCommunicationResponse = new S7ParameterSetupCommunication(this.amqCaller, this.amqCallee, this.pduLength);
                    S7MessageResponseData s7MessageResponse = new S7MessageResponseData(s7TpduReference, (S7Parameter)s7ParameterSetupCommunicationResponse, null, 0, 0);
                    ctx.writeAndFlush((Object)new TPKTPacket((COTPPacket)new COTPPacketData(null, (S7Message)s7MessageResponse, true, cotpTpduRef, Integer.valueOf(Integer.MAX_VALUE))));
                    this.state = State.S7_CONNECTED;
                    break;
                }
                case S7_CONNECTED: {
                    if (!(cotpPacket instanceof COTPPacketData)) {
                        LOGGER.error("Expecting COTP Data packet");
                        return;
                    }
                    COTPPacketData packetData = (COTPPacketData)cotpPacket;
                    short cotpTpduRef = packetData.getTpduRef();
                    S7Message payload = packetData.getPayload();
                    if (payload instanceof S7MessageUserData) {
                        S7MessageUserData s7MessageUserData = (S7MessageUserData)payload;
                        int s7TpduReference = s7MessageUserData.getTpduReference();
                        S7Parameter s7Parameter = s7MessageUserData.getParameter();
                        if (s7Parameter instanceof S7ParameterUserData) {
                            S7ParameterUserData userDataParameter = (S7ParameterUserData)s7Parameter;
                            for (S7ParameterUserDataItem item : userDataParameter.getItems()) {
                                if (!(item instanceof S7ParameterUserDataItemCPUFunctions)) continue;
                                S7ParameterUserDataItemCPUFunctions function = (S7ParameterUserDataItemCPUFunctions)item;
                                S7PayloadUserData userDataPayload = (S7PayloadUserData)s7MessageUserData.getPayload();
                                for (S7PayloadUserDataItem userDataPayloadItem : userDataPayload.getItems()) {
                                    if (!(userDataPayloadItem instanceof S7PayloadUserDataItemCpuFunctionReadSzlRequest)) continue;
                                    S7PayloadUserDataItemCpuFunctionReadSzlRequest readSzlRequestPayload = (S7PayloadUserDataItemCpuFunctionReadSzlRequest)userDataPayloadItem;
                                    SzlId szlId = readSzlRequestPayload.getSzlId();
                                    if (szlId.getTypeClass() == SzlModuleTypeClass.CPU && szlId.getSublistList() == SzlSublist.MODULE_IDENTIFICATION) {
                                        S7ParameterUserDataItemCPUFunctions readSzlResponseParameter = new S7ParameterUserDataItemCPUFunctions(18, 8, function.getCpuFunctionGroup(), function.getCpuSubfunction(), 1, Short.valueOf((short)0), Short.valueOf((short)0), Integer.valueOf(0));
                                        ArrayList<SzlDataTreeItem> items = new ArrayList<SzlDataTreeItem>();
                                        items.add(new SzlDataTreeItem(1, "6ES7 212-1BD30-0XB0 ".getBytes(), 8224, 1, 8224));
                                        S7PayloadUserDataItemCpuFunctionReadSzlResponse readSzlResponsePayload = new S7PayloadUserDataItemCpuFunctionReadSzlResponse(DataTransportErrorCode.OK, DataTransportSize.OCTET_STRING, szlId, readSzlRequestPayload.getSzlIndex(), items);
                                        ArrayList<S7ParameterUserDataItemCPUFunctions> responseParameterItems = new ArrayList<S7ParameterUserDataItemCPUFunctions>();
                                        responseParameterItems.add(readSzlResponseParameter);
                                        S7ParameterUserData responseParameterUserData = new S7ParameterUserData(responseParameterItems);
                                        ArrayList<S7PayloadUserDataItemCpuFunctionReadSzlResponse> responsePayloadItems = new ArrayList<S7PayloadUserDataItemCpuFunctionReadSzlResponse>();
                                        responsePayloadItems.add(readSzlResponsePayload);
                                        S7PayloadUserData responsePayloadUserData = new S7PayloadUserData(responsePayloadItems, null);
                                        S7MessageUserData s7ResponseMessage = new S7MessageUserData(s7TpduReference, (S7Parameter)responseParameterUserData, (S7Payload)responsePayloadUserData);
                                        ctx.writeAndFlush((Object)new TPKTPacket((COTPPacket)new COTPPacketData(null, (S7Message)s7ResponseMessage, true, cotpTpduRef, Integer.valueOf(Integer.MAX_VALUE))));
                                        continue;
                                    }
                                    LOGGER.error("Not able to respond to the given request Read SZL with SZL type class " + szlId.getTypeClass().name() + " and SZL sublist " + szlId.getSublistList().name());
                                }
                            }
                            break;
                        }
                        LOGGER.error("Unsupported type of S7MessageUserData parameter " + s7Parameter.getClass().getName());
                        break;
                    }
                    if (cotpPacket.getPayload() instanceof S7MessageRequest) {
                        S7MessageRequest request = (S7MessageRequest)cotpPacket.getPayload();
                        if (request.getParameter() instanceof S7ParameterReadVarRequest) {
                            S7ParameterReadVarRequest readVarRequestParameter = (S7ParameterReadVarRequest)request.getParameter();
                            List items = readVarRequestParameter.getItems();
                            ArrayList<S7VarPayloadDataItem> payloadItems = new ArrayList<S7VarPayloadDataItem>();
                            for (S7VarRequestParameterItem item : items) {
                                S7VarRequestParameterItemAddress address;
                                S7Address address1;
                                if (!(item instanceof S7VarRequestParameterItemAddress) || !((address1 = (address = (S7VarRequestParameterItemAddress)item).getAddress()) instanceof S7AddressAny)) continue;
                                S7AddressAny addressAny = (S7AddressAny)address1;
                                block5 : switch (addressAny.getArea()) {
                                    case DATA_BLOCKS: {
                                        int byteAddress;
                                        int numberOfElements;
                                        int dataBlockNumber = addressAny.getDbNumber();
                                        if (dataBlockNumber != 1) {
                                            // empty if block
                                        }
                                        if ((numberOfElements = addressAny.getNumberOfElements()) != 1) {
                                            // empty if block
                                        }
                                        if ((byteAddress = addressAny.getByteAddress()) != 0) {
                                            // empty if block
                                        }
                                        byte bitAddress = addressAny.getBitAddress();
                                        switch (addressAny.getTransportSize()) {
                                            case BOOL: {
                                                payloadItems.add(new S7VarPayloadDataItem(DataTransportErrorCode.OK, DataTransportSize.BIT, new byte[]{1}));
                                                break block5;
                                            }
                                            case INT: 
                                            case UINT: {
                                                String firstKey = this.context.getMemory().keySet().iterator().next();
                                                Object value = this.context.getMemory().get(firstKey);
                                                int shortValue = 42;
                                                byte[] data = new byte[2];
                                                data[1] = (byte)(shortValue & 0xFF);
                                                data[0] = (byte)(shortValue >> 8 & 0xFF);
                                                payloadItems.add(new S7VarPayloadDataItem(DataTransportErrorCode.OK, DataTransportSize.BYTE_WORD_DWORD, data));
                                                break block5;
                                            }
                                        }
                                        break;
                                    }
                                    case INPUTS: 
                                    case OUTPUTS: {
                                        int ioNumber = addressAny.getByteAddress() * 8 + addressAny.getBitAddress();
                                        int numElements = addressAny.getTransportSize() == TransportSize.BOOL ? addressAny.getNumberOfElements() : addressAny.getTransportSize().getSizeInBytes() * 8;
                                        BitSet bitSet = this.toBitSet(this.context.getDigitalInputs(), ioNumber, numElements);
                                        byte[] data = Arrays.copyOf(bitSet.toByteArray(), (numElements + 7) / 8);
                                        payloadItems.add(new S7VarPayloadDataItem(DataTransportErrorCode.OK, DataTransportSize.BYTE_WORD_DWORD, data));
                                        break;
                                    }
                                }
                            }
                            S7ParameterReadVarResponse readVarResponseParameter = new S7ParameterReadVarResponse((short)items.size());
                            S7PayloadReadVarResponse readVarResponsePayload = new S7PayloadReadVarResponse(payloadItems, null);
                            S7MessageResponseData response = new S7MessageResponseData(request.getTpduReference(), (S7Parameter)readVarResponseParameter, (S7Payload)readVarResponsePayload, 0, 0);
                            ctx.writeAndFlush((Object)new TPKTPacket((COTPPacket)new COTPPacketData(null, (S7Message)response, true, cotpTpduRef, Integer.valueOf(Integer.MAX_VALUE))));
                            break;
                        }
                        if (request.getParameter() instanceof S7ParameterWriteVarRequest) {
                            S7ParameterWriteVarRequest s7ParameterWriteVarRequest = (S7ParameterWriteVarRequest)request.getParameter();
                            break;
                        }
                        LOGGER.error("Unsupported type of S7MessageRequest parameter " + request.getParameter().getClass().getName());
                        break;
                    }
                    LOGGER.error("Unsupported type of message " + payload.getClass().getName());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.state));
                }
            }
        }
    }

    private BitSet toBitSet(List<Boolean> booleans, int startIndex, int numElements) {
        BitSet bitSet = new BitSet(booleans.size());
        for (int i = 0; i < Math.min(booleans.size() - startIndex, numElements); ++i) {
            bitSet.set(i, booleans.get(i + startIndex));
        }
        return bitSet;
    }

    private static enum State {
        INITIAL,
        COTP_CONNECTED,
        S7_CONNECTED;

    }
}

