/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.simulator.server.s7;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.s7.readwrite.S7Driver;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.spi.connection.GeneratedProtocolMessageCodec;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.simulator.PlcSimulatorConfig;
import org.apache.plc4x.simulator.exceptions.SimulatorException;
import org.apache.plc4x.simulator.model.Context;
import org.apache.plc4x.simulator.server.ServerModule;
import org.apache.plc4x.simulator.server.s7.protocol.S7Step7ServerAdapter;

public class S7ServerModule
implements ServerModule {
    private static final int ISO_ON_TCP_PORT = 102;
    private EventLoopGroup loopGroup;
    private EventLoopGroup workerGroup;
    private Context context;
    private PlcSimulatorConfig config;

    @Override
    public String getName() {
        return "S7-STEP7";
    }

    @Override
    public void setConfig(PlcSimulatorConfig config) {
        this.config = config;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void start() throws SimulatorException {
        if (this.loopGroup != null) {
            return;
        }
        try {
            String host;
            this.loopGroup = new NioEventLoopGroup();
            this.workerGroup = new NioEventLoopGroup();
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.loopGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel channel) {
                    ChannelPipeline pipeline = channel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new GeneratedProtocolMessageCodec(TPKTPacket.class, TPKTPacket::staticParse, ByteOrder.BIG_ENDIAN, null, (ToIntFunction)new S7Driver.ByteLengthEstimator(), (Consumer)new S7Driver.CorruptPackageCleaner())});
                    pipeline.addLast(new ChannelHandler[]{new S7Step7ServerAdapter(S7ServerModule.this.context)});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            int port = 102;
            if (this.config.getS7Port() != null) {
                port = Integer.parseInt(this.config.getS7Port());
            }
            if ((host = this.config.getHost()) != null) {
                bootstrap.bind(host, port).sync();
            } else {
                bootstrap.bind(port).sync();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SimulatorException(e);
        }
    }

    @Override
    public void stop() {
        if (this.workerGroup == null) {
            return;
        }
        this.workerGroup.shutdownGracefully();
        this.loopGroup.shutdownGracefully();
    }
}

