/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.simulator.server.cbus.protocol;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.plc4x.java.cbus.readwrite.Alpha;
import org.apache.plc4x.java.cbus.readwrite.ApplicationAddress1;
import org.apache.plc4x.java.cbus.readwrite.ApplicationAddress2;
import org.apache.plc4x.java.cbus.readwrite.ApplicationIdContainer;
import org.apache.plc4x.java.cbus.readwrite.BaudRateSelector;
import org.apache.plc4x.java.cbus.readwrite.CALCommandType;
import org.apache.plc4x.java.cbus.readwrite.CALCommandTypeContainer;
import org.apache.plc4x.java.cbus.readwrite.CALData;
import org.apache.plc4x.java.cbus.readwrite.CALDataAcknowledge;
import org.apache.plc4x.java.cbus.readwrite.CALDataGetStatus;
import org.apache.plc4x.java.cbus.readwrite.CALDataIdentify;
import org.apache.plc4x.java.cbus.readwrite.CALDataIdentifyReply;
import org.apache.plc4x.java.cbus.readwrite.CALDataRecall;
import org.apache.plc4x.java.cbus.readwrite.CALDataReset;
import org.apache.plc4x.java.cbus.readwrite.CALDataStatus;
import org.apache.plc4x.java.cbus.readwrite.CALDataStatusExtended;
import org.apache.plc4x.java.cbus.readwrite.CALDataWrite;
import org.apache.plc4x.java.cbus.readwrite.CALReply;
import org.apache.plc4x.java.cbus.readwrite.CALReplyLong;
import org.apache.plc4x.java.cbus.readwrite.CALReplyShort;
import org.apache.plc4x.java.cbus.readwrite.CBusCommand;
import org.apache.plc4x.java.cbus.readwrite.CBusCommandDeviceManagement;
import org.apache.plc4x.java.cbus.readwrite.CBusCommandPointToMultiPoint;
import org.apache.plc4x.java.cbus.readwrite.CBusCommandPointToPoint;
import org.apache.plc4x.java.cbus.readwrite.CBusCommandPointToPointToMultiPoint;
import org.apache.plc4x.java.cbus.readwrite.CBusMessage;
import org.apache.plc4x.java.cbus.readwrite.CBusMessageToClient;
import org.apache.plc4x.java.cbus.readwrite.CBusMessageToServer;
import org.apache.plc4x.java.cbus.readwrite.CBusOptions;
import org.apache.plc4x.java.cbus.readwrite.CBusPointToMultiPointCommand;
import org.apache.plc4x.java.cbus.readwrite.CBusPointToMultiPointCommandNormal;
import org.apache.plc4x.java.cbus.readwrite.CBusPointToMultiPointCommandStatus;
import org.apache.plc4x.java.cbus.readwrite.CBusPointToPointCommand;
import org.apache.plc4x.java.cbus.readwrite.CBusPointToPointCommandDirect;
import org.apache.plc4x.java.cbus.readwrite.CBusPointToPointCommandIndirect;
import org.apache.plc4x.java.cbus.readwrite.ChannelStatus;
import org.apache.plc4x.java.cbus.readwrite.Confirmation;
import org.apache.plc4x.java.cbus.readwrite.ConfirmationType;
import org.apache.plc4x.java.cbus.readwrite.EncodedReply;
import org.apache.plc4x.java.cbus.readwrite.EncodedReplyCALReply;
import org.apache.plc4x.java.cbus.readwrite.GAVState;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommand;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandCurrentSenseLevels;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandDSIStatus;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandDelays;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandExtendedDiagnosticSummary;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandFirmwareVersion;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandGAVPhysicalAddresses;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandGAVValuesCurrent;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandGAVValuesStored;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandLogicalAssignment;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandManufacturer;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandMaximumLevels;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandMinimumLevels;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandNetworkTerminalLevels;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandNetworkVoltage;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandOutputUnitSummary;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandSummary;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandTerminalLevels;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandType;
import org.apache.plc4x.java.cbus.readwrite.IdentifyReplyCommandUnitSummary;
import org.apache.plc4x.java.cbus.readwrite.InterfaceOptions1;
import org.apache.plc4x.java.cbus.readwrite.InterfaceOptions2;
import org.apache.plc4x.java.cbus.readwrite.InterfaceOptions3;
import org.apache.plc4x.java.cbus.readwrite.LevelInformationNibblePair;
import org.apache.plc4x.java.cbus.readwrite.LevelInformationNormal;
import org.apache.plc4x.java.cbus.readwrite.LightingCommandTypeContainer;
import org.apache.plc4x.java.cbus.readwrite.LightingData;
import org.apache.plc4x.java.cbus.readwrite.LightingDataOff;
import org.apache.plc4x.java.cbus.readwrite.LightingDataOn;
import org.apache.plc4x.java.cbus.readwrite.LightingDataRampToLevel;
import org.apache.plc4x.java.cbus.readwrite.LightingDataTerminateRamp;
import org.apache.plc4x.java.cbus.readwrite.LogicAssignment;
import org.apache.plc4x.java.cbus.readwrite.MonitoredSAL;
import org.apache.plc4x.java.cbus.readwrite.MonitoredSALLongFormSmartMode;
import org.apache.plc4x.java.cbus.readwrite.MonitoredSALReply;
import org.apache.plc4x.java.cbus.readwrite.MonitoredSALShortFormBasicMode;
import org.apache.plc4x.java.cbus.readwrite.ParameterValueApplicationAddress1;
import org.apache.plc4x.java.cbus.readwrite.ParameterValueApplicationAddress2;
import org.apache.plc4x.java.cbus.readwrite.ParameterValueBaudRateSelector;
import org.apache.plc4x.java.cbus.readwrite.ParameterValueInterfaceOptions1;
import org.apache.plc4x.java.cbus.readwrite.ParameterValueInterfaceOptions1PowerUpSettings;
import org.apache.plc4x.java.cbus.readwrite.ParameterValueInterfaceOptions2;
import org.apache.plc4x.java.cbus.readwrite.ParameterValueInterfaceOptions3;
import org.apache.plc4x.java.cbus.readwrite.Reply;
import org.apache.plc4x.java.cbus.readwrite.ReplyEncodedReply;
import org.apache.plc4x.java.cbus.readwrite.ReplyOrConfirmation;
import org.apache.plc4x.java.cbus.readwrite.ReplyOrConfirmationConfirmation;
import org.apache.plc4x.java.cbus.readwrite.ReplyOrConfirmationReply;
import org.apache.plc4x.java.cbus.readwrite.Request;
import org.apache.plc4x.java.cbus.readwrite.RequestCommand;
import org.apache.plc4x.java.cbus.readwrite.RequestContext;
import org.apache.plc4x.java.cbus.readwrite.RequestDirectCommandAccess;
import org.apache.plc4x.java.cbus.readwrite.RequestEmpty;
import org.apache.plc4x.java.cbus.readwrite.RequestNull;
import org.apache.plc4x.java.cbus.readwrite.RequestObsolete;
import org.apache.plc4x.java.cbus.readwrite.RequestReset;
import org.apache.plc4x.java.cbus.readwrite.RequestSmartConnectShortcut;
import org.apache.plc4x.java.cbus.readwrite.ResponseTermination;
import org.apache.plc4x.java.cbus.readwrite.SALData;
import org.apache.plc4x.java.cbus.readwrite.SALDataLighting;
import org.apache.plc4x.java.cbus.readwrite.SerialInterfaceAddress;
import org.apache.plc4x.java.cbus.readwrite.ServerErrorReply;
import org.apache.plc4x.java.cbus.readwrite.StatusByte;
import org.apache.plc4x.java.cbus.readwrite.StatusCoding;
import org.apache.plc4x.java.cbus.readwrite.StatusRequest;
import org.apache.plc4x.java.cbus.readwrite.StatusRequestBinaryState;
import org.apache.plc4x.java.cbus.readwrite.StatusRequestBinaryStateDeprecated;
import org.apache.plc4x.java.cbus.readwrite.StatusRequestLevel;
import org.apache.plc4x.java.cbus.readwrite.UnitAddress;
import org.apache.plc4x.java.cbus.readwrite.UnitStatus;
import org.apache.plc4x.simulator.model.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBusServerAdapter
extends ChannelInboundHandlerAdapter {
    private static final List<Byte> AVAILABLE_UNITS = Arrays.asList((byte)3, (byte)23, (byte)48);
    private static final Logger LOGGER = LoggerFactory.getLogger(CBusServerAdapter.class);
    private Context context;
    private static final RequestContext requestContext = new RequestContext(false);
    private static boolean connect;
    private static boolean smart;
    private static boolean idmon;
    private static boolean exstat;
    private static boolean monitor;
    private static boolean monall;
    private static boolean pun;
    private static boolean pcn;
    private static boolean srchk;
    private static byte monitorApplicationAddress1;
    private static byte monitorApplicationAddress2;
    private static CBusOptions cBusOptions;
    private final Lock outputLock = new ReentrantLock();
    private ScheduledFuture<?> salMonitorFuture;
    private ScheduledFuture<?> mmiMonitorFuture;

    public CBusServerAdapter(Context context) {
        LOGGER.info("Creating adapter with context {}", (Object)context);
        this.context = context;
        cBusOptions = new CBusOptions(connect, smart, idmon, exstat, monitor, monall, pun, pcn, srchk);
    }

    private static void buildCBusOptions() {
        LOGGER.info("Updating options {}", (Object)cBusOptions);
        cBusOptions = new CBusOptions(connect, smart, idmon, exstat, monitor, monall, pun, pcn, srchk);
        LOGGER.info("Updated options {}", (Object)cBusOptions);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.salMonitorFuture != null) {
            this.salMonitorFuture.cancel(false);
        }
        if (this.mmiMonitorFuture != null) {
            this.mmiMonitorFuture.cancel(false);
        }
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof CBusMessage)) {
            return;
        }
        try {
            this.outputLock.lock();
            this.syncChannelRead(ctx, msg);
        }
        finally {
            ctx.flush();
            this.outputLock.unlock();
        }
    }

    private void syncChannelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        CBusMessage packet;
        LOGGER.debug("Working with cBusOptions\n{}", (Object)cBusOptions);
        TimeUnit.MILLISECONDS.sleep(100L);
        if (!smart && !connect) {
            LOGGER.info("Sending echo");
            ctx.write(msg);
        }
        if ((packet = (CBusMessage)msg) instanceof CBusMessageToClient) {
            LOGGER.info("Message to client not supported\n{}", (Object)packet);
            return;
        }
        CBusMessageToServer cBusMessageToServer = (CBusMessageToServer)packet;
        Request request = cBusMessageToServer.getRequest();
        if (request instanceof RequestEmpty || request instanceof RequestNull) {
            LOGGER.debug("Ignoring\n{}", (Object)request);
        } else if (request instanceof RequestDirectCommandAccess) {
            this.handleDirectCommandAccess(ctx, (RequestDirectCommandAccess)request);
        } else if (request instanceof RequestCommand) {
            this.handleRequestCommand(ctx, (RequestCommand)request);
        } else if (request instanceof RequestObsolete) {
            RequestObsolete requestObsolete = (RequestObsolete)request;
            LOGGER.info("Handling RequestObsolete\n{}", (Object)requestObsolete);
        } else if (request instanceof RequestReset) {
            if (smart || connect) {
                LOGGER.info("Sending echo");
                ctx.write(msg);
            }
            LOGGER.info("Handling RequestReset\n{}", (Object)request);
            this.handleReset();
        } else if (request instanceof RequestSmartConnectShortcut) {
            CBusServerAdapter.handleSmartConnect((RequestSmartConnectShortcut)request);
        }
    }

    private void handleDirectCommandAccess(ChannelHandlerContext ctx, RequestDirectCommandAccess requestDirectCommandAccess) {
        CALData calData = requestDirectCommandAccess.getCalData();
        LOGGER.info("Handling RequestDirectCommandAccess\n{}", (Object)requestDirectCommandAccess);
        this.handleCalData(ctx, calData, requestDirectCommandAccess.getAlpha());
    }

    private void handleRequestCommand(ChannelHandlerContext ctx, RequestCommand requestCommand) {
        LOGGER.info("Handling RequestCommand\n{}", (Object)requestCommand);
        CBusCommand cbusCommand = requestCommand.getCbusCommand();
        LOGGER.info("Handling CBusCommand\n{}", (Object)cbusCommand);
        if (cbusCommand instanceof CBusCommandPointToPoint) {
            CBusCommandPointToPoint cBusCommandPointToPoint = (CBusCommandPointToPoint)cbusCommand;
            CBusPointToPointCommand command = cBusCommandPointToPoint.getCommand();
            UnitAddress unitAddress = null;
            if (command instanceof CBusPointToPointCommandIndirect) {
                CBusPointToPointCommandIndirect cBusPointToPointCommandIndirect = (CBusPointToPointCommandIndirect)command;
                unitAddress = cBusPointToPointCommandIndirect.getUnitAddress();
            }
            if (command instanceof CBusPointToPointCommandDirect) {
                CBusPointToPointCommandDirect cBusPointToPointCommandDirect = (CBusPointToPointCommandDirect)command;
                unitAddress = cBusPointToPointCommandDirect.getUnitAddress();
            }
            if (unitAddress == null) {
                throw new IllegalStateException("Unit address should be set at this point");
            }
            boolean knownUnit = AVAILABLE_UNITS.contains(unitAddress.getAddress());
            if (!knownUnit) {
                LOGGER.warn("{} not a known unit", (Object)unitAddress);
                ServerErrorReply replyOrConfirmation = new ServerErrorReply(0, cBusOptions, requestContext);
                CBusMessageToClient cBusMessageToClient = new CBusMessageToClient((ReplyOrConfirmation)replyOrConfirmation, requestContext, cBusOptions);
                ctx.writeAndFlush((Object)cBusMessageToClient);
                return;
            }
            CALData calData = command.getCalData();
            this.handleCalData(ctx, calData, requestCommand.getAlpha());
            return;
        }
        if (cbusCommand instanceof CBusCommandPointToMultiPoint) {
            CBusCommandPointToMultiPoint cBusCommandPointToMultiPoint = (CBusCommandPointToMultiPoint)cbusCommand;
            CBusPointToMultiPointCommand command = cBusCommandPointToMultiPoint.getCommand();
            if (command instanceof CBusPointToMultiPointCommandStatus) {
                CBusPointToMultiPointCommandStatus cBusPointToMultiPointCommandStatus = (CBusPointToMultiPointCommandStatus)command;
                StatusRequest statusRequest = cBusPointToMultiPointCommandStatus.getStatusRequest();
                if (statusRequest instanceof StatusRequestBinaryState) {
                    StatusRequestBinaryState statusRequestBinaryState = (StatusRequestBinaryState)statusRequest;
                    LOGGER.info("Handling StatusRequestBinaryState\n{}", (Object)statusRequestBinaryState);
                    this.handleStatusRequestBinary(ctx, requestCommand, statusRequestBinaryState.getApplication());
                }
                if (statusRequest instanceof StatusRequestBinaryStateDeprecated) {
                    StatusRequestBinaryStateDeprecated statusRequestBinaryStateDeprecated = (StatusRequestBinaryStateDeprecated)statusRequest;
                    LOGGER.info("Handling StatusRequestBinaryStateDeprecated\n{}", (Object)statusRequestBinaryStateDeprecated);
                    this.handleStatusRequestBinary(ctx, requestCommand, statusRequestBinaryStateDeprecated.getApplication());
                    return;
                }
                if (statusRequest instanceof StatusRequestLevel) {
                    StatusRequestLevel statusRequestLevel = (StatusRequestLevel)statusRequest;
                    CBusServerAdapter.handleStatusRequestLevel(ctx, requestCommand, statusRequestLevel);
                    return;
                }
                throw new IllegalStateException();
            }
            if (command instanceof CBusPointToMultiPointCommandNormal) {
                CBusPointToMultiPointCommandNormal cBusPointToMultiPointCommandNormal = (CBusPointToMultiPointCommandNormal)command;
                LOGGER.info("Handling CBusPointToMultiPointCommandNormal\n{}", (Object)cBusPointToMultiPointCommandNormal);
                return;
            }
            return;
        }
        if (cbusCommand instanceof CBusCommandPointToPointToMultiPoint) {
            CBusCommandPointToPointToMultiPoint cBusCommandPointToPointToMultiPoint = (CBusCommandPointToPointToMultiPoint)cbusCommand;
            LOGGER.info("Handling CBusCommandPointToPointToMultiPoint\n{}", (Object)cBusCommandPointToPointToMultiPoint);
            return;
        }
        if (cbusCommand instanceof CBusCommandDeviceManagement) {
            CBusCommandDeviceManagement cBusCommandDeviceManagement = (CBusCommandDeviceManagement)cbusCommand;
            LOGGER.info("Handling CBusCommandDeviceManagement\n{}", (Object)cBusCommandDeviceManagement);
            return;
        }
        Alpha alpha = requestCommand.getAlpha();
        if (alpha != null) {
            Confirmation confirmation = new Confirmation(alpha, null, ConfirmationType.NOT_TRANSMITTED_CORRUPTION);
            ReplyOrConfirmationConfirmation replyOrConfirmationConfirmation = new ReplyOrConfirmationConfirmation(alpha.getCharacter(), confirmation, null, cBusOptions, requestContext);
            CBusMessageToClient response = new CBusMessageToClient((ReplyOrConfirmation)replyOrConfirmationConfirmation, requestContext, cBusOptions);
            LOGGER.info("Send response\n{}", (Object)response);
            ctx.writeAndFlush((Object)response);
        }
    }

    private static void handleStatusRequestLevel(ChannelHandlerContext ctx, RequestCommand requestCommand, StatusRequestLevel statusRequestLevel) {
        StatusCoding coding = StatusCoding.LEVEL_BY_THIS_SERIAL_INTERFACE;
        byte blockStart = statusRequestLevel.getStartingGroupAddressLabel();
        List<LevelInformationNormal> levelInformations = Collections.singletonList(new LevelInformationNormal(21845, LevelInformationNibblePair.Value_F, LevelInformationNibblePair.Value_F));
        CALDataStatusExtended calData = new CALDataStatusExtended(CALCommandTypeContainer.CALCommandReply_4Bytes, null, coding, statusRequestLevel.getApplication(), (short)blockStart, null, levelInformations, requestContext);
        Object calReply = exstat ? new CALReplyLong(0, (CALData)calData, 0L, new UnitAddress(4), null, new SerialInterfaceAddress(2), Byte.valueOf((byte)0), null, cBusOptions, requestContext) : new CALReplyShort(0, (CALData)calData, cBusOptions, requestContext);
        CBusMessage response = CBusServerAdapter.createCBusMessageForReply(requestCommand.getAlpha(), (CALReply)calReply, cBusOptions);
        LOGGER.info("Send level status response\n{}", (Object)response);
        ctx.writeAndFlush((Object)response);
    }

    private void handleStatusRequestBinary(ChannelHandlerContext ctx, RequestCommand requestCommand, ApplicationIdContainer application) {
        if (application == ApplicationIdContainer.NETWORK_CONTROL) {
            LOGGER.info("Handling installation MMI Request");
            CBusServerAdapter.sendInstallationMMIResponse(ctx, requestCommand.getAlpha());
            return;
        }
        LinkedList<StatusByte> statusBytes = new LinkedList<StatusByte>();
        for (int i = 0; i < 22; ++i) {
            statusBytes.add(new StatusByte(GAVState.ON, GAVState.ERROR, GAVState.OFF, GAVState.DOES_NOT_EXIST));
        }
        LOGGER.info("Send binary status response");
        CBusServerAdapter.sendStatusBytes(ctx, "First parts {}", application, (byte)0, statusBytes, requestCommand.getAlpha(), cBusOptions);
    }

    private void handleCalData(ChannelHandlerContext ctx, CALData calData, Alpha alpha) {
        if (!(calData instanceof CALDataGetStatus)) {
            if (calData instanceof CALDataIdentify) {
                this.handleCalDataIdentify(ctx, (CALDataIdentify)calData, alpha);
            } else if (!(calData instanceof CALDataRecall)) {
                if (calData instanceof CALDataReset) {
                    CALDataReset calDataReset = (CALDataReset)calData;
                    if (smart || connect) {
                        LOGGER.info("Sending echo");
                        ctx.write((Object)calDataReset);
                    }
                    LOGGER.info("Handling CALDataReset\n{}", (Object)calDataReset);
                    this.handleReset();
                } else {
                    if (calData instanceof CALDataWrite) {
                        CALDataWrite calDataWrite = (CALDataWrite)calData;
                        Runnable acknowledger = () -> {
                            CALDataAcknowledge calDataAcknowledge = new CALDataAcknowledge(CALCommandTypeContainer.CALCommandAcknowledge, null, calDataWrite.getParamNo(), 0, requestContext);
                            CALReplyShort calReply = new CALReplyShort(0, (CALData)calDataAcknowledge, cBusOptions, requestContext);
                            EncodedReplyCALReply encodedReply = new EncodedReplyCALReply(0, (CALReply)calReply, cBusOptions, requestContext);
                            ReplyEncodedReply replyEncodedReply = new ReplyEncodedReply(0, (EncodedReply)encodedReply, null, cBusOptions, requestContext);
                            ReplyOrConfirmationReply replyOrConfirmation = new ReplyOrConfirmationReply(0, (Reply)replyEncodedReply, new ResponseTermination(), cBusOptions, requestContext);
                            if (alpha != null) {
                                replyOrConfirmation = new ReplyOrConfirmationConfirmation(0, new Confirmation(alpha, null, ConfirmationType.CONFIRMATION_SUCCESSFUL), (ReplyOrConfirmation)replyOrConfirmation, cBusOptions, requestContext);
                            }
                            CBusMessageToClient cBusMessageToClient = new CBusMessageToClient((ReplyOrConfirmation)replyOrConfirmation, requestContext, cBusOptions);
                            LOGGER.info("Sending ack\n{}", (Object)cBusMessageToClient);
                            ctx.writeAndFlush((Object)cBusMessageToClient);
                        };
                        switch (calDataWrite.getParamNo().getParameterType()) {
                            case APPLICATION_ADDRESS_1: {
                                ApplicationAddress1 applicationAddress1 = ((ParameterValueApplicationAddress1)calDataWrite.getParameterValue()).getValue();
                                monitorApplicationAddress1 = applicationAddress1.getAddress();
                                acknowledger.run();
                                return;
                            }
                            case APPLICATION_ADDRESS_2: {
                                ApplicationAddress2 applicationAddress2 = ((ParameterValueApplicationAddress2)calDataWrite.getParameterValue()).getValue();
                                monitorApplicationAddress2 = applicationAddress2.getAddress();
                                acknowledger.run();
                                return;
                            }
                            case INTERFACE_OPTIONS_1: {
                                InterfaceOptions1 interfaceOptions1 = ((ParameterValueInterfaceOptions1)calDataWrite.getParameterValue()).getValue();
                                idmon = interfaceOptions1.getIdmon();
                                monitor = interfaceOptions1.getMonitor();
                                if (monitor) {
                                    this.startMMIMonitor(ctx);
                                } else {
                                    this.stopMMIMonitor();
                                }
                                smart = interfaceOptions1.getSmart();
                                srchk = interfaceOptions1.getSrchk();
                                connect = interfaceOptions1.getConnect();
                                if (connect) {
                                    this.startSALMonitor(ctx);
                                } else {
                                    this.stopSALMonitor();
                                }
                                CBusServerAdapter.buildCBusOptions();
                                acknowledger.run();
                                return;
                            }
                            case INTERFACE_OPTIONS_2: {
                                InterfaceOptions2 interfaceOptions2 = ((ParameterValueInterfaceOptions2)calDataWrite.getParameterValue()).getValue();
                                CBusServerAdapter.buildCBusOptions();
                                acknowledger.run();
                                return;
                            }
                            case INTERFACE_OPTIONS_3: {
                                InterfaceOptions3 interfaceOptions3Value = ((ParameterValueInterfaceOptions3)calDataWrite.getParameterValue()).getValue();
                                boolean oldExstat = exstat;
                                exstat = interfaceOptions3Value.getExstat();
                                if (oldExstat != exstat) {
                                    LOGGER.info("Restarting monitors");
                                    this.stopMMIMonitor();
                                    this.startMMIMonitor(ctx);
                                    this.stopSALMonitor();
                                    this.startSALMonitor(ctx);
                                }
                                pun = interfaceOptions3Value.getPun();
                                pcn = interfaceOptions3Value.getPcn();
                                CBusServerAdapter.buildCBusOptions();
                                acknowledger.run();
                                return;
                            }
                            case BAUD_RATE_SELECTOR: {
                                BaudRateSelector baudRateSelector = ((ParameterValueBaudRateSelector)calDataWrite.getParameterValue()).getValue();
                                CBusServerAdapter.buildCBusOptions();
                                acknowledger.run();
                                return;
                            }
                            case INTERFACE_OPTIONS_1_POWER_UP_SETTINGS: {
                                InterfaceOptions1 interfaceOptions1PowerUpSettings = ((ParameterValueInterfaceOptions1PowerUpSettings)calDataWrite.getParameterValue()).getValue().getInterfaceOptions1();
                                idmon = interfaceOptions1PowerUpSettings.getIdmon();
                                monitor = interfaceOptions1PowerUpSettings.getMonitor();
                                if (monitor) {
                                    this.startMMIMonitor(ctx);
                                } else {
                                    this.stopMMIMonitor();
                                }
                                smart = interfaceOptions1PowerUpSettings.getSmart();
                                srchk = interfaceOptions1PowerUpSettings.getSrchk();
                                connect = interfaceOptions1PowerUpSettings.getConnect();
                                if (connect) {
                                    this.startSALMonitor(ctx);
                                } else {
                                    this.stopSALMonitor();
                                }
                                CBusServerAdapter.buildCBusOptions();
                                acknowledger.run();
                                return;
                            }
                            case CUSTOM_MANUFACTURER: {
                                acknowledger.run();
                                return;
                            }
                            case SERIAL_NUMBER: {
                                acknowledger.run();
                                return;
                            }
                            case CUSTOM_TYPE: {
                                acknowledger.run();
                                return;
                            }
                        }
                        throw new IllegalStateException("Unmapped type");
                    }
                    throw new IllegalStateException("Unmapped type: " + calData.getClass());
                }
            }
        }
    }

    private static CBusMessage createCBusMessageForReply(Alpha alpha, CALReply calReply, CBusOptions cBusOptions) {
        EncodedReplyCALReply encodedReply = new EncodedReplyCALReply(0, calReply, CBusServerAdapter.cBusOptions, requestContext);
        ReplyEncodedReply replyEncodedReply = new ReplyEncodedReply(-64, (EncodedReply)encodedReply, null, CBusServerAdapter.cBusOptions, requestContext);
        ReplyOrConfirmationReply replyOrConfirmation = new ReplyOrConfirmationReply(-1, (Reply)replyEncodedReply, new ResponseTermination(), CBusServerAdapter.cBusOptions, requestContext);
        if (alpha != null) {
            Confirmation confirmation = new Confirmation(alpha, null, ConfirmationType.CONFIRMATION_SUCCESSFUL);
            replyOrConfirmation = new ReplyOrConfirmationConfirmation(alpha.getCharacter(), confirmation, (ReplyOrConfirmation)replyOrConfirmation, CBusServerAdapter.cBusOptions, requestContext);
        }
        return new CBusMessageToClient((ReplyOrConfirmation)replyOrConfirmation, requestContext, cBusOptions);
    }

    private static void sendInstallationMMIResponse(ChannelHandlerContext ctx, Alpha alpha) {
        LOGGER.info("Send installation MMIs");
        CBusServerAdapter.sendMMIs(ctx, ApplicationIdContainer.NETWORK_CONTROL, alpha, cBusOptions);
    }

    private static void sendMonitoredMMIs(ChannelHandlerContext ctx) {
        LOGGER.info("Send installation MMIs");
        CBusOptions cBusOptions = new CBusOptions(connect, smart, idmon, exstat, monitor, monall, pun, pcn, false);
        CBusServerAdapter.sendMMIs(ctx, ApplicationIdContainer.LIGHTING_38, null, cBusOptions);
    }

    private static void sendMMIs(ChannelHandlerContext ctx, ApplicationIdContainer application, Alpha alpha, CBusOptions cBusOptions) {
        int i;
        int blockStart = 0;
        LinkedList<Object> unitStatusBytes = new LinkedList<StatusByte>();
        for (i = blockStart; i <= 84; i += 4) {
            LOGGER.debug("Handling units 0-88 {},{},{},{}", new Object[]{i, i + 1, i + 2, i + 3});
            CBusServerAdapter.addStatusBytesAtOffset(unitStatusBytes, i);
        }
        LOGGER.debug("Produced {}, status bytes which equates to {} status", (Object)unitStatusBytes.size(), (Object)(unitStatusBytes.size() * 4));
        CBusServerAdapter.sendStatusBytes(ctx, "Sending second part {}", application, (byte)blockStart, unitStatusBytes, alpha, cBusOptions);
        blockStart = 88;
        unitStatusBytes = new LinkedList();
        for (i = 88; i <= 172; i += 4) {
            LOGGER.debug("Handling units 88-176 {},{},{},{}", new Object[]{i, i + 1, i + 2, i + 3});
            CBusServerAdapter.addStatusBytesAtOffset(unitStatusBytes, i);
        }
        LOGGER.debug("Produced {}, status bytes which equates to {} status", (Object)unitStatusBytes.size(), (Object)(unitStatusBytes.size() * 4));
        CBusServerAdapter.sendStatusBytes(ctx, "Sending second part {}", application, (byte)blockStart, unitStatusBytes, null, cBusOptions);
        blockStart = -80;
        unitStatusBytes = new LinkedList();
        for (i = 176; i <= 252; i += 4) {
            LOGGER.debug("Handling units 176-256 {},{},{},{}", new Object[]{i, i + 1, i + 2, i + 3});
            CBusServerAdapter.addStatusBytesAtOffset(unitStatusBytes, i);
        }
        LOGGER.debug("Produced {}, status bytes which equates to {} status", (Object)unitStatusBytes.size(), (Object)(unitStatusBytes.size() * 4));
        CBusServerAdapter.sendStatusBytes(ctx, "Sending third part {}", application, (byte)blockStart, unitStatusBytes, null, cBusOptions);
    }

    private static void addStatusBytesAtOffset(List<StatusByte> unitStatusBytes, int i) {
        unitStatusBytes.add(new StatusByte(AVAILABLE_UNITS.contains((byte)(i + 3)) ? GAVState.ON : GAVState.DOES_NOT_EXIST, AVAILABLE_UNITS.contains((byte)(i + 2)) ? GAVState.ON : GAVState.DOES_NOT_EXIST, AVAILABLE_UNITS.contains((byte)(i + 1)) ? GAVState.ON : GAVState.DOES_NOT_EXIST, AVAILABLE_UNITS.contains((byte)i) ? GAVState.ON : GAVState.DOES_NOT_EXIST));
    }

    private static void sendStatusBytes(ChannelHandlerContext ctx, String logMessage, ApplicationIdContainer application, byte blockStart, List<StatusByte> unitStatusBytes, Alpha alpha, CBusOptions cBusOptions) {
        CALReplyShort calReply;
        CALDataStatus calData;
        int numberOfStatusBytes = unitStatusBytes.size();
        CALCommandTypeContainer commandTypeContainer = null;
        if (cBusOptions.getExstat()) {
            for (CALCommandTypeContainer calCommandTypeContainerElement : CALCommandTypeContainer.values()) {
                if (calCommandTypeContainerElement.getCommandType() != CALCommandType.STATUS_EXTENDED || calCommandTypeContainerElement.getNumBytes() + 3 != numberOfStatusBytes) continue;
                commandTypeContainer = calCommandTypeContainerElement;
                break;
            }
            calData = new CALDataStatusExtended(commandTypeContainer, null, StatusCoding.BINARY_BY_THIS_SERIAL_INTERFACE, application, (short)blockStart, unitStatusBytes, null, requestContext);
            int randomElementIndex = ThreadLocalRandom.current().nextInt(AVAILABLE_UNITS.size()) % AVAILABLE_UNITS.size();
            byte randomUnit = AVAILABLE_UNITS.get(randomElementIndex);
            calReply = new CALReplyLong(-122, (CALData)calData, 0L, new UnitAddress(randomUnit), null, new SerialInterfaceAddress(2), Byte.valueOf((byte)0), null, cBusOptions, requestContext);
        } else {
            for (CALCommandTypeContainer calCommandTypeContainerElement : CALCommandTypeContainer.values()) {
                if (calCommandTypeContainerElement.getCommandType() != CALCommandType.STATUS || calCommandTypeContainerElement.getNumBytes() + 3 != numberOfStatusBytes) continue;
                commandTypeContainer = calCommandTypeContainerElement;
                break;
            }
            calData = new CALDataStatus(commandTypeContainer, null, application, 0, unitStatusBytes, requestContext);
            calReply = new CALReplyShort(0, (CALData)calData, cBusOptions, requestContext);
        }
        CBusMessage response = CBusServerAdapter.createCBusMessageForReply(alpha, (CALReply)calReply, cBusOptions);
        LOGGER.debug(logMessage, (Object)response);
        ctx.writeAndFlush((Object)response);
    }

    private void handleCalDataIdentify(ChannelHandlerContext ctx, CALDataIdentify calDataIdentify, Alpha alpha) {
        IdentifyReplyCommandManufacturer identifyReplyCommand;
        short numBytes;
        switch (calDataIdentify.getAttribute()) {
            case Manufacturer: {
                numBytes = 8;
                identifyReplyCommand = new IdentifyReplyCommandManufacturer("Apache  ", Short.valueOf(numBytes));
                break;
            }
            case Type: {
                numBytes = 8;
                identifyReplyCommand = new IdentifyReplyCommandType("plc4x-si", Short.valueOf(numBytes));
                break;
            }
            case FirmwareVersion: {
                numBytes = 8;
                identifyReplyCommand = new IdentifyReplyCommandFirmwareVersion("  0.09  ", Short.valueOf(numBytes));
                break;
            }
            case Summary: {
                numBytes = 9;
                identifyReplyCommand = new IdentifyReplyCommandSummary("NOIDEA", -81, "0900", Short.valueOf(numBytes));
                break;
            }
            case ExtendedDiagnosticSummary: {
                numBytes = 12;
                identifyReplyCommand = new IdentifyReplyCommandExtendedDiagnosticSummary(ApplicationIdContainer.FREE_USAGE_01, ApplicationIdContainer.FREE_USAGE_0F, 0, 0, 4711L, 19, false, false, false, true, false, false, false, false, false, false, false, false, false, Short.valueOf(numBytes));
                break;
            }
            case NetworkTerminalLevels: {
                numBytes = 12;
                identifyReplyCommand = new IdentifyReplyCommandNetworkTerminalLevels(new byte[]{19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}, Short.valueOf(numBytes));
                break;
            }
            case TerminalLevel: {
                numBytes = 12;
                identifyReplyCommand = new IdentifyReplyCommandTerminalLevels(new byte[]{19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}, Short.valueOf(numBytes));
                break;
            }
            case NetworkVoltage: {
                numBytes = 5;
                identifyReplyCommand = new IdentifyReplyCommandNetworkVoltage("48", "7", Short.valueOf(numBytes));
                break;
            }
            case GAVValuesCurrent: {
                numBytes = 16;
                identifyReplyCommand = new IdentifyReplyCommandGAVValuesCurrent(new byte[]{19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}, Short.valueOf(numBytes));
                break;
            }
            case GAVValuesStored: {
                numBytes = 16;
                identifyReplyCommand = new IdentifyReplyCommandGAVValuesStored(new byte[]{19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}, Short.valueOf(numBytes));
                break;
            }
            case GAVPhysicalAddresses: {
                numBytes = 16;
                identifyReplyCommand = new IdentifyReplyCommandGAVPhysicalAddresses(new byte[]{19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19}, Short.valueOf(numBytes));
                break;
            }
            case LogicalAssignment: {
                numBytes = 14;
                identifyReplyCommand = new IdentifyReplyCommandLogicalAssignment(Collections.singletonList(new LogicAssignment(false, true, true, true, true, true)), Short.valueOf(numBytes));
                break;
            }
            case Delays: {
                numBytes = 15;
                identifyReplyCommand = new IdentifyReplyCommandDelays(new byte[]{3}, 19, Short.valueOf(numBytes));
                break;
            }
            case MinimumLevels: {
                numBytes = 14;
                identifyReplyCommand = new IdentifyReplyCommandMinimumLevels(new byte[]{3}, Short.valueOf(numBytes));
                break;
            }
            case MaximumLevels: {
                numBytes = 15;
                identifyReplyCommand = new IdentifyReplyCommandMaximumLevels(new byte[]{15}, Short.valueOf(numBytes));
                break;
            }
            case CurrentSenseLevels: {
                numBytes = 16;
                identifyReplyCommand = new IdentifyReplyCommandCurrentSenseLevels(new byte[]{15}, Short.valueOf(numBytes));
                break;
            }
            case OutputUnitSummary: {
                numBytes = 18;
                identifyReplyCommand = new IdentifyReplyCommandOutputUnitSummary(new IdentifyReplyCommandUnitSummary(false, false, false, false, false, false, false, false), Byte.valueOf((byte)4), Byte.valueOf((byte)4), 45, Short.valueOf(numBytes));
                break;
            }
            case DSIStatus: {
                numBytes = 18;
                identifyReplyCommand = new IdentifyReplyCommandDSIStatus(ChannelStatus.OK, ChannelStatus.OK, ChannelStatus.OK, ChannelStatus.OK, ChannelStatus.OK, ChannelStatus.OK, ChannelStatus.OK, ChannelStatus.OK, UnitStatus.OK, 52, Short.valueOf(numBytes));
                break;
            }
            default: {
                throw new IllegalStateException("unmapped type " + calDataIdentify.getAttribute());
            }
        }
        CALDataIdentifyReply calData = new CALDataIdentifyReply(this.getReplyCommandType(numBytes + 1), null, calDataIdentify.getAttribute(), (IdentifyReplyCommand)identifyReplyCommand, requestContext);
        Object calReply = exstat ? new CALReplyLong(0, (CALData)calData, 0L, new UnitAddress(0), null, new SerialInterfaceAddress(2), Byte.valueOf((byte)0), null, cBusOptions, requestContext) : new CALReplyShort(0, (CALData)calData, cBusOptions, requestContext);
        CBusMessage response = CBusServerAdapter.createCBusMessageForReply(alpha, (CALReply)calReply, cBusOptions);
        LOGGER.info("Send identify response\n{}", (Object)response);
        ctx.writeAndFlush((Object)response);
    }

    private static void handleSmartConnect(RequestSmartConnectShortcut requestSmartConnectShortcut) {
        LOGGER.info("Handling RequestSmartConnectShortcut\n{}", (Object)requestSmartConnectShortcut);
        smart = true;
        connect = true;
        CBusServerAdapter.buildCBusOptions();
    }

    private void handleReset() {
        connect = false;
        smart = false;
        idmon = false;
        exstat = false;
        monitor = false;
        monall = false;
        pun = false;
        pcn = false;
        srchk = false;
        this.stopSALMonitor();
        this.stopMMIMonitor();
    }

    private void startSALMonitor(ChannelHandlerContext ctx) {
        if (this.salMonitorFuture != null) {
            LOGGER.debug("SAL Monitor already running");
            return;
        }
        LOGGER.info("Starting monitor");
        this.salMonitorFuture = ctx.executor().scheduleAtFixedRate(() -> {
            if (monitorApplicationAddress1 != 56 && monitorApplicationAddress2 != 56 && monitorApplicationAddress1 != -1 && monitorApplicationAddress2 != -1) {
                LOGGER.debug("Filtered because monitor application address 1 {} monitor application address 1 {}", (Object)monitorApplicationAddress1, (Object)monitorApplicationAddress2);
                return;
            }
            try {
                int randomElementIndex = ThreadLocalRandom.current().nextInt(AVAILABLE_UNITS.size()) % AVAILABLE_UNITS.size();
                byte randomUnit = AVAILABLE_UNITS.get(randomElementIndex);
                this.outputLock.lock();
                SALData salData = CBusServerAdapter.createLightingData();
                Object monitoredSAL = cBusOptions.getExstat() ? new MonitoredSALLongFormSmartMode(5, 0L, new UnitAddress(randomUnit), null, ApplicationIdContainer.LIGHTING_38, Byte.valueOf((byte)0), null, salData, cBusOptions) : new MonitoredSALShortFormBasicMode(0, 0, Short.valueOf((short)0), Short.valueOf((short)0), Byte.valueOf((byte)0), ApplicationIdContainer.LIGHTING_38, salData, cBusOptions);
                MonitoredSALReply encodedReply = new MonitoredSALReply(0, (MonitoredSAL)monitoredSAL, cBusOptions, requestContext);
                ReplyEncodedReply reply = new ReplyEncodedReply(0, (EncodedReply)encodedReply, null, cBusOptions, requestContext);
                ReplyOrConfirmationReply replyOrConfirmation = new ReplyOrConfirmationReply(0, (Reply)reply, new ResponseTermination(), cBusOptions, requestContext);
                CBusMessageToClient message = new CBusMessageToClient((ReplyOrConfirmation)replyOrConfirmation, requestContext, cBusOptions);
                LOGGER.info("[SAL Monitor] Sending out\n{}", (Object)message);
                ctx.writeAndFlush((Object)message);
            }
            finally {
                this.outputLock.unlock();
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private static SALData createLightingData() {
        double random = Math.random();
        Object lightingData = random < 0.25 ? new LightingDataOn(LightingCommandTypeContainer.LightingCommandOn, -81) : (random > 0.25 && random < 0.5 ? new LightingDataOff(LightingCommandTypeContainer.LightingCommandOff, -81) : (random > 0.5 && random < 0.75 ? new LightingDataRampToLevel(LightingCommandTypeContainer.LightingCommandRampToLevel_20Second, -81, -32) : new LightingDataTerminateRamp(LightingCommandTypeContainer.LightingCommandTerminateRamp, -81)));
        return new SALDataLighting(null, (LightingData)lightingData);
    }

    private void stopSALMonitor() {
        if (this.salMonitorFuture == null) {
            return;
        }
        LOGGER.info("Stopping SAL monitor");
        this.salMonitorFuture.cancel(false);
        this.salMonitorFuture = null;
    }

    private void startMMIMonitor(ChannelHandlerContext ctx) {
        if (this.mmiMonitorFuture != null) {
            LOGGER.debug("MMI Monitor already running");
            return;
        }
        LOGGER.info("Starting MMI monitor");
        this.mmiMonitorFuture = ctx.executor().scheduleAtFixedRate(() -> {
            try {
                this.outputLock.lock();
                LOGGER.info("[MMI Monitor] Sending out infos");
                CBusServerAdapter.sendMonitoredMMIs(ctx);
            }
            finally {
                this.outputLock.unlock();
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private void stopMMIMonitor() {
        if (this.mmiMonitorFuture == null) {
            return;
        }
        LOGGER.info("Stopping monitor");
        this.mmiMonitorFuture.cancel(false);
        this.mmiMonitorFuture = null;
    }

    private CALCommandTypeContainer getReplyCommandType(int numBytes) {
        for (CALCommandTypeContainer value : CALCommandTypeContainer.values()) {
            if (value.getCommandType() != CALCommandType.REPLY || value.getNumBytes() != numBytes) continue;
            return value;
        }
        throw new IllegalArgumentException("No reply type for " + numBytes);
    }
}

