/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.simulator.server.cbus;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.cbus.CBusDriver;
import org.apache.plc4x.java.cbus.readwrite.CBusConstants;
import org.apache.plc4x.java.cbus.readwrite.CBusMessage;
import org.apache.plc4x.java.cbus.readwrite.CBusOptions;
import org.apache.plc4x.java.cbus.readwrite.RequestContext;
import org.apache.plc4x.java.spi.connection.GeneratedProtocolMessageCodec;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.simulator.PlcSimulatorConfig;
import org.apache.plc4x.simulator.exceptions.SimulatorException;
import org.apache.plc4x.simulator.model.Context;
import org.apache.plc4x.simulator.server.ServerModule;
import org.apache.plc4x.simulator.server.cbus.protocol.CBusServerAdapter;

public class CBusServerModule
implements ServerModule {
    private EventLoopGroup loopGroup;
    private EventLoopGroup workerGroup;
    private Context context;
    private PlcSimulatorConfig config;

    @Override
    public String getName() {
        return "C-BUS";
    }

    @Override
    public void setConfig(PlcSimulatorConfig config) {
        this.config = config;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void start() throws SimulatorException {
        if (this.loopGroup != null) {
            return;
        }
        try {
            String host;
            this.loopGroup = new NioEventLoopGroup();
            this.workerGroup = new NioEventLoopGroup();
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.loopGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel channel) {
                    ChannelPipeline pipeline = channel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new GeneratedProtocolMessageCodec(CBusMessage.class, CBusMessage::staticParse, ByteOrder.BIG_ENDIAN, new Object[]{false, new RequestContext(false), new CBusOptions(false, false, false, false, false, false, false, false, false)}, (ToIntFunction)new CBusDriver.ByteLengthEstimator(), (Consumer)new CBusDriver.CorruptPackageCleaner())});
                    pipeline.addLast(new ChannelHandler[]{new CBusServerAdapter(CBusServerModule.this.context)});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            int port = CBusConstants.CBUSTCPDEFAULTPORT;
            if (this.config.getS7Port() != null) {
                port = Integer.parseInt(this.config.getS7Port());
            }
            if ((host = this.config.getHost()) != null) {
                bootstrap.bind(host, port).sync();
            } else {
                bootstrap.bind(port).sync();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SimulatorException(e);
        }
    }

    @Override
    public void stop() {
        if (this.workerGroup == null) {
            return;
        }
        this.workerGroup.shutdownGracefully();
        this.loopGroup.shutdownGracefully();
    }
}

