/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.simulator.model;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.list.FixedSizeList;
import org.apache.commons.collections4.map.FixedSizeMap;

public class Context {
    private final FixedSizeMap<String, Object> memory;
    private final FixedSizeList<Boolean> digitalInputs;
    private final FixedSizeList<Long> analogInputs;
    private final FixedSizeList<Boolean> digitalOutputs;
    private final FixedSizeList<Long> analogOutputs;

    public Context(FixedSizeMap<String, Object> memory, FixedSizeList<Boolean> digitalInputs, FixedSizeList<Long> analogInputs, FixedSizeList<Boolean> digitalOutputs, FixedSizeList<Long> analogOutputs) {
        this.memory = memory;
        this.digitalInputs = digitalInputs;
        this.analogInputs = analogInputs;
        this.digitalOutputs = digitalOutputs;
        this.analogOutputs = analogOutputs;
    }

    public Map<String, Object> getMemory() {
        return this.memory;
    }

    public List<Boolean> getDigitalInputs() {
        return this.digitalInputs;
    }

    public List<Long> getAnalogInputs() {
        return this.analogInputs;
    }

    public List<Boolean> getDigitalOutputs() {
        return this.digitalOutputs;
    }

    public List<Long> getAnalogOutputs() {
        return this.analogOutputs;
    }

    public static class ContextBuilder {
        private final Map<String, Object> memory = new TreeMap<String, Object>();
        private final List<Boolean> digitalInputs = new LinkedList<Boolean>();
        private final List<Long> analogInputs = new LinkedList<Long>();
        private final List<Boolean> digitalOutputs = new LinkedList<Boolean>();
        private final List<Long> analogOutputs = new LinkedList<Long>();

        public ContextBuilder addMemoryVariable(String name, Object defaultValue) {
            this.memory.put(name, defaultValue);
            return this;
        }

        public ContextBuilder addDigitalInput(Boolean defaultValue) {
            this.digitalInputs.add(defaultValue);
            return this;
        }

        public ContextBuilder addAnalogInput(Long defaultValue) {
            this.analogInputs.add(defaultValue);
            return this;
        }

        public ContextBuilder addDigitalOutput(Boolean defaultValue) {
            this.digitalOutputs.add(defaultValue);
            return this;
        }

        public ContextBuilder addAnalogOutput(Long defaultValue) {
            this.analogOutputs.add(defaultValue);
            return this;
        }

        public Context build() {
            return new Context((FixedSizeMap<String, Object>)FixedSizeMap.fixedSizeMap(this.memory), (FixedSizeList<Boolean>)FixedSizeList.fixedSizeList(this.digitalInputs), (FixedSizeList<Long>)FixedSizeList.fixedSizeList(this.analogInputs), (FixedSizeList<Boolean>)FixedSizeList.fixedSizeList(this.digitalOutputs), (FixedSizeList<Long>)FixedSizeList.fixedSizeList(this.analogOutputs));
        }
    }
}

