/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.simulator;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.plc4x.simulator.PlcSimulatorConfig;
import org.apache.plc4x.simulator.model.Context;
import org.apache.plc4x.simulator.server.ServerModule;
import org.apache.plc4x.simulator.simulation.SimulationModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlcSimulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlcSimulator.class);
    private boolean running;
    private final Map<String, ServerModule> serverModules;
    private final SimulationModule simulationModule;

    private PlcSimulator(String simulationName, PlcSimulatorConfig config) {
        this(simulationName, config, Thread.currentThread().getContextClassLoader());
    }

    private PlcSimulator(String simulationName, PlcSimulatorConfig config, ClassLoader classLoader) {
        Context context = null;
        LOGGER.info("Initializing Simulation Modules:");
        SimulationModule foundSimulationModule = null;
        ServiceLoader<SimulationModule> simulationModuleLoader = ServiceLoader.load(SimulationModule.class, classLoader);
        for (SimulationModule curSimulationModule : simulationModuleLoader) {
            if (!curSimulationModule.getName().equals(simulationName)) continue;
            LOGGER.info("Initializing simulation module: {} ...", (Object)simulationName);
            foundSimulationModule = curSimulationModule;
            context = curSimulationModule.getContext();
            LOGGER.info("Initialized");
        }
        if (foundSimulationModule == null) {
            LOGGER.info("Couldn't find simulation module {}", (Object)simulationName);
            System.exit(1);
        }
        this.simulationModule = foundSimulationModule;
        LOGGER.info("Finished Initializing Simulation Modules\n");
        LOGGER.info("Initializing Server Modules:");
        this.serverModules = new TreeMap<String, ServerModule>();
        ServiceLoader<ServerModule> serverModuleLoader = ServiceLoader.load(ServerModule.class, classLoader);
        for (ServerModule serverModule : serverModuleLoader) {
            LOGGER.info("Initializing server module: {} ...", (Object)serverModule.getName());
            this.serverModules.put(serverModule.getName(), serverModule);
            serverModule.setContext(context);
            serverModule.setConfig(config);
            LOGGER.info("Initialized");
        }
        LOGGER.info("Finished Initializing Server Modules\n");
        this.running = true;
    }

    private void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run() {
        LOGGER.info("Starting Server Modules:");
        for (ServerModule serverModule : this.serverModules.values()) {
            LOGGER.info("Starting server module: {}...", (Object)serverModule.getName());
            try {
                serverModule.start();
                LOGGER.info("Started");
            }
            catch (Exception e) {
                LOGGER.warn("Error starting server module: {}...", (Object)serverModule.getName(), (Object)e);
            }
        }
        LOGGER.info("Finished Starting Server Modules\n");
        try {
            LOGGER.info("Starting simulations ...");
            while (this.running) {
                try {
                    this.simulationModule.loop();
                }
                catch (Exception e) {
                    LOGGER.error("Caught error while executing loop() method of {} simulation.", (Object)this.simulationModule.getName(), (Object)e);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            LOGGER.info("Simulations ended");
            for (ServerModule serverModule : this.serverModules.values()) {
                LOGGER.info("Stopping server module {} ...", (Object)serverModule.getName());
                try {
                    serverModule.stop();
                    LOGGER.info("Stopped");
                }
                catch (Exception e) {
                    LOGGER.warn("Error stopping server module {} ...", (Object)serverModule.getName());
                }
            }
        }
    }

    public static void main(String ... args) throws Exception {
        PlcSimulator simulator = new PlcSimulator("Water Tank", PlcSimulator.plcSimulatorConfigFromArgs(args));
        Runtime.getRuntime().addShutdownHook(new Thread(simulator::stop));
        simulator.run();
    }

    public static PlcSimulatorConfig plcSimulatorConfigFromArgs(String ... args) throws Exception {
        PlcSimulatorConfig config = new PlcSimulatorConfig();
        Options options = new Options();
        options.addOption("public", false, "listen on all interfaces (overrides host option)");
        options.addOption("host", true, "display current time");
        options.addOption("s7port", true, "changes the s7 port");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        config.host = cmd.getOptionValue("host", "localhost");
        if (cmd.hasOption("public")) {
            LOGGER.info("Listening on all interfaces. (omitting {})", (Object)config.host);
            config.host = null;
        }
        config.s7Port = cmd.getOptionValue("s7port");
        return config;
    }
}

