/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.util;

import java.util.BitSet;
import java.util.LinkedList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.base.connection.DefaultPlcFieldHandler;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultBooleanFieldItem;
import org.apache.plc4x.java.modbus.messages.items.DefaultModbusByteArrayFieldItem;
import org.apache.plc4x.java.modbus.model.CoilModbusField;
import org.apache.plc4x.java.modbus.model.MaskWriteRegisterModbusField;
import org.apache.plc4x.java.modbus.model.ModbusField;
import org.apache.plc4x.java.modbus.model.ReadDiscreteInputsModbusField;
import org.apache.plc4x.java.modbus.model.ReadHoldingRegistersModbusField;
import org.apache.plc4x.java.modbus.model.ReadInputRegistersModbusField;
import org.apache.plc4x.java.modbus.model.RegisterModbusField;

public class ModbusPlcFieldHandler
extends DefaultPlcFieldHandler {
    public PlcField createField(String fieldQuery) throws PlcInvalidFieldException {
        if (MaskWriteRegisterModbusField.ADDRESS_PATTERN.matcher(fieldQuery).matches()) {
            return MaskWriteRegisterModbusField.of(fieldQuery);
        }
        if (ReadDiscreteInputsModbusField.ADDRESS_PATTERN.matcher(fieldQuery).matches()) {
            return ReadDiscreteInputsModbusField.of(fieldQuery);
        }
        if (ReadHoldingRegistersModbusField.ADDRESS_PATTERN.matcher(fieldQuery).matches()) {
            return ReadHoldingRegistersModbusField.of(fieldQuery);
        }
        if (ReadInputRegistersModbusField.ADDRESS_PATTERN.matcher(fieldQuery).matches()) {
            return ReadInputRegistersModbusField.of(fieldQuery);
        }
        if (CoilModbusField.ADDRESS_PATTERN.matcher(fieldQuery).matches()) {
            return CoilModbusField.of(fieldQuery);
        }
        if (RegisterModbusField.ADDRESS_PATTERN.matcher(fieldQuery).matches()) {
            return RegisterModbusField.of(fieldQuery);
        }
        throw new PlcInvalidFieldException(fieldQuery);
    }

    public BaseDefaultFieldItem encodeBoolean(PlcField field, Object[] values) {
        ModbusField modbusField = (ModbusField)field;
        LinkedList<Boolean> booleanValues = new LinkedList<Boolean>();
        for (Object value : values) {
            BitSet bitSet;
            if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                booleanValues.add(booleanValue);
                continue;
            }
            if (value instanceof Byte) {
                Byte byteValue = (Byte)value;
                bitSet = BitSet.valueOf(new byte[]{byteValue});
                for (int i = 0; i < 8; ++i) {
                    booleanValues.add(bitSet.get(i));
                }
                continue;
            }
            if (value instanceof Short) {
                Short shortValue = (Short)value;
                bitSet = BitSet.valueOf(new long[]{shortValue.shortValue()});
                for (int i = 0; i < 16; ++i) {
                    booleanValues.add(bitSet.get(i));
                }
                continue;
            }
            if (value instanceof Integer) {
                Integer integerValue = (Integer)value;
                bitSet = BitSet.valueOf(new long[]{integerValue.intValue()});
                for (int i = 0; i < 32; ++i) {
                    booleanValues.add(bitSet.get(i));
                }
                continue;
            }
            if (value instanceof Long) {
                long longValue = (Long)value;
                BitSet bitSet2 = BitSet.valueOf(new long[]{longValue});
                for (int i = 0; i < 64; ++i) {
                    booleanValues.add(bitSet2.get(i));
                }
                continue;
            }
            throw new IllegalArgumentException("Value of type " + value.getClass().getName() + " is not assignable to " + modbusField + " fields.");
        }
        return new DefaultBooleanFieldItem(booleanValues.toArray(new Boolean[0]));
    }

    public BaseDefaultFieldItem encodeByteArray(PlcField field, Object[] values) {
        ModbusField modbusField = (ModbusField)field;
        LinkedList<byte[]> byteArrays = new LinkedList<byte[]>();
        for (Object value : values) {
            Object[] byteArray;
            if (value instanceof byte[]) {
                byteArray = (byte[])value;
                byteArrays.add(ArrayUtils.toObject((byte[])byteArray));
                continue;
            }
            if (value instanceof Byte[]) {
                byteArray = (Byte[])value;
                byteArrays.add((byte[])byteArray);
                continue;
            }
            throw new IllegalArgumentException("Value of type " + value.getClass().getName() + " is not assignable to " + modbusField + " fields.");
        }
        return new DefaultModbusByteArrayFieldItem((Byte[][])byteArrays.toArray((T[])new Byte[0][0]));
    }
}

