/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.netty;

import com.digitalpetri.modbus.ModbusPdu;
import com.digitalpetri.modbus.codec.ModbusTcpPayload;
import com.digitalpetri.modbus.requests.MaskWriteRegisterRequest;
import com.digitalpetri.modbus.requests.ReadCoilsRequest;
import com.digitalpetri.modbus.requests.ReadDiscreteInputsRequest;
import com.digitalpetri.modbus.requests.ReadHoldingRegistersRequest;
import com.digitalpetri.modbus.requests.ReadInputRegistersRequest;
import com.digitalpetri.modbus.requests.WriteMultipleCoilsRequest;
import com.digitalpetri.modbus.requests.WriteMultipleRegistersRequest;
import com.digitalpetri.modbus.requests.WriteSingleCoilRequest;
import com.digitalpetri.modbus.requests.WriteSingleRegisterRequest;
import com.digitalpetri.modbus.responses.ExceptionResponse;
import com.digitalpetri.modbus.responses.MaskWriteRegisterResponse;
import com.digitalpetri.modbus.responses.ReadCoilsResponse;
import com.digitalpetri.modbus.responses.ReadDiscreteInputsResponse;
import com.digitalpetri.modbus.responses.ReadHoldingRegistersResponse;
import com.digitalpetri.modbus.responses.ReadInputRegistersResponse;
import com.digitalpetri.modbus.responses.WriteMultipleCoilsResponse;
import com.digitalpetri.modbus.responses.WriteMultipleRegistersResponse;
import com.digitalpetri.modbus.responses.WriteSingleCoilResponse;
import com.digitalpetri.modbus.responses.WriteSingleRegisterResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.exceptions.PlcNotImplementedException;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedDataTypeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.base.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.base.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.base.messages.InternalPlcFieldRequest;
import org.apache.plc4x.java.base.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.base.messages.InternalPlcRequest;
import org.apache.plc4x.java.base.messages.InternalPlcResponse;
import org.apache.plc4x.java.base.messages.InternalPlcWriteRequest;
import org.apache.plc4x.java.base.messages.PlcRequestContainer;
import org.apache.plc4x.java.base.messages.items.DefaultBooleanFieldItem;
import org.apache.plc4x.java.modbus.messages.items.DefaultModbusByteArrayFieldItem;
import org.apache.plc4x.java.modbus.model.CoilModbusField;
import org.apache.plc4x.java.modbus.model.MaskWriteRegisterModbusField;
import org.apache.plc4x.java.modbus.model.ModbusField;
import org.apache.plc4x.java.modbus.model.ReadDiscreteInputsModbusField;
import org.apache.plc4x.java.modbus.model.ReadHoldingRegistersModbusField;
import org.apache.plc4x.java.modbus.model.ReadInputRegistersModbusField;
import org.apache.plc4x.java.modbus.model.RegisterModbusField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4XModbusProtocol
extends MessageToMessageCodec<ModbusTcpPayload, PlcRequestContainer<InternalPlcRequest, InternalPlcResponse>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Plc4XModbusProtocol.class);
    public final AtomicInteger transactionId = new AtomicInteger();
    private final ConcurrentMap<Short, PlcRequestContainer<InternalPlcRequest, InternalPlcResponse>> requestsMap = new ConcurrentHashMap<Short, PlcRequestContainer<InternalPlcRequest, InternalPlcResponse>>();
    private final short slaveId;

    public Plc4XModbusProtocol(short slaveId) {
        this.slaveId = slaveId;
    }

    protected void encode(ChannelHandlerContext ctx, PlcRequestContainer<InternalPlcRequest, InternalPlcResponse> msg, List<Object> out) throws Exception {
        LOGGER.trace("(<--OUT): {}, {}, {}", new Object[]{ctx, msg, out});
        this.transactionId.compareAndSet(32768, 0);
        InternalPlcRequest request = msg.getRequest();
        if (request instanceof PlcReadRequest) {
            this.encodeReadRequest(msg, out);
        } else if (request instanceof PlcWriteRequest) {
            this.encodeWriteRequest(msg, out);
        }
    }

    private void encodeWriteRequest(PlcRequestContainer<InternalPlcRequest, InternalPlcResponse> msg, List<Object> out) throws PlcException {
        WriteSingleCoilRequest modbusRequest;
        ModbusField field;
        InternalPlcWriteRequest request = (InternalPlcWriteRequest)msg.getRequest();
        if (request.getFieldNames().size() != 1) {
            throw new PlcNotImplementedException("Only single message supported for now");
        }
        String fieldName = (String)request.getFieldNames().iterator().next();
        int quantity = request.getNumberOfValues(fieldName);
        if (quantity != (field = (ModbusField)request.getField(fieldName)).getQuantity()) {
            LOGGER.warn("Supplied number of values [{}] don't match t the addressed quantity of [{}]", (Object)field.getQuantity(), (Object)quantity);
        }
        if (field instanceof RegisterModbusField) {
            RegisterModbusField registerModbusField = (RegisterModbusField)field;
            if (quantity > 1) {
                int requiredLength;
                byte[] bytesToWrite = this.produceRegisterValue(Arrays.asList(request.getFieldItem(fieldName).getValues()));
                if (bytesToWrite.length != (requiredLength = 2 * quantity)) {
                    throw new PlcProtocolException("Invalid register values created. Should be at least quantity * 2 = N bytes. Was " + bytesToWrite.length + ", expected " + requiredLength);
                }
                modbusRequest = new WriteMultipleRegistersRequest(registerModbusField.getAddress(), quantity, bytesToWrite);
            } else {
                byte[] register = this.produceRegisterValue(Arrays.asList(request.getFieldItem(fieldName).getValues()));
                if (register == null || register.length != 2) {
                    throw new PlcProtocolException("Invalid register values created. Should be 2 bytes. Was " + (register != null ? register.length : 0));
                }
                int intToWrite = register[0] << 8 | register[1] & 0xFF;
                modbusRequest = new WriteSingleRegisterRequest(registerModbusField.getAddress(), intToWrite);
            }
        } else if (field instanceof CoilModbusField) {
            CoilModbusField coilModbusField = (CoilModbusField)field;
            if (quantity > 1) {
                int requiredLength;
                byte[] bytesToWrite = this.produceCoilValues(Arrays.asList(request.getFieldItem(fieldName).getValues()));
                if (bytesToWrite.length != (requiredLength = (quantity >> 3) + 1)) {
                    throw new PlcProtocolException("Invalid coil values created. Should be big enough to transport N bits. Was " + bytesToWrite.length + ", expected " + requiredLength);
                }
                modbusRequest = new WriteMultipleCoilsRequest(coilModbusField.getAddress(), quantity, bytesToWrite);
            } else {
                boolean booleanToWrite = this.produceCoilValue(Arrays.asList(request.getFieldItem(fieldName).getValues()));
                modbusRequest = new WriteSingleCoilRequest(coilModbusField.getAddress(), booleanToWrite);
            }
        } else if (field instanceof MaskWriteRegisterModbusField) {
            MaskWriteRegisterModbusField maskWriteRegisterModbusField = (MaskWriteRegisterModbusField)field;
            if (quantity > 1) {
                throw new PlcProtocolException("Mask write request can only write one value");
            }
            int andMask = maskWriteRegisterModbusField.getAndMask();
            int orMask = maskWriteRegisterModbusField.getOrMask();
            modbusRequest = new MaskWriteRegisterRequest(maskWriteRegisterModbusField.getAddress(), andMask, orMask);
        } else {
            throw new PlcProtocolException("Unsupported field type " + field.getClass() + " for a write request.");
        }
        short transactionId = (short)this.transactionId.getAndIncrement();
        this.requestsMap.put(transactionId, msg);
        out.add(new ModbusTcpPayload(transactionId, this.slaveId, (ModbusPdu)modbusRequest));
    }

    private void encodeReadRequest(PlcRequestContainer<InternalPlcRequest, InternalPlcResponse> msg, List<Object> out) throws PlcException {
        ReadCoilsRequest modbusRequest;
        PlcReadRequest request = (PlcReadRequest)msg.getRequest();
        if (request.getFieldNames().size() != 1) {
            throw new PlcNotImplementedException("Only single message supported for now");
        }
        String fieldName = (String)request.getFieldNames().iterator().next();
        ModbusField field = (ModbusField)request.getField(fieldName);
        int quantity = field.getQuantity();
        if (field instanceof CoilModbusField) {
            CoilModbusField coilModbusField = (CoilModbusField)field;
            modbusRequest = new ReadCoilsRequest(coilModbusField.getAddress(), quantity);
        } else if (field instanceof RegisterModbusField) {
            RegisterModbusField registerModbusField = (RegisterModbusField)field;
            modbusRequest = new ReadHoldingRegistersRequest(registerModbusField.getAddress(), quantity);
        } else if (field instanceof ReadDiscreteInputsModbusField) {
            ReadDiscreteInputsModbusField readDiscreteInputsModbusField = (ReadDiscreteInputsModbusField)field;
            modbusRequest = new ReadDiscreteInputsRequest(readDiscreteInputsModbusField.getAddress(), quantity);
        } else if (field instanceof ReadHoldingRegistersModbusField) {
            ReadHoldingRegistersModbusField readHoldingRegistersModbusField = (ReadHoldingRegistersModbusField)field;
            modbusRequest = new ReadHoldingRegistersRequest(readHoldingRegistersModbusField.getAddress(), quantity);
        } else if (field instanceof ReadInputRegistersModbusField) {
            ReadInputRegistersModbusField readInputRegistersModbusField = (ReadInputRegistersModbusField)field;
            modbusRequest = new ReadInputRegistersRequest(readInputRegistersModbusField.getAddress(), quantity);
        } else {
            throw new PlcProtocolException("Unsupported field type " + field.getClass() + " for a read request.");
        }
        short transactionId = (short)this.transactionId.getAndIncrement();
        this.requestsMap.put(transactionId, msg);
        out.add(new ModbusTcpPayload(transactionId, this.slaveId, (ModbusPdu)modbusRequest));
    }

    protected void decode(ChannelHandlerContext ctx, ModbusTcpPayload msg, List<Object> out) throws Exception {
        LOGGER.trace("(-->IN): {}, {}, {}", new Object[]{ctx, msg, out});
        LOGGER.debug("{}: transactionId: {}, unitId: {}, modbusPdu:{}", new Object[]{msg, msg.getTransactionId(), msg.getUnitId(), msg.getModbusPdu()});
        short transactionId = msg.getTransactionId();
        PlcRequestContainer plcRequestContainer = (PlcRequestContainer)this.requestsMap.get(transactionId);
        if (plcRequestContainer == null) {
            throw new PlcProtocolException("Unrelated payload received. [transactionId: " + msg.getTransactionId() + ", unitId: " + msg.getUnitId() + ", modbusPdu: " + msg.getModbusPdu() + "]");
        }
        InternalPlcFieldRequest request = (InternalPlcFieldRequest)plcRequestContainer.getRequest();
        if (request.getFieldNames().size() != 1) {
            throw new PlcNotImplementedException("Only single message supported for now");
        }
        String fieldName = (String)request.getFieldNames().iterator().next();
        ModbusField field = (ModbusField)request.getField(fieldName);
        ModbusPdu modbusPdu = msg.getModbusPdu();
        if (modbusPdu instanceof WriteMultipleCoilsResponse) {
            WriteMultipleCoilsResponse writeMultipleCoilsResponse = (WriteMultipleCoilsResponse)modbusPdu;
            LOGGER.debug("{}: address:{}, quantity:{}", new Object[]{writeMultipleCoilsResponse, writeMultipleCoilsResponse.getAddress(), writeMultipleCoilsResponse.getQuantity()});
            HashMap<String, PlcResponseCode> responseValues = new HashMap<String, PlcResponseCode>();
            responseValues.put(fieldName, PlcResponseCode.OK);
            plcRequestContainer.getResponseFuture().complete(new DefaultPlcWriteResponse((InternalPlcWriteRequest)request, responseValues));
        } else if (modbusPdu instanceof WriteMultipleRegistersResponse) {
            WriteMultipleRegistersResponse writeMultipleRegistersResponse = (WriteMultipleRegistersResponse)modbusPdu;
            LOGGER.debug("{}: address:{}, quantity:{}", new Object[]{writeMultipleRegistersResponse, writeMultipleRegistersResponse.getAddress(), writeMultipleRegistersResponse.getQuantity()});
            HashMap<String, PlcResponseCode> responseValues = new HashMap<String, PlcResponseCode>();
            responseValues.put(fieldName, PlcResponseCode.OK);
            plcRequestContainer.getResponseFuture().complete(new DefaultPlcWriteResponse((InternalPlcWriteRequest)request, responseValues));
        } else if (modbusPdu instanceof WriteSingleCoilResponse) {
            WriteSingleCoilResponse writeSingleCoilResponse = (WriteSingleCoilResponse)modbusPdu;
            LOGGER.debug("{}: address:{}, value:{}", new Object[]{writeSingleCoilResponse, writeSingleCoilResponse.getAddress(), writeSingleCoilResponse.getValue()});
            HashMap<String, PlcResponseCode> responseValues = new HashMap<String, PlcResponseCode>();
            responseValues.put(fieldName, PlcResponseCode.OK);
            plcRequestContainer.getResponseFuture().complete(new DefaultPlcWriteResponse((InternalPlcWriteRequest)request, responseValues));
        } else if (modbusPdu instanceof WriteSingleRegisterResponse) {
            WriteSingleRegisterResponse writeSingleRegisterResponse = (WriteSingleRegisterResponse)modbusPdu;
            LOGGER.debug("{}: address:{}, value:{}", new Object[]{writeSingleRegisterResponse, writeSingleRegisterResponse.getAddress(), writeSingleRegisterResponse.getValue()});
            HashMap<String, PlcResponseCode> responseValues = new HashMap<String, PlcResponseCode>();
            responseValues.put(fieldName, PlcResponseCode.OK);
            plcRequestContainer.getResponseFuture().complete(new DefaultPlcWriteResponse((InternalPlcWriteRequest)request, responseValues));
        } else if (modbusPdu instanceof ReadCoilsResponse) {
            ReadCoilsResponse readCoilsResponse = (ReadCoilsResponse)modbusPdu;
            LOGGER.debug("{}: Nothing", (Object)readCoilsResponse);
            ByteBuf byteBuf = readCoilsResponse.getCoilStatus();
            DefaultBooleanFieldItem data = this.produceCoilValueList(byteBuf, field.getQuantity());
            HashMap<String, ImmutablePair> responseValues = new HashMap<String, ImmutablePair>();
            responseValues.put(fieldName, new ImmutablePair((Object)PlcResponseCode.OK, (Object)data));
            plcRequestContainer.getResponseFuture().complete(new DefaultPlcReadResponse((InternalPlcReadRequest)request, responseValues));
        } else if (modbusPdu instanceof ReadDiscreteInputsResponse) {
            ReadDiscreteInputsResponse readDiscreteInputsResponse = (ReadDiscreteInputsResponse)modbusPdu;
            LOGGER.debug("{}: Nothing", (Object)readDiscreteInputsResponse);
            ByteBuf byteBuf = readDiscreteInputsResponse.getInputStatus();
            DefaultBooleanFieldItem data = this.produceCoilValueList(byteBuf, field.getQuantity());
            HashMap<String, ImmutablePair> responseValues = new HashMap<String, ImmutablePair>();
            responseValues.put(fieldName, new ImmutablePair((Object)PlcResponseCode.OK, (Object)data));
            plcRequestContainer.getResponseFuture().complete(new DefaultPlcReadResponse((InternalPlcReadRequest)request, responseValues));
        } else if (modbusPdu instanceof ReadHoldingRegistersResponse) {
            ReadHoldingRegistersResponse readHoldingRegistersResponse = (ReadHoldingRegistersResponse)modbusPdu;
            LOGGER.debug("{}: Nothing", (Object)readHoldingRegistersResponse);
            ByteBuf byteBuf = readHoldingRegistersResponse.getRegisters();
            DefaultModbusByteArrayFieldItem data = this.produceRegisterValueList(byteBuf, field.getQuantity());
            HashMap<String, ImmutablePair> responseValues = new HashMap<String, ImmutablePair>();
            responseValues.put(fieldName, new ImmutablePair((Object)PlcResponseCode.OK, (Object)data));
            plcRequestContainer.getResponseFuture().complete(new DefaultPlcReadResponse((InternalPlcReadRequest)request, responseValues));
        } else if (modbusPdu instanceof ReadInputRegistersResponse) {
            ReadInputRegistersResponse readInputRegistersResponse = (ReadInputRegistersResponse)modbusPdu;
            LOGGER.debug("{}: Nothing", (Object)readInputRegistersResponse);
            ByteBuf byteBuf = readInputRegistersResponse.getRegisters();
            DefaultModbusByteArrayFieldItem data = this.produceRegisterValueList(byteBuf, field.getQuantity());
            HashMap<String, ImmutablePair> responseValues = new HashMap<String, ImmutablePair>();
            responseValues.put(fieldName, new ImmutablePair((Object)PlcResponseCode.OK, (Object)data));
            plcRequestContainer.getResponseFuture().complete(new DefaultPlcReadResponse((InternalPlcReadRequest)request, responseValues));
        } else if (modbusPdu instanceof MaskWriteRegisterResponse) {
            MaskWriteRegisterResponse maskWriteRegisterResponse = (MaskWriteRegisterResponse)modbusPdu;
            LOGGER.debug("{}: Nothing", (Object)maskWriteRegisterResponse);
            HashMap<String, PlcResponseCode> responseValues = new HashMap<String, PlcResponseCode>();
            responseValues.put(fieldName, PlcResponseCode.OK);
            plcRequestContainer.getResponseFuture().complete(new DefaultPlcWriteResponse((InternalPlcWriteRequest)request, responseValues));
        } else {
            if (modbusPdu instanceof ExceptionResponse) {
                ExceptionResponse exceptionResponse = (ExceptionResponse)modbusPdu;
                throw new PlcProtocolException("Error received " + exceptionResponse.getExceptionCode());
            }
            throw new PlcProtocolException("Unsupported messageTyp type" + modbusPdu.getClass());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.trace("(-->ERR): {}", (Object)ctx, (Object)cause);
        super.exceptionCaught(ctx, cause);
    }

    private boolean produceCoilValue(List<?> values) throws PlcProtocolException {
        if (values.size() != 1) {
            throw new PlcProtocolException("Only one value allowed");
        }
        byte multiCoil = this.produceCoilValues(values)[0];
        return multiCoil != 0;
    }

    private byte[] produceCoilValues(List<?> values) throws PlcProtocolException {
        LinkedList<Byte> coils = new LinkedList<Byte>();
        byte actualCoil = 0;
        int i = 7;
        for (Object value : values) {
            byte byteValue;
            boolean coilSet;
            if (value.getClass() == Boolean.class) {
                coilSet = (Boolean)value;
            } else if (value.getClass() == Byte.class) {
                if ((Byte)value > 1) {
                    throw new PlcProtocolException("Value to high to fit into Byte: " + value);
                }
                coilSet = (Byte)value == 1;
            } else if (value.getClass() == byte[].class) {
                byte[] bytes = (byte[])value;
                if (bytes.length != 1) {
                    throw new PlcProtocolException("Exactly one byte is allowed: " + bytes.length);
                }
                byteValue = bytes[0];
                if (byteValue > 1) {
                    throw new PlcProtocolException("Value to high to fit into Byte: " + value);
                }
                coilSet = byteValue == 1;
            } else if (value.getClass() == Byte[].class) {
                Byte[] bytes = (Byte[])value;
                if (bytes.length != 1) {
                    throw new PlcProtocolException("Exactly one byte is allowed: " + bytes.length);
                }
                byteValue = bytes[0];
                if (byteValue > 1) {
                    throw new PlcProtocolException("Value to high to fit into Byte: " + value);
                }
                coilSet = byteValue == 1;
            } else if (value.getClass() == Short.class) {
                if ((Short)value > 1) {
                    throw new PlcProtocolException("Value to high to fit into Byte: " + value);
                }
                coilSet = (Short)value == 1;
            } else if (value.getClass() == Integer.class) {
                if ((Integer)value > 1) {
                    throw new PlcProtocolException("Value to high to fit into Byte: " + value);
                }
                coilSet = (Integer)value == 1;
            } else if (value.getClass() == BigInteger.class) {
                coilSet = value.equals(BigInteger.ONE);
            } else if (value.getClass() == Float.class) {
                coilSet = value.equals(Float.valueOf(1.0f));
            } else if (value.getClass() == Double.class) {
                coilSet = value.equals(1.0);
            } else {
                throw new PlcUnsupportedDataTypeException(value.getClass());
            }
            int coilToSet = coilSet ? 1 : 0;
            actualCoil = (byte)(actualCoil & 0xFF | coilToSet << i);
            if (--i >= 0) continue;
            coils.add(actualCoil);
            actualCoil = 0;
            i = 8;
        }
        if (coils.isEmpty()) {
            return new byte[]{actualCoil};
        }
        return ArrayUtils.toPrimitive((Byte[])coils.toArray(new Byte[0]));
    }

    private byte[] produceRegisterValue(List<?> values) throws PlcProtocolException {
        ByteBuf buffer = Unpooled.buffer();
        long upperRegisterValue = 65535L;
        for (Object value : values) {
            if (value.getClass() == Boolean.class) {
                buffer.writeByte(0);
                buffer.writeByte((Boolean)value != false ? 1 : 0);
                continue;
            }
            if (value.getClass() == Byte.class) {
                buffer.writeByte(0);
                buffer.writeByte((int)((Byte)value).byteValue());
                continue;
            }
            if (value.getClass() == byte[].class) {
                byte[] bytes = (byte[])value;
                if (bytes.length != 2) {
                    throw new PlcProtocolException("Exactly two bytes are allowed: " + bytes.length);
                }
                buffer.writeBytes(bytes);
                continue;
            }
            if (value.getClass() == Byte[].class) {
                Byte[] bytes = (Byte[])value;
                if (bytes.length != 2) {
                    throw new PlcProtocolException("Exactly two bytes are allowed: " + bytes.length);
                }
                buffer.writeBytes(ArrayUtils.toPrimitive((Byte[])bytes));
                continue;
            }
            if (value.getClass() == Short.class) {
                if ((Short)value < 0) {
                    throw new PlcProtocolException("Only positive values are supported for Short: " + value);
                }
                buffer.writeShort((int)((Short)value).shortValue());
                continue;
            }
            if (value.getClass() == Integer.class) {
                if ((long)((Integer)value).intValue() > upperRegisterValue) {
                    throw new PlcProtocolException("Value to high to fit into register for Integer: " + value);
                }
                if ((Integer)value < 0) {
                    throw new PlcProtocolException("Only positive values are supported for Integer: " + value);
                }
                buffer.writeShort(((Integer)value).intValue());
                continue;
            }
            if (value.getClass() == BigInteger.class) {
                if (((BigInteger)value).compareTo(BigInteger.ZERO) < 0) {
                    throw new PlcProtocolException("Only positive values are supported for BigInteger: " + value);
                }
                if (((BigInteger)value).compareTo(BigInteger.valueOf(0xFFFFFFFFL)) > 0) {
                    throw new PlcProtocolException("Value to high to fit into register for BigInteger: " + value);
                }
                if (((BigInteger)value).compareTo(BigInteger.valueOf(upperRegisterValue)) > 0) {
                    throw new PlcProtocolException("Value to high to fit into register for BigInteger: " + value);
                }
                int maxBytes = 2;
                byte[] bigIntegerBytes = ((BigInteger)value).toByteArray();
                byte[] bytes = new byte[maxBytes];
                int lengthToCopy = Math.min(bigIntegerBytes.length, maxBytes);
                int srcPosition = Math.max(bigIntegerBytes.length - maxBytes, 0);
                int destPosition = maxBytes - lengthToCopy;
                System.arraycopy(bigIntegerBytes, srcPosition, bytes, destPosition, lengthToCopy);
                buffer.writeBytes(bytes);
                continue;
            }
            if (value.getClass() == Float.class) {
                if (((Float)value).floatValue() < 0.0f) {
                    throw new PlcProtocolException("Only positive values are supported for Float: " + value);
                }
                if (((Float)value).floatValue() > (float)upperRegisterValue) {
                    throw new PlcProtocolException("Value to high to fit into register for Float: " + value);
                }
                buffer.writeShort(Math.round(((Float)value).floatValue()));
                continue;
            }
            if (value.getClass() == Double.class) {
                if ((Double)value < 0.0) {
                    throw new PlcProtocolException("Only positive values are supported for Double: " + value);
                }
                if ((Double)value > (double)upperRegisterValue) {
                    throw new PlcProtocolException("Value to high to fit into register for Double: " + value);
                }
                buffer.writeShort((int)Math.round((Double)value));
                continue;
            }
            throw new PlcUnsupportedDataTypeException(value.getClass());
        }
        byte[] result = new byte[buffer.writerIndex()];
        buffer.readBytes(result);
        return result;
    }

    private DefaultBooleanFieldItem produceCoilValueList(ByteBuf byteBuf, int expectedQuantity) {
        byte[] bytes;
        if (byteBuf.readableBytes() < expectedQuantity / 8) {
            LOGGER.warn("Expected to read {} coils but only max of {} can be supplied", (Object)expectedQuantity, (Object)(byteBuf.readableBytes() * 8));
        }
        if ((bytes = new byte[byteBuf.readableBytes()]).length < 1) {
            return new DefaultBooleanFieldItem(new Boolean[0]);
        }
        byteBuf.readBytes(bytes);
        LinkedList<Boolean> data = new LinkedList<Boolean>();
        int bitIndex = 0;
        int coilIndex = 0;
        while (coilIndex < bytes.length && data.size() < expectedQuantity) {
            if (bitIndex > 7) {
                bitIndex = 0;
                if (++coilIndex >= bytes.length) break;
            }
            boolean coilSet = ((long)(bytes[coilIndex] & 0xFF) & 1L << bitIndex) != 0L;
            data.add(coilSet);
            ++bitIndex;
        }
        return new DefaultBooleanFieldItem(data.toArray(new Boolean[0]));
    }

    private DefaultModbusByteArrayFieldItem produceRegisterValueList(ByteBuf byteBuf, int expectedQuantity) throws PlcProtocolException {
        int readableBytes = byteBuf.readableBytes();
        if (readableBytes % 2 != 0) {
            throw new PlcProtocolException("Readables bytes should even: " + readableBytes);
        }
        LinkedList<Byte[]> data = new LinkedList<Byte[]>();
        while (byteBuf.readableBytes() > 0) {
            byte[] register = new byte[2];
            byteBuf.readBytes(register);
            data.add(ArrayUtils.toObject((byte[])register));
        }
        return new DefaultModbusByteArrayFieldItem((Byte[][])data.toArray((T[])new Byte[0][0]));
    }
}

