/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.modbus.model.ModbusField;

public class RegisterModbusField
extends ModbusField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("register:" + ModbusField.ADDRESS_PATTERN);

    protected RegisterModbusField(int address, Integer quantity) {
        super(address, quantity);
    }

    public static RegisterModbusField of(String addressString) throws PlcInvalidFieldException {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (!matcher.matches()) {
            throw new PlcInvalidFieldException(addressString, ADDRESS_PATTERN);
        }
        int address = Integer.parseInt(matcher.group("address"));
        String quantityString = matcher.group("quantity");
        Integer quantity = quantityString != null ? Integer.valueOf(quantityString) : null;
        return new RegisterModbusField(address, quantity);
    }
}

