/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.model;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.model.PlcField;

public abstract class ModbusField
implements PlcField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?<address>\\d+)(\\[(?<quantity>\\d+)])?");
    private final int address;
    private final int quantity;

    protected ModbusField(int address, Integer quantity) {
        this.address = address;
        int n = this.quantity = quantity != null ? quantity : 1;
        if (this.quantity <= 0) {
            throw new IllegalArgumentException("quantity must be greater then zero. Was " + this.quantity);
        }
    }

    public int getAddress() {
        return this.address;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusField)) {
            return false;
        }
        ModbusField that = (ModbusField)o;
        return this.address == that.address;
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        return "ModbusField{address=" + this.address + "quantity=" + this.quantity + '}';
    }
}

