/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.model;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.modbus.model.ModbusField;

public class MaskWriteRegisterModbusField
extends ModbusField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("maskwrite:" + ModbusField.ADDRESS_PATTERN + "/(?<andMask>\\d+)/(?<orMask>\\d+)");
    private final int andMask;
    private final int orMask;

    protected MaskWriteRegisterModbusField(int address, int andMask, int orMask, Integer quantity) {
        super(address, quantity);
        this.andMask = andMask;
        this.orMask = orMask;
    }

    public static MaskWriteRegisterModbusField of(String addressString) throws PlcInvalidFieldException {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (!matcher.matches()) {
            throw new PlcInvalidFieldException(addressString, ADDRESS_PATTERN);
        }
        int address = Integer.parseInt(matcher.group("address"));
        int andMask = Integer.parseInt(matcher.group("andMask"));
        int orMask = Integer.parseInt(matcher.group("orMask"));
        String quantityString = matcher.group("quantity");
        Integer quantity = quantityString != null ? Integer.valueOf(quantityString) : null;
        return new MaskWriteRegisterModbusField(address, andMask, orMask, quantity);
    }

    public int getAndMask() {
        return this.andMask;
    }

    public int getOrMask() {
        return this.orMask;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaskWriteRegisterModbusField)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MaskWriteRegisterModbusField that = (MaskWriteRegisterModbusField)o;
        return this.andMask == that.andMask && this.orMask == that.orMask;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.andMask, this.orMask);
    }

    @Override
    public String toString() {
        return "MaskWriteRegisterModbusField{andMask=" + this.andMask + ", orMask=" + this.orMask + "} " + super.toString();
    }
}

