/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.messages.items;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.base.messages.items.DefaultByteArrayFieldItem;

public class DefaultModbusByteArrayFieldItem
extends DefaultByteArrayFieldItem {
    private static final int SHORT_BYTES = 2;
    private static final int INTEGER_BYTES = 4;
    private static final int FLOAT_BYTES = 4;
    private static final int LONG_BYTES = 8;
    private static final ByteOrder DEFAULT_ENDIANNESS = ByteOrder.BIG_ENDIAN;
    private ByteOrder byteOrder = DEFAULT_ENDIANNESS;
    private Byte[] completeByteArray = (Byte[])Arrays.stream((Byte[][])this.getValues()).flatMap(Stream::of).toArray(Byte[]::new);

    public DefaultModbusByteArrayFieldItem(Byte[] ... values) {
        super(values);
    }

    public Object getObject(int index) {
        return this.getValue(index);
    }

    public boolean isValidByteArray(int index) {
        Byte[] value = (Byte[])this.getValue(index);
        return value != null;
    }

    public Byte[] getByteArray(int index) {
        return (Byte[])this.getValue(index);
    }

    public boolean isValidShort(int index) {
        return this.completeByteArray.length >= DefaultModbusByteArrayFieldItem.shortIndexToByteIndex(index) + 2;
    }

    public Short getShort(int index) {
        return this.getShort(index, this.byteOrder);
    }

    public Short getShort(int index, ByteOrder byteOrder) {
        if (!this.isValidShort(index)) {
            return null;
        }
        return ByteBuffer.wrap(ArrayUtils.toPrimitive((Byte[])this.getByteArrayFromIndex(DefaultModbusByteArrayFieldItem.shortIndexToByteIndex(index)))).order(byteOrder).getShort();
    }

    private static int shortIndexToByteIndex(int shortIndex) {
        return shortIndex * 2;
    }

    public boolean isValidInteger(int index) {
        return this.completeByteArray.length >= DefaultModbusByteArrayFieldItem.intIndexToByteIndex(index) + 4;
    }

    public Integer getInteger(int index) {
        return this.getInteger(index, this.byteOrder);
    }

    public Integer getInteger(int index, ByteOrder byteOrder) {
        if (!this.isValidInteger(index)) {
            return null;
        }
        return ByteBuffer.wrap(ArrayUtils.toPrimitive((Byte[])this.getByteArrayFromIndex(DefaultModbusByteArrayFieldItem.intIndexToByteIndex(index)))).order(byteOrder).getInt();
    }

    private static int intIndexToByteIndex(int intIndex) {
        return intIndex * 4;
    }

    public boolean isValidLong(int index) {
        return this.completeByteArray.length >= DefaultModbusByteArrayFieldItem.longIndexToByteIndex(index) + 8;
    }

    public Long getLong(int index) {
        return this.getLong(index, this.byteOrder);
    }

    public Long getLong(int index, ByteOrder byteOrder) {
        if (!this.isValidLong(index)) {
            return null;
        }
        return ByteBuffer.wrap(ArrayUtils.toPrimitive((Byte[])this.getByteArrayFromIndex(DefaultModbusByteArrayFieldItem.longIndexToByteIndex(index)))).order(byteOrder).getLong();
    }

    private static int longIndexToByteIndex(int longIndex) {
        return longIndex * 8;
    }

    public boolean isValidFloat(int index) {
        return this.completeByteArray.length >= DefaultModbusByteArrayFieldItem.floatIndexToByteIndex(index) + 4;
    }

    public Float getFloat(int index) {
        return this.getFloat(index, this.byteOrder);
    }

    public Float getFloat(int index, ByteOrder byteOrder) {
        if (!this.isValidFloat(index)) {
            return null;
        }
        return Float.valueOf(ByteBuffer.wrap(ArrayUtils.toPrimitive((Byte[])this.getByteArrayFromIndex(DefaultModbusByteArrayFieldItem.floatIndexToByteIndex(index)))).order(byteOrder).getFloat());
    }

    private static int floatIndexToByteIndex(int floatIndex) {
        return floatIndex * 4;
    }

    private Byte[] getByteArrayFromIndex(int index) {
        if (index > this.completeByteArray.length) {
            return new Byte[0];
        }
        return Arrays.copyOfRange(this.completeByteArray, index, this.completeByteArray.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultModbusByteArrayFieldItem that = (DefaultModbusByteArrayFieldItem)((Object)o);
        return Arrays.equals((Object[])this.completeByteArray, (Object[])that.completeByteArray);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode((Object[])this.completeByteArray);
        return result;
    }
}

