/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.isoontcp.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.base.PlcByteToMessageCodec;
import org.apache.plc4x.java.isoontcp.protocol.model.IsoOnTcpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsoOnTcpProtocol
extends PlcByteToMessageCodec<IsoOnTcpMessage> {
    static final byte ISO_ON_TCP_MAGIC_NUMBER = 3;
    private static final Logger logger = LoggerFactory.getLogger(IsoOnTcpProtocol.class);

    protected void encode(ChannelHandlerContext ctx, IsoOnTcpMessage in, ByteBuf out) throws Exception {
        logger.debug("ISO on TCP Message sent");
        ByteBuf userData = in.getUserData();
        int packetSize = userData.readableBytes() + 4;
        out.writeByte(3);
        out.writeByte(0);
        out.writeShort((int)((short)packetSize));
        out.writeBytes(userData);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Got Data: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
        }
        if (in.readableBytes() >= 4) {
            logger.debug("ISO on TCP Message received");
            if (in.getByte(0) != 3) {
                logger.warn("Expecting ISO on TCP magic number: {}", (Object)3);
                if (logger.isDebugEnabled()) {
                    logger.debug("Got Data: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
                }
                this.exceptionCaught(ctx, (Throwable)new PlcProtocolException(String.format("Expecting ISO on TCP magic number: %02X", (byte)3)));
                return;
            }
            short packetLength = in.getShort(2);
            if (in.readableBytes() >= packetLength) {
                in.skipBytes(4);
                ByteBuf payload = in.readBytes(packetLength - 4);
                out.add((Object)new IsoOnTcpMessage(payload));
            }
        }
    }
}

