/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.serial.connection.connection;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import io.netty.buffer.ByteBuf;
import java.net.SocketAddress;
import org.apache.plc4x.java.serial.connection.connection.SerialPollingSelector;
import org.apache.plc4x.java.serial.connection.connection.SerialSelectionKey;
import org.apache.plc4x.java.serial.connection.connection.SerialSocketAddress;

public abstract class SerialChannelHandler {
    private final SocketAddress address;

    public SerialChannelHandler(SocketAddress address) {
        this.address = address;
    }

    abstract boolean open();

    abstract String getIdentifier();

    abstract void registerSelectionKey(SerialSelectionKey var1);

    public abstract void close();

    public abstract int read(ByteBuf var1);

    public abstract int write(ByteBuf var1);

    public static class SerialPortHandler
    extends SerialChannelHandler {
        private SerialPort comPort;

        public SerialPortHandler(SocketAddress address) {
            super(address);
            this.comPort = SerialPort.getCommPort((String)((SerialSocketAddress)address).getIdentifier());
        }

        @Override
        public boolean open() {
            if (this.comPort.openPort()) {
                this.comPort.setComPortParameters(19200, 8, 1, 0);
                return true;
            }
            return false;
        }

        @Override
        public String getIdentifier() {
            return this.comPort.getDescriptivePortName();
        }

        @Override
        public void registerSelectionKey(final SerialSelectionKey selectionKey) {
            this.comPort.addDataListener(new SerialPortDataListener(){

                public int getListeningEvents() {
                    return 1;
                }

                public void serialEvent(SerialPortEvent event) {
                    ((SerialPollingSelector)selectionKey.selector()).addEvent(new SerialPollingSelector.SelectorEvent(selectionKey, 1));
                }
            });
        }

        @Override
        public void close() {
            this.comPort.closePort();
        }

        @Override
        public int read(ByteBuf buf) {
            int bytesToRead = this.comPort.bytesAvailable();
            assert (bytesToRead > 0);
            byte[] buffer = new byte[bytesToRead];
            this.comPort.readBytes(buffer, (long)bytesToRead);
            buf.writeBytes(buffer);
            return bytesToRead;
        }

        @Override
        public int write(ByteBuf buf) {
            int expectedToWrite = buf.readableBytes();
            byte[] bytes = new byte[expectedToWrite];
            buf.readBytes(bytes);
            int bytesWritten = this.comPort.writeBytes(bytes, (long)expectedToWrite);
            return bytesWritten;
        }
    }

    public static class DummyHandler
    extends SerialChannelHandler {
        public static final DummyHandler INSTANCE = new DummyHandler(null);
        private SerialSelectionKey selectionKey;

        public DummyHandler(SocketAddress address) {
            super(address);
        }

        @Override
        public boolean open() {
            return true;
        }

        @Override
        public String getIdentifier() {
            return null;
        }

        @Override
        public void registerSelectionKey(SerialSelectionKey selectionKey) {
            this.selectionKey = selectionKey;
        }

        @Override
        public void close() {
        }

        @Override
        public int read(ByteBuf buf) {
            buf.writeByte(1);
            return 1;
        }

        @Override
        public int write(ByteBuf buf) {
            System.out.println("Haha i wrote something");
            return 1;
        }

        public void fireEvent(int readyOp) {
            ((SerialPollingSelector)this.selectionKey.selector()).addEvent(new SerialPollingSelector.SelectorEvent(this.selectionKey, readyOp));
        }
    }
}

