/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.serial.connection.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.base.connection.ChannelFactory;
import org.apache.plc4x.java.serial.connection.connection.SerialChannel;
import org.apache.plc4x.java.serial.connection.connection.SerialSelectorProvider;
import org.apache.plc4x.java.serial.connection.connection.SerialSocketAddress;

public class SerialChannelFactory
implements ChannelFactory {
    private final String serialPort;

    public SerialChannelFactory(String serialPort) {
        this.serialPort = serialPort;
    }

    public Channel createChannel(ChannelHandler channelHandler) throws PlcConnectionException {
        SerialSocketAddress address = new SerialSocketAddress(this.serialPort);
        try {
            Bootstrap bootstrap = new Bootstrap();
            final NioEventLoopGroup eventLoop = new NioEventLoopGroup(0, (Executor)null, (SelectorProvider)new SerialSelectorProvider());
            bootstrap.group((EventLoopGroup)eventLoop);
            bootstrap.channel(SerialChannel.class);
            bootstrap.handler(channelHandler);
            ChannelFuture f = bootstrap.connect((SocketAddress)address);
            f.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                    if (future.isSuccess()) {
                        System.out.println("Connection sucesfull!");
                    } else {
                        System.out.println("Connection not sucessfull: " + future.cause().getMessage());
                        eventLoop.shutdownGracefully();
                    }
                }
            });
            f.sync();
            f.awaitUninterruptibly();
            return f.channel();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlcConnectionException("Error creating channel.", (Throwable)e);
        }
    }

    public void ping() {
    }

    public String getSerialPort() {
        return this.serialPort;
    }
}

