/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.serial.connection.connection;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.nio.AbstractNioByteChannel;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.socket.DuplexChannel;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.serial.connection.connection.SerialChannelHandler;
import org.apache.plc4x.java.serial.connection.connection.SerialPollingSelector;
import org.apache.plc4x.java.serial.connection.connection.SerialSelectionKey;
import org.apache.plc4x.java.serial.connection.connection.SerialSelectorProvider;
import org.apache.plc4x.java.serial.connection.connection.SerialSocketAddress;
import org.apache.plc4x.java.serial.connection.connection.SerialSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialChannel
extends AbstractNioByteChannel
implements DuplexChannel {
    private static final Logger logger = LoggerFactory.getLogger(SerialChannel.class);
    private final ChannelConfig config;
    private final VoidChannelPromise unsafeVoidPromise = new VoidChannelPromise((Channel)this, false);
    private boolean readPending = false;
    private SocketAddress remoteAddress;
    private boolean active = false;
    private SerialSelectionKey selectionKey;
    private SerialChannelHandler comPort;
    private final DefaultChannelPipeline pipeline;

    public SerialChannel() {
        this(null, new SerialSocketChannel(new SerialSelectorProvider()));
        ((SerialSocketChannel)this.javaChannel()).setChild(this);
    }

    protected SerialChannel(Channel parent, SelectableChannel ch) {
        super(parent, ch);
        this.config = new DefaultChannelConfig((Channel)this);
        this.pipeline = this.newChannelPipeline();
    }

    public AbstractNioChannel.NioUnsafe unsafe() {
        return new SerialNioUnsafe();
    }

    public boolean isInputShutdown() {
        throw new NotImplementedException("");
    }

    public ChannelFuture shutdownInput() {
        throw new NotImplementedException("");
    }

    public ChannelFuture shutdownInput(ChannelPromise promise) {
        throw new NotImplementedException("");
    }

    public boolean isOutputShutdown() {
        throw new NotImplementedException("");
    }

    public ChannelFuture shutdownOutput() {
        throw new NotImplementedException("");
    }

    public ChannelFuture shutdownOutput(ChannelPromise promise) {
        throw new NotImplementedException("");
    }

    public boolean isShutdown() {
        throw new NotImplementedException("");
    }

    public ChannelFuture shutdown() {
        throw new NotImplementedException("");
    }

    public ChannelFuture shutdown(ChannelPromise promise) {
        throw new NotImplementedException("");
    }

    protected long doWriteFileRegion(FileRegion region) throws Exception {
        throw new NotImplementedException("");
    }

    protected int doReadBytes(ByteBuf buf) throws Exception {
        if (!this.active) {
            return 0;
        }
        logger.debug("Trying to read bytes from wire...");
        int bytesRead = this.comPort.read(buf);
        logger.debug("Read {} bytes from the wire", (Object)bytesRead);
        return bytesRead;
    }

    protected int doWriteBytes(ByteBuf buf) throws Exception {
        if (!this.active) {
            return 0;
        }
        logger.debug("Trying to write bytes to wire...");
        int bytesWritten = this.comPort.write(buf);
        logger.debug("Wrote {} bytes to wire!", (Object)bytesWritten);
        return bytesWritten;
    }

    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        this.remoteAddress = remoteAddress;
        if (!(remoteAddress instanceof SerialSocketAddress)) {
            throw new IllegalArgumentException("Socket Address has to be of type " + SerialSocketAddress.class);
        }
        logger.debug("Connecting to Socket Address '{}'", (Object)((SerialSocketAddress)remoteAddress).getIdentifier());
        try {
            this.comPort = ((SerialSocketAddress)remoteAddress).getIdentifier().startsWith("TEST") ? SerialChannelHandler.DummyHandler.INSTANCE : new SerialChannelHandler.SerialPortHandler(remoteAddress);
            logger.debug("Using Com Port {}, trying to open port", (Object)this.comPort.getIdentifier());
            if (this.comPort.open()) {
                logger.debug("Opened port successful to {}", (Object)this.comPort.getIdentifier());
                this.comPort.registerSelectionKey(this.selectionKey);
                this.active = true;
                return true;
            }
            logger.debug("Unable to open port {}", (Object)this.comPort.getIdentifier());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.active = false;
            return false;
        }
    }

    protected void doClose() throws Exception {
        if (this.comPort != null) {
            this.comPort.close();
        }
    }

    protected void doFinishConnect() throws Exception {
        throw new NotImplementedException("");
    }

    protected SocketAddress localAddress0() {
        return null;
    }

    protected SocketAddress remoteAddress0() {
        return null;
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        throw new NotImplementedException("");
    }

    protected void doDisconnect() throws Exception {
        throw new NotImplementedException("");
    }

    public ChannelConfig config() {
        return this.config;
    }

    public boolean isActive() {
        return this.active;
    }

    private class SerialNioUnsafe
    implements AbstractNioChannel.NioUnsafe {
        private boolean inFlush0;
        private Throwable initialCloseCause;
        private volatile ChannelOutboundBuffer outboundBuffer;
        private RecvByteBufAllocator.Handle recvHandle;

        public SerialNioUnsafe() {
            try {
                Constructor ctor = ChannelOutboundBuffer.class.getDeclaredConstructor(AbstractChannel.class);
                ctor.setAccessible(true);
                this.outboundBuffer = (ChannelOutboundBuffer)ctor.newInstance(new Object[]{SerialChannel.this});
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.warn("Problem with reflection", (Throwable)e);
                throw new RuntimeException("Problem providing Buffer", e);
            }
        }

        public SelectableChannel ch() {
            throw new NotImplementedException("");
        }

        public void finishConnect() {
            throw new NotImplementedException("");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read() {
            logger.debug("Reading...");
            ChannelConfig config = SerialChannel.this.config();
            ChannelPipeline pipeline = SerialChannel.this.pipeline();
            ByteBufAllocator allocator = config.getAllocator();
            RecvByteBufAllocator.Handle allocHandle = this.recvBufAllocHandle();
            allocHandle.reset(config);
            ByteBuf byteBuf = null;
            boolean close = false;
            try {
                do {
                    byteBuf = allocHandle.allocate(allocator);
                    allocHandle.lastBytesRead(SerialChannel.this.doReadBytes(byteBuf));
                    if (allocHandle.lastBytesRead() <= 0) {
                        byteBuf.release();
                        byteBuf = null;
                        boolean bl = close = allocHandle.lastBytesRead() < 0;
                        if (!close) break;
                        SerialChannel.this.readPending = false;
                        break;
                    }
                    allocHandle.incMessagesRead(1);
                    SerialChannel.this.readPending = false;
                    pipeline.fireChannelRead((Object)byteBuf);
                    byteBuf = null;
                } while (allocHandle.continueReading());
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                if (close) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                if (SerialChannel.this.readPending || !config.isAutoRead()) {
                    // empty if block
                }
            }
        }

        public void forceFlush() {
            throw new NotImplementedException("");
        }

        public RecvByteBufAllocator.Handle recvBufAllocHandle() {
            if (this.recvHandle == null) {
                this.recvHandle = SerialChannel.this.config().getRecvByteBufAllocator().newHandle();
            }
            return this.recvHandle;
        }

        public SocketAddress localAddress() {
            throw new NotImplementedException("");
        }

        public SocketAddress remoteAddress() {
            return null;
        }

        public void register(EventLoop eventLoop, ChannelPromise promise) {
            if (!(eventLoop instanceof NioEventLoop)) {
                throw new IllegalArgumentException("Only valid for NioEventLoop!");
            }
            if (!(promise.channel() instanceof SerialChannel)) {
                throw new IllegalArgumentException("Only valid for " + SerialChannel.class + " but is " + promise.channel().getClass());
            }
            try {
                Method method = NioEventLoop.class.getDeclaredMethod("unwrappedSelector", new Class[0]);
                method.setAccessible(true);
                SerialPollingSelector selector = (SerialPollingSelector)method.invoke((Object)eventLoop, new Object[0]);
                SerialChannel.this.selectionKey = (SerialSelectionKey)((SerialChannel)promise.channel()).javaChannel().register(selector, 0, (Object)SerialChannel.this);
                Field selectionKeyField = AbstractNioChannel.class.getDeclaredField("selectionKey");
                selectionKeyField.setAccessible(true);
                selectionKeyField.set((Object)SerialChannel.this, SerialChannel.this.selectionKey);
                Field loop = AbstractChannel.class.getDeclaredField("eventLoop");
                loop.setAccessible(true);
                loop.set((Object)SerialChannel.this, eventLoop);
                if (!(SerialChannel.this.pipeline() instanceof DefaultChannelPipeline)) {
                    throw new IllegalStateException("Pipeline should be of Type " + DefaultChannelPipeline.class);
                }
                SerialChannel.this.eventLoop().execute(() -> {
                    try {
                        Method invokeHandlerAddedIfNeeded = DefaultChannelPipeline.class.getDeclaredMethod("invokeHandlerAddedIfNeeded", new Class[0]);
                        invokeHandlerAddedIfNeeded.setAccessible(true);
                        invokeHandlerAddedIfNeeded.invoke((Object)SerialChannel.this.pipeline(), new Object[0]);
                        SerialChannel.this.pipeline().fireChannelRegistered();
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                });
                promise.setSuccess();
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException | ClosedChannelException e) {
                e.printStackTrace();
                throw new NotImplementedException("Should register channel to event loop!!!");
            }
        }

        public void bind(SocketAddress localAddress, ChannelPromise promise) {
            throw new NotImplementedException("");
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            SerialChannel.this.remoteAddress = remoteAddress;
            SerialChannel.this.eventLoop().execute(() -> {
                try {
                    boolean sucess = SerialChannel.this.doConnect(remoteAddress, localAddress);
                    if (sucess) {
                        SerialChannel.this.pipeline().fireChannelActive();
                        promise.setSuccess();
                    } else {
                        promise.setFailure((Throwable)new RuntimeException("Unable to open the com port '" + ((SerialSocketAddress)remoteAddress).getIdentifier() + "'"));
                    }
                }
                catch (Exception e) {
                    promise.setFailure((Throwable)e);
                }
            });
        }

        public void disconnect(ChannelPromise promise) {
            throw new NotImplementedException("");
        }

        public void close(ChannelPromise promise) {
            logger.debug("Closing the Serial Port '{}'", (Object)((SerialSocketAddress)SerialChannel.this.remoteAddress).getIdentifier());
            SerialChannel.this.eventLoop().execute(() -> {
                try {
                    SerialChannel.this.doClose();
                    promise.setSuccess();
                }
                catch (Exception e) {
                    logger.warn("Unable to close the connection", (Throwable)e);
                    promise.setFailure((Throwable)e);
                }
            });
        }

        public void closeForcibly() {
            throw new NotImplementedException("");
        }

        public void deregister(ChannelPromise promise) {
            throw new NotImplementedException("");
        }

        public final void beginRead() {
            assert (SerialChannel.this.eventLoop().inEventLoop());
            if (!SerialChannel.this.isActive()) {
                return;
            }
            try {
                SerialChannel.this.doBeginRead();
            }
            catch (Exception e) {
                this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SerialChannel.this.pipeline().fireExceptionCaught((Throwable)e);
                    }
                });
                this.close(this.voidPromise());
            }
        }

        private void invokeLater(Runnable task) {
            try {
                SerialChannel.this.eventLoop().execute(task);
            }
            catch (RejectedExecutionException e) {
                logger.warn("Can't invoke task later as EventLoop rejected it", (Throwable)e);
            }
        }

        public void write(Object msg, ChannelPromise promise) {
            int size;
            assert (SerialChannel.this.eventLoop().inEventLoop());
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer == null) {
                this.close(this.voidPromise());
                ReferenceCountUtil.release((Object)msg);
                throw new RuntimeException("Unable to write", this.initialCloseCause);
            }
            try {
                msg = SerialChannel.this.filterOutboundMessage(msg);
                Method estimatorHandle = DefaultChannelPipeline.class.getDeclaredMethod("estimatorHandle", new Class[0]);
                estimatorHandle.setAccessible(true);
                MessageSizeEstimator.Handle handle = (MessageSizeEstimator.Handle)estimatorHandle.invoke((Object)SerialChannel.this.pipeline, new Object[0]);
                size = handle.size(msg);
                if (size < 0) {
                    size = 0;
                }
            }
            catch (Throwable t) {
                this.close(this.voidPromise());
                ReferenceCountUtil.release((Object)msg);
                logger.error("Problem during write", t);
                throw new RuntimeException("Problem during write", t);
            }
            outboundBuffer.addMessage(msg, size, promise);
        }

        public final void flush() {
            assert (SerialChannel.this.eventLoop().inEventLoop());
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer == null) {
                return;
            }
            outboundBuffer.addFlush();
            this.flush0();
        }

        protected void flush0() {
            if (this.inFlush0) {
                return;
            }
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer == null || outboundBuffer.isEmpty()) {
                return;
            }
            this.inFlush0 = true;
            if (!SerialChannel.this.isActive()) {
                try {
                    if (SerialChannel.this.isOpen()) {
                        this.callFailFlushed(true);
                    } else {
                        this.callFailFlushed(false);
                    }
                }
                finally {
                    this.inFlush0 = false;
                }
                return;
            }
            try {
                SerialChannel.this.doWrite(outboundBuffer);
            }
            catch (Throwable t) {
                if (t instanceof IOException && SerialChannel.this.config().isAutoClose()) {
                    this.initialCloseCause = t;
                    this.close(this.voidPromise());
                    throw new RuntimeException("Unable to flush", t);
                }
                try {
                    SerialChannel.this.shutdownOutput(this.voidPromise());
                    throw new RuntimeException("Unable to flush", t);
                }
                catch (Throwable t2) {
                    this.initialCloseCause = t;
                    this.close(this.voidPromise());
                    throw new RuntimeException("Unable to flush", t);
                }
            }
            finally {
                this.inFlush0 = false;
            }
        }

        private void callFailFlushed(boolean notify) {
            try {
                Method failFlushed = ChannelOutboundBuffer.class.getDeclaredMethod("failFlushed", Throwable.class, Boolean.TYPE);
                failFlushed.setAccessible(true);
                failFlushed.invoke((Object)new RuntimeException("Unable to Flush!"), notify);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to call Failed Flushed!");
            }
        }

        public ChannelPromise voidPromise() {
            return SerialChannel.this.unsafeVoidPromise;
        }

        public ChannelOutboundBuffer outboundBuffer() {
            return this.outboundBuffer;
        }
    }
}

