/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.jsc.JSerialCommChannel;
import io.netty.channel.jsc.JSerialCommDeviceAddress;
import io.netty.channel.oio.OioEventLoopGroup;
import java.net.SocketAddress;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.base.connection.ChannelFactory;

public class SerialChannelFactory
implements ChannelFactory {
    private final String serialPort;

    public SerialChannelFactory(String serialPort) {
        this.serialPort = serialPort;
    }

    public Channel createChannel(ChannelHandler channelHandler) throws PlcConnectionException {
        JSerialCommDeviceAddress address = new JSerialCommDeviceAddress(this.serialPort);
        try {
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)new OioEventLoopGroup());
            bootstrap.channel(JSerialCommChannel.class);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.handler(channelHandler);
            ChannelFuture f = bootstrap.connect((SocketAddress)address).sync();
            f.awaitUninterruptibly();
            return f.channel();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlcConnectionException("Error creating channel.", (Throwable)e);
        }
    }

    public void ping() {
    }

    public String getSerialPort() {
        return this.serialPort;
    }
}

