/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum VirtualLanPriority {
    BEST_EFFORT(0, "BE"),
    BACKGROUND(1, "BK"),
    EXCELLENT_EFFORT(2, "EE"),
    CRITICAL_APPLICATIONS(3, "CA"),
    VIDEO(4, "VI"),
    VOICE(5, "VO"),
    INTERNETWORK_CONTROL(6, "IC"),
    NETWORK_CONTROL(7, "NC");

    private static final Logger logger;
    private static final Map<Byte, VirtualLanPriority> map;
    private byte value;
    private String acronym;

    private VirtualLanPriority(byte value, String acronym) {
        this.value = value;
        this.acronym = acronym;
    }

    public byte getValue() {
        return this.value;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public static VirtualLanPriority firstEnumForFieldAcronym(String fieldValue) {
        for (VirtualLanPriority _val : VirtualLanPriority.values()) {
            if (_val.getAcronym() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<VirtualLanPriority> enumsForFieldAcronym(String fieldValue) {
        ArrayList<VirtualLanPriority> _values = new ArrayList<VirtualLanPriority>();
        for (VirtualLanPriority _val : VirtualLanPriority.values()) {
            if (_val.getAcronym() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static VirtualLanPriority enumForValue(byte value) {
        if (!map.containsKey(value)) {
            logger.error("No VirtualLanPriority for value {}", (Object)value);
        }
        return map.get(value);
    }

    public static Boolean isDefined(byte value) {
        return map.containsKey(value);
    }

    static {
        logger = LoggerFactory.getLogger(VirtualLanPriority.class);
        map = new HashMap<Byte, VirtualLanPriority>();
        for (VirtualLanPriority value : VirtualLanPriority.values()) {
            map.put(value.getValue(), value);
        }
    }
}

