/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite.io;

import java.util.LinkedList;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet_Req;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Packet_Res;
import org.apache.plc4x.java.profinet.readwrite.io.PnIoCm_BlockIO;
import org.apache.plc4x.java.profinet.readwrite.io.PnIoCm_Packet_ReqIO;
import org.apache.plc4x.java.profinet.readwrite.io.PnIoCm_Packet_ResIO;
import org.apache.plc4x.java.profinet.readwrite.types.DceRpc_PacketType;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PnIoCm_PacketIO
implements MessageIO<PnIoCm_Packet, PnIoCm_Packet> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PnIoCm_PacketIO.class);

    public PnIoCm_Packet parse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (!(args[0] instanceof DceRpc_PacketType)) {
            throw new PlcRuntimeException("Argument 0 expected to be of type DceRpc_PacketType or a string which is parseable but was " + args[0].getClass().getName());
        }
        DceRpc_PacketType packetType = (DceRpc_PacketType)((Object)args[0]);
        return PnIoCm_PacketIO.staticParse(readBuffer, packetType);
    }

    public void serialize(WriteBuffer writeBuffer, PnIoCm_Packet value, Object ... args) throws ParseException {
        PnIoCm_PacketIO.staticSerialize(writeBuffer, value);
    }

    public static PnIoCm_Packet staticParse(ReadBuffer readBuffer, DceRpc_PacketType packetType) throws ParseException {
        readBuffer.pullContext("PnIoCm_Packet", new WithReaderArgs[0]);
        int startPos = readBuffer.getPos();
        PnIoCm_PacketBuilder builder = null;
        if (EvaluationHelper.equals((Object)((Object)packetType), (Object)((Object)DceRpc_PacketType.REQUEST))) {
            builder = PnIoCm_Packet_ReqIO.staticParse(readBuffer);
        } else if (EvaluationHelper.equals((Object)((Object)packetType), (Object)((Object)DceRpc_PacketType.RESPONSE))) {
            builder = PnIoCm_Packet_ResIO.staticParse(readBuffer);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type");
        }
        long argsLength = readBuffer.readUnsignedLong("argsLength", 32, new WithReaderArgs[0]);
        long arrayMaximumCount = readBuffer.readUnsignedLong("arrayMaximumCount", 32, new WithReaderArgs[0]);
        long arrayOffset = readBuffer.readUnsignedLong("arrayOffset", 32, new WithReaderArgs[0]);
        long arrayActualCount = readBuffer.readUnsignedLong("arrayActualCount", 32, new WithReaderArgs[0]);
        readBuffer.pullContext("blocks", new WithReaderArgs[]{WithReaderWriterArgs.WithRenderAsList((boolean)true)});
        long _blocksLength = argsLength;
        LinkedList<PnIoCm_Block> _blocksList = new LinkedList<PnIoCm_Block>();
        long blocksEndPos = (long)readBuffer.getPos() + _blocksLength;
        while ((long)readBuffer.getPos() < blocksEndPos) {
            _blocksList.add(PnIoCm_BlockIO.staticParse(readBuffer));
        }
        PnIoCm_Block[] blocks = _blocksList.toArray(new PnIoCm_Block[0]);
        readBuffer.closeContext("blocks", new WithReaderArgs[]{WithReaderWriterArgs.WithRenderAsList((boolean)true)});
        readBuffer.closeContext("PnIoCm_Packet", new WithReaderArgs[0]);
        return builder.build(argsLength, arrayMaximumCount, arrayOffset, arrayActualCount, blocks);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PnIoCm_Packet _value) throws ParseException {
        int startPos = writeBuffer.getPos();
        writeBuffer.pushContext("PnIoCm_Packet", new WithWriterArgs[0]);
        if (_value instanceof PnIoCm_Packet_Req) {
            PnIoCm_Packet_ReqIO.staticSerialize(writeBuffer, (PnIoCm_Packet_Req)_value);
        } else if (_value instanceof PnIoCm_Packet_Res) {
            PnIoCm_Packet_ResIO.staticSerialize(writeBuffer, (PnIoCm_Packet_Res)_value);
        }
        long argsLength = _value.getArgsLength();
        writeBuffer.writeUnsignedLong("argsLength", 32, ((Number)argsLength).longValue(), new WithWriterArgs[0]);
        long arrayMaximumCount = _value.getArrayMaximumCount();
        writeBuffer.writeUnsignedLong("arrayMaximumCount", 32, ((Number)arrayMaximumCount).longValue(), new WithWriterArgs[0]);
        long arrayOffset = _value.getArrayOffset();
        writeBuffer.writeUnsignedLong("arrayOffset", 32, ((Number)arrayOffset).longValue(), new WithWriterArgs[0]);
        long arrayActualCount = _value.getArrayActualCount();
        writeBuffer.writeUnsignedLong("arrayActualCount", 32, ((Number)arrayActualCount).longValue(), new WithWriterArgs[0]);
        if (_value.getBlocks() != null) {
            writeBuffer.pushContext("blocks", new WithWriterArgs[]{WithReaderWriterArgs.WithRenderAsList((boolean)true)});
            int itemCount = _value.getBlocks().length;
            int curItem = 0;
            for (PnIoCm_Block element : _value.getBlocks()) {
                boolean lastItem = curItem == itemCount - 1;
                PnIoCm_BlockIO.staticSerialize(writeBuffer, element);
                ++curItem;
            }
            writeBuffer.popContext("blocks", new WithWriterArgs[]{WithReaderWriterArgs.WithRenderAsList((boolean)true)});
        }
        writeBuffer.popContext("PnIoCm_Packet", new WithWriterArgs[0]);
    }

    public static interface PnIoCm_PacketBuilder {
        public PnIoCm_Packet build(long var1, long var3, long var5, long var7, PnIoCm_Block[] var9);
    }
}

