/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.profinet.readwrite.PnIoCm_Block;
import org.apache.plc4x.java.profinet.readwrite.io.PnIoCm_PacketIO;
import org.apache.plc4x.java.profinet.readwrite.types.DceRpc_PacketType;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

public abstract class PnIoCm_Packet
implements Message {
    private final long argsLength;
    private final long arrayMaximumCount;
    private final long arrayOffset;
    private final long arrayActualCount;
    private final PnIoCm_Block[] blocks;

    public abstract DceRpc_PacketType getPacketType();

    public PnIoCm_Packet(long argsLength, long arrayMaximumCount, long arrayOffset, long arrayActualCount, PnIoCm_Block[] blocks) {
        this.argsLength = argsLength;
        this.arrayMaximumCount = arrayMaximumCount;
        this.arrayOffset = arrayOffset;
        this.arrayActualCount = arrayActualCount;
        this.blocks = blocks;
    }

    public long getArgsLength() {
        return this.argsLength;
    }

    public long getArrayMaximumCount() {
        return this.arrayMaximumCount;
    }

    public long getArrayOffset() {
        return this.arrayOffset;
    }

    public long getArrayActualCount() {
        return this.arrayActualCount;
    }

    public PnIoCm_Block[] getBlocks() {
        return this.blocks;
    }

    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    public int getLengthInBits() {
        return this.getLengthInBitsConditional(false);
    }

    public int getLengthInBitsConditional(boolean lastItem) {
        int lengthInBits = 0;
        PnIoCm_Packet _value = this;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.blocks != null) {
            for (PnIoCm_Block element : this.blocks) {
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public MessageIO<PnIoCm_Packet, PnIoCm_Packet> getMessageIO() {
        return new PnIoCm_PacketIO();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PnIoCm_Packet)) {
            return false;
        }
        PnIoCm_Packet that = (PnIoCm_Packet)o;
        return this.getArgsLength() == that.getArgsLength() && this.getArrayMaximumCount() == that.getArrayMaximumCount() && this.getArrayOffset() == that.getArrayOffset() && this.getArrayActualCount() == that.getArrayActualCount() && this.getBlocks() == that.getBlocks();
    }

    public int hashCode() {
        return Objects.hash(this.getArgsLength(), this.getArrayMaximumCount(), this.getArrayOffset(), this.getArrayActualCount(), this.getBlocks());
    }

    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).append("argsLength", this.getArgsLength()).append("arrayMaximumCount", this.getArrayMaximumCount()).append("arrayOffset", this.getArrayOffset()).append("arrayActualCount", this.getArrayActualCount()).append("blocks", (Object[])this.getBlocks()).toString();
    }
}

