/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_ServiceType;
import org.apache.plc4x.java.profinet.readwrite.io.PnDcp_PduIO;
import org.apache.plc4x.java.profinet.readwrite.types.PnDcp_FrameId;
import org.apache.plc4x.java.profinet.readwrite.types.PnDcp_ServiceId;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

public abstract class PnDcp_Pdu
implements Message {
    private final PnDcp_ServiceType serviceType;
    private final long xid;
    private final int responseDelayFactorOrPadding;

    public abstract PnDcp_FrameId getFrameId();

    public abstract PnDcp_ServiceId getServiceId();

    public abstract Boolean getServiceTypeResponse();

    public PnDcp_Pdu(PnDcp_ServiceType serviceType, long xid, int responseDelayFactorOrPadding) {
        this.serviceType = serviceType;
        this.xid = xid;
        this.responseDelayFactorOrPadding = responseDelayFactorOrPadding;
    }

    public PnDcp_ServiceType getServiceType() {
        return this.serviceType;
    }

    public long getXid() {
        return this.xid;
    }

    public int getResponseDelayFactorOrPadding() {
        return this.responseDelayFactorOrPadding;
    }

    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    public int getLengthInBits() {
        return this.getLengthInBitsConditional(false);
    }

    public int getLengthInBitsConditional(boolean lastItem) {
        int lengthInBits = 0;
        PnDcp_Pdu _value = this;
        lengthInBits += 16;
        lengthInBits += 8;
        lengthInBits += this.serviceType.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 16;
        return lengthInBits += 16;
    }

    public MessageIO<PnDcp_Pdu, PnDcp_Pdu> getMessageIO() {
        return new PnDcp_PduIO();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PnDcp_Pdu)) {
            return false;
        }
        PnDcp_Pdu that = (PnDcp_Pdu)o;
        return this.getServiceType() == that.getServiceType() && this.getXid() == that.getXid() && this.getResponseDelayFactorOrPadding() == that.getResponseDelayFactorOrPadding();
    }

    public int hashCode() {
        return Objects.hash(this.getServiceType(), this.getXid(), this.getResponseDelayFactorOrPadding());
    }

    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).append("serviceType", (Object)this.getServiceType()).append("xid", this.getXid()).append("responseDelayFactorOrPadding", this.getResponseDelayFactorOrPadding()).toString();
    }
}

