/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.readwrite;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.profinet.readwrite.io.IpAddressIO;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

public class IpAddress
implements Message {
    private final byte[] data;

    public IpAddress(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    public int getLengthInBits() {
        return this.getLengthInBitsConditional(false);
    }

    public int getLengthInBitsConditional(boolean lastItem) {
        int lengthInBits = 0;
        IpAddress _value = this;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public MessageIO<IpAddress, IpAddress> getMessageIO() {
        return new IpAddressIO();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpAddress)) {
            return false;
        }
        IpAddress that = (IpAddress)o;
        return this.getData() == that.getData();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getData()});
    }

    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).append("data", this.getData()).toString();
    }
}

