/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItem;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItemHandler;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.api.messages.PlcDiscoveryResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_Frame;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_FramePayload_PnDcp;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_FramePayload_VirtualLan;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block_ALLSelector;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block_DevicePropertiesDeviceVendor;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Block_DevicePropertiesNameOfStation;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Pdu;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Pdu_IdentifyReq;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_Pdu_IdentifyRes;
import org.apache.plc4x.java.profinet.readwrite.PnDcp_ServiceType;
import org.apache.plc4x.java.profinet.readwrite.io.Ethernet_FrameIO;
import org.apache.plc4x.java.profinet.readwrite.types.VirtualLanPriority;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryItem;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryResponse;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.Dot1qVlanTagPacket;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.util.LinkLayerAddress;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfinetPlcDiscoverer
implements PlcDiscoverer {
    private static final EtherType PN_EtherType = EtherType.getInstance((Short)-30574);
    private static final String DEVICE_TYPE_NAME = "DEVICE_PROPERTIES_OPTION-1";
    private static final String DEVICE_NAME_OF_STATION = "DEVICE_PROPERTIES_OPTION-2";
    private static final String DEVICE_ID = "DEVICE_PROPERTIES_OPTION-3";
    private static final String DEVICE_ROLE = "DEVICE_PROPERTIES_OPTION-4";
    private static final String DEVICE_OPTIONS = "DEVICE_PROPERTIES_OPTION-5";
    private static final String DEVICE_INSTANCE = "DEVICE_PROPERTIES_OPTION-7";
    private static final String IP_OPTION_IP = "IP_OPTION-2";
    private final Logger logger = LoggerFactory.getLogger(ProfinetPlcDiscoverer.class);

    public CompletableFuture<PlcDiscoveryResponse> discover(PlcDiscoveryRequest discoveryRequest) {
        return this.discoverWithHandler(discoveryRequest, null);
    }

    public CompletableFuture<PlcDiscoveryResponse> discoverWithHandler(final PlcDiscoveryRequest discoveryRequest, PlcDiscoveryItemHandler handler) {
        final CompletableFuture<PlcDiscoveryResponse> future = new CompletableFuture<PlcDiscoveryResponse>();
        final HashSet<PcapHandle> openHandles = new HashSet<PcapHandle>();
        final ArrayList values = new ArrayList();
        try {
            for (PcapNetworkInterface dev : Pcaps.findAllDevs()) {
                if (dev.isLoopBack() || !dev.isRunning()) continue;
                for (LinkLayerAddress linkLayerAddress : dev.getLinkLayerAddresses()) {
                    MacAddress macAddress = (MacAddress)linkLayerAddress;
                    PcapHandle handle = dev.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);
                    openHandles.add(handle);
                    ExecutorService pool = Executors.newSingleThreadExecutor();
                    handle.setFilter("((ether proto 0x8100) or (ether proto 0x8892)) and (ether dst " + Pcaps.toBpfString((MacAddress)macAddress) + ")", BpfProgram.BpfCompileMode.OPTIMIZE);
                    PacketListener listener = packet -> {
                        if (packet instanceof EthernetPacket) {
                            EthernetPacket ethernetPacket = (EthernetPacket)packet;
                            boolean isPnPacket = false;
                            if (ethernetPacket.getPayload() instanceof Dot1qVlanTagPacket) {
                                Dot1qVlanTagPacket vlanPacket = (Dot1qVlanTagPacket)ethernetPacket.getPayload();
                                if (PN_EtherType.equals((Object)vlanPacket.getHeader().getType())) {
                                    isPnPacket = true;
                                }
                            } else if (PN_EtherType.equals((Object)ethernetPacket.getHeader().getType())) {
                                isPnPacket = true;
                            }
                            if (isPnPacket) {
                                ReadBufferByteBased reader = new ReadBufferByteBased(ethernetPacket.getRawData());
                                try {
                                    PnDcp_Pdu pdu;
                                    Ethernet_Frame ethernetFrame = Ethernet_FrameIO.staticParse((ReadBuffer)reader);
                                    if (ethernetFrame.getPayload() instanceof Ethernet_FramePayload_VirtualLan) {
                                        Ethernet_FramePayload_VirtualLan vlefpl = (Ethernet_FramePayload_VirtualLan)ethernetFrame.getPayload();
                                        pdu = ((Ethernet_FramePayload_PnDcp)vlefpl.getPayload()).getPdu();
                                    } else {
                                        pdu = ((Ethernet_FramePayload_PnDcp)ethernetFrame.getPayload()).getPdu();
                                    }
                                    if (pdu instanceof PnDcp_Pdu_IdentifyRes) {
                                        PnDcp_Pdu_IdentifyRes identifyResPDU = (PnDcp_Pdu_IdentifyRes)pdu;
                                        HashMap<String, PnDcp_Block> blocks = new HashMap<String, PnDcp_Block>();
                                        for (PnDcp_Block block : identifyResPDU.getBlocks()) {
                                            String blockName = block.getOption().name() + "-" + block.getSuboption().toString();
                                            blocks.put(blockName, block);
                                        }
                                        MacAddress srcAddr = ethernetPacket.getHeader().getSrcAddr();
                                        MacAddress dstAddr = ethernetPacket.getHeader().getDstAddr();
                                        String deviceTypeName = "unknown";
                                        if (blocks.containsKey(DEVICE_TYPE_NAME)) {
                                            PnDcp_Block block;
                                            block = (PnDcp_Block_DevicePropertiesDeviceVendor)blocks.get(DEVICE_TYPE_NAME);
                                            deviceTypeName = new String(((PnDcp_Block_DevicePropertiesDeviceVendor)block).getDeviceVendorValue());
                                        }
                                        String deviceName = "unknown";
                                        if (blocks.containsKey(DEVICE_NAME_OF_STATION)) {
                                            PnDcp_Block_DevicePropertiesNameOfStation block = (PnDcp_Block_DevicePropertiesNameOfStation)blocks.get(DEVICE_NAME_OF_STATION);
                                            deviceName = new String(block.getNameOfStation());
                                        }
                                        String transportUrl = srcAddr.toString();
                                        Map<String, String> options = Collections.singletonMap("localMacAddress", dstAddr.toString());
                                        String name = deviceTypeName + " - " + deviceName;
                                        DefaultPlcDiscoveryItem value = new DefaultPlcDiscoveryItem("profinet", "raw", transportUrl, options, name);
                                        values.add(value);
                                        if (handler != null) {
                                            handler.handle((PlcDiscoveryItem)value);
                                        }
                                        this.logger.debug("Found new device: '{}' with connection-url '{}'", (Object)value.getName(), (Object)value.getConnectionUrl());
                                    }
                                }
                                catch (ParseException e) {
                                    this.logger.error("Got error decoding packet", (Throwable)e);
                                }
                            }
                        }
                    };
                    Task t = new Task(handle, listener);
                    pool.execute(t);
                    Ethernet_Frame identificationRequest = new Ethernet_Frame(new org.apache.plc4x.java.profinet.readwrite.MacAddress(new byte[]{1, 14, -49, 0, 0, 0}), ProfinetPlcDiscoverer.toPlc4xMacAddress(macAddress), new Ethernet_FramePayload_VirtualLan(VirtualLanPriority.BEST_EFFORT, false, 0, new Ethernet_FramePayload_PnDcp(new PnDcp_Pdu_IdentifyReq(new PnDcp_ServiceType(false, false), 1L, 256, new PnDcp_Block[]{new PnDcp_Block_ALLSelector()}))));
                    WriteBufferByteBased buffer = new WriteBufferByteBased(34);
                    Ethernet_FrameIO.staticSerialize((WriteBuffer)buffer, identificationRequest);
                    EthernetPacket packet2 = EthernetPacket.newPacket((byte[])buffer.getData(), (int)0, (int)34);
                    handle.sendPacket((Packet)packet2);
                }
            }
        }
        catch (ParseException | NotOpenException | PcapNativeException | IllegalRawDataException e) {
            this.logger.error("Got an exception while processing raw socket data", e);
            future.completeExceptionally((Throwable)new PlcException("Got an internal error while performing discovery"));
            for (PcapHandle openHandle : openHandles) {
                openHandle.close();
            }
            return future;
        }
        Timer timer = new Timer("Discovery Timeout");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DefaultPlcDiscoveryResponse response = new DefaultPlcDiscoveryResponse(discoveryRequest, PlcResponseCode.OK, values);
                future.complete(response);
                for (PcapHandle openHandle : openHandles) {
                    openHandle.close();
                }
            }
        }, 5000L);
        return future;
    }

    private static org.apache.plc4x.java.profinet.readwrite.MacAddress toPlc4xMacAddress(MacAddress pcap4jMacAddress) {
        byte[] address = pcap4jMacAddress.getAddress();
        return new org.apache.plc4x.java.profinet.readwrite.MacAddress(new byte[]{address[0], address[1], address[2], address[3], address[4], address[5]});
    }

    public static void main(String[] args) throws Exception {
        ProfinetPlcDiscoverer discoverer = new ProfinetPlcDiscoverer();
        discoverer.discover(null);
        Thread.sleep(10000L);
    }

    private static class Task
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(Task.class);
        private final PcapHandle handle;
        private final PacketListener listener;

        public Task(PcapHandle handle, PacketListener listener) {
            this.handle = handle;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                this.handle.loop(10, this.listener);
            }
            catch (InterruptedException e) {
                this.logger.error("Got error handling raw socket", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (NotOpenException | PcapNativeException e) {
                this.logger.error("Got error handling raw socket", e);
            }
        }
    }
}

