/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.profinet;

import io.netty.buffer.ByteBuf;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.api.metadata.PlcDriverMetadata;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.profinet.config.ProfinetConfiguration;
import org.apache.plc4x.java.profinet.discovery.ProfinetPlcDiscoverer;
import org.apache.plc4x.java.profinet.field.ProfinetField;
import org.apache.plc4x.java.profinet.field.ProfinetFieldHandler;
import org.apache.plc4x.java.profinet.protocol.ProfinetProtocolLogic;
import org.apache.plc4x.java.profinet.readwrite.Ethernet_Frame;
import org.apache.plc4x.java.profinet.readwrite.io.Ethernet_FrameIO;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryRequest;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleFieldOptimizer;
import org.apache.plc4x.java.spi.values.IEC61131ValueHandler;

public class ProfinetDriver
extends GeneratedDriverBase<Ethernet_Frame> {
    public static final String DRIVER_CODE = "profinet";

    public String getProtocolCode() {
        return DRIVER_CODE;
    }

    public String getProtocolName() {
        return "Profinet";
    }

    public PlcDriverMetadata getMetadata() {
        return new PlcDriverMetadata(){

            public boolean canDiscover() {
                return true;
            }
        };
    }

    public PlcDiscoveryRequest.Builder discoveryRequestBuilder() {
        return new DefaultPlcDiscoveryRequest.Builder((PlcDiscoverer)new ProfinetPlcDiscoverer());
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return ProfinetConfiguration.class;
    }

    protected String getDefaultTransport() {
        return "raw";
    }

    protected boolean awaitSetupComplete() {
        return false;
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new SingleFieldOptimizer();
    }

    protected ProfinetFieldHandler getFieldHandler() {
        return new ProfinetFieldHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new IEC61131ValueHandler();
    }

    protected ProtocolStackConfigurer<Ethernet_Frame> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(Ethernet_Frame.class, Ethernet_FrameIO.class).withProtocol(ProfinetProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withParserArgs(new Object[]{true}).build();
    }

    public ProfinetField prepareField(String query) {
        return ProfinetField.of(query);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 6) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 4) + 6;
            }
            return -1;
        }
    }
}

