/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.openprotocol;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.openprotocol.config.OpenProtocolConfiguration;
import org.apache.plc4x.java.openprotocol.config.OpenProtocolTcpTransportConfiguration;
import org.apache.plc4x.java.openprotocol.protocol.OpenProtocolProtocolLogic;
import org.apache.plc4x.java.openprotocol.readwrite.OpenProtocolMessage;
import org.apache.plc4x.java.openprotocol.tag.OpenProtocolTag;
import org.apache.plc4x.java.openprotocol.tag.OpenProtocolTagHandler;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleTagOptimizer;
import org.apache.plc4x.java.spi.values.PlcValueHandler;

public class OpenProtocolDriver
extends GeneratedDriverBase<OpenProtocolMessage> {
    public String getProtocolCode() {
        return "open-protocol";
    }

    public String getProtocolName() {
        return "Open-Protocol";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return OpenProtocolConfiguration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(OpenProtocolTcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("tcp");
    }

    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("tcp");
    }

    protected boolean awaitSetupComplete() {
        return false;
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new SingleTagOptimizer();
    }

    protected OpenProtocolTagHandler getTagHandler() {
        return new OpenProtocolTagHandler();
    }

    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler();
    }

    protected ProtocolStackConfigurer<OpenProtocolMessage> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(OpenProtocolMessage.class, (readBuffer, objectArray) -> OpenProtocolMessage.staticParse(readBuffer, objectArray)).withProtocol(OpenProtocolProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).build();
    }

    public OpenProtocolTag prepareTag(String tagAddress) {
        return OpenProtocolTag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 6) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 4) + 6;
            }
            return -1;
        }
    }
}

