/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.kafka.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.kafka.config.Job;
import org.apache.plc4x.kafka.config.JobReference;
import org.apache.plc4x.kafka.config.Source;

public class SourceConfig {
    private static final String CONNECTION_STRING_CONFIG = "connectionString";
    private static final String JOB_REFERENCES_CONFIG = "jobReferences";
    private static final String TOPIC_CONFIG = "topic";
    private static final String INTERVAL_CONFIG = "interval";
    private static final String FIELDS_CONFIG = "fields";
    private final List<Source> sources;
    private final List<Job> jobs;

    public static SourceConfig fromPropertyMap(Map<String, String> properties) {
        String defaultTopic = properties.getOrDefault("default-topic", null);
        String[] sourceNames = properties.getOrDefault("sources", "").split(",");
        ArrayList<Source> sources = new ArrayList<Source>(sourceNames.length);
        for (String sourceName : sourceNames) {
            String connectionString = properties.get("sources." + sourceName + "." + CONNECTION_STRING_CONFIG);
            String sourceTopic = properties.getOrDefault("sources." + sourceName + "." + TOPIC_CONFIG, defaultTopic);
            String[] jobReferenceNames = properties.get("sources." + sourceName + "." + JOB_REFERENCES_CONFIG).split(",");
            JobReference[] jobReferences = new JobReference[jobReferenceNames.length];
            for (int i = 0; i < jobReferenceNames.length; ++i) {
                JobReference jobReference;
                String[] jobReferenceName = jobReferenceNames[i];
                String topic = properties.getOrDefault("sources." + sourceName + "." + JOB_REFERENCES_CONFIG + "." + (String)jobReferenceName + "." + TOPIC_CONFIG, sourceTopic);
                jobReferences[i] = jobReference = new JobReference((String)jobReferenceName, topic);
            }
            Source source = new Source(sourceName, connectionString, jobReferences);
            sources.add(source);
        }
        String[] jobNames = properties.getOrDefault("jobs", "").split(",");
        ArrayList<Job> jobs = new ArrayList<Job>(jobNames.length);
        for (String jobName : jobNames) {
            int interval = Integer.parseInt(properties.get("jobs." + jobName + "." + INTERVAL_CONFIG));
            String[] fieldNames = properties.get("jobs." + jobName + "." + FIELDS_CONFIG).split(",");
            HashMap<String, String> fields = new HashMap<String, String>();
            for (String fieldName : fieldNames) {
                String fieldAddress = properties.get("jobs." + jobName + "." + FIELDS_CONFIG + "." + fieldName);
                fields.put(fieldName, fieldAddress);
            }
            Job job = new Job(jobName, interval, fields);
            jobs.add(job);
        }
        return new SourceConfig(sources, jobs);
    }

    public SourceConfig(List<Source> sources, List<Job> jobs) {
        this.sources = sources;
        this.jobs = jobs;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public Source getSource(String sourceName) {
        if (this.sources == null) {
            return null;
        }
        return this.sources.stream().filter(source -> source.getName().equals(sourceName)).findFirst().orElse(null);
    }

    public List<Job> getJobs() {
        return this.jobs;
    }

    public Job getJob(String jobName) {
        if (this.jobs == null) {
            return null;
        }
        return this.jobs.stream().filter(job -> job.getName().equals(jobName)).findFirst().orElse(null);
    }
}

