/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.kafka;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.scraper.config.ScraperConfiguration;
import org.apache.plc4x.java.scraper.config.triggeredscraper.JobConfigurationTriggeredImplBuilder;
import org.apache.plc4x.java.scraper.config.triggeredscraper.ScraperConfigurationTriggeredImpl;
import org.apache.plc4x.java.scraper.config.triggeredscraper.ScraperConfigurationTriggeredImplBuilder;
import org.apache.plc4x.java.scraper.exception.ScraperException;
import org.apache.plc4x.java.scraper.triggeredscraper.TriggeredScraperImpl;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector.TriggerCollector;
import org.apache.plc4x.java.scraper.triggeredscraper.triggerhandler.collector.TriggerCollectorImpl;
import org.apache.plc4x.java.utils.connectionpool.PooledPlcDriverManager;
import org.apache.plc4x.kafka.util.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4xSourceTask
extends SourceTask {
    private static final Logger log = LoggerFactory.getLogger(Plc4xSourceTask.class);
    static final String CONNECTION_NAME_CONFIG = "connection-name";
    private static final String CONNECTION_NAME_STRING_DOC = "Connection Name";
    static final String PLC4X_CONNECTION_STRING_CONFIG = "plc4x-connection-string";
    private static final String PLC4X_CONNECTION_STRING_DOC = "PLC4X Connection String";
    static final String QUERIES_CONFIG = "queries";
    private static final String QUERIES_DOC = "Field queries to be sent to the PLC";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("connection-name", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Connection Name").define("plc4x-connection-string", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "PLC4X Connection String").define("queries", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "Field queries to be sent to the PLC");
    private static final String SOURCE_NAME_FIELD = "source-name";
    private static final String JOB_NAME_FIELD = "job-name";
    private static final Schema KEY_SCHEMA = new SchemaBuilder(Schema.Type.STRUCT).field("source-name", Schema.STRING_SCHEMA).field("job-name", Schema.STRING_SCHEMA).build();
    private ArrayBlockingQueue<SourceRecord> buffer;

    public String version() {
        return VersionUtil.getVersion();
    }

    public void start(Map<String, String> props) {
        AbstractConfig config = new AbstractConfig(CONFIG_DEF, props);
        String connectionName = config.getString(CONNECTION_NAME_CONFIG);
        String plc4xConnectionString = config.getString(PLC4X_CONNECTION_STRING_CONFIG);
        HashMap<String, String> topics = new HashMap<String, String>();
        this.buffer = new ArrayBlockingQueue(1000, true);
        ScraperConfigurationTriggeredImplBuilder builder = new ScraperConfigurationTriggeredImplBuilder();
        builder.addSource(connectionName, plc4xConnectionString);
        List jobConfigs = config.getList(QUERIES_CONFIG);
        for (String jobConfig : jobConfigs) {
            String[] jobConfigSegments = jobConfig.split("\\|");
            if (jobConfigSegments.length < 4) {
                log.warn(String.format("Error in job configuration '%s'. The configuration expects at least 4 segments: {job-name}|{topic}|{rate}(|{field-alias}#{field-address})+", jobConfig));
                continue;
            }
            String jobName2 = jobConfigSegments[0];
            String topic = jobConfigSegments[1];
            Integer rate = Integer.valueOf(jobConfigSegments[2]);
            JobConfigurationTriggeredImplBuilder jobBuilder = builder.job(jobName2, String.format("(SCHEDULED,%s)", rate)).source(connectionName);
            for (int i = 3; i < jobConfigSegments.length; ++i) {
                String[] fieldSegments = jobConfigSegments[i].split("#");
                if (fieldSegments.length != 2) {
                    log.warn(String.format("Error in job configuration '%s'. The field segment expects a format {field-alias}#{field-address}, but got '%s'", jobName2, jobConfigSegments[i]));
                    continue;
                }
                String fieldAlias = fieldSegments[0];
                String fieldAddress = fieldSegments[1];
                jobBuilder.field(fieldAlias, fieldAddress);
                topics.put(jobName2, topic);
            }
            jobBuilder.build();
        }
        ScraperConfigurationTriggeredImpl scraperConfig = builder.build();
        try {
            PooledPlcDriverManager plcDriverManager = new PooledPlcDriverManager();
            TriggerCollectorImpl triggerCollector = new TriggerCollectorImpl((PlcDriverManager)plcDriverManager);
            TriggeredScraperImpl scraper = new TriggeredScraperImpl((ScraperConfiguration)scraperConfig, (jobName, sourceName, results) -> {
                Long timestamp = System.currentTimeMillis();
                HashMap<String, String> sourcePartition = new HashMap<String, String>();
                sourcePartition.put("sourceName", sourceName);
                sourcePartition.put("jobName", jobName);
                Map<String, Long> sourceOffset = Collections.singletonMap("offset", timestamp);
                String topic = (String)topics.get(jobName);
                Struct key = new Struct(KEY_SCHEMA).put(SOURCE_NAME_FIELD, (Object)sourceName).put(JOB_NAME_FIELD, (Object)jobName);
                SchemaBuilder recordSchemaBuilder = SchemaBuilder.struct().name("org.apache.plc4x.kafka.JobResult");
                for (Map.Entry result : results.entrySet()) {
                    String fieldName = (String)result.getKey();
                    Object v = result.getValue();
                    Schema valueSchema = this.getSchema(v);
                    recordSchemaBuilder.field(fieldName, valueSchema);
                }
                Schema recordSchema = recordSchemaBuilder.build();
                Struct recordStruct = new Struct(recordSchema);
                for (Map.Entry entry : results.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    Object fieldValue = entry.getValue();
                    recordStruct.put(fieldName, fieldValue);
                }
                SourceRecord record = new SourceRecord(sourcePartition, sourceOffset, topic, KEY_SCHEMA, (Object)key, recordSchema, (Object)recordStruct);
                this.buffer.add(record);
            }, (TriggerCollector)triggerCollector);
            scraper.start();
            triggerCollector.start();
        }
        catch (ScraperException e) {
            log.error("Error starting the scraper", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Plc4xSourceTask plc4xSourceTask = this;
        synchronized (plc4xSourceTask) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public List<SourceRecord> poll() {
        if (!this.buffer.isEmpty()) {
            int numElements = this.buffer.size();
            ArrayList<SourceRecord> result = new ArrayList<SourceRecord>(numElements);
            this.buffer.drainTo(result, numElements);
            return result;
        }
        return Collections.emptyList();
    }

    private Schema getSchema(Object value) {
        Objects.requireNonNull(value);
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                throw new ConnectException("Unsupported empty lists.");
            }
            Object firstElement = list.get(0);
            Schema elementSchema = this.getSchema(firstElement);
            return SchemaBuilder.array((Schema)elementSchema).build();
        }
        if (value instanceof BigDecimal) {
            // empty if block
        }
        if (value instanceof BigDecimal) {
            // empty if block
        }
        if (value instanceof Boolean) {
            return Schema.BOOLEAN_SCHEMA;
        }
        if (value instanceof byte[]) {
            return Schema.BYTES_SCHEMA;
        }
        if (value instanceof Byte) {
            return Schema.INT8_SCHEMA;
        }
        if (value instanceof Double) {
            return Schema.FLOAT64_SCHEMA;
        }
        if (value instanceof Float) {
            return Schema.FLOAT32_SCHEMA;
        }
        if (value instanceof Integer) {
            return Schema.INT32_SCHEMA;
        }
        if (value instanceof LocalDate) {
            // empty if block
        }
        if (value instanceof LocalDateTime) {
            // empty if block
        }
        if (value instanceof LocalTime) {
            // empty if block
        }
        if (value instanceof Long) {
            return Schema.INT64_SCHEMA;
        }
        if (value instanceof Short) {
            return Schema.INT16_SCHEMA;
        }
        if (value instanceof String) {
            return Schema.STRING_SCHEMA;
        }
        throw new ConnectException(String.format("Unsupported data type %s", value.getClass().getName()));
    }
}

