/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.kafka;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.plc4x.kafka.Plc4xSourceTask;
import org.apache.plc4x.kafka.config.Job;
import org.apache.plc4x.kafka.config.JobReference;
import org.apache.plc4x.kafka.config.Source;
import org.apache.plc4x.kafka.config.SourceConfig;
import org.apache.plc4x.kafka.util.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4xSourceConnector
extends SourceConnector {
    private static final Logger log = LoggerFactory.getLogger(Plc4xSourceConnector.class);
    public static final String DEFAULT_TOPIC_CONFIG = "default-topic";
    private static final String DEFAULT_TOPIC_DOC = "Default topic to be used, if not otherwise configured.";
    public static final String SOURCES_CONFIG = "sources";
    private static final String SOURCES_DOC = "List of source names that will be configured.";
    public static final String JOBS_CONFIG = "jobs";
    private static final String JOBS_DOC = "List of job names that will be configured.";
    private static final String CONNECTION_STRING_CONFIG = "connectionString";
    private static final String JOB_REFERENCES_CONFIG = "jobReferences";
    private static final String TOPIC_CONFIG = "topic";
    private static final String INTERVAL_CONFIG = "interval";
    private static final String FIELDS_CONFIG = "fields";
    private SourceConfig sourceConfig;

    public void start(Map<String, String> props) {
        this.sourceConfig = SourceConfig.fromPropertyMap(props);
    }

    public void stop() {
        this.sourceConfig = null;
    }

    public Class<? extends Task> taskClass() {
        return Plc4xSourceTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (this.sourceConfig.getJobs().size() > maxTasks) {
            log.warn("NOT ENOUGH TASKS!");
            return Collections.emptyList();
        }
        LinkedList<Map<String, String>> configs = new LinkedList<Map<String, String>>();
        for (Source source : this.sourceConfig.getSources()) {
            StringBuilder query = new StringBuilder();
            for (JobReference jobReference : source.getJobReferences()) {
                Job job = this.sourceConfig.getJob(jobReference.getName());
                if (job == null) {
                    log.warn(String.format("Couldn't find referenced job '%s'", jobReference.getName()));
                    continue;
                }
                query.append(",").append(jobReference.getName()).append("|").append(jobReference.getTopic());
                query.append("|").append(job.getInterval());
                for (Map.Entry<String, String> field : job.getFields().entrySet()) {
                    String fieldName = field.getKey();
                    String fieldAddress = field.getValue();
                    query.append("|").append(fieldName).append("#").append(fieldAddress);
                }
            }
            HashMap<String, String> taskConfig = new HashMap<String, String>();
            taskConfig.put("connection-name", source.getName());
            taskConfig.put("plc4x-connection-string", source.getConnectionString());
            taskConfig.put("queries", query.toString().substring(1));
            configs.add(taskConfig);
        }
        return configs;
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Config config = super.validate(connectorConfigs);
        String defaultTopic = null;
        ConfigValue sources = null;
        ConfigValue jobs = null;
        for (ConfigValue configValue : config.configValues()) {
            switch (configValue.name()) {
                case "default-topic": {
                    defaultTopic = (String)configValue.value();
                    break;
                }
                case "jobs": {
                    jobs = configValue;
                    break;
                }
                case "sources": {
                    sources = configValue;
                    break;
                }
            }
        }
        LinkedList<String> foundJobs = new LinkedList<String>();
        if (jobs != null) {
            List jobNames = (List)jobs.value();
            for (String jobName : jobNames) {
                String jobIntervalConfig = "jobs." + jobName + "." + INTERVAL_CONFIG;
                ConfigValue jobIntervalConfigValue = new ConfigValue(jobIntervalConfig);
                config.configValues().add(jobIntervalConfigValue);
                String jobIntervalString = connectorConfigs.get(jobIntervalConfig);
                if (jobIntervalString == null) {
                    jobIntervalConfigValue.value(null);
                    jobIntervalConfigValue.addErrorMessage(jobIntervalConfig + " is mandatory");
                } else if (NumberUtils.isParsable((String)jobIntervalString)) {
                    int jobInterval = NumberUtils.toInt((String)jobIntervalString);
                    if (jobInterval > 0) {
                        jobIntervalConfigValue.value((Object)jobInterval);
                    } else {
                        jobIntervalConfigValue.value(null);
                        jobIntervalConfigValue.addErrorMessage(jobIntervalConfig + " must be greater than 0");
                    }
                } else {
                    jobIntervalConfigValue.value(null);
                    jobIntervalConfigValue.addErrorMessage(jobIntervalConfig + " must be a numeric value greater than 0");
                }
                String jobFieldsConfig = "jobs." + jobName + "." + FIELDS_CONFIG;
                ConfigValue jobFieldsConfigValue = new ConfigValue(jobFieldsConfig);
                if (!connectorConfigs.containsKey(jobFieldsConfig)) {
                    jobFieldsConfigValue.value(null);
                    jobFieldsConfigValue.addErrorMessage(jobFieldsConfig + " is mandatory");
                } else {
                    String[] jobFieldNames = connectorConfigs.getOrDefault(jobFieldsConfig, "").split(",");
                    jobFieldsConfigValue.value((Object)jobFieldNames);
                    if (jobFieldNames.length == 0) {
                        jobFieldsConfigValue.addErrorMessage(jobFieldsConfig + " at least has to contain one field name");
                    } else {
                        for (String jobFieldName : jobFieldNames) {
                            String jobFieldAddressConfig = "jobs." + jobName + "." + FIELDS_CONFIG + "." + jobFieldName;
                            ConfigValue jobFieldAddressConfigValue = new ConfigValue(jobFieldAddressConfig);
                            String jobFieldAddress = connectorConfigs.get(jobFieldAddressConfig);
                            jobFieldAddressConfigValue.value((Object)jobFieldAddress);
                            if (jobFieldAddress != null && !jobFieldAddress.isEmpty()) continue;
                            jobFieldAddressConfigValue.addErrorMessage(jobFieldAddressConfig + " is mandatory");
                        }
                    }
                }
                foundJobs.add(jobName);
            }
        }
        if (sources != null) {
            List sourceNames = (List)sources.value();
            for (String sourceName : sourceNames) {
                String connectionStringConfig = "sources." + sourceName + "." + CONNECTION_STRING_CONFIG;
                ConfigValue sourceConnectionStringConfigValue = new ConfigValue(connectionStringConfig);
                config.configValues().add(sourceConnectionStringConfigValue);
                String connectionString = connectorConfigs.get(connectionStringConfig);
                sourceConnectionStringConfigValue.value();
                if (connectionString == null) {
                    sourceConnectionStringConfigValue.addErrorMessage(connectionStringConfig + " is mandatory");
                    continue;
                }
                String sourceTopicConfig = "sources." + sourceName + "." + TOPIC_CONFIG;
                ConfigValue sourceTopicConfigValue = new ConfigValue(sourceTopicConfig);
                config.configValues().add(sourceTopicConfigValue);
                String sourceTopic = connectorConfigs.get(sourceTopicConfig);
                sourceTopicConfigValue.value((Object)sourceTopic);
                String jobReferenceNamesConfig = "sources." + sourceName + "." + JOB_REFERENCES_CONFIG;
                ConfigValue jobReferenceNamesConfigValue = new ConfigValue(jobReferenceNamesConfig);
                jobReferenceNamesConfigValue.recommendedValues(foundJobs);
                config.configValues().add(jobReferenceNamesConfigValue);
                if (!connectorConfigs.containsKey(jobReferenceNamesConfig)) {
                    jobReferenceNamesConfigValue.value(null);
                    jobReferenceNamesConfigValue.addErrorMessage(jobReferenceNamesConfig + " is mandatory");
                    continue;
                }
                String[] jobReferenceNames = connectorConfigs.getOrDefault(jobReferenceNamesConfig, "").split(",");
                jobReferenceNamesConfigValue.value((Object)jobReferenceNames);
                if (jobReferenceNames.length == 0) {
                    jobReferenceNamesConfigValue.addErrorMessage(jobReferenceNamesConfig + " is mandatory");
                }
                for (String jobReferenceName : jobReferenceNames) {
                    if (!foundJobs.contains(jobReferenceName)) {
                        jobReferenceNamesConfigValue.addErrorMessage(jobReferenceNamesConfig + " references non-existent job " + jobReferenceName);
                        continue;
                    }
                    String jobReferenceTopicNameConfig = "sources." + sourceName + "." + JOB_REFERENCES_CONFIG + "." + jobReferenceName + TOPIC_CONFIG;
                    ConfigValue jobReferenceTopicNameConfigValue = new ConfigValue(jobReferenceTopicNameConfig);
                    config.configValues().add(jobReferenceTopicNameConfigValue);
                    String jobReferenceTopic = connectorConfigs.get(jobReferenceTopicNameConfig);
                    jobReferenceTopicNameConfigValue.value((Object)jobReferenceTopic);
                    if (jobReferenceTopic != null || sourceTopic != null || defaultTopic != null) continue;
                    jobReferenceTopicNameConfigValue.addErrorMessage("No topic definition found at any level for " + jobReferenceTopicNameConfig);
                }
            }
        }
        return config;
    }

    public ConfigDef config() {
        return new ConfigDef().define(DEFAULT_TOPIC_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.LOW, DEFAULT_TOPIC_DOC).define(SOURCES_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, SOURCES_DOC).define(JOBS_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, JOBS_DOC);
    }

    public String version() {
        return VersionUtil.getVersion();
    }
}

