/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.kafka;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.plc4x.kafka.Plc4xSourceTask;
import org.apache.plc4x.kafka.util.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4xSourceConnector
extends SourceConnector {
    private static final Logger log = LoggerFactory.getLogger(Plc4xSourceConnector.class);
    private static final String TOPIC_CONFIG = "topic";
    private static final String TOPIC_DOC = "Kafka topic to publish to";
    private static final String QUERIES_CONFIG = "queries";
    private static final String QUERIES_DOC = "Field queries to be sent to the PLC";
    private static final String JSON_CONFIG = "json.url";
    private static final String JSON_DEFAULT = "";
    private static final String JSON_DOC = "JSON configuration";
    private static final String RATE_CONFIG = "rate";
    private static final Integer RATE_DEFAULT = 1000;
    private static final String RATE_DOC = "Polling rate";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("topic", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Kafka topic to publish to").define("queries", ConfigDef.Type.LIST, new LinkedList(), ConfigDef.Importance.HIGH, "Field queries to be sent to the PLC").define("json.url", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "JSON configuration").define("rate", ConfigDef.Type.INT, (Object)RATE_DEFAULT, ConfigDef.Importance.MEDIUM, "Polling rate");
    private String topic;
    private List<String> queries;
    private String json;
    private Integer rate;

    public Class<? extends Task> taskClass() {
        return Plc4xSourceTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        LinkedList<Map<String, String>> configs = new LinkedList<Map<String, String>>();
        if (this.json.isEmpty()) {
            HashMap<String, List> groupedByHost = new HashMap<String, List>();
            this.queries.stream().map(query -> query.split("#", 2)).collect(Collectors.groupingBy(parts -> parts[0])).forEach((host, q) -> groupedByHost.put((String)host, q.stream().map(parts -> parts[1]).collect(Collectors.toList())));
            if (groupedByHost.size() > maxTasks) {
                return Collections.emptyList();
            }
            groupedByHost.forEach((host, qs) -> {
                HashMap<String, String> taskConfig = new HashMap<String, String>();
                taskConfig.put(TOPIC_CONFIG, this.topic);
                taskConfig.put("url", (String)host);
                taskConfig.put(QUERIES_CONFIG, String.join((CharSequence)",", qs));
                taskConfig.put(RATE_CONFIG, this.rate.toString());
                configs.add(taskConfig);
            });
        } else {
            try {
                String config = new Scanner(new URL(this.json).openStream(), "UTF-8").useDelimiter("\\A").next();
                ObjectMapper mapper = new ObjectMapper();
                Map values = (Map)mapper.readValue(config, (TypeReference)new TypeReference<Map<String, Object>>(){});
                List plcs = (List)values.get("PLCs");
                log.info("TASKS REQUIRED: " + plcs.size());
                if (plcs.size() > maxTasks) {
                    log.warn("NOT ENOUGH TASKS!");
                    return Collections.emptyList();
                }
                for (Map plc : plcs) {
                    String ip;
                    HashMap<String, String> taskConfig = new HashMap<String, String>();
                    String topic = ip = plc.get("IP").toString();
                    String url = "s7://" + ip + "/1/" + plc.get("Slot");
                    LinkedList<String> queries = new LinkedList<String>();
                    for (Map operand : (List)plc.get("operands")) {
                        String query2 = "%" + operand.get("Operand") + ":" + operand.get("Datatype");
                        queries.add(query2);
                    }
                    taskConfig.put(TOPIC_CONFIG, topic);
                    taskConfig.put("url", url);
                    taskConfig.put(RATE_CONFIG, this.rate.toString());
                    taskConfig.put(QUERIES_CONFIG, String.join((CharSequence)",", queries));
                    configs.add(taskConfig);
                }
            }
            catch (IOException e) {
                log.error("ERROR CONFIGURING TASK", (Throwable)e);
            }
        }
        return configs;
    }

    public void start(Map<String, String> props) {
        AbstractConfig config = new AbstractConfig(CONFIG_DEF, props);
        this.topic = config.getString(TOPIC_CONFIG);
        this.queries = config.getList(QUERIES_CONFIG);
        this.rate = config.getInt(RATE_CONFIG);
        this.json = config.getString(JSON_CONFIG);
    }

    public void stop() {
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public String version() {
        return VersionUtil.getVersion();
    }
}

