/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.kafka;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.plc4x.kafka.Plc4xSinkTask;
import org.apache.plc4x.kafka.util.VersionUtil;

public class Plc4xSinkConnector
extends SinkConnector {
    static final String URL_CONFIG = "url";
    private static final String URL_DOC = "Connection string used by PLC4X to connect to the PLC";
    static final ConfigDef CONFIG_DEF = new ConfigDef().define("url", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Connection string used by PLC4X to connect to the PLC");
    private String url;
    private String query;

    public Class<? extends Task> taskClass() {
        return Plc4xSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        LinkedList<Map<String, String>> configs = new LinkedList<Map<String, String>>();
        for (int i = 0; i < maxTasks; ++i) {
            HashMap<String, String> taskConfig = new HashMap<String, String>();
            taskConfig.put(URL_CONFIG, this.url);
            configs.add(taskConfig);
        }
        return configs;
    }

    public void start(Map<String, String> props) {
        AbstractConfig config = new AbstractConfig(CONFIG_DEF, props);
        this.url = config.getString(URL_CONFIG);
    }

    public void stop() {
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public String version() {
        return VersionUtil.getVersion();
    }
}

