/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.segmentuploader;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.spi.auth.AuthContext;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.ingestion.batch.BatchConfig;
import org.apache.pinot.spi.ingestion.segment.uploader.SegmentUploader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentUploaderDefault
implements SegmentUploader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentUploaderDefault.class);
    private String _tableNameWithType;
    private BatchConfig _batchConfig;

    public void init(TableConfig tableConfig) throws Exception {
        this.init(tableConfig, Collections.emptyMap());
    }

    public void init(TableConfig tableConfig, Map<String, String> batchConfigOverride) throws Exception {
        this._tableNameWithType = tableConfig.getTableName();
        Preconditions.checkState((tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getBatchIngestionConfig() != null && CollectionUtils.isNotEmpty((Collection)tableConfig.getIngestionConfig().getBatchIngestionConfig().getBatchConfigMaps()) ? 1 : 0) != 0, (String)"Must provide ingestionConfig->batchIngestionConfig->batchConfigMaps in tableConfig for table: %s", (Object)this._tableNameWithType);
        Preconditions.checkState((tableConfig.getIngestionConfig().getBatchIngestionConfig().getBatchConfigMaps().size() == 1 ? 1 : 0) != 0, (String)"batchConfigMaps must contain only 1 BatchConfig for table: %s", (Object)this._tableNameWithType);
        HashMap<String, String> batchConfigMap = new HashMap<String, String>((Map)tableConfig.getIngestionConfig().getBatchIngestionConfig().getBatchConfigMaps().get(0));
        batchConfigMap.putAll(batchConfigOverride);
        this._batchConfig = new BatchConfig(this._tableNameWithType, batchConfigMap);
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this._batchConfig.getPushControllerURI()), (String)"Must provide: %s in batchConfigs for table: %s", (Object)"push.controllerUri", (Object)this._tableNameWithType);
        LOGGER.info("Initialized {} for table: {}", (Object)SegmentUploaderDefault.class.getName(), (Object)this._tableNameWithType);
    }

    public void uploadSegment(URI segmentTarURI, @Nullable AuthContext authContext) throws Exception {
        IngestionUtils.uploadSegment((String)this._tableNameWithType, (BatchConfig)this._batchConfig, Collections.singletonList(segmentTarURI), (AuthContext)authContext);
        LOGGER.info("Successfully uploaded segment: {} to table: {}", (Object)segmentTarURI, (Object)this._tableNameWithType);
    }

    public void uploadSegmentsFromDir(URI segmentDir, @Nullable AuthContext authContext) throws Exception {
        String[] filePaths;
        ArrayList<URI> segmentTarURIs = new ArrayList<URI>();
        PinotFS outputPinotFS = IngestionUtils.getOutputPinotFS((BatchConfig)this._batchConfig, (URI)segmentDir);
        for (String filePath : filePaths = outputPinotFS.listFiles(segmentDir, true)) {
            URI uri = URI.create(filePath);
            if (outputPinotFS.isDirectory(uri) || !filePath.endsWith(".tar.gz")) continue;
            segmentTarURIs.add(uri);
        }
        IngestionUtils.uploadSegment((String)this._tableNameWithType, (BatchConfig)this._batchConfig, segmentTarURIs, (AuthContext)authContext);
        LOGGER.info("Successfully uploaded segments: {} to table: {}", segmentTarURIs, (Object)this._tableNameWithType);
    }
}

