/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kinesis;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import org.apache.pinot.plugin.stream.kinesis.KinesisPartitionGroupOffset;
import org.apache.pinot.spi.stream.MessageBatch;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import software.amazon.awssdk.services.kinesis.model.Record;

public class KinesisRecordsBatch
implements MessageBatch<byte[]> {
    private final List<Record> _recordList;
    private final String _shardId;
    private final boolean _endOfShard;

    public KinesisRecordsBatch(List<Record> recordList, String shardId, boolean endOfShard) {
        this._recordList = recordList;
        this._shardId = shardId;
        this._endOfShard = endOfShard;
    }

    public int getMessageCount() {
        return this._recordList.size();
    }

    public byte[] getMessageAtIndex(int index) {
        return this._recordList.get(index).data().asByteArray();
    }

    public int getMessageOffsetAtIndex(int index) {
        return ByteBuffer.wrap(this._recordList.get(index).data().asByteArray()).arrayOffset();
    }

    public int getMessageLengthAtIndex(int index) {
        return this._recordList.get(index).data().asByteArray().length;
    }

    public StreamPartitionMsgOffset getNextStreamParitionMsgOffsetAtIndex(int index) {
        HashMap<String, String> shardToSequenceMap = new HashMap<String, String>();
        shardToSequenceMap.put(this._shardId, this._recordList.get(index).sequenceNumber());
        return new KinesisPartitionGroupOffset(shardToSequenceMap);
    }

    public long getNextStreamMessageOffsetAtIndex(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean isEndOfPartitionGroup() {
        return this._endOfShard;
    }
}

