/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kinesis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.apache.pinot.spi.utils.JsonUtils;

public class KinesisPartitionGroupOffset
implements StreamPartitionMsgOffset {
    private final Map<String, String> _shardToStartSequenceMap;

    public KinesisPartitionGroupOffset(Map<String, String> shardToStartSequenceMap) {
        this._shardToStartSequenceMap = shardToStartSequenceMap;
    }

    public KinesisPartitionGroupOffset(String offsetStr) throws IOException {
        this._shardToStartSequenceMap = (Map)JsonUtils.stringToObject((String)offsetStr, (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    public Map<String, String> getShardToStartSequenceMap() {
        return this._shardToStartSequenceMap;
    }

    public String toString() {
        try {
            return JsonUtils.objectToString(this._shardToStartSequenceMap);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Caught exception when converting KinesisCheckpoint to string: " + this._shardToStartSequenceMap);
        }
    }

    public KinesisPartitionGroupOffset fromString(String kinesisCheckpointStr) {
        try {
            return new KinesisPartitionGroupOffset(kinesisCheckpointStr);
        }
        catch (IOException e) {
            throw new IllegalStateException("Caught exception when converting string to KinesisCheckpoint: " + kinesisCheckpointStr);
        }
    }

    public int compareTo(Object o) {
        Preconditions.checkNotNull((Object)o);
        KinesisPartitionGroupOffset other = (KinesisPartitionGroupOffset)o;
        Preconditions.checkNotNull(other._shardToStartSequenceMap);
        Preconditions.checkNotNull(this._shardToStartSequenceMap);
        Preconditions.checkState((other._shardToStartSequenceMap.size() == 1 ? 1 : 0) != 0, (String)"Only 1 shard per consumer supported. Found: %s", other._shardToStartSequenceMap);
        Preconditions.checkState((this._shardToStartSequenceMap.size() == 1 ? 1 : 0) != 0, (String)"Only 1 shard per consumer supported. Found: %s", this._shardToStartSequenceMap);
        return this._shardToStartSequenceMap.values().iterator().next().compareTo(other._shardToStartSequenceMap.values().iterator().next());
    }
}

