/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kinesis;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.stream.kinesis.KinesisConfig;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheSdkHttpService;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.Shard;

public class KinesisConnectionHandler {
    protected KinesisClient _kinesisClient;
    private final String _stream;
    private final String _region;
    private final String _accessKey;
    private final String _secretKey;
    private final String _endpoint;

    public KinesisConnectionHandler(KinesisConfig kinesisConfig) {
        this._stream = kinesisConfig.getStreamTopicName();
        this._region = kinesisConfig.getAwsRegion();
        this._accessKey = kinesisConfig.getAccessKey();
        this._secretKey = kinesisConfig.getSecretKey();
        this._endpoint = kinesisConfig.getEndpoint();
        this.createConnection();
    }

    @VisibleForTesting
    public KinesisConnectionHandler(KinesisConfig kinesisConfig, KinesisClient kinesisClient) {
        this._stream = kinesisConfig.getStreamTopicName();
        this._region = kinesisConfig.getAwsRegion();
        this._accessKey = kinesisConfig.getAccessKey();
        this._secretKey = kinesisConfig.getSecretKey();
        this._endpoint = kinesisConfig.getEndpoint();
        this._kinesisClient = kinesisClient;
    }

    public List<Shard> getShards() {
        ListShardsResponse listShardsResponse = this._kinesisClient.listShards((ListShardsRequest)ListShardsRequest.builder().streamName(this._stream).build());
        return listShardsResponse.shards();
    }

    public void createConnection() {
        if (this._kinesisClient == null) {
            KinesisClientBuilder kinesisClientBuilder;
            if (StringUtils.isNotBlank((CharSequence)this._accessKey) && StringUtils.isNotBlank((CharSequence)this._secretKey)) {
                AwsBasicCredentials awsBasicCredentials = AwsBasicCredentials.create((String)this._accessKey, (String)this._secretKey);
                kinesisClientBuilder = (KinesisClientBuilder)((KinesisClientBuilder)((KinesisClientBuilder)KinesisClient.builder().region(Region.of((String)this._region))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsBasicCredentials))).httpClientBuilder(new ApacheSdkHttpService().createHttpClientBuilder());
            } else {
                kinesisClientBuilder = (KinesisClientBuilder)((KinesisClientBuilder)((KinesisClientBuilder)KinesisClient.builder().region(Region.of((String)this._region))).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).httpClientBuilder(new ApacheSdkHttpService().createHttpClientBuilder());
            }
            if (StringUtils.isNotBlank((CharSequence)this._endpoint)) {
                try {
                    kinesisClientBuilder = (KinesisClientBuilder)kinesisClientBuilder.endpointOverride(new URI(this._endpoint));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("URI syntax is not correctly specified for endpoint: " + this._endpoint, e);
                }
            }
            this._kinesisClient = (KinesisClient)kinesisClientBuilder.build();
        }
    }

    public void close() {
        if (this._kinesisClient != null) {
            this._kinesisClient.close();
            this._kinesisClient = null;
        }
    }
}

