/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kinesis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.UUID;
import org.apache.pinot.spi.stream.StreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public class KinesisConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(KinesisConfig.class);
    public static final String STREAM_TYPE = "kinesis";
    public static final String SHARD_ITERATOR_TYPE = "shardIteratorType";
    public static final String REGION = "region";
    public static final String ACCESS_KEY = "accessKey";
    public static final String SECRET_KEY = "secretKey";
    public static final String MAX_RECORDS_TO_FETCH = "maxRecordsToFetch";
    public static final String ENDPOINT = "endpoint";
    public static final String RPS_LIMIT = "requests_per_second_limit";
    public static final String IAM_ROLE_BASED_ACCESS_ENABLED = "iamRoleBasedAccessEnabled";
    public static final String ROLE_ARN = "roleArn";
    public static final String ROLE_SESSION_NAME = "roleSessionName";
    public static final String EXTERNAL_ID = "externalId";
    public static final String SESSION_DURATION_SECONDS = "sessionDurationSeconds";
    public static final String ASYNC_SESSION_UPDATED_ENABLED = "asyncSessionUpdateEnabled";
    public static final String DEFAULT_MAX_RECORDS = "20";
    public static final String DEFAULT_SHARD_ITERATOR_TYPE = ShardIteratorType.LATEST.toString();
    public static final String DEFAULT_IAM_ROLE_BASED_ACCESS_ENABLED = "false";
    public static final String DEFAULT_SESSION_DURATION_SECONDS = "900";
    public static final String DEFAULT_ASYNC_SESSION_UPDATED_ENABLED = "true";
    public static final String DEFAULT_RPS_LIMIT = "5";
    private final String _streamTopicName;
    private final String _awsRegion;
    private final int _numMaxRecordsToFetch;
    private final ShardIteratorType _shardIteratorType;
    private final String _accessKey;
    private final String _secretKey;
    private final String _endpoint;
    private boolean _iamRoleBasedAccess;
    private String _roleArn;
    private String _roleSessionName;
    private String _externalId;
    private int _sessionDurationSeconds;
    private boolean _asyncSessionUpdateEnabled;
    private int _rpsLimit;

    public KinesisConfig(StreamConfig streamConfig) {
        Map props = streamConfig.getStreamConfigsMap();
        this._streamTopicName = streamConfig.getTopicName();
        this._awsRegion = (String)props.get(REGION);
        Preconditions.checkNotNull((Object)this._awsRegion, (String)"Must provide 'region' in stream config for table: %s", (Object)streamConfig.getTableNameWithType());
        this._numMaxRecordsToFetch = Integer.parseInt(props.getOrDefault(MAX_RECORDS_TO_FETCH, DEFAULT_MAX_RECORDS));
        this._rpsLimit = Integer.parseInt(props.getOrDefault(RPS_LIMIT, DEFAULT_RPS_LIMIT));
        if (this._rpsLimit <= 0) {
            LOGGER.warn("Invalid 'requests_per_second_limit' value: {}. Please provide value greater than 0. Using default: {}", (Object)this._rpsLimit, (Object)DEFAULT_RPS_LIMIT);
            this._rpsLimit = Integer.parseInt(DEFAULT_RPS_LIMIT);
        }
        this._shardIteratorType = ShardIteratorType.fromValue((String)props.getOrDefault(SHARD_ITERATOR_TYPE, DEFAULT_SHARD_ITERATOR_TYPE));
        this._accessKey = (String)props.get(ACCESS_KEY);
        this._secretKey = (String)props.get(SECRET_KEY);
        this._endpoint = (String)props.get(ENDPOINT);
        this._iamRoleBasedAccess = Boolean.parseBoolean(props.getOrDefault(IAM_ROLE_BASED_ACCESS_ENABLED, DEFAULT_IAM_ROLE_BASED_ACCESS_ENABLED));
        this._roleArn = (String)props.get(ROLE_ARN);
        this._roleSessionName = props.getOrDefault(ROLE_SESSION_NAME, Joiner.on((String)"-").join((Object)"pinot", (Object)STREAM_TYPE, new Object[]{UUID.randomUUID()}));
        this._externalId = (String)props.get(EXTERNAL_ID);
        this._sessionDurationSeconds = Integer.parseInt(props.getOrDefault(SESSION_DURATION_SECONDS, DEFAULT_SESSION_DURATION_SECONDS));
        this._asyncSessionUpdateEnabled = Boolean.parseBoolean(props.getOrDefault(ASYNC_SESSION_UPDATED_ENABLED, DEFAULT_ASYNC_SESSION_UPDATED_ENABLED));
        if (this._iamRoleBasedAccess) {
            Preconditions.checkNotNull((Object)this._roleArn, (String)"Must provide 'roleArn' in stream config for table %s if iamRoleBasedAccess is enabled", (Object)streamConfig.getTableNameWithType());
        }
    }

    public String getStreamTopicName() {
        return this._streamTopicName;
    }

    public String getAwsRegion() {
        return this._awsRegion;
    }

    public int getNumMaxRecordsToFetch() {
        return this._numMaxRecordsToFetch;
    }

    public int getRpsLimit() {
        return this._rpsLimit;
    }

    public ShardIteratorType getShardIteratorType() {
        return this._shardIteratorType;
    }

    public String getAccessKey() {
        return this._accessKey;
    }

    public String getSecretKey() {
        return this._secretKey;
    }

    public String getEndpoint() {
        return this._endpoint;
    }

    public boolean isIamRoleBasedAccess() {
        return this._iamRoleBasedAccess;
    }

    public String getRoleArn() {
        return this._roleArn;
    }

    public String getRoleSessionName() {
        return this._roleSessionName;
    }

    public String getExternalId() {
        return this._externalId;
    }

    public int getSessionDurationSeconds() {
        return this._sessionDurationSeconds;
    }

    public boolean isAsyncSessionUpdateEnabled() {
        return this._asyncSessionUpdateEnabled;
    }
}

