/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kinesis;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.pinot.spi.stream.StreamConfig;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public class KinesisConfig {
    public static final String STREAM_TYPE = "kinesis";
    public static final String SHARD_ITERATOR_TYPE = "shardIteratorType";
    public static final String REGION = "region";
    public static final String ACCESS_KEY = "accessKey";
    public static final String SECRET_KEY = "secretKey";
    public static final String MAX_RECORDS_TO_FETCH = "maxRecordsToFetch";
    public static final String ENDPOINT = "endpoint";
    public static final String DEFAULT_MAX_RECORDS = "20";
    public static final String DEFAULT_SHARD_ITERATOR_TYPE = ShardIteratorType.LATEST.toString();
    private final String _streamTopicName;
    private final String _awsRegion;
    private final int _numMaxRecordsToFetch;
    private final ShardIteratorType _shardIteratorType;
    private final String _accessKey;
    private final String _secretKey;
    private final String _endpoint;

    public KinesisConfig(StreamConfig streamConfig) {
        Map props = streamConfig.getStreamConfigsMap();
        this._streamTopicName = streamConfig.getTopicName();
        this._awsRegion = (String)props.get(REGION);
        Preconditions.checkNotNull((Object)this._awsRegion, (String)"Must provide 'region' in stream config for table: %s", (Object)streamConfig.getTableNameWithType());
        this._numMaxRecordsToFetch = Integer.parseInt(props.getOrDefault(MAX_RECORDS_TO_FETCH, DEFAULT_MAX_RECORDS));
        this._shardIteratorType = ShardIteratorType.fromValue((String)props.getOrDefault(SHARD_ITERATOR_TYPE, DEFAULT_SHARD_ITERATOR_TYPE));
        this._accessKey = (String)props.get(ACCESS_KEY);
        this._secretKey = (String)props.get(SECRET_KEY);
        this._endpoint = (String)props.get(ENDPOINT);
    }

    public String getStreamTopicName() {
        return this._streamTopicName;
    }

    public String getAwsRegion() {
        return this._awsRegion;
    }

    public int getNumMaxRecordsToFetch() {
        return this._numMaxRecordsToFetch;
    }

    public ShardIteratorType getShardIteratorType() {
        return this._shardIteratorType;
    }

    public String getAccessKey() {
        return this._accessKey;
    }

    public String getSecretKey() {
        return this._secretKey;
    }

    public String getEndpoint() {
        return this._endpoint;
    }
}

