/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.client.SelectionResultSet;
import org.apache.pinot.spi.utils.JsonUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SelectionResultSetTest {
    private JsonNode _mockSelectionResults;
    private SelectionResultSet _selectionResultSetUnderTest;

    @BeforeMethod
    public void setUp() throws Exception {
        String jsonString = "{\"results\":[[\"r1c1\",\"r1c2\"]], \"columns\":[\"column1\", \"column2\"]}";
        this._mockSelectionResults = JsonUtils.stringToJsonNode((String)jsonString);
        this._selectionResultSetUnderTest = new SelectionResultSet(this._mockSelectionResults);
    }

    @Test
    public void testGetRowCount() {
        int result = this._selectionResultSetUnderTest.getRowCount();
        Assert.assertEquals((int)1, (int)result);
    }

    @Test
    public void testGetColumnCount() {
        int result = this._selectionResultSetUnderTest.getColumnCount();
        Assert.assertEquals((int)2, (int)result);
    }

    @Test
    public void testGetColumnName() {
        String result = this._selectionResultSetUnderTest.getColumnName(0);
        Assert.assertEquals((String)"column1", (String)result);
    }

    @Test
    public void testGetString() {
        String result = this._selectionResultSetUnderTest.getString(0, 0);
        Assert.assertEquals((String)"r1c1", (String)result);
    }

    @Test
    public void testGetGroupKeyLength() {
        int result = this._selectionResultSetUnderTest.getGroupKeyLength();
        Assert.assertEquals((int)0, (int)result);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testGetGroupKeyString() {
        this._selectionResultSetUnderTest.getGroupKeyString(0, 0);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testGetGroupKeyColumnName() {
        this._selectionResultSetUnderTest.getGroupKeyColumnName(0);
    }

    @Test
    public void testToString() {
        String result = this._selectionResultSetUnderTest.toString();
        Assert.assertNotEquals((Object)"", (Object)result);
    }
}

