/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.apache.pinot.client.ResultTableResultSet;
import org.apache.pinot.spi.utils.JsonUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ResultTableResultSetTest {
    private JsonNode _jsonNode;
    private ResultTableResultSet _resultTableResultSetUnderTest;

    @BeforeTest
    public void setUp() throws Exception {
        String json = "{ \"rows\" : [[\"r1c1\", \"r1c2\"], [\"r2c1\", \"r2c2\"]], \"dataSchema\" : {\"columnNames\":[\"column1\", \"column2\"], \"columnDataTypes\":[\"column1DataType\", \"column2DataType\"]} } ";
        this._jsonNode = JsonUtils.stringToJsonNode((String)json);
        this._resultTableResultSetUnderTest = new ResultTableResultSet(this._jsonNode);
    }

    @Test
    public void testGetRowCount() {
        int result = this._resultTableResultSetUnderTest.getRowCount();
        Assert.assertEquals((int)2, (int)result);
    }

    @Test
    public void testGetColumnCount() {
        int result = this._resultTableResultSetUnderTest.getColumnCount();
        Assert.assertEquals((int)2, (int)result);
    }

    @Test
    public void testGetColumnName() {
        String result = this._resultTableResultSetUnderTest.getColumnName(0);
        Assert.assertEquals((String)"column1", (String)result);
    }

    @Test
    public void testGetColumnDataType() {
        String result = this._resultTableResultSetUnderTest.getColumnDataType(0);
        Assert.assertEquals((String)"column1DataType", (String)result);
    }

    @Test
    public void testGetString() {
        String result = this._resultTableResultSetUnderTest.getString(0, 0);
        Assert.assertEquals((String)"r1c1", (String)result);
    }

    @Test
    public void testGetAllColumns() {
        List result = this._resultTableResultSetUnderTest.getAllColumns();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)2, (int)result.size());
    }

    @Test
    public void testGetAllColumnsDataTypes() {
        List result = this._resultTableResultSetUnderTest.getAllColumnsDataTypes();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)2, (int)result.size());
    }

    @Test
    public void testGetGroupKeyLength() {
        int result = this._resultTableResultSetUnderTest.getGroupKeyLength();
        Assert.assertEquals((int)0, (int)result);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testGetGroupKeyString() {
        this._resultTableResultSetUnderTest.getGroupKeyString(0, 0);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testGetGroupKeyColumnName() {
        this._resultTableResultSetUnderTest.getGroupKeyColumnName(0);
    }

    @Test
    public void testToString() {
        String result = this._resultTableResultSetUnderTest.toString();
        Assert.assertNotEquals((Object)"", (Object)result);
    }
}

